/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.timer;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.timer.TimerTask;
import com.mathworks.timer.TimerTaskException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Vector;

public class MWCallback
implements Serializable,
MatlabListener {
    private boolean taskEnabled = false;
    private int callbacksPending = 0;
    private long totalCallbacks = 0L;
    private long maxCallbacks = -1L;
    public static final int OVERRATE_DROP = 0;
    public static final int OVERRATE_QUEUE = 1;
    public static final int OVERRATE_ERROR = 2;
    private int overrateAction = 1;
    private static final int TYPE_UNDEF = 0;
    private static final int TYPE_EVAL = 1;
    private static final int TYPE_FEVAL = 2;
    private int callbackType = 0;
    private String callbackDescription = "Callback";
    private MLArrayRef callbackFcn = null;
    private MatlabMCR fMatlabMCR;
    private Vector listeners = new Vector();
    protected MyActionListener actionListener;
    public static final int postfixEvent = 1;
    public static final int prefixEvent = 2;
    public static final int errorEvent = 3;
    public static final int busyEvent = 4;
    public static final int stateChangeEvent = 5;
    public static final int dropEvent = 6;

    public long getMaxCallbacks() {
        return this.maxCallbacks;
    }

    public void setMaxCallbacks(long l) {
        this.maxCallbacks = l;
    }

    public void resetCallbackCount() {
        this.totalCallbacks = 0L;
    }

    public void incCallbackCount() {
        ++this.totalCallbacks;
    }

    public long getCallbackCount() {
        return this.totalCallbacks;
    }

    public MWCallback(MatlabMCR matlabMCR) {
        this.fMatlabMCR = matlabMCR;
        Matlab.addListener((MatlabListener)this);
    }

    public MWCallback(String string, MatlabMCR matlabMCR) {
        this(matlabMCR);
        this.callbackDescription = string;
    }

    public MWCallback(String string, MyActionListener myActionListener, MatlabMCR matlabMCR) {
        this(string, matlabMCR);
        this.addActionListener(myActionListener);
    }

    public void dispose() {
        if (this.fMatlabMCR != null) {
            this.fMatlabMCR = null;
        }
        Matlab.removeListener((MatlabListener)this);
        if (this.callbackFcn != null) {
            this.callbackFcn.dispose();
        }
        this.callbackFcn = null;
    }

    public boolean getEnabled() {
        return this.taskEnabled;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.taskEnabled) {
            this.taskEnabled = bl;
            this.callbacksPending = 0;
            this.notifyActionListeners(new MyActionEvent(this, 5, "stateChange"));
        }
    }

    public int getOverrateAction() {
        return this.overrateAction;
    }

    public void setOverrateAction(int n) {
        this.overrateAction = n;
    }

    public int getCallbacksPending() {
        return this.callbacksPending;
    }

    public MLArrayRef getCallbackFcn() {
        return this.callbackFcn;
    }

    public boolean isEmpty() {
        return this.callbackType == 0;
    }

    public void setCallbackFcn(MLArrayRef mLArrayRef) throws TimerTaskException {
        if (mLArrayRef == null) {
            if (this.callbackFcn != null) {
                this.callbackFcn.dispose();
            }
            this.callbackFcn = mLArrayRef;
            this.callbackType = 0;
            return;
        }
        int n = mLArrayRef.getType();
        if (mLArrayRef.getM() == 0 || mLArrayRef.getN() == 0) {
            if (this.callbackFcn != null) {
                this.callbackFcn.dispose();
            }
            this.callbackFcn = mLArrayRef;
            this.callbackType = 0;
            return;
        }
        if (mLArrayRef.getM() != 1) {
            mLArrayRef.dispose();
            throw new TimerTaskException(this.callbackDescription + " callback must be set to a string, a function handle, or a\n1-by-N cell array.  The first element of the 1-by-N cell array must be\nthe callback function name or handle.");
        }
        switch (n) {
            case 1: {
                MLArrayRef mLArrayRef2 = mLArrayRef.cellInfoAt(0);
                if (mLArrayRef2.getType() != 4 && mLArrayRef2.getType() != 16) {
                    mLArrayRef.dispose();
                    throw new TimerTaskException(this.callbackDescription + " callback must be set to a string, a function handle, or a\n1-by-N cell array.  The first element of the 1-by-N cell array must be\nthe callback function name or handle.");
                }
            }
            case 16: {
                if (this.callbackFcn != null) {
                    this.callbackFcn.dispose();
                }
                this.callbackFcn = mLArrayRef;
                this.callbackType = 2;
                break;
            }
            case 4: {
                if (this.callbackFcn != null) {
                    this.callbackFcn.dispose();
                }
                this.callbackFcn = mLArrayRef;
                this.callbackType = 1;
                break;
            }
            default: {
                mLArrayRef.dispose();
                throw new TimerTaskException(this.callbackDescription + " callback must be set to a string, a function handle, or a\n1-by-N cell array.  The first element of the 1-by-N cell array must be\nthe callback function name or handle.");
            }
        }
    }

    public void sendInterrupt() {
        this.fMatlabMCR.interrupt();
    }

    public void asyncExecute(TimerTask timerTask) {
        if (this.callbackFcn == null || this.callbackType == 0) {
            return;
        }
        if (this.callbacksPending > 0) {
            switch (this.overrateAction) {
                case 2: {
                    this.setEnabled(false);
                    this.notifyActionListeners(new MyActionEvent(this, 4, "Cannot execute TimerFcn due to previous TimerFcn callback not yet completed."));
                    return;
                }
                case 0: {
                    this.notifyActionListeners(new MyActionEvent(this, 6, "drop"));
                    return;
                }
            }
        }
        ++this.callbacksPending;
        if (this.callbackType == 1) {
            this.fMatlabMCR.timerRequest((Runnable)new callbackEvent(this, timerTask, this.callbackFcn));
        } else {
            this.fMatlabMCR.timerRequest((Runnable)new callbackEvent(this, timerTask, this.callbackFcn, new EventStruct(this.callbackDescription, MWCallback.clockVector())));
        }
    }

    public void asyncExecute(TimerTask timerTask, String string, String string2) {
        if (this.callbackFcn == null || this.callbackType == 0) {
            return;
        }
        if (this.callbackType == 1) {
            this.fMatlabMCR.whenMatlabReady((Runnable)new callbackEvent(this, timerTask, this.callbackFcn));
        } else {
            this.fMatlabMCR.whenMatlabReady((Runnable)new callbackEvent(this, timerTask, this.callbackFcn, new EventStruct(this.callbackDescription, MWCallback.clockVector(), string, string2)));
        }
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        if (matlabEvent.getEventType() == 1) {
            this.setEnabled(false);
        }
    }

    public void addActionListener(MyActionListener myActionListener) {
        this.listeners.addElement(myActionListener);
    }

    public void removeActionListener(MyActionListener myActionListener) {
        this.listeners.removeElement(myActionListener);
    }

    public void notifyActionListeners(MyActionEvent myActionEvent) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((MyActionListener)this.listeners.elementAt(i)).actionPerformed(myActionEvent);
        }
    }

    private static final double[][] clockVector() {
        double[][] dArray = new double[1][6];
        Calendar calendar = Calendar.getInstance();
        dArray[0][0] = calendar.get(1);
        dArray[0][1] = calendar.get(2) + 1;
        dArray[0][2] = calendar.get(5);
        dArray[0][3] = calendar.get(11);
        dArray[0][4] = calendar.get(12);
        dArray[0][5] = (double)calendar.get(13) + (double)calendar.get(14) / 1000.0;
        return dArray;
    }

    public static interface MyActionListener {
        public void actionPerformed(MyActionEvent var1);
    }

    class MyActionEvent {
        public static final int ACTION_PERFORMED = 1;
        private Object m_source;
        private int m_id;
        private String m_command;

        private MyActionEvent(Object object, int n, String string) {
            this.m_source = object;
            this.m_id = n;
            this.m_command = string;
        }

        public int getID() {
            return this.m_id;
        }

        public Object getSource() {
            return this.m_source;
        }

        public String getActionCommand() {
            return this.m_command;
        }
    }

    protected class EventStruct
    implements AutoConvertStringToMatlabChar {
        public String Type;
        public Object Data;

        public EventStruct(String string, double[][] dArray) {
            dataStruct dataStruct2 = new dataStruct();
            dataStruct2.time = dArray;
            this.Type = string;
            this.Data = dataStruct2;
        }

        public EventStruct(String string, double[][] dArray, String string2, String string3) {
            errorDataStruct errorDataStruct2 = new errorDataStruct();
            errorDataStruct2.time = dArray;
            errorDataStruct2.message = string2;
            errorDataStruct2.messageID = string3;
            this.Type = string;
            this.Data = errorDataStruct2;
        }

        private class errorDataStruct
        extends dataStruct
        implements AutoConvertStringToMatlabChar {
            public String message;
            public String messageID;

            private errorDataStruct() {
            }
        }

        private class dataStruct {
            public double[][] time;

            private dataStruct() {
            }
        }
    }

    protected class callbackEvent
    implements Runnable {
        MWCallback parent;
        TimerTask tt;
        Object[] args;

        public callbackEvent(MWCallback mWCallback2, TimerTask timerTask, MLArrayRef mLArrayRef) {
            this.parent = mWCallback2;
            this.args = new Object[3];
            this.args[0] = timerTask;
            this.args[1] = this.parent.callbackDescription;
            this.args[2] = mLArrayRef;
        }

        public callbackEvent(MWCallback mWCallback2, TimerTask timerTask, MLArrayRef mLArrayRef, EventStruct eventStruct) {
            this.parent = mWCallback2;
            this.args = new Object[4];
            this.args[0] = timerTask;
            this.args[1] = this.parent.callbackDescription;
            this.args[2] = mLArrayRef;
            this.args[3] = eventStruct;
        }

        @Override
        public void run() {
            if (!this.parent.getEnabled()) {
                return;
            }
            this.parent.incCallbackCount();
            this.parent.callbacksPending--;
            this.parent.notifyActionListeners(new MyActionEvent(this.parent, 2, "prefix"));
            try {
                MWCallback.this.fMatlabMCR;
                MatlabMCR.mtFevalConsoleOutput((String)"timercb", (Object[])this.args, (int)0);
            }
            catch (Exception exception) {
                MWCallback.this.setEnabled(false);
                this.parent.notifyActionListeners(new MyActionEvent(this.parent, 3, exception.getMessage()));
            }
            if (this.parent.getCallbackCount() == this.parent.getMaxCallbacks()) {
                MWCallback.this.setEnabled(false);
            }
            this.parent.notifyActionListeners(new MyActionEvent(this.parent, 1, "postfix"));
        }
    }
}

