/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.comparisons.util.FileNameFilters;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.ButtonFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileNameFiltersDialog
extends MJPanel {
    private MJButton fRemoveButton;
    private MJButton fAddButton;
    private MJList fList;
    private DefaultListModel fModel;
    private ActionListener fListener;

    private FileNameFiltersDialog(ActionListener actionListener) {
        String string2;
        String[] stringArray;
        this.fListener = actionListener;
        this.fModel = new DefaultListModel();
        for (String string2 : stringArray = FileNameFilters.get()) {
            this.fModel.addElement(string2);
        }
        this.fList = new MJList((ListModel)this.fModel);
        this.fList.setName("FiltersList");
        this.fList.addListSelectionListener((ListSelectionListener)new FileFiltersListSelectionListener());
        this.fList.setSelectionMode(0);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = FileNameFiltersDialog.this.fList.locationToIndex(mouseEvent.getPoint());
                    FileNameFiltersDialog.this.edit(n);
                }
            }
        };
        this.fList.addMouseListener((MouseListener)mouseAdapter);
        this.fList.setToolTipText(ResourceManager.getString("filters.doubleclickprompt"));
        this.fAddButton = new MJButton((Action)((Object)new AddFilterAction()));
        this.fAddButton.setName("AddFilterButton");
        this.fRemoveButton = new MJButton((Action)((Object)new RemoveFilterAction()));
        this.fRemoveButton.setName("RemoveFilterButton");
        this.fRemoveButton.setEnabled(false);
        JComponent jComponent = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fAddButton, this.fRemoveButton});
        JLabel jLabel = new JLabel(ResourceManager.getString("filters.prompt"));
        string2 = new PanelBuilder(new FormLayout("p, 0dlu:grow", "p, 1dlu, fill:p:grow, 1dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        string2.add((Component)jLabel, cellConstraints.xyw(1, 1, 2));
        string2.add((Component)new MJScrollPane((Component)this.fList), cellConstraints.xyw(1, 3, 2));
        string2.add((Component)jComponent, cellConstraints.xy(1, 5));
        this.setLayout(new BorderLayout());
        this.add(string2.getPanel(), "Center");
    }

    public static MJFrame getFrame(Component component, ActionListener actionListener) {
        FileNameFiltersDialog fileNameFiltersDialog = new FileNameFiltersDialog(actionListener);
        MJFrame mJFrame = new MJFrame(ResourceManager.getString("filters.title"));
        mJFrame.setName("FiltersDialog");
        mJFrame.setContentPane((Container)((Object)fileNameFiltersDialog));
        fileNameFiltersDialog.attachToFrame(mJFrame);
        mJFrame.pack();
        mJFrame.setLocationRelativeTo(component);
        mJFrame.setAlwaysOnTop(true);
        mJFrame.setVisible(true);
        return mJFrame;
    }

    private void attachToFrame(MJFrame mJFrame) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(2));
        OKAction oKAction = new OKAction(mJFrame);
        MJButton mJButton = new MJButton((Action)((Object)oKAction));
        mJButton.setName("FiltersOkButton");
        mJPanel.add((Component)mJButton);
        CancelAction cancelAction = new CancelAction(mJFrame);
        MJButton mJButton2 = new MJButton((Action)((Object)cancelAction));
        mJButton2.setName("FiltersCancelButton");
        mJPanel.add((Component)mJButton2);
        MJButton mJButton3 = new MJButton((Action)((Object)new ApplyAction()));
        mJButton3.setName("FiltersApplyButton");
        mJPanel.add((Component)mJButton3);
        this.add((Component)mJPanel, "South");
        this.setBorder(new EmptyBorder(5, 5, 0, 5));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        mJFrame.getRootPane().registerKeyboardAction((ActionListener)((Object)cancelAction), keyStroke, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        mJFrame.getRootPane().registerKeyboardAction((ActionListener)((Object)oKAction), keyStroke2, 2);
    }

    public void apply() {
        String[] stringArray = new String[this.fModel.getSize()];
        Enumeration enumeration = this.fModel.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        FileNameFilters.set(stringArray);
        this.fListener.actionPerformed(null);
    }

    public void edit(int n) {
        String string = (String)this.fModel.get(n);
        String string2 = ResourceManager.getString("filters.editfilter");
        if ((string = this.showEditDialog(string, string2)) != null) {
            this.fModel.set(n, string);
        }
    }

    public String showEditDialog(String string, String string2) {
        String string3 = string;
        while (true) {
            String string4 = ResourceManager.getString("filters.enterfilter");
            string3 = (String)MJOptionPane.showInputDialog((Component)((Object)this), (Object)string4, (String)string2, (int)3, null, null, (Object)string3);
            try {
                if (string3 == null) break;
                FileNameFilters.checkValidFilter(string3);
            }
            catch (Exception exception) {
                MJOptionPane.showMessageDialog((Component)((Object)this), (Object)exception.getMessage());
                continue;
            }
            break;
        }
        return string3;
    }

    private class CancelAction
    extends MJAbstractAction {
        MJFrame fFrame;

        CancelAction(MJFrame mJFrame) {
            super(MJUtilities.intlString((String)"labelCancel"));
            this.fFrame = mJFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fFrame.dispose();
        }
    }

    private class OKAction
    extends MJAbstractAction {
        MJFrame fFrame;

        OKAction(MJFrame mJFrame) {
            super(MJUtilities.intlString((String)"labelOK"));
            this.fFrame = mJFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileNameFiltersDialog.this.apply();
            this.fFrame.dispose();
        }
    }

    private class ApplyAction
    extends MJAbstractAction {
        ApplyAction() {
            super(MJUtilities.intlString((String)"labelApply"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FileNameFiltersDialog.this.apply();
        }
    }

    private class AddFilterAction
    extends MJAbstractAction {
        AddFilterAction() {
            super("", (Icon)MiscellaneousIcon.ADD_ENTRY.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ResourceManager.getString("filters.addfilter");
            String string2 = FileNameFiltersDialog.this.showEditDialog(null, string);
            if (string2 != null) {
                FileNameFiltersDialog.this.fModel.addElement(string2);
            }
        }
    }

    private class RemoveFilterAction
    extends MJAbstractAction {
        RemoveFilterAction() {
            super("", (Icon)MiscellaneousIcon.REMOVE_ENTRY.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = FileNameFiltersDialog.this.fList.getSelectionModel().getLeadSelectionIndex();
            FileNameFiltersDialog.this.fModel.remove(n);
        }
    }

    private class FileFiltersListSelectionListener
    implements ListSelectionListener {
        private FileFiltersListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            FileNameFiltersDialog.this.fRemoveButton.setEnabled(!FileNameFiltersDialog.this.fList.getSelectionModel().isSelectionEmpty());
        }
    }
}

