/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.prefs;

import com.mathworks.comparisons.prefs.ComparisonPreference;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.services.Prefs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ComparisonPrefsManager {
    private static ComparisonPrefsManager sPrefsManager = null;
    private final Map<ComparisonPreference, Object> mPreferenceRegister = Collections.synchronizedMap(new HashMap());

    public static synchronized ComparisonPrefsManager getInstance() {
        if (sPrefsManager == null) {
            sPrefsManager = new ComparisonPrefsManager();
        }
        return sPrefsManager;
    }

    private ComparisonPrefsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePref(ComparisonPreference comparisonPreference) {
        Map<ComparisonPreference, Object> map = this.mPreferenceRegister;
        synchronized (map) {
            if (this.mPreferenceRegister.containsKey(comparisonPreference)) {
                this.mPreferenceRegister.remove(comparisonPreference);
            }
        }
        Prefs.remove((String)comparisonPreference.getName());
    }

    public void setValue(ComparisonPreference comparisonPreference, Object object) throws UnsupportedOperationException {
        Object object2 = object;
        if (object2 == null) {
            object2 = comparisonPreference.getDefaultValue();
        }
        if (object2 == null) {
            this.removePref(comparisonPreference);
        } else if (comparisonPreference.isAssignableFromValueType(object2.getClass())) {
            this.mPreferenceRegister.put(comparisonPreference, object2);
            comparisonPreference.set(object2);
        } else {
            throw new UnsupportedOperationException(ResourceManager.format("exception.setpreferenceproblem", comparisonPreference.getName(), ResourceManager.format("exception.incompatibleclasses", object2.getClass().getName(), comparisonPreference.getValueType().getName())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(ComparisonPreference comparisonPreference) {
        Map<ComparisonPreference, Object> map = this.mPreferenceRegister;
        synchronized (map) {
            if (!this.mPreferenceRegister.containsKey(comparisonPreference)) {
                this.mPreferenceRegister.put(comparisonPreference, comparisonPreference.get());
            }
            return this.mPreferenceRegister.get(comparisonPreference);
        }
    }
}

