/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionUtilities;
import com.mathworks.comparisons.compare.concr.BinaryComparison;
import com.mathworks.comparisons.compare.concr.ComparisonQueue;
import com.mathworks.comparisons.compare.concr.ComparisonUtilities;
import com.mathworks.comparisons.compare.concr.ListComparison;
import com.mathworks.comparisons.compare.concr.ListComparisonUtilities;
import com.mathworks.comparisons.compare.concr.ListReportUpdater;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHTMLRenderer;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.parameter.CParameterIncludeSubfolders;
import com.mathworks.comparisons.param.parameter.CParameterSizesAndDatesOnly;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourceProperty;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.ComparisonSourceUtilities;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyComparisonCollection;
import com.mathworks.comparisons.source.property.CSPropertyHeaderInformation;
import com.mathworks.comparisons.source.property.CSPropertyInputStream;
import com.mathworks.comparisons.source.property.CSPropertyLastModifiedDate;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.util.AbstractPropertyWithInfo;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mlwidgets.dialog.ProgressBarDialog;
import com.mathworks.mlwidgets.html.HTMLCallbackProvider;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ListComparisonGenerator
implements ProgressBarDialog.CancellationListener,
Runnable {
    private ComparisonSource fLeftSource;
    private ComparisonSource fRightSource;
    private ComparisonCollection fLeftCollection;
    private ComparisonCollection fRightCollection;
    private String fLeftType;
    private String fRightType;
    private DateFormat fDateFormat;
    private boolean fIncludeSubfolders;
    private boolean fSizesAndDatesOnly;
    private ListReportUpdater fReportUpdater;
    private ComparisonQueue fComparisonQueue;
    private HTMLReportDecorator fReportDecorator;
    private ProgressBarDialog fProgressBar;
    private Thread fRunner;
    private ListComparison fParent;
    private boolean fStopped;

    private void stopAsynchronousTasks() {
        if (this.fStopped) {
            return;
        }
        this.fStopped = true;
        if (this.fRunner != null) {
            this.fRunner.interrupt();
            this.fRunner = null;
        }
        if (this.fReportUpdater != null) {
            this.fReportUpdater.reportClosed();
            this.fReportUpdater = null;
        }
        if (this.fComparisonQueue != null) {
            this.fComparisonQueue.cancelAll();
        }
    }

    public synchronized void cancel() {
        this.stopAsynchronousTasks();
        if (this.fReportDecorator != null) {
            this.fReportDecorator.enableControls();
        }
    }

    void setProgressBarValue(double d) {
        if (this.fProgressBar != null) {
            this.fProgressBar.setValue(d);
        }
    }

    ListComparisonGenerator(ListComparison listComparison, HTMLReportDecorator hTMLReportDecorator, ComparisonSource comparisonSource, ComparisonSource comparisonSource2, ComparisonParameterSet comparisonParameterSet) {
        this.fParent = listComparison;
        this.fReportDecorator = hTMLReportDecorator;
        this.fLeftSource = comparisonSource;
        this.fRightSource = comparisonSource2;
        this.fDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (comparisonParameterSet != null) {
            if (comparisonParameterSet.hasParameter(CParameterIncludeSubfolders.getInstance())) {
                this.fIncludeSubfolders = (Boolean)comparisonParameterSet.getValue(CParameterIncludeSubfolders.getInstance());
            }
            if (comparisonParameterSet.hasParameter(CParameterSizesAndDatesOnly.getInstance())) {
                this.fSizesAndDatesOnly = (Boolean)comparisonParameterSet.getValue(CParameterSizesAndDatesOnly.getInstance());
            }
        }
        ListComparisonUtilities.addComparison(this);
        this.fRunner = new Thread(ListComparisonUtilities.getThreadGroup(), this);
        this.fRunner.start();
    }

    @Override
    public void run() {
        String string;
        Object object;
        if (this.fReportDecorator != null) {
            object = new Runnable(){

                @Override
                public void run() {
                    Object object;
                    for (object = ListComparisonGenerator.this.fReportDecorator.getHTMLRenderer(); object != null && !(object instanceof RootPaneContainer); object = ((Component)object).getParent()) {
                    }
                    if (object != null) {
                        ListComparisonGenerator.this.fProgressBar = ProgressBarDialog.createHeavyweightInternalProgressBar((RootPaneContainer)((RootPaneContainer)object), (String)"", (ProgressBarDialog.CancellationListener)ListComparisonGenerator.this);
                        ListComparisonGenerator.this.fProgressBar.setVisible(true);
                    }
                }
            };
            try {
                SwingUtilities.invokeAndWait((Runnable)object);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        this.fComparisonQueue = new ComparisonQueue(this);
        try {
            object = this.generateEditScript();
            if (object == null) {
                assert (this.fStopped);
                return;
            }
            ListComparisonUtilities.debugSaveXML((Document)object);
            this.setProgressString(ProgressStage.GENERATE_REPORT.getStageString(this));
            ProgressStage.GENERATE_REPORT.setProgressValue(this.fProgressBar, 0, 1);
            string = ListComparisonGenerator.createReport((Document)object);
            if (string == null) {
                assert (this.fStopped);
                return;
            }
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            string = ListComparisonGenerator.formatError(string2 == null ? exception.toString() : string2);
        }
        final String string3 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListComparisonGenerator.this.fParent.fireComparisonFinishedEvent();
                ListComparisonGenerator.this.showReport(string3);
                if (ListComparisonGenerator.this.fReportDecorator != null) {
                    ListComparisonGenerator.this.fReportDecorator.enableControls();
                }
            }
        });
    }

    private static String formatError(String string) {
        return "<html><body>" + string.replace("\n", "<br>") + "</body></html>";
    }

    private static Element addTextElement(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
        return element2;
    }

    private static String getSourceName(ComparisonSource comparisonSource) {
        return ComparisonSourceUtilities.getName(comparisonSource);
    }

    private static boolean isFolder(ComparisonSource comparisonSource) {
        return ComparisonSourceUtilities.isFolder(comparisonSource);
    }

    private static long getSize(ComparisonSource comparisonSource) {
        return ComparisonSourceUtilities.getSize(comparisonSource);
    }

    private String getLastModifiedDate(ComparisonSource comparisonSource) {
        CSPropertyLastModifiedDate cSPropertyLastModifiedDate = CSPropertyLastModifiedDate.getInstance();
        if (comparisonSource.hasProperty(cSPropertyLastModifiedDate)) {
            Date date = (Date)comparisonSource.getPropertyValue(cSPropertyLastModifiedDate, new ComparisonSourcePropertyInfo[0]);
            return this.fDateFormat.format(date);
        }
        return "";
    }

    public String getReportID() {
        return Integer.toString(this.hashCode());
    }

    public synchronized void reportClosed() {
        this.stopAsynchronousTasks();
        ListComparisonUtilities.removeComparison(this);
    }

    public void setDecorator(HTMLReportDecorator hTMLReportDecorator) {
        this.fReportDecorator = hTMLReportDecorator;
    }

    private String getPageTitle() {
        return ResourceManager.format("listcomparison.title", this.fLeftType, ComparisonSourceUtilities.getSuitableShortTitle(this.fLeftSource), this.fRightType, ComparisonSourceUtilities.getSuitableShortTitle(this.fRightSource));
    }

    private HTMLCallbackProvider getHTMLRenderer() {
        if (this.fReportDecorator != null) {
            return this.fReportDecorator.getHTMLRenderer();
        }
        return ListComparisonUtilities.getTestRenderer();
    }

    ComparisonSource getLeftSource() {
        return this.fLeftSource;
    }

    ComparisonCollection getLeftCollection() {
        return this.fLeftCollection;
    }

    ComparisonSource getRightSource() {
        return this.fRightSource;
    }

    ComparisonCollection getRightCollection() {
        return this.fRightCollection;
    }

    ComparisonQueue getQueue() {
        return this.fComparisonQueue;
    }

    void reportError(String string) {
        MJOptionPane.showMessageDialog((Component)((Object)this.fReportDecorator.getHTMLRenderer()), (Object)string, (String)ResourceManager.getString("listcomparison.errorTitle"), (int)0);
    }

    void setProgressString(String string) {
        if (this.fProgressBar != null) {
            this.fProgressBar.setProgressStatusLabel(string);
        }
    }

    private static String createReport(Document document) {
        try {
            Source source = XMLUtils.transformSourceFactory((Object)document);
            return ListComparisonUtilities.doTransform(source);
        }
        catch (Throwable throwable) {
            ExceptionHandler.rethrow(throwable);
            return null;
        }
    }

    private synchronized void showReport(String string) {
        this.setProgressString(ProgressStage.SHOW_REPORT.getStageString(this));
        ProgressStage.SHOW_REPORT.setProgressValue(this.fProgressBar, 0, 1);
        if (this.fStopped) {
            return;
        }
        ComparisonHTMLRenderer.showHtmlFragment(this.getHTMLRenderer(), string, this.getPageTitle());
        ProgressStage.SHOW_REPORT.setProgressValue(this.fProgressBar, 1, 1);
        if (this.fComparisonQueue.getQueueSize() > 0) {
            this.fReportUpdater = new ListReportUpdater(this.getHTMLRenderer(), this.getReportID(), this.fProgressBar);
            this.fComparisonQueue.start();
        } else if (this.fProgressBar != null) {
            this.fProgressBar.dispose();
            this.fProgressBar = null;
        }
    }

    private Document generateEditScript() {
        Object object;
        Object object2;
        this.setProgressString(ProgressStage.GET_SOURCES.getStageString(this));
        ProgressStage.GET_SOURCES.setProgressValue(this.fProgressBar, 0, 2);
        CSPropertyComparisonCollection cSPropertyComparisonCollection = CSPropertyComparisonCollection.getInstance();
        assert (this.fLeftSource.hasProperty(cSPropertyComparisonCollection) && this.fRightSource.hasProperty(cSPropertyComparisonCollection));
        CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders = new CSPInfoIncludeSubFolders(this.fIncludeSubfolders);
        CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom = new CSPInfoIncludeRelativeFrom("");
        if (this.fStopped) {
            return null;
        }
        this.fLeftCollection = (ComparisonCollection)this.fLeftSource.getPropertyValue(cSPropertyComparisonCollection, new ComparisonSourcePropertyInfo[]{cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom});
        ProgressStage.GET_SOURCES.setProgressValue(this.fProgressBar, 1, 2);
        if (this.fStopped) {
            return null;
        }
        this.fRightCollection = (ComparisonCollection)this.fRightSource.getPropertyValue(cSPropertyComparisonCollection, new ComparisonSourcePropertyInfo[]{cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom});
        if (this.fStopped) {
            return null;
        }
        this.fLeftType = this.fLeftCollection.getType();
        this.fRightType = this.fRightCollection.getType();
        Collection<ComparisonSource> collection = this.fLeftCollection.getComparisonSources();
        Collection<ComparisonSource> collection2 = this.fRightCollection.getComparisonSources();
        int n = collection.size();
        int n2 = collection2.size();
        int n3 = n + n2;
        ProgressStage.GET_SOURCES.setProgressValue(this.fProgressBar, 0, n3);
        this.setProgressString(ProgressStage.COMPARE_SOURCES.getStageString(this));
        int n4 = 0;
        ArrayList<ComparisonSource> arrayList = new ArrayList<ComparisonSource>(n);
        ArrayList<ComparisonSource> arrayList2 = new ArrayList<ComparisonSource>(n2);
        ArrayList<ComparisonSource> arrayList3 = new ArrayList<ComparisonSource>(n + n2);
        for (ComparisonSource object32 : collection) {
            object2 = ComparisonCollectionUtilities.getSourceByName(this.fRightCollection, ListComparisonGenerator.getSourceName(object32));
            if (object2 != null && !(ComparisonSourceUtilities.isFolder(object32) ^ ComparisonSourceUtilities.isFolder((ComparisonSource)object2))) {
                arrayList3.add(object32);
            } else {
                arrayList.add(object32);
            }
            ProgressStage.COMPARE_SOURCES.setProgressValue(this.fProgressBar, n4++, n3);
        }
        if (this.fStopped) {
            return null;
        }
        for (ComparisonSource comparisonSource : collection2) {
            object2 = ComparisonCollectionUtilities.getSourceByName(this.fLeftCollection, (String)comparisonSource.getPropertyValue(CSPropertyName.getInstance(), new ComparisonSourcePropertyInfo[0]));
            if (object2 == null || ComparisonSourceUtilities.isFolder(comparisonSource) ^ ComparisonSourceUtilities.isFolder((ComparisonSource)object2)) {
                arrayList2.add(comparisonSource);
            }
            ProgressStage.COMPARE_SOURCES.setProgressValue(this.fProgressBar, n4++, n3);
        }
        if (this.fStopped) {
            return null;
        }
        this.setProgressString(ProgressStage.GENERATE_XML.getStageString(this));
        ProgressStage.GENERATE_XML.setProgressValue(this.fProgressBar, 0, 1);
        Object object4 = null;
        try {
            object4 = XMLUtils.createDocument((String)"FileListEditScript");
        }
        catch (Throwable throwable) {
            ExceptionHandler.rethrow(throwable);
        }
        Element element = object4.getDocumentElement();
        element.setAttribute("id", this.getReportID());
        ListComparisonGenerator.addTextElement(element, "Title", this.getPageTitle());
        if (this.fLeftSource.hasProperty(CSPropertyHeaderInformation.getInstance())) {
            ListComparisonGenerator.addTextElement(element, "LeftHeader", (String)this.fLeftSource.getPropertyValue(CSPropertyHeaderInformation.getInstance(), new ComparisonSourcePropertyInfo[0]));
        }
        if (this.fRightSource.hasProperty(CSPropertyHeaderInformation.getInstance())) {
            ListComparisonGenerator.addTextElement(element, "RightHeader", (String)this.fRightSource.getPropertyValue(CSPropertyHeaderInformation.getInstance(), new ComparisonSourcePropertyInfo[0]));
        }
        String string = this.fLeftSource.hasProperty((ComparisonSourceProperty)(object2 = CSPropertyAbsoluteName.getInstance())) ? (String)this.fLeftSource.getPropertyValue((AbstractPropertyWithInfo)object2, new ComparisonSourcePropertyInfo[0]) : ComparisonSourceUtilities.getName(this.fLeftSource);
        Element element2 = ListComparisonGenerator.addTextElement(element, "LeftLocation", string);
        element2.setAttribute("Type", this.fLeftCollection.getType());
        element2.setAttribute("ShortName", this.fLeftCollection.getType() + " " + ComparisonSourceUtilities.getSuitableShortTitle(this.fLeftSource));
        String string2 = this.fRightSource.hasProperty((ComparisonSourceProperty)object2) ? (String)this.fRightSource.getPropertyValue((AbstractPropertyWithInfo)object2, new ComparisonSourcePropertyInfo[0]) : ComparisonSourceUtilities.getName(this.fRightSource);
        Element element3 = ListComparisonGenerator.addTextElement(element, "RightLocation", string2);
        element3.setAttribute("Type", this.fRightCollection.getType());
        element3.setAttribute("ShortName", this.fRightCollection.getType() + " " + ComparisonSourceUtilities.getSuitableShortTitle(this.fRightSource));
        Hashtable<String, Element> hashtable = new Hashtable<String, Element>(n + n2);
        ArrayList<String> arrayList4 = new ArrayList<String>(n + n2);
        for (ComparisonSource comparisonSource : arrayList) {
            object = this.processOneSideOnly(comparisonSource, true, (Document)object4);
            hashtable.put(ListComparisonGenerator.getSourceName(comparisonSource), (Element)object);
            arrayList4.add(ListComparisonGenerator.getSourceName(comparisonSource));
            if (!this.fStopped) continue;
            return null;
        }
        for (ComparisonSource comparisonSource : arrayList2) {
            object = this.processOneSideOnly(comparisonSource, false, (Document)object4);
            hashtable.put(ListComparisonGenerator.getSourceName(comparisonSource), (Element)object);
            arrayList4.add(ListComparisonGenerator.getSourceName(comparisonSource));
            if (!this.fStopped) continue;
            return null;
        }
        for (ComparisonSource comparisonSource : arrayList3) {
            object = ComparisonCollectionUtilities.getSourceByName(this.fRightCollection, ListComparisonGenerator.getSourceName(comparisonSource));
            Element element4 = this.processBothSides(comparisonSource, (ComparisonSource)object, (Document)object4);
            hashtable.put(ListComparisonGenerator.getSourceName(comparisonSource), element4);
            arrayList4.add(ListComparisonGenerator.getSourceName(comparisonSource));
            if (!this.fStopped) continue;
            return null;
        }
        Collections.sort(arrayList4);
        for (String string3 : arrayList4) {
            object = (Element)hashtable.get(string3);
            element.appendChild((Node)object);
        }
        if (this.fStopped) {
            return null;
        }
        element.setAttribute("queuelength", Integer.toString(this.fComparisonQueue.getQueueSize()));
        return object4;
    }

    private Element processBothSides(ComparisonSource comparisonSource, ComparisonSource comparisonSource2, Document document) {
        Element element;
        String string = this.getLastModifiedDate(comparisonSource);
        String string2 = this.getLastModifiedDate(comparisonSource2);
        if (ListComparisonGenerator.isFolder(comparisonSource)) {
            element = document.createElement("Directory");
            element.setAttribute("leftsize", "unknown");
            element.setAttribute("rightsize", "unknown");
            if (ComparisonUtilities.isFilteredOut(comparisonSource)) {
                element.setAttribute("contentsMatch", "filtered");
            } else {
                element.setAttribute("contentsMatch", "queued");
                this.fComparisonQueue.add(comparisonSource, comparisonSource2, element);
            }
        } else {
            String string3;
            block13: {
                element = document.createElement("File");
                long l = ListComparisonGenerator.getSize(comparisonSource);
                long l2 = ListComparisonGenerator.getSize(comparisonSource2);
                element.setAttribute("leftsize", Long.toString(l));
                element.setAttribute("rightsize", Long.toString(l2));
                if (ComparisonUtilities.isFilteredOut(comparisonSource)) {
                    string3 = "filtered";
                } else if (l != l2) {
                    string3 = "no";
                } else {
                    CSPropertyInputStream cSPropertyInputStream = CSPropertyInputStream.getInstance();
                    if (!this.fSizesAndDatesOnly && comparisonSource.hasProperty(cSPropertyInputStream) && comparisonSource2.hasProperty(cSPropertyInputStream)) {
                        try {
                            if (BinaryComparison.compareContents(comparisonSource, comparisonSource2)) {
                                string3 = "yes";
                                break block13;
                            }
                            string3 = "no";
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                            string3 = "skipped";
                        }
                    } else {
                        string3 = !string.equals(string2) ? "datesdiffer" : "assume";
                    }
                }
            }
            element.setAttribute("contentsMatch", string3);
        }
        element.setAttribute("leftdate", string);
        element.setAttribute("rightdate", string2);
        element.setAttribute("id", ListComparisonUtilities.fileNameToId(ListComparisonGenerator.getSourceName(comparisonSource)));
        element.appendChild(document.createTextNode(ListComparisonGenerator.getSourceName(comparisonSource)));
        return element;
    }

    private Element processOneSideOnly(ComparisonSource comparisonSource, boolean bl, Document document) {
        Element element;
        String string;
        String string2 = string = bl ? "Left" : "Right";
        if (ListComparisonGenerator.isFolder(comparisonSource)) {
            element = document.createElement(string + "Directory");
            element.setAttribute("size", "unknown");
        } else {
            element = document.createElement(string + "File");
            element.setAttribute("size", Long.toString(ListComparisonGenerator.getSize(comparisonSource)));
        }
        element.setAttribute("id", ListComparisonUtilities.fileNameToId(ListComparisonGenerator.getSourceName(comparisonSource)));
        element.setAttribute("date", this.getLastModifiedDate(comparisonSource));
        element.appendChild(document.createTextNode(ListComparisonGenerator.getSourceName(comparisonSource)));
        if (ComparisonUtilities.isFilteredOut(comparisonSource)) {
            element.setAttribute("filter", "true");
        }
        return element;
    }

    public synchronized void updateReport(String string, String string2, Element element) {
        if (this.fStopped) {
            return;
        }
        String string3 = ListComparisonUtilities.fileNameToId(string);
        try {
            Document document = XMLUtils.createDocument((String)"FileListEditScriptFragment");
            document.getDocumentElement().setAttribute("id", this.getReportID());
            Element element2 = (Element)document.importNode(element, true);
            element2.setAttribute("contentsMatch", string2);
            document.getDocumentElement().appendChild(element2);
            Source source = XMLUtils.transformSourceFactory((Object)element2);
            ListComparisonUtilities.debugSaveXML(document);
            String string4 = ListComparisonUtilities.doTransform(source);
            this.fReportUpdater.updateReport(string4, string3, this.fComparisonQueue.getQueueSize());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ExceptionHandler.rethrow(throwable);
        }
    }

    private static enum ProgressStage {
        GET_SOURCES,
        COMPARE_SOURCES,
        GENERATE_XML,
        GENERATE_REPORT,
        SHOW_REPORT;


        private static double stageValue(ProgressStage progressStage) {
            if (progressStage == null) {
                return 1.0;
            }
            switch (progressStage) {
                case GET_SOURCES: {
                    return 0.1;
                }
                case COMPARE_SOURCES: {
                    return 0.2;
                }
                case GENERATE_XML: {
                    return 0.7;
                }
                case GENERATE_REPORT: {
                    return 0.8;
                }
                case SHOW_REPORT: {
                    return 0.9;
                }
            }
            return 1.0;
        }

        String getStageString(ListComparisonGenerator listComparisonGenerator) {
            switch (this) {
                case GET_SOURCES: {
                    return ResourceManager.format("listcomparison.Scanning", new Object[0]);
                }
                case COMPARE_SOURCES: {
                    return ResourceManager.getString("listcomparison.Comparing");
                }
                case GENERATE_XML: 
                case GENERATE_REPORT: 
                case SHOW_REPORT: {
                    return ResourceManager.getString("listcomparison.GeneratingReport");
                }
            }
            return "";
        }

        private static ProgressStage nextStage(ProgressStage progressStage) {
            switch (progressStage) {
                case GET_SOURCES: {
                    return COMPARE_SOURCES;
                }
                case COMPARE_SOURCES: {
                    return GENERATE_XML;
                }
                case GENERATE_XML: {
                    return GENERATE_REPORT;
                }
                case GENERATE_REPORT: {
                    return SHOW_REPORT;
                }
                case SHOW_REPORT: {
                    return null;
                }
            }
            return null;
        }

        void setProgressValue(ProgressBarDialog progressBarDialog, int n, int n2) {
            if (progressBarDialog != null) {
                double d = ProgressStage.stageValue(this);
                double d2 = ProgressStage.stageValue(ProgressStage.nextStage(this));
                double d3 = (double)n / (double)n2;
                d += (d2 - d) * d3;
                progressBarDialog.setValue(d);
            }
        }
    }
}

