/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.toolstrip;

import com.mathworks.desktop.client.Client;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.desktop.AddFilesDropDownButton;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.desktop.ToolstripProjectClient;
import com.mathworks.project.impl.desktop.ToolstripUtils;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.toolstrip.CodeViewer;
import com.mathworks.toolbox.coder.toolstrip.FileNavigator;
import com.mathworks.toolbox.coder.toolstrip.StartCWorkflowAction;
import com.mathworks.toolbox.coder.toolstrip.StartMexWorkflowAction;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.sections.ToolstripSections;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class CoderClient
extends ToolstripProjectClient {
    private static final String NAME = "CoderClient";
    private final MJLabel fCurrentProjectLabel = new MJLabel(" ");
    private final FileNavigator fFileNavigator = new FileNavigator();
    private final CodeViewer fCodeViewer = new CodeViewer();

    public CoderClient() {
        super(NAME, CoderResources.getString("toolstrip.client.title"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        MJSplitPane mJSplitPane = new MJSplitPane(1, (Component)this.fFileNavigator.getComponent(), (Component)this.fCodeViewer.getComponent());
        mJSplitPane.setDividerLocation(250);
        mJSplitPane.setDividerSize(6);
        mJSplitPane.setBorder(null);
        mJSplitPane.setContinuousLayout(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        mJPanel.add((Component)this.fCurrentProjectLabel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 0;
        mJPanel.add((Component)mJSplitPane, (Object)gridBagConstraints);
        this.setContentPane((Component)mJPanel);
        this.configureToolstrip();
        this.fFileNavigator.addSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CoderClient.this.fCodeViewer.displayFile(CoderClient.this.fFileNavigator.getSelectedFile());
            }
        });
    }

    private void configureToolstrip() {
        TSPanel tSPanel = new TSPanel((LayoutManager)new GridLayout(1, 1, 0, 0));
        tSPanel.add((Component)new AddFilesDropDownButton((ProjectClient)this).getComponent());
        ToolstripTab toolstripTab = this.getHomeTab();
        toolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"SETUP", (String)CoderResources.getString("toolstrip.setup")).add((JComponent)tSPanel).build());
        TSPanel tSPanel2 = new TSPanel((LayoutManager)new GridLayout(1, 2, 0, 0));
        tSPanel2.add((Component)ToolstripUtils.createVerticalButton((MJAbstractAction)new StartMexWorkflowAction(this, this.getToolstrip())));
        tSPanel2.add((Component)ToolstripUtils.createVerticalButton((MJAbstractAction)new StartCWorkflowAction(this, this.getToolstrip())));
        toolstripTab.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"CODE GENERATION", (String)CoderResources.getString("toolstrip.codegen")).add((JComponent)tSPanel2).build());
    }

    protected void updateToolbar() {
        Project project = this.getProject();
        if (project != null) {
            File file = project.getFile();
            this.fCurrentProjectLabel.setText(file.getAbsolutePath());
            this.fCurrentProjectLabel.setIcon(UiFileSystemUtils.getIconEvenIfNonExistent((FileSystem)RealFileSystem.getInstance(), (FileLocation)new FileLocation(file), (ExtensionRegistry)ExplorerExtensionRegistry.getInstance()));
            ArrayList<FileSetInstance> arrayList = new ArrayList<FileSetInstance>();
            for (String string : project.getConfiguration().getFileSetKeys()) {
                if (string.equals("fileset.package")) continue;
                arrayList.add(project.getConfiguration().getFileSet(string));
            }
            this.fFileNavigator.setup(project, arrayList);
        }
    }

    public void projectClosed() {
    }

    public void start(DeploymentProcess deploymentProcess) {
    }

    public FileSetEditor getFileSetEditor(String string) {
        return this.fFileNavigator.getFileSetEditor(string);
    }

    public void disableChangeActionsWhileRunning(DeploymentProcess deploymentProcess) {
    }

    protected void disableActionsRequiringOpenProject() {
    }

    protected void enableActionsRequiringOpenProject() {
    }
}

