/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ParamWidget;
import com.mathworks.project.api.ProjectComponent;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.settingsui.ParamWidgetBinder;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesListener;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesModel;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesTableModel;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class ProposeTypesWidget
implements ProjectComponent,
ProposedTypesListener {
    private final ParamWidgetBinder fBinder;
    private final ParamAdapter fParamAdapter;
    private final MJPanel fComponent = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final HyperlinkTextLabel fViewReportLink;
    private final HyperlinkTextLabel fClearAnnotationsLink;
    private final BusyAffordance fLoadingAffordance;
    private static final Matlab MATLAB = new Matlab();
    private static Set<ProposedTypesListener> sWidgets = new LinkedHashSet<ProposedTypesListener>();

    public static Set<ProposedTypesListener> getWidgetList() {
        return Collections.unmodifiableSet(sWidgets);
    }

    public ProposeTypesWidget(Project project) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu:grow", "3dlu:grow, fill:d, 3dlu:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)new MJLabel(CoderResources.getString("fixptconv.notYetRun")), (Object)cellConstraints.xy(2, 2));
        mJPanel.add((Component)new MJPanel(), (Object)cellConstraints);
        this.fComponent.add((Component)mJPanel, (Object)"Center");
        this.fBinder = new ParamWidgetBinder(project, false);
        this.fLoadingAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_32x32);
        this.fParamAdapter = new ParamAdapter(project);
        WorkflowStep workflowStep = project.getConfiguration().getTarget().getWorkflow().getStepByKey("category.workflow.proposefixpttypes");
        Param param = workflowStep.getParam("param.transformedVariables");
        this.fBinder.register(param, (ParamWidget)this.fParamAdapter);
        this.fClearAnnotationsLink = Utilities.createLink(CoderResources.getString("fixptconv.clearAnnotations"), "param.fixptconv.proposetypes.proposals.clearAnnotations", new Runnable(){

            @Override
            public void run() {
                MATLAB.evalNoOutput("emlhdlcoder.WorkFlow.Manager.instance.clearAnnotations");
            }
        });
        this.fClearAnnotationsLink.getComponent().setBorder(null);
        this.fViewReportLink = Utilities.createLink(CoderResources.getString("fixptconv.report"), "param.fixptconv.proposetypes.proposals.report", new Runnable(){

            @Override
            public void run() {
                MATLAB.evalNoOutput("emlhdlcoder.WorkFlow.Manager.instance.printTypeReport");
            }
        });
        this.fViewReportLink.getComponent().setBorder(null);
        sWidgets.add(this);
    }

    public static void registerListener(ProposedTypesListener proposedTypesListener) {
        if (!sWidgets.contains(proposedTypesListener)) {
            sWidgets.add(proposedTypesListener);
        }
    }

    public static void unregisterListener(ProposedTypesListener proposedTypesListener) {
        sWidgets.remove(proposedTypesListener);
    }

    @Override
    public void notifyLoading() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProposeTypesWidget.this.fComponent.removeAll();
                ProposeTypesWidget.this.fComponent.setLayout((LayoutManager)new FormLayout("3dlu:grow, fill:d, 3dlu:grow", "3dlu:grow, fill:d, 3dlu:grow"));
                CellConstraints cellConstraints = new CellConstraints();
                ProposeTypesWidget.this.fLoadingAffordance.start();
                ProposeTypesWidget.this.fComponent.add((Component)ProposeTypesWidget.this.fLoadingAffordance.getComponent(), (Object)cellConstraints.xy(2, 2));
                ProposeTypesWidget.this.fComponent.revalidate();
                ProposeTypesWidget.this.fComponent.repaint();
            }
        });
    }

    @Override
    public void updateData(final ProposedTypesModel proposedTypesModel) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ProposeTypesWidget.this.fLoadingAffordance.stop();
                ProposeTypesWidget.this.fComponent.removeAll();
                CellConstraints cellConstraints = new CellConstraints();
                ProposeTypesWidget.this.fComponent.setLayout((LayoutManager)new FormLayout("fill:d:grow, fill:d, 3dlu, fill:d", "2dlu, fill:d:grow, 3dlu, fill:d, 2dlu"));
                ProposeTypesWidget.this.fComponent.add(ProposeTypesWidget.this.fParamAdapter.getComponent(), (Object)cellConstraints.xyw(1, 2, 4));
                ProposeTypesWidget.this.fComponent.add((Component)ProposeTypesWidget.this.fClearAnnotationsLink.getComponent(), (Object)cellConstraints.xy(2, 4));
                ProposeTypesWidget.this.fComponent.add((Component)ProposeTypesWidget.this.fViewReportLink.getComponent(), (Object)cellConstraints.xy(4, 4));
                ProposeTypesWidget.this.fComponent.revalidate();
                ProposeTypesWidget.this.fComponent.repaint();
                ProposeTypesWidget.this.fParamAdapter.updateData(proposedTypesModel);
            }
        });
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        sWidgets.remove(this);
        this.fBinder.dispose();
    }

    private static String[] getEnumConstants(Class clazz) {
        String[] stringArray = new String[clazz.getEnumConstants().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = clazz.getEnumConstants()[i].toString();
        }
        return stringArray;
    }

    private static void addUserChangeAffordance(ProposedTypesModel proposedTypesModel, JTable jTable, JTree jTree, int n, int n2, JComponent jComponent) {
        String string;
        String string2 = jTable.getValueAt(n, 0).toString();
        Object object = jTree.getSelectionPath().getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && proposedTypesModel.hasAnnotationData(string = ((DefaultMutableTreeNode)object).getUserObject().toString(), string2, proposedTypesModel.getColumnName(n2))) {
            jComponent.setBorder(LineBorder.createGrayLineBorder());
            jComponent.setBackground(Color.LIGHT_GRAY);
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private ProposedTypesModel fModel;
        private MJTree fTree;
        private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

        BooleanRenderer(ProposedTypesModel proposedTypesModel, MJTree mJTree) {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.fModel = proposedTypesModel;
            this.fTree = mJTree;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(NO_FOCUS_BORDER);
            }
            ProposeTypesWidget.addUserChangeAffordance(this.fModel, jTable, (JTree)this.fTree, n, n2, this);
            return this;
        }
    }

    private static class DoubleRenderer
    extends StringRenderer {
        DoubleRenderer(ProposedTypesModel proposedTypesModel, MJTree mJTree) {
            super(proposedTypesModel, mJTree);
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object object) {
            if (object == null) {
                return;
            }
            if (object.equals(Double.MIN_VALUE)) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
        }
    }

    private static class StringRenderer
    extends DefaultTableCellRenderer {
        private final ProposedTypesModel fModel;
        private final MJTree fTree;

        private StringRenderer(ProposedTypesModel proposedTypesModel, MJTree mJTree) {
            this.fModel = proposedTypesModel;
            this.fTree = mJTree;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(jTable.getBackground());
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ProposeTypesWidget.addUserChangeAffordance(this.fModel, jTable, (JTree)this.fTree, n, n2, this);
            return component;
        }
    }

    public static class EnumEditor
    extends DefaultCellEditor {
        public EnumEditor(Class clazz) {
            super((JComboBox<?>)new MJComboBox((Object[])ProposeTypesWidget.getEnumConstants(clazz)));
        }
    }

    private static class ParamAdapter
    implements ParamWidget<XmlReader> {
        private final Configuration fConfiguration;
        private final ProposedTypesModel fTypesModel;
        private final MJSplitPane fSplitPane;
        private final MJTree fTree;
        private final MJTable fTable;
        private final PropertyChangeListener fPropertyChangeListener;
        private final MulticastChangeListener fChangeListeners;
        private final TableModelListener fTableModelListener;
        private final MJMenuItem fMenuItem;
        private final MJPopupMenu fContextMenu;
        private ProposedTypesTableModel fCurrentTableModel;
        private XmlReader fSerializedData;

        ParamAdapter(Project project) {
            this.fConfiguration = project.getConfiguration();
            this.fTypesModel = new ProposedTypesModel(this.fConfiguration);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CoderResources.getString("fxp.proposedtypes.treeRoot"));
            this.fTree = new MJTree();
            this.fTree.setName("proposeTypesTree");
            this.fTree.setModel((TreeModel)new DefaultTreeModel(defaultMutableTreeNode));
            this.fMenuItem = new MJMenuItem(CoderResources.getString("fxp.proposedtypes.removeAnnotation"));
            this.fTable = new MJTable();
            this.fTable.setCellSelectionEnabled(false);
            this.fTable.setColumnSelectionAllowed(false);
            this.fTable.setEnabled(true);
            this.fTable.setName("proposeTypesTable");
            this.fTable.setRowSelectionAllowed(false);
            this.fTable.setShowHorizontalLines(false);
            this.fTable.setShowVerticalLines(true);
            this.fContextMenu = new MJPopupMenu();
            this.fContextMenu.add((JMenuItem)this.fMenuItem);
            this.fTable.add((Component)this.fContextMenu);
            MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTree);
            mJScrollPane.setMinimumSize(new Dimension(150, 23));
            mJScrollPane.getViewport().setBorder(null);
            MJScrollPane mJScrollPane2 = new MJScrollPane((Component)this.fTable);
            mJScrollPane2.getViewport().setBorder(null);
            this.fSplitPane = new MJSplitPane(1, (Component)mJScrollPane, (Component)mJScrollPane2);
            this.fSplitPane.setBorder(null);
            this.fChangeListeners = new MulticastChangeListener();
            this.fTableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    ParamAdapter.this.fSerializedData = ParamAdapter.this.fTypesModel.serializeAnnotations();
                    ParamAdapter.this.fChangeListeners.stateChanged(new ChangeEvent(ParamAdapter.this));
                    ParamAdapter.this.fTable.repaint();
                }
            };
            this.fPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("__result:category.workflow.proposefixpttypes")) {
                        if (propertyChangeEvent.getNewValue() == null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CoderResources.getString("fxp.proposedtypes.treeRoot"));
                            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
                            ParamAdapter.this.fTree.setModel((TreeModel)defaultTreeModel);
                            ParamAdapter.this.clearTable();
                        }
                    } else if (propertyChangeEvent.getPropertyName().equals("param.fixptconv.useStaticAnalysis") || propertyChangeEvent.getPropertyName().equals("param.fixptconv.OutputDisplayType")) {
                        ParamAdapter.this.fTypesModel.processColumnVisibility(ParamAdapter.this.fTable.getColumnModel());
                    }
                }
            };
            this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
            this.fMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    String string2;
                    boolean bl;
                    int n = ParamAdapter.this.fTable.getEditingRow();
                    int n2 = ParamAdapter.this.fTable.getEditingColumn();
                    Object object = ParamAdapter.this.fTree.getSelectionPath().getLastPathComponent();
                    if (object instanceof DefaultMutableTreeNode && (bl = ParamAdapter.this.removeAnnotation(n, n2, string2 = ((DefaultMutableTreeNode)object).getUserObject().toString(), string = ParamAdapter.this.fTable.getModel().getValueAt(n, 0).toString()))) {
                        ParamAdapter.this.fChangeListeners.stateChanged(new ChangeEvent(ParamAdapter.this));
                        ParamAdapter.this.fTable.repaint();
                    }
                }
            });
            this.fTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ParamAdapter.this.showCurrentFunctionInTable();
                }
            });
            this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    super.mousePressed(mouseEvent);
                    this.handlePopUp(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    super.mouseReleased(mouseEvent);
                    this.handlePopUp(mouseEvent);
                }

                private void handlePopUp(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = ParamAdapter.this.fTable.rowAtPoint(mouseEvent.getPoint());
                        int n2 = ParamAdapter.this.fTable.columnAtPoint(mouseEvent.getPoint());
                        Object object = ParamAdapter.this.fTree.getSelectionPath().getLastPathComponent();
                        if (object instanceof DefaultMutableTreeNode) {
                            String string = ((DefaultMutableTreeNode)object).getUserObject().toString();
                            String string2 = ParamAdapter.this.fTable.getModel().getValueAt(n, 0).toString();
                            if (ParamAdapter.this.fTypesModel.hasAnnotationData(string)) {
                                ParamAdapter.this.fTable.setEditingColumn(n2);
                                ParamAdapter.this.fTable.setEditingRow(n);
                                String string3 = ParamAdapter.this.fTypesModel.getColumnName(n2);
                                ParamAdapter.this.fMenuItem.setEnabled(n2 == 0 || ParamAdapter.this.fTypesModel.hasAnnotationData(string, string2, string3));
                                ParamAdapter.this.fContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    }
                }
            });
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isExternalLabelRequired() {
            return false;
        }

        public void setData(XmlReader xmlReader) {
            this.fTypesModel.clearAnnotationData();
            if (xmlReader != null) {
                this.fTypesModel.deserializeAnnotations(xmlReader);
            } else {
                this.showCurrentFunctionInTable();
            }
        }

        private void updateData(ProposedTypesModel proposedTypesModel) {
            this.fTypesModel.updateProposedTypes(proposedTypesModel);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CoderResources.getString("fxp.proposedtypes.treeRoot"));
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.fTree.setModel((TreeModel)defaultTreeModel);
            for (String string : proposedTypesModel.getFunctionNames()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            this.fTree.expandRow(0);
            this.fTree.setSelectionRow(proposedTypesModel.getFunctionCount());
        }

        private void showCurrentFunctionInTable() {
            Object object = this.fTree.getLastSelectedPathComponent();
            if (this.fTypesModel != null && object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                String string = defaultMutableTreeNode.getUserObject().toString();
                if (!this.fTypesModel.hasFunction(string)) {
                    return;
                }
                if (this.fCurrentTableModel != null) {
                    this.fCurrentTableModel.removeTableModelListener(this.fTableModelListener);
                }
                this.fTypesModel.resetColumnVisibility();
                this.fCurrentTableModel = new ProposedTypesTableModel(this.fTypesModel, string, this.fConfiguration);
                this.fCurrentTableModel.addTableModelListener(this.fTableModelListener);
                this.fTable.setModel((TableModel)this.fCurrentTableModel);
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setBackground(SystemColor.menu);
                TableColumn tableColumn = this.fTable.getColumnModel().getColumn(0);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                this.fTypesModel.setFieldTableColumn(0, tableColumn);
                DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer();
                defaultTableCellRenderer2.setHorizontalAlignment(0);
                tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
                this.fTable.getColumnModel().getColumn(this.fCurrentTableModel.getColumnCount() - 1).setHeaderRenderer(defaultTableCellRenderer2);
                DefaultTableCellRenderer defaultTableCellRenderer3 = new DefaultTableCellRenderer();
                defaultTableCellRenderer3.setHorizontalAlignment(0);
                DoubleRenderer doubleRenderer = new DoubleRenderer(this.fTypesModel, this.fTree);
                StringRenderer stringRenderer = new StringRenderer(this.fTypesModel, this.fTree);
                BooleanRenderer booleanRenderer = new BooleanRenderer(this.fTypesModel, this.fTree);
                EnumEditor enumEditor = new EnumEditor(RoundMode.class);
                EnumEditor enumEditor2 = new EnumEditor(OverflowMode.class);
                for (int i = 1; i < this.fCurrentTableModel.getColumnCount(); ++i) {
                    TableColumn tableColumn2 = this.fTable.getColumnModel().getColumn(i);
                    tableColumn2.setHeaderRenderer(defaultTableCellRenderer3);
                    JComponent jComponent = stringRenderer;
                    Class<?> clazz = this.fCurrentTableModel.getColumnClass(i);
                    if (clazz.equals(Double.class)) {
                        jComponent = doubleRenderer;
                    } else if (clazz.equals(Boolean.class)) {
                        jComponent = booleanRenderer;
                        int n = booleanRenderer.getMinimumSize().width;
                        tableColumn2.setMinWidth(n);
                        tableColumn2.setPreferredWidth(n + 20);
                    }
                    tableColumn2.setCellRenderer((TableCellRenderer)((Object)jComponent));
                    this.fTypesModel.setFieldTableColumn(i, tableColumn2);
                    String string2 = this.fCurrentTableModel.getVariableFieldName(i);
                    if (string2.equals("RoundMode")) {
                        tableColumn2.setCellEditor(enumEditor);
                        continue;
                    }
                    if (!string2.equals("OverflowMode")) continue;
                    tableColumn2.setCellEditor(enumEditor2);
                }
                this.fTypesModel.processColumnVisibility(this.fTable.getColumnModel());
            }
        }

        private void clearTable() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ParamAdapter.this.fTable.setModel((TableModel)new DefaultTableModel());
                }
            });
        }

        private boolean removeAnnotation(int n, int n2, String string, String string2) {
            boolean bl = false;
            if (this.fTypesModel.hasAnnotationData(string)) {
                String string3 = this.fTypesModel.getColumnName(n2);
                if (this.fTypesModel.hasAnnotationData(string, string2, string3)) {
                    Object object = this.fTypesModel.getProposedData(string, string2, string3);
                    this.fTable.setValueAt(object, n, n2);
                    bl = true;
                } else if (n2 == 0) {
                    for (int i = this.fCurrentTableModel.getColumnCount() - 1; i >= 0; --i) {
                        string3 = this.fTypesModel.getVariableFieldName(i);
                        Object object = this.fTypesModel.getProposedData(string, string2, string3);
                        this.fTable.setValueAt(object, n, i);
                    }
                    this.fTypesModel.removeAnnotationData(string, string2);
                    bl = true;
                }
            }
            return bl;
        }

        public XmlReader getData() {
            return this.fSerializedData;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.fChangeListeners.removeChangeListener(changeListener);
        }

        public boolean showValidationMessage(ValidationMessage validationMessage) {
            return false;
        }

        public void clearValidationMessage() {
        }

        public Component getComponent() {
            return this.fSplitPane;
        }

        public void dispose() {
            this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fTable.remove((Component)this.fContextMenu);
            this.fContextMenu.remove((Component)this.fMenuItem);
            this.clearTable();
            for (int i = 0; i < this.fTable.getColumnModel().getColumnCount(); ++i) {
                this.fTable.getColumnModel().getColumn(i).setCellEditor(null);
                this.fTable.getColumnModel().getColumn(i).setCellRenderer(null);
            }
            this.fTable.setColumnModel((TableColumnModel)new DefaultTableColumnModel());
        }
    }

    private static enum OverflowMode {
        saturate,
        wrap;

    }

    private static enum RoundMode {
        ceil,
        convergent,
        fix,
        floor,
        nearest,
        round;

    }
}

