/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.ImportExportUtils;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestQueue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class ExportAction
extends ProjectAction {
    private final Component fDialogParent;
    private final RequestQueue fBackgroundThread;
    public static final String KEY = "EXPORT_CONFIG_OBJECT";

    public ExportAction(Component component) {
        super(KEY, CoderResources.getString("action.exportConfigObject"), CoderResources.getIcon("export.png"));
        this.fDialogParent = component;
        this.fBackgroundThread = new RequestQueue("MATLAB Coder settings export thread");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fBackgroundThread.request(new Runnable(){

            @Override
            public void run() {
                String[] stringArray = MATFileUtils.getNames((List)MATFileUtils.getWorkspaceVariables());
                final HashSet<String> hashSet = new HashSet<String>();
                hashSet.addAll(Arrays.asList(stringArray));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExportAction.this.showDialog(hashSet);
                    }
                });
            }
        });
    }

    public void showDialog(final Set<String> set) {
        MJPanel mJPanel;
        Window window = SwingUtilities.windowForComponent(this.fDialogParent);
        String string = CoderResources.getString("export.settings.title");
        final MJDialog mJDialog = window instanceof Frame ? new MJDialog((Frame)window, string) : new MJDialog((Dialog)window, string);
        MJLabel mJLabel = new MJLabel(CoderResources.getString("export.settings.desc"));
        MJHelpButton mJHelpButton = new MJHelpButton();
        final MJButton mJButton = new MJButton(BuiltInResources.getString((String)"button.ok"));
        MJButton mJButton2 = new MJButton(BuiltInResources.getString((String)"button.cancel"));
        final MJLabel mJLabel2 = new MJLabel();
        mJLabel2.setHorizontalAlignment(0);
        mJHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Target target = ProjectGUI.getInstance().getCurrentProject().getConfiguration().getTarget();
                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                MLHelpServices.cshDisplayTopic((Object)ExportAction.this.fDialogParent, (String)string, (String)"help_button_export_settings");
            }
        });
        JPanel jPanel = ButtonBarFactory.buildHelpBar((JButton)mJHelpButton, (JButton)mJButton, (JButton)mJButton2);
        MJLabel mJLabel3 = new MJLabel(CoderResources.getString("export.settings.varname.label"));
        final ValidatableTextField validatableTextField = new ValidatableTextField(new Validatable(){

            public Validity validateText(String string) {
                if (!MatlabLanguage.isValidVariableName((String)string)) {
                    mJLabel2.setText(CoderResources.getString("error.export.invalid.varname"));
                    mJButton.setEnabled(false);
                    return Validity.INVALID;
                }
                if (set.contains(string)) {
                    mJLabel2.setText(CoderResources.getString("warning.export.existing.varname"));
                    mJButton.setEnabled(true);
                    return Validity.WARNING;
                }
                mJLabel2.setText(" ");
                mJButton.setEnabled(true);
                return Validity.VALID;
            }

            public Validity getValidityWhenBlank() {
                mJLabel2.setText(" ");
                mJButton.setEnabled(false);
                return Validity.INVALID;
            }
        });
        validatableTextField.setColumns(20);
        validatableTextField.setText(ExportAction.getNonexistentVariableName(set));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportExportUtils.exportCurrentProjectSettings(validatableTextField.getText());
                mJDialog.dispose();
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mJDialog.dispose();
            }
        });
        mJDialog.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = Utilities.getDialogBannerInsets();
        gridBagConstraints.insets.left = Utilities.getDialogButtonBarInsets().left + 2;
        gridBagConstraints.insets.right = Utilities.getDialogButtonBarInsets().right;
        mJDialog.add((Component)mJLabel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.right = 4;
        if (PlatformInfo.isMacintosh()) {
            mJPanel = new MJPanel((LayoutManager)new FlowLayout(1));
            mJPanel.add((Component)mJLabel3);
            mJPanel.add((Component)validatableTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            mJDialog.add((Component)mJPanel, (Object)gridBagConstraints);
            gridBagConstraints.fill = 2;
        } else {
            mJDialog.add((Component)mJLabel3, (Object)gridBagConstraints);
            gridBagConstraints.insets.right = gridBagConstraints.insets.left;
            gridBagConstraints.insets.left = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridx;
            mJDialog.add((Component)validatableTextField, (Object)gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.left = gridBagConstraints.insets.right;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.bottom = 3;
        mJDialog.add((Component)mJLabel2, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        mJDialog.add((Component)mJPanel, (Object)gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = Utilities.getDialogButtonBarInsets();
        mJDialog.add((Component)jPanel, (Object)gridBagConstraints);
        mJDialog.setSize(550, 260);
        mJDialog.setResizable(false);
        mJDialog.getRootPane().setDefaultButton((JButton)mJButton);
        mJDialog.setLocationRelativeTo((Component)window);
        mJDialog.setVisible(true);
    }

    private static String getNonexistentVariableName(Set<String> set) {
        for (int i = 0; i < 50; ++i) {
            String string = "config" + (i == 0 ? "" : Integer.valueOf(i));
            if (set.contains(string)) continue;
            return string;
        }
        return "config";
    }
}

