/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

class TagManager {
    private LayoutArea fLayoutArea;
    private Hashtable fCounts;

    TagManager(LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        this.fCounts = new Hashtable();
    }

    private void setNameFromBaseTag(Component component, String string) {
        int n;
        if (this.fCounts.containsKey(string)) {
            n = (Integer)this.fCounts.get(string);
            this.fCounts.remove(string);
            ++n;
        } else {
            n = 1;
        }
        String string2 = string + n;
        while (this.isNameInUse(component, string2)) {
            string2 = string + ++n;
        }
        component.setName(string2);
        this.fCounts.put(string, new Integer(n));
    }

    void setNewUniqueName(Object object) {
        BeanInfo beanInfo = null;
        if (object instanceof Component) {
            Component component = (Component)object;
            try {
                beanInfo = Introspector.getBeanInfo(component.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (beanInfo != null) {
                String string = beanInfo.getBeanDescriptor().getDisplayName().toLowerCase();
                String string2 = this.stripSpaces(string);
                this.setNameFromBaseTag(component, string2);
            }
        }
    }

    void setUniqueName(Object object) {
        BeanInfo beanInfo = null;
        if (object instanceof Component) {
            Component component = (Component)object;
            try {
                beanInfo = Introspector.getBeanInfo(component.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (beanInfo != null) {
                String string = component.getName();
                if (string == null || string.length() == 0) {
                    String string2 = beanInfo.getBeanDescriptor().getDisplayName().toLowerCase();
                    String string3 = this.stripSpaces(string2);
                    this.setNameFromBaseTag(component, string3);
                } else if (this.isNameInUse(object, string)) {
                    String string4 = this.stripIntegerOffEnd(string);
                    this.setNameFromBaseTag(component, string4);
                }
            }
        }
    }

    private String stripIntegerOffEnd(String string) {
        int n = string.length() - 1;
        char c = string.charAt(n);
        while (n > 0 && c >= '0' && c <= '9') {
            c = string.charAt(--n);
        }
        String string2 = n == 0 && c >= '0' && c <= '9' ? "" : string.substring(0, n + 1);
        return string2;
    }

    private String stripSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    boolean isNameInUse(Object object, String string) {
        Enumeration enumeration = this.fLayoutArea.allWrappers();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            Object object2 = ((LOControlWrapper)enumeration.nextElement()).getBean();
            if (object2 == object || !(object2 instanceof Component) || !string.equals(((Component)object2).getName())) continue;
            bl = true;
        }
        return bl;
    }
}

