/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.jgoodies.forms.layout.Sizes;
import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.table.TableEditor;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ObjectOwner;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolbox.matlab.guide.GuidePreferenceEnum;
import com.mathworks.toolbox.matlab.guide.HGControl;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutClipboard;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.LayoutMRUFiles;
import com.mathworks.toolbox.matlab.guide.LayoutPrefs;
import com.mathworks.toolbox.matlab.guide.LayoutStatusBar;
import com.mathworks.toolbox.matlab.guide.ResourceManager;
import com.mathworks.toolbox.matlab.guide.RuntimeArea;
import com.mathworks.toolbox.matlab.guide.action.CallbackAction;
import com.mathworks.toolbox.matlab.guide.action.LayoutActionEnum;
import com.mathworks.toolbox.matlab.guide.action.LayoutActionManager;
import com.mathworks.toolbox.matlab.guide.action.OpenMRUAction;
import com.mathworks.toolbox.matlab.guide.alignmenttool.AlignToolbar;
import com.mathworks.toolbox.matlab.guide.dragdrop.AddDragListener;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.GridDialog;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutGrid;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutGridTarget;
import com.mathworks.toolbox.matlab.guide.gridrulerguide.LayoutRuler;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolHandler;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolInfo;
import com.mathworks.toolbox.matlab.guide.layouttool.LayoutToolRegistry;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditor;
import com.mathworks.toolbox.matlab.guide.objectbrowser.ObjectBrowser;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.MObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.ToolPalette;
import com.mathworks.toolbox.matlab.guide.palette.ToolRegistry;
import com.mathworks.toolbox.matlab.guide.scroll.ScrollPanel;
import com.mathworks.toolbox.matlab.guide.tabordereditor.TabOrderEditor;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoManager;
import com.mathworks.toolbox.matlab.guide.utils.BottomBorder;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.desk.DTWindowHandler;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class LayoutEditor
extends MJPanel
implements UndoableEditListener,
CompletionObserver,
ObjectOwner {
    public static final String LAYOUT_EDITOR_SERVICE = "com/mathworks/toolbox/matlab/guide/LayoutEditor";
    public static final String GUIDE_NAME = "GUIDE";
    private static final String LAYOUT_PAGE = ResourceManager.getString("string.layout");
    private static final String RUNTIME_PAGE = ResourceManager.getString("string.runtime");
    private static final int DEFAULT_WIDTH = 560;
    private static final int DEFAULT_HEIGHT = 420;
    private static final int OK = 0;
    private static final int CANCEL = 2;
    private static final int FIGURE_SELECTED = -1;
    private static final int MULTIPLE_CONTROLS = -2;
    private static final String UNTITLED_STRING = ResourceManager.getString("string.untitled");
    private static final String FIGURE_EXTENSION = ".fig";
    private static final int INITIAL_HORIZONTAL_LOCATION = 20;
    private static final int INITIAL_VERTICAL_LOCATION = 60;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 20;
    private static int sCount;
    private static int sOpenCount;
    private static int sHorizontalLocation;
    private static int sVerticalLocation;
    private static Vector<LayoutEditor> sLayoutEditors;
    private static boolean sInspectorOpenFromLayout;
    private static boolean sBrowserOpenFromLayout;
    private ToolPalette fToolPalette;
    private Component fToolbar;
    private LayoutStatusBar fStatusBar;
    private LayoutArea fLayoutArea;
    private RuntimeArea fRuntimeArea;
    private LayoutGrid fLayoutGrid;
    private MJPanel fTogglePanel;
    private LayoutFrame fEditorFrame;
    private LayoutUndoManager fUndoManager;
    private LayoutActionManager fActionManager;
    private PrefListener fPrefListener;
    private File fFile;
    private Object fHandle;
    private Object fBean;
    private AlignToolbar fAlignToolbar;
    private MJFrame fAlignmentFrame;
    private GridDialog fGridDialog;
    private MJFrame fGridFrame;
    private MenuEditor fMenuEditor;
    private MJFrame fTabFrame;
    private TabOrderEditor fTabEditor;
    private Rectangle fRuntimeBounds;
    private Rectangle fLayoutBounds;
    private boolean fDirty;
    private boolean fNoExtension;
    private boolean fCurrentlyRunning;
    private final int DEFAULT_PADDING = Sizes.dialogUnitXAsPixel((int)20, (Component)((Object)this));
    private boolean fShowToolBar = GuidePreferenceEnum.getBooleanPreference(GuidePreferenceEnum.SHOW_TOOLBAR);
    private boolean fShowStatusBar = GuidePreferenceEnum.getBooleanPreference(GuidePreferenceEnum.SHOW_STATUSBAR);
    private boolean fShowToolNames = LayoutPrefs.sShowToolNames;
    private boolean fShowExtension = LayoutPrefs.sShowExtension;
    private boolean fShowFullPath = LayoutPrefs.sShowFullPath;
    private LayoutToolHandler fToolHandler;
    private static LayoutFrame sCurrentLayout;
    private static ResourceBundle sRes;
    private boolean fTestMode = false;

    private LayoutEditor() {
        this.buildLayoutEditor();
    }

    public LayoutActionManager getActionManager() {
        return this.fActionManager;
    }

    private void buildLayoutEditor() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setName("Layout Editor");
        this.fActionManager = new LayoutActionManager(this);
        this.fEditorFrame = new LayoutFrame();
        this.getFrame().setName(ResourceManager.getUntranslatedString("windowname.editorframe"));
        new WindowHandler(this.getFrame());
        this.fUndoManager = new LayoutUndoManager(this);
        this.fUndoManager.addUndoableEditListener(this);
        this.fRuntimeArea = new RuntimeArea(this);
        this.fRuntimeArea.setSize(560, 420);
        if (PlatformInfo.isMacintosh()) {
            this.getFrame().addComponentListener(new FrameMoved());
        }
        this.fRuntimeBounds = new Rectangle(sHorizontalLocation, sVerticalLocation, 560, 420);
        this.fLayoutArea = new LayoutArea(this, 560, 420, this.fRuntimeArea);
        this.fLayoutArea.setUndoManager(this.fUndoManager);
        this.fLayoutGrid = new LayoutGrid();
        this.fLayoutArea.setGrid(this.fLayoutGrid);
        this.fToolPalette = this.buildToolPalette();
        this.fLayoutArea.setPalette(this.fToolPalette);
        ScrollPanel scrollPanel = new ScrollPanel(this.fLayoutArea);
        this.add(scrollPanel, "Center");
        this.add((Component)((Object)this.fToolPalette), "West");
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setOpaque(false);
        mJPanel.add((Component)((Object)this), (Object)"Center");
        if (this.fShowToolBar) {
            this.fToolbar = this.fEditorFrame.createLayoutToolbar();
            mJPanel.add(this.fToolbar, (Object)"North");
        }
        this.fTogglePanel = new MJPanel((LayoutManager)new CardLayout());
        this.fTogglePanel.setOpaque(false);
        this.getFrame().add((Component)this.fTogglePanel, "Center");
        this.fTogglePanel.add((Component)mJPanel, (Object)LAYOUT_PAGE);
        this.fTogglePanel.add((Component)this.fRuntimeArea, (Object)RUNTIME_PAGE);
        int n = 420;
        LayoutRuler layoutRuler = new LayoutRuler(this.fLayoutArea, 1, 0);
        LayoutRuler layoutRuler2 = new LayoutRuler(this.fLayoutArea, 0, n);
        layoutRuler.setGridWidth(this.fLayoutGrid.getGridWidth());
        layoutRuler2.setGridWidth(this.fLayoutGrid.getGridWidth());
        this.fLayoutArea.setHRuler(layoutRuler);
        this.fLayoutArea.setVRuler(layoutRuler2);
        scrollPanel.add((Component)((Object)layoutRuler), "North");
        scrollPanel.add((Component)((Object)layoutRuler2), "West");
        scrollPanel.add(LayoutRuler.buildMitre(), "Northwest");
        scrollPanel.addScrollTarget(layoutRuler);
        scrollPanel.addScrollTarget(layoutRuler2);
        this.fEditorFrame.addLayoutMenuBar();
        this.fLayoutArea.addService(LAYOUT_EDITOR_SERVICE, this);
        Dimension dimension = this.getParent().getPreferredSize();
        this.fLayoutBounds = new Rectangle(sHorizontalLocation, sVerticalLocation, dimension.width + this.DEFAULT_PADDING, dimension.height);
        this.setContentBounds(this.fLayoutBounds);
        this.fPrefListener = new PrefChanged();
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"Layout");
        this.addToLayoutEditorList(this);
        this.showStatusBar(false);
        this.fToolHandler = new LayoutToolHandler(this);
    }

    public String toString() {
        String string = "";
        if (this.fRuntimeArea != null) {
            string = ResourceManager.getString("string.layout_document") + " [" + this.fRuntimeArea.getName() + "]";
        }
        return string;
    }

    private ToolPalette buildToolPalette() {
        return new ToolPalette(ToolRegistry.getUIControlToolRegistry(), this.fShowToolNames, new AddDragListener(this.fLayoutArea));
    }

    private MJPopupMenu buildObjectPopup() {
        MJAbstractAction mJAbstractAction = this.fActionManager.getAction(LayoutActionEnum.EDIT_PROPERTIES);
        MJMenuItem mJMenuItem = new MJMenuItem((Action)mJAbstractAction);
        DynamicObjectMenu dynamicObjectMenu = new DynamicObjectMenu(ResourceManager.getString("popmenu.layout"), (JMenuItem)mJMenuItem);
        dynamicObjectMenu.setName(ResourceManager.getUntranslatedString("menuname.object_context"));
        JMenuItem jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.CUT));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.cut"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.COPY));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.copy"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.PASTE));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.paste"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.CLEAR));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.clear"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.DUPLICATE));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.duplicate"));
        dynamicObjectMenu.addSeparator();
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.MOVE_TO_FRONT));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.movefront"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.MOVE_TO_BACK));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.moveback"));
        dynamicObjectMenu.addSeparator();
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.OBJECT_BROWSER));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.objectbrowser"));
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.MFILE_EDITOR));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.mfile"));
        dynamicObjectMenu.addSeparator();
        MJMenu mJMenu = new MJMenu((Action)this.fActionManager.getAction(LayoutActionEnum.CALLBACK_CMDS));
        mJMenu.setName(ResourceManager.getUntranslatedString("menuname.object_callback"));
        dynamicObjectMenu.add((JMenuItem)mJMenu);
        dynamicObjectMenu.addSeparator();
        jMenuItem = dynamicObjectMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.PROPERTY_INSPECTOR));
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.inspector"));
        jMenuItem = dynamicObjectMenu.add((JMenuItem)mJMenuItem);
        jMenuItem.setName(ResourceManager.getUntranslatedString("objcontext.properties"));
        return dynamicObjectMenu;
    }

    private MJPopupMenu buildWindowPopup() {
        DynamicMenu dynamicMenu = new DynamicMenu(ResourceManager.getString("popmenu.layout"));
        dynamicMenu.setName(ResourceManager.getUntranslatedString("menuname.window_context"));
        JMenuItem jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.PASTE));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.paste"));
        SnapMenuItem snapMenuItem = new SnapMenuItem((Action)this.fActionManager.getAction(LayoutActionEnum.SNAP_TO_GRID));
        jMenuItem = dynamicMenu.add((JMenuItem)((Object)snapMenuItem));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.snaptogrid"));
        dynamicMenu.addSeparator();
        jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.RUN));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.run"));
        dynamicMenu.addSeparator();
        if (!PlatformInfo.isMacintosh()) {
            jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.APP_OPTIONS));
            jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.guioptions"));
            dynamicMenu.addSeparator();
        }
        jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.PROPERTY_INSPECTOR));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.inspector"));
        jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.OBJECT_BROWSER));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.objectbrowser"));
        jMenuItem = dynamicMenu.add((Action)this.fActionManager.getAction(LayoutActionEnum.MFILE_EDITOR));
        jMenuItem.setName(ResourceManager.getUntranslatedString("wincontext.mfile"));
        dynamicMenu.addSeparator();
        MJMenu mJMenu = new MJMenu((Action)this.fActionManager.getAction(LayoutActionEnum.CALLBACK_CMDS));
        mJMenu.setName(ResourceManager.getUntranslatedString("menuname.window_callback"));
        dynamicMenu.add((JMenuItem)mJMenu);
        this.fLayoutGrid.addLayoutGridTarget(new SnapChanged((JMenuItem)((Object)snapMenuItem)));
        return dynamicMenu;
    }

    public Object getHandle() {
        return this.fHandle;
    }

    public boolean isHandle() {
        return this.fHandle != null;
    }

    public Object getToolHandler() {
        return this.fToolHandler;
    }

    public Insets getInsets() {
        if (PlatformInfo.isWindows()) {
            return new Insets(2, 2, 2, 2);
        }
        return super.getInsets();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.updateUndoRedoDisplay();
    }

    public void updateUndoRedoDisplay() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJAbstractAction mJAbstractAction = LayoutEditor.this.fActionManager.getAction(LayoutActionEnum.UNDO);
                mJAbstractAction.setEnabled(LayoutEditor.this.fUndoManager.hasUndo());
                mJAbstractAction.setName(LayoutEditor.this.fUndoManager.getUndoName());
                MJAbstractAction mJAbstractAction2 = LayoutEditor.this.fActionManager.getAction(LayoutActionEnum.REDO);
                mJAbstractAction2.setEnabled(LayoutEditor.this.fUndoManager.hasRedo());
                mJAbstractAction2.setName(LayoutEditor.this.fUndoManager.getRedoName());
            }
        });
    }

    public void doCommand(LayoutActionEnum layoutActionEnum) {
        switch (layoutActionEnum) {
            case NEW: {
                this.doNew();
                break;
            }
            case OPEN: {
                this.doOpen();
                break;
            }
            case CLOSE: {
                this.closeWindow(0);
                break;
            }
            case SAVE: {
                this.doSave();
                break;
            }
            case SAVE_AS: {
                this.doSaveAs();
                break;
            }
            case GUI_EXPORT: {
                this.doExport();
                break;
            }
            case PREFERENCES: {
                this.doPreferences();
                break;
            }
            case PRINT: {
                this.doPrint();
                break;
            }
            case UNDO: {
                if (this.fUndoManager == null) break;
                this.fUndoManager.undo();
                break;
            }
            case REDO: {
                if (this.fUndoManager == null) break;
                this.fUndoManager.redo();
                break;
            }
            case CUT: {
                this.fLayoutArea.doCut();
                this.updatePaste();
                break;
            }
            case COPY: {
                this.fLayoutArea.doCopy();
                this.updatePaste();
                break;
            }
            case PASTE: {
                this.fLayoutArea.doPaste();
                break;
            }
            case CLEAR: {
                this.fLayoutArea.doClear();
                break;
            }
            case SELECT_ALL: {
                this.fLayoutArea.selectAllObjects(true);
                break;
            }
            case DUPLICATE: {
                LOControlWrapper lOControlWrapper = null;
                Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
                if (vector != null && !vector.isEmpty()) {
                    lOControlWrapper = vector.elementAt(0).getParent();
                }
                this.fLayoutArea.doDuplicate(lOControlWrapper, new Point(10, 10));
                break;
            }
            case MOVE_TO_FRONT: {
                this.fLayoutArea.moveToFront();
                break;
            }
            case MOVE_TO_BACK: {
                this.fLayoutArea.moveToBack();
                break;
            }
            case MOVE_FORWARD: {
                this.fLayoutArea.moveForward();
                break;
            }
            case MOVE_BACKWARD: {
                this.fLayoutArea.moveBackward();
                break;
            }
            case EDIT_PROPERTIES: {
                this.showPropertyEditor();
                break;
            }
            case PROPERTY_INSPECTOR: {
                if (!this.fLayoutArea.hasSelection()) {
                    Object[] objectArray = new Object[]{this.getBean()};
                    ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
                }
                LayoutEditor.showInspector();
                break;
            }
            case ALIGN_OBJECTS: {
                this.showAlignmentWindow();
                break;
            }
            case SHOW_TOOLBAR: {
                this.fShowToolBar = !this.fShowToolBar;
                this.showToolbar(true);
                break;
            }
            case SHOW_STATUSBAR: {
                this.fShowStatusBar = !this.fShowStatusBar;
                this.showStatusBar(true);
                if (!this.fShowStatusBar) break;
                this.fStatusBar.updateSelectionCoord();
                break;
            }
            case GRID_RULERS: {
                this.showGridDlgWindow();
                break;
            }
            case SNAP_TO_GRID: {
                this.toggleSnap();
                break;
            }
            case MENU_EDITOR: {
                this.showMenuEditor();
                break;
            }
            case TAB_ORDER: {
                this.showTabEditor();
                break;
            }
            case OBJECT_BROWSER: {
                LayoutEditor.showObjectBrowser();
                break;
            }
            case MFILE_EDITOR: {
                this.showCallbackEditor();
                break;
            }
            case APP_OPTIONS: {
                if (this.fHandle == null) break;
                LayoutLooper.applicationOptions(this.fHandle);
                break;
            }
            case RUN: {
                if (this.fHandle == null) break;
                LayoutLooper.activateFigure(this.fHandle, new ActivateCompleted());
                this.setCurrentlyRunning(true);
                break;
            }
            case GETTING_STARTED: {
                LayoutLooper.executeInM("helpGettingStarted");
                break;
            }
            case HELP_LAYING_OUT_GUIS: {
                LayoutLooper.executeInM("helpLayingOutGUIs");
                break;
            }
            case HELP_PROGRAMMING_GUIS: {
                LayoutLooper.executeInM("helpProgrammingGUIs");
                break;
            }
            case EXAMPLE_GUIS: {
                LayoutLooper.executeInM("helpExampleGUIs");
                break;
            }
            case ONLINE_VIDEOS: {
                LayoutLooper.executeInM("helpOnlineDemos");
                break;
            }
            case CONTENT_CHANGED: {
                this.contentChanged(null);
                break;
            }
        }
    }

    public void doRegisteredToolCommand(int n) {
        int n2 = 10000;
        int n3 = n2 + LayoutToolRegistry.getNumberOfTools();
        if (n >= n2 && n < n3) {
            this.fToolHandler.doToolAction(n - n2, "start");
        } else {
            System.out.println("Unhandled LayoutEditor doRegisteredToolCommand option " + n);
        }
    }

    public void updateAction(LayoutActionEnum layoutActionEnum) {
        MJAbstractAction mJAbstractAction = this.fActionManager.getAction(layoutActionEnum);
        if (mJAbstractAction != null) {
            mJAbstractAction.setEnabled(this.isActionEnabled(layoutActionEnum));
        }
    }

    public boolean isActionEnabled(LayoutActionEnum layoutActionEnum) {
        switch (layoutActionEnum) {
            case CUT: 
            case COPY: 
            case CLEAR: 
            case DUPLICATE: 
            case MOVE_TO_FRONT: 
            case MOVE_TO_BACK: 
            case MOVE_FORWARD: 
            case MOVE_BACKWARD: {
                return this.fLayoutArea.hasSelection();
            }
            case PASTE: {
                return LayoutClipboard.getClipboard().canPaste(this.fLayoutArea);
            }
            case RUN: {
                return !this.fCurrentlyRunning;
            }
            case GUI_EXPORT: 
            case MENU_EDITOR: 
            case TAB_ORDER: {
                return this.fHandle != null;
            }
            case MFILE_EDITOR: {
                boolean bl = false;
                if (this.fHandle != null) {
                    bl = this.fLayoutArea.getLayoutOptions().isMfileMode();
                }
                return bl;
            }
            case SAVE: {
                return this.fDirty;
            }
            case UNDO: {
                return this.fUndoManager != null && this.fUndoManager.canUndo();
            }
            case REDO: {
                return this.fUndoManager != null && this.fUndoManager.canRedo();
            }
            case EDIT_PROPERTIES: {
                return this.isTypeSelected(1, 10) || this.isTypeSelected(6, 0);
            }
        }
        int n = layoutActionEnum.ordinal();
        return n < 10000 || this.fHandle != null;
    }

    public Frame getFrame() {
        return this.fEditorFrame.getFrame();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean getDirty() {
        return this.fDirty;
    }

    public void setDirty(boolean bl) {
        if (bl != this.fDirty) {
            this.fDirty = bl;
            this.fActionManager.getAction(LayoutActionEnum.SAVE).setEnabled(bl);
        }
    }

    public boolean isCurrentlyRunning() {
        return this.fCurrentlyRunning;
    }

    public void setCurrentlyRunning(boolean bl) {
        if (this.fCurrentlyRunning != bl) {
            this.fCurrentlyRunning = bl;
            this.updateAction(LayoutActionEnum.RUN);
        }
    }

    public final LayoutArea getLayoutArea() {
        return this.fLayoutArea;
    }

    public final RuntimeArea getRuntimeArea() {
        return this.fRuntimeArea;
    }

    private void buildAlignmentWindow() {
        this.fAlignToolbar = new AlignToolbar(this.fLayoutArea);
        this.fAlignmentFrame = this.buildToolWindow((Component)((Object)this.fAlignToolbar), ResourceManager.getString("windowtitle.alignobjects"), ResourceManager.getUntranslatedString("windowname.alignobjects"));
    }

    private boolean isTypeSelected(int n, int n2) {
        if (this.fLayoutArea.hasSelection() && this.fLayoutArea.getSelectedObjectCount() == 1) {
            Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
            LOControlWrapper lOControlWrapper = vector.elementAt(0);
            int n3 = lOControlWrapper.getControlType();
            switch (n) {
                case 1: {
                    return lOControlWrapper.isGObjectType(n2);
                }
                case 6: {
                    return n3 == n;
                }
            }
            return false;
        }
        return false;
    }

    private void saveControlTypeInAction(MJAbstractAction mJAbstractAction) {
        if (this.fLayoutArea.hasSelection() && this.fLayoutArea.getSelectedObjectCount() == 1) {
            Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
            LOControlWrapper lOControlWrapper = vector.elementAt(0);
            int n = lOControlWrapper.getControlType();
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    mJAbstractAction.putValue("MTYPE", (Object)n);
                    mJAbstractAction.putValue("GTYPE", (Object)lOControlWrapper.getGObjectType());
                    break;
                }
                case 6: {
                    mJAbstractAction.putValue("MTYPE", (Object)6);
                    mJAbstractAction.putValue("GTYPE", (Object)Integer.MIN_VALUE);
                }
            }
        } else if (this.fLayoutArea.hasSelection()) {
            mJAbstractAction.putValue("MTYPE", (Object)-2);
            mJAbstractAction.putValue("GTYPE", (Object)-2);
        } else {
            mJAbstractAction.putValue("MTYPE", (Object)-1);
            mJAbstractAction.putValue("GTYPE", (Object)-1);
        }
    }

    private void showToolbar(boolean bl) {
        if (this.fShowToolBar) {
            if (this.fToolbar == null) {
                this.fToolbar = this.fEditorFrame.createLayoutToolbar();
                this.getParent().add(this.fToolbar, "North");
            }
        } else if (this.fToolbar != null) {
            this.getParent().remove(this.fToolbar);
            this.fToolbar = null;
        }
        this.getParent().validate();
        if (bl) {
            Prefs.setBooleanPref((String)GuidePreferenceEnum.SHOW_TOOLBAR.getKey(), (boolean)this.fShowToolBar);
        }
    }

    private void showStatusBar(boolean bl) {
        if (this.fShowStatusBar) {
            if (this.fStatusBar == null) {
                this.fStatusBar = new LayoutStatusBar(this.fLayoutArea);
                this.fLayoutArea.setLayoutStatusBar(this.fStatusBar);
                this.getParent().add((Component)((Object)this.fStatusBar), "South");
            }
        } else if (this.fStatusBar != null) {
            this.getParent().remove((Component)((Object)this.fStatusBar));
            this.fStatusBar = null;
        }
        this.getParent().validate();
        if (bl) {
            Prefs.setBooleanPref((String)GuidePreferenceEnum.SHOW_STATUSBAR.getKey(), (boolean)this.fShowStatusBar);
        }
    }

    private void showPropertyEditor() {
        MJAbstractAction mJAbstractAction = this.fActionManager.getAction(LayoutActionEnum.EDIT_PROPERTIES);
        int n = (Integer)mJAbstractAction.getValue("MTYPE");
        switch (n) {
            case 1: {
                int n2 = (Integer)mJAbstractAction.getValue("GTYPE");
                if (n2 != 10) break;
                Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
                GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(0);
                TableEditor.showTableEditorDialog((Frame)this.getFrame(), (Object)gObjectWrapper.getPeerBean(), (!this.fTestMode ? 1 : 0) != 0);
                break;
            }
            case 6: {
                Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
                if (vector == null || vector.size() != 1) break;
                GObjectWrapper gObjectWrapper = (GObjectWrapper)vector.elementAt(0);
                LayoutLooper.showPropertyPage(gObjectWrapper.getHandle());
            }
        }
    }

    private void buildGridDlgWindow() {
        this.fGridDialog = new GridDialog(this.fLayoutArea);
        this.fGridFrame = this.buildToolWindow((Component)((Object)this.fGridDialog), ResourceManager.getString("windowtitle.gridrulers"), ResourceManager.getUntranslatedString("windowname.gridrulers"));
    }

    private void buildTabEditorWindow() {
        this.fTabEditor = new TabOrderEditor(this.fLayoutArea);
        this.fTabFrame = this.buildToolWindow((Component)((Object)this.fTabEditor), ResourceManager.getString("windowtitle.taborder"), ResourceManager.getUntranslatedString("windowname.taborder"));
        this.fTabFrame.setResizable(true);
    }

    private MJFrame buildToolWindow(Component component, String string, String string2) {
        MJFrame mJFrame = new MJFrame(string);
        mJFrame.setName(string2);
        mJFrame.setResizable(false);
        mJFrame.add("Center", component);
        mJFrame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
            }
        });
        Rectangle rectangle = this.getFrame().getBounds();
        int n = rectangle.x + rectangle.width + 8;
        int n2 = rectangle.y;
        mJFrame.setLocation(n, n2);
        return mJFrame;
    }

    private void showToolWindow(MJFrame mJFrame, boolean bl) {
        if (mJFrame != null && this.fLayoutArea != null) {
            Point point;
            if (bl) {
                mJFrame.pack();
                Rectangle rectangle = mJFrame.getBounds();
                point = WindowUtils.ensureOnScreen((Point)new Point(rectangle.x, rectangle.y), (Dimension)new Dimension(rectangle.width, rectangle.height), (int)8);
            } else {
                point = mJFrame.getLocation();
            }
            mJFrame.setLocation(point);
            mJFrame.setVisible(true);
        }
    }

    private void showAlignmentWindow() {
        boolean bl;
        boolean bl2 = bl = this.fAlignmentFrame == null;
        if (this.fAlignmentFrame == null) {
            this.buildAlignmentWindow();
        }
        this.showToolWindow(this.fAlignmentFrame, bl);
    }

    private void showGridDlgWindow() {
        boolean bl;
        boolean bl2 = bl = this.fGridFrame == null;
        if (this.fGridFrame == null) {
            this.buildGridDlgWindow();
        }
        if (this.fGridFrame != null && this.fLayoutArea != null && !this.fGridFrame.isVisible()) {
            this.fGridDialog.updateState();
        }
        this.showToolWindow(this.fGridFrame, bl);
    }

    private void showTabEditor() {
        boolean bl;
        boolean bl2 = bl = this.fTabFrame == null;
        if (this.fTabFrame == null) {
            this.buildTabEditorWindow();
        }
        this.showToolWindow(this.fTabFrame, bl);
    }

    public static void showInspector() {
        if (!MLInspectorServices.isInspectorOpen()) {
            sInspectorOpenFromLayout = true;
        }
        MLInspectorServices.activateInspector();
    }

    public static void showObjectBrowser() {
        if (!ObjectBrowser.isObjectBrowserOpen()) {
            sBrowserOpenFromLayout = true;
        }
        ObjectBrowser.activateObjectBrowser();
    }

    private void toggleSnap() {
        this.setSnap(!this.getSnap());
    }

    boolean getSnap() {
        return this.fLayoutGrid.getSnapToGrid();
    }

    void setSnap(boolean bl) {
        this.fLayoutGrid.setSnapToGrid(bl);
    }

    public void toFront() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LayoutEditor.this.getFrame().toFront();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public final String[] getComponentNames() {
        return this.fLayoutArea.getComponentNames();
    }

    public final Object getComponentByName(String string) {
        return this.fLayoutArea.getComponentByName(string);
    }

    public File getFile() {
        File file = null;
        if (this.fFile != null) {
            file = new File(this.fFile.getPath());
        }
        return file;
    }

    void fireObjectChangedEvent() {
        Object[] objectArray = new Object[]{this.getBean()};
        ObjectRegistry.getLayoutRegistry().change(objectArray);
    }

    public String getDocumentName() {
        if (this.fNoExtension) {
            return this.fRuntimeArea.getName();
        }
        return this.fRuntimeArea.getName() + FIGURE_EXTENSION;
    }

    public String getRuntimeName() {
        return this.fRuntimeArea.getName();
    }

    private void updateTitle() {
        String string;
        String string2;
        if (this.fFile != null) {
            int n;
            string2 = this.fShowFullPath ? FileUtils.fromJavaPath((String)this.fFile.getAbsolutePath()) : this.fFile.getName();
            if (!this.fShowExtension && (n = string2.lastIndexOf(".")) != -1) {
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = !this.fNoExtension && this.fShowExtension ? this.fRuntimeArea.getName() + FIGURE_EXTENSION : this.fRuntimeArea.getName();
        }
        if ((string = this.fRuntimeArea.getTitle()) != null && !string.equals("")) {
            string2 = string2 + " [" + string + "]";
        }
        if (!string2.equals(this.getFrame().getTitle())) {
            this.getFrame().setTitle(string2);
        }
    }

    void nameChanged() {
        if (this.fFile != null) {
            File file;
            String string = this.getDocumentName();
            if (this.fFile.getParent() != null) {
                string = this.fFile.getParent() + File.separatorChar + string;
            }
            if (!this.fFile.equals(file = FileUtils.absoluteFile((File)new File(string)))) {
                this.fFile = null;
                this.fNoExtension = false;
            }
        }
        this.updateTitle();
    }

    void titleChanged() {
        this.updateTitle();
    }

    public String getTitle() {
        return this.fRuntimeArea.getTitle();
    }

    public void setTitle(String string) {
        this.fRuntimeArea.setTitle(string);
    }

    public int closeWindow(int n) {
        if (n == 0 && this.checkIfDirty() == 2) {
            return 2;
        }
        if (this.fTabEditor != null) {
            this.fTabEditor.closeWindow();
            this.fTabFrame.dispose();
        }
        this.hideWindow();
        this.fLayoutArea.removeServices();
        this.fUndoManager.removeUndoableEditListener(this);
        if (this.fAlignToolbar != null) {
            this.fAlignToolbar.doCleanup();
        }
        if (this.fAlignmentFrame != null) {
            this.fAlignmentFrame.dispose();
        }
        if (this.fGridFrame != null) {
            this.fGridFrame.dispose();
        }
        if (this.fMenuEditor != null) {
            this.fMenuEditor.closeWindow();
        }
        this.remove((Component)((Object)this.fToolPalette));
        this.fLayoutArea.setPalette(null);
        this.fTogglePanel.removeAll();
        if (this.fEditorFrame != null) {
            this.fEditorFrame.close();
        }
        if (this.fPrefListener != null) {
            Prefs.removeListener((PrefListener)this.fPrefListener);
        }
        if (this.fToolHandler != null) {
            this.fToolHandler.doToolAction("stop");
            this.fToolHandler.cleanUp();
        }
        if (this.fHandle != null) {
            LayoutLooper.deleteFigure(this.fHandle, new CloseCompleted());
            this.fHandle = null;
        }
        this.removeFromLayoutEditorList(this);
        if (sLayoutEditors.size() == 0 && sBrowserOpenFromLayout) {
            sBrowserOpenFromLayout = false;
            if (ObjectBrowser.isObjectBrowserOpen()) {
                ObjectBrowser.getObjectBrowser().closeWindow();
            }
        }
        if (sLayoutEditors.size() == 0 && sInspectorOpenFromLayout) {
            sInspectorOpenFromLayout = false;
            if (MLInspectorServices.isInspectorOpen()) {
                MLInspectorServices.closeWindow();
            }
        }
        return 0;
    }

    private int checkIfDirty() {
        int n = 0;
        if (this.isDirty()) {
            int n2 = Dialogs.showSaveDirtyFile((Component)this.getFrame(), (String)this.getDocumentName(), (String)GUIDE_NAME);
            if (n2 == 2) {
                n = 2;
            } else if (n2 == 0) {
                n = this.doSave();
            }
        }
        return n;
    }

    public void setActive(boolean bl) {
        if (PlatformInfo.isMacintosh() && this.fToolPalette != null) {
            this.fToolPalette.setEnabled(bl);
        }
        if (this.fLayoutArea != null) {
            this.fLayoutArea.getHRuler().setShowTracker(bl);
            this.fLayoutArea.getVRuler().setShowTracker(bl);
        }
        if (bl) {
            if (this.fLayoutArea != null) {
                this.fLayoutArea.requestFocusInWindow();
            }
            if (this.fEditorFrame != null) {
                this.updatePaste();
            }
        }
    }

    void updatePaste() {
        this.fActionManager.getAction(LayoutActionEnum.PASTE).setEnabled(LayoutClipboard.getClipboard().canPaste(this.fLayoutArea));
    }

    public void showWindow() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (LayoutEditor.this.getFrame() != null && !LayoutEditor.this.getFrame().isVisible()) {
                    LayoutEditor.this.getFrame().setIconImage(ApplicationIcon.GUIDE.getIcon().getImage());
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension dimension2 = LayoutEditor.this.getFrame().getPreferredSize();
                    int n = (dimension.width - dimension2.width) / 2 > 0 ? (dimension.width - dimension2.width) / 2 : 0;
                    int n2 = (dimension.height - dimension2.height) / 3 > 0 ? (dimension.height - dimension2.height) / 3 : 0;
                    LayoutEditor.this.getFrame().setLocation(n, n2);
                    LayoutEditor.this.getFrame().setVisible(true);
                    sOpenCount++;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void unregister() {
        this.fLayoutArea.unregisterAll();
        Object object = this.getBean();
        if (object != null) {
            this.unregisterObject(object);
        }
    }

    private void registerObject(Object object) {
        Object[] objectArray = new Object[]{object};
        ObjectRegistry.getLayoutRegistry().register(objectArray, null, -1, null, true);
        ObjectRegistry.getLayoutRegistry().setSelected(objectArray, true);
        this.fLayoutArea.registerAll();
    }

    private void unregisterObject(Object object) {
        Object[] objectArray = new Object[]{object};
        ObjectRegistry.getLayoutRegistry().unregister(objectArray);
        if (ObjectRegistry.getLayoutRegistry().isSelected(object)) {
            ObjectRegistry.getLayoutRegistry().setSelected(objectArray, false);
        }
    }

    public void setLayoutOptions(Object[] objectArray, Object[] objectArray2) {
        this.fLayoutArea.setLayoutOptions(objectArray, objectArray2);
        this.updateAction(LayoutActionEnum.MFILE_EDITOR);
    }

    Object getBean() {
        if (this.fBean != null) {
            return this.fBean;
        }
        return null;
    }

    public void hideWindow() {
        if (this.getFrame() != null && this.getFrame().isVisible()) {
            if (--sOpenCount <= 0) {
                sOpenCount = 0;
                sHorizontalLocation = 20;
                sVerticalLocation = 60;
            }
            this.getFrame().setVisible(false);
            this.unregister();
        }
    }

    protected void doNew() {
        LayoutLooper.executeInM("newLayout", this.fHandle);
    }

    protected void doOpen() {
        LayoutLooper.executeInM("openFigure");
    }

    protected int doSave() {
        LayoutLooper.executeInM("save", this.fHandle);
        return 0;
    }

    protected int doExternalProperty() {
        return 0;
    }

    protected int doExport() {
        LayoutLooper.executeInM("export", this.fHandle);
        return 0;
    }

    private int doSaveAs() {
        LayoutLooper.executeInM("saveAs", this.fHandle);
        return 0;
    }

    private void doPrint() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(new JobName(this.getDocumentName(), null));
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printerJob != null && printServiceArray != null && printServiceArray.length > 0) {
            try {
                printerJob.setPrintable(new LayoutPrintJob());
                PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
                if (printService == null) {
                    printService = printServiceArray[0];
                }
                printerJob.setPrintService(printService);
                if (printerJob.printDialog(hashPrintRequestAttributeSet)) {
                    printerJob.print(hashPrintRequestAttributeSet);
                }
            }
            catch (PrinterException printerException) {
                this.showPrinterConfigurationMessage();
            }
        } else {
            this.showPrinterConfigurationMessage();
        }
    }

    private void showPrinterConfigurationMessage() {
        MJOptionPane.showMessageDialog((Component)MJOptionPane.getFrameForComponent((Component)((Object)this)), (Object)ResourceManager.getString("print.no_config"), (String)GUIDE_NAME, (int)0);
    }

    protected void doPreferences() {
        MLPrefsDialogServices.showPrefsDialog((String)sRes.getString("area.guide"));
    }

    Rectangle getDocumentBounds() {
        return this.getRuntimeBounds();
    }

    void setDocumentBounds(Rectangle rectangle) {
        this.fRuntimeBounds = new Rectangle(rectangle);
        this.fRuntimeArea.setSize(rectangle.width, rectangle.height);
        this.fLayoutBounds.x = rectangle.x;
        this.fLayoutBounds.y = rectangle.y;
        this.fEditorFrame.setContentLocation(rectangle.x, rectangle.y);
    }

    public void setDocumentLocation(int n, int n2) {
        this.fEditorFrame.setContentLocation(n, n2);
        this.fRuntimeBounds.x = n;
        this.fRuntimeBounds.y = n2;
        this.fLayoutBounds.x = n;
        this.fLayoutBounds.y = n2;
    }

    public void setDocumentSize(int n, int n2) {
        this.fRuntimeArea.setSize(n, n2);
        this.fLayoutArea.setSize(n, n2);
        Dimension dimension = this.getParent().getPreferredSize();
        this.fEditorFrame.setContentSize(dimension.width, dimension.height);
        this.fRuntimeBounds.width = n;
        this.fRuntimeBounds.height = n2;
        this.fLayoutBounds.width = dimension.width;
        this.fLayoutBounds.height = dimension.height;
    }

    public void setRuntimeBounds(Rectangle rectangle) {
        this.fRuntimeBounds = rectangle;
        this.fRuntimeArea.setSize(rectangle.width, rectangle.height);
        this.fLayoutArea.setSize(rectangle.width, rectangle.height);
        if (this.fStatusBar != null) {
            this.fStatusBar.updateSelectionCoord();
        }
    }

    public void setLayoutBounds(Rectangle rectangle) {
        this.fLayoutBounds = rectangle;
        this.fLayoutBounds.x = this.fRuntimeBounds.x;
        this.fLayoutBounds.y = this.fRuntimeBounds.y;
        this.setContentBounds(rectangle);
    }

    public Rectangle getRuntimeBounds() {
        return this.fRuntimeBounds;
    }

    public Rectangle getLayoutBounds() {
        return this.fLayoutBounds;
    }

    private void setContentBounds(Rectangle rectangle) {
        this.fEditorFrame.setContentLocation(rectangle.x, rectangle.y);
        this.fEditorFrame.setContentSize(rectangle.width, rectangle.height);
    }

    void selectionChanged() {
        this.updateAction(LayoutActionEnum.CUT);
        this.updateAction(LayoutActionEnum.COPY);
        this.updateAction(LayoutActionEnum.CLEAR);
        this.updateAction(LayoutActionEnum.DUPLICATE);
        this.updateAction(LayoutActionEnum.MOVE_TO_FRONT);
        this.updateAction(LayoutActionEnum.MOVE_TO_BACK);
        this.updateAction(LayoutActionEnum.MOVE_FORWARD);
        this.updateAction(LayoutActionEnum.MOVE_BACKWARD);
        this.updateAction(LayoutActionEnum.EDIT_PROPERTIES);
        MJAbstractAction mJAbstractAction = this.fActionManager.getAction(LayoutActionEnum.EDIT_PROPERTIES);
        if (mJAbstractAction != null) {
            this.saveControlTypeInAction(mJAbstractAction);
        }
    }

    public void contentChanged(Object object) {
        if (object == null || !object.equals("TableData")) {
            this.setDirty(true);
        }
    }

    private void showMenuEditor() {
        if (this.fMenuEditor != null) {
            Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.fMenuEditor));
            if (window != null) {
                window.toFront();
            }
        } else if (this.fHandle != null) {
            double[] dArray = (double[])this.fHandle;
            this.fMenuEditor = new MenuEditor(this, dArray[0]);
            Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.fMenuEditor));
            if (window != null) {
                window.setName(this.getFrame().getTitle() + " " + this.fMenuEditor.getName());
                window.addWindowListener(new MenuEditorClosed());
            }
        }
    }

    private void showCallbackEditor() {
        LayoutLooper.executeInM("openCallbackEditor", this.fHandle);
    }

    private void setMenuEditor(MenuEditor menuEditor) {
        this.fMenuEditor = menuEditor;
    }

    private void addToLayoutEditorList(LayoutEditor layoutEditor) {
        sLayoutEditors.addElement(layoutEditor);
    }

    private void removeFromLayoutEditorList(LayoutEditor layoutEditor) {
        sLayoutEditors.removeElement(layoutEditor);
    }

    public static String[] getOpenGUI() {
        int n = sLayoutEditors.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            File file = sLayoutEditors.elementAt(i).getFile();
            stringArray[i] = file == null ? "" : file.getAbsolutePath();
        }
        return stringArray;
    }

    public static boolean isGUIOpen(String string) {
        String[] stringArray;
        boolean bl = false;
        for (String string2 : stringArray = LayoutEditor.getOpenGUI()) {
            if (PlatformInfo.isWindows()) {
                bl = string2.toLowerCase().compareTo(string.toLowerCase()) == 0;
            } else {
                boolean bl2 = bl = string2.compareTo(string) == 0;
            }
            if (bl) break;
        }
        return bl;
    }

    public void writeCompleted(File file) {
        if (file != null) {
            if (this.fFile == null || !this.fFile.equals(file)) {
                LayoutMRUFiles.addItem(file.getAbsolutePath());
            }
            this.fFile = file;
            String string = this.fFile.getName();
            int n = string.lastIndexOf(".");
            if (n != -1 && n != 0) {
                string = string.substring(0, n);
            }
            this.fRuntimeArea.setName(string);
            this.setDirty(false);
        }
    }

    public void writeCompleted(String string) {
        this.writeCompleted(FileUtils.absoluteFile((File)new File(string)));
    }

    public void readCompleted(File file) {
        this.fFile = file;
        String string = this.fFile.getName();
        int n = string.lastIndexOf(46);
        boolean bl = this.fNoExtension = n == -1;
        if (n != -1 && n != 0) {
            string = string.substring(0, n);
        }
        this.fRuntimeArea.setName(string);
    }

    public static void clearLayoutClipboard() {
        LayoutClipboard.getClipboard().clearClipboard();
    }

    public static LayoutEditor newLayoutEditor() {
        LayoutEditor layoutEditor = LayoutEditor.untitledLayoutEditor();
        boolean bl = LayoutLooper.isAvailable();
        if (bl) {
            LayoutLooper.requestFigure(layoutEditor);
        } else {
            layoutEditor.showWindow();
        }
        return layoutEditor;
    }

    private static LayoutEditor untitledLayoutEditor() {
        LayoutEditor layoutEditor = LayoutEditor.instantiateLayoutEditor();
        Frame frame = layoutEditor.getFrame();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if ((sHorizontalLocation += 10) + dimension.width > dimension2.width) {
            sHorizontalLocation = 20;
        }
        if ((sVerticalLocation += 20) + dimension.height > dimension2.height) {
            sVerticalLocation = 60;
        }
        return layoutEditor;
    }

    public void setLayoutUntitled() {
        this.fFile = null;
        String string = sCount == 0 ? UNTITLED_STRING : UNTITLED_STRING + sCount;
        ++sCount;
        this.getRuntimeArea().setName(string);
    }

    public static LayoutEditor openLayoutEditor(String string) {
        return LayoutEditor.openLayoutEditor(new File(FileUtils.toJavaPath((String)string)));
    }

    private static LayoutEditor findLayoutEditor(File file) {
        Enumeration<LayoutEditor> enumeration = sLayoutEditors.elements();
        while (enumeration.hasMoreElements()) {
            LayoutEditor layoutEditor = enumeration.nextElement();
            if (!file.equals(layoutEditor.fFile)) continue;
            return layoutEditor;
        }
        return null;
    }

    public static LayoutEditor openLayoutEditor(File file) {
        if (!FileUtils.fileExists((File)(file = FileUtils.absoluteFile((File)file)))) {
            return null;
        }
        LayoutEditor layoutEditor = LayoutEditor.findLayoutEditor(file);
        if (layoutEditor != null) {
            layoutEditor.toFront();
        } else {
            layoutEditor = LayoutEditor.instantiateLayoutEditor();
            LayoutLooper.readFigure(FileUtils.fromJavaPath((String)file.getAbsolutePath()), layoutEditor, new ReadFigureCompleted(layoutEditor, file));
            if (!LayoutLooper.isAvailable()) {
                layoutEditor.showWindow();
            }
        }
        return layoutEditor;
    }

    public static LayoutEditor openLayoutEditor(double d) {
        LayoutEditor layoutEditor = LayoutEditor.untitledLayoutEditor();
        if (LayoutLooper.isAvailable()) {
            LayoutLooper.snapshotFigure(d, layoutEditor);
        } else {
            layoutEditor.showWindow();
        }
        return layoutEditor;
    }

    private static LayoutEditor instantiateLayoutEditor() {
        LayoutEditor layoutEditor = null;
        try {
            layoutEditor = (LayoutEditor)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)new AWTUtilities.InvocationRunnable(){

                public Object runWithOutput() {
                    return new LayoutEditor();
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        return layoutEditor;
    }

    private void frameResized() {
        this.fTogglePanel.invalidate();
        this.fTogglePanel.validate();
        this.fTogglePanel.repaint();
    }

    private void runtimeResized() {
        Dimension dimension = this.fRuntimeArea.getSize();
        if (dimension.width != this.fRuntimeBounds.width || dimension.height != this.fRuntimeBounds.height) {
            this.fRuntimeBounds.width = dimension.width;
            this.fRuntimeBounds.height = dimension.height;
            this.fRuntimeArea.setInRuntimeResize(true);
            this.fireObjectChangedEvent();
        }
    }

    private void updatePrefs() {
        boolean bl;
        boolean bl2 = LayoutPrefs.getLayoutBooleanPref("LayoutToolNames");
        boolean bl3 = false;
        if (this.fShowToolNames != bl2) {
            this.fShowToolNames = bl2;
            bl3 = true;
        }
        boolean bl4 = LayoutPrefs.getLayoutBooleanPref("LayoutExtension");
        boolean bl5 = false;
        if (this.fShowExtension != bl4) {
            this.fShowExtension = bl4;
            bl5 = true;
        }
        if (this.fShowFullPath != (bl = LayoutPrefs.getLayoutBooleanPref("LayoutFullPath"))) {
            this.fShowFullPath = bl;
            bl5 = true;
        }
        if (bl3) {
            this.remove((Component)((Object)this.fToolPalette));
            this.fToolPalette = this.buildToolPalette();
            this.add((Component)((Object)this.fToolPalette), "West");
            this.fLayoutArea.setPalette(this.fToolPalette);
            this.getParent().validate();
        }
        if (bl5) {
            this.updateTitle();
        }
    }

    public void completed(int n, Object object) {
        if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null && object instanceof Object[]) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4 = (Object[])object;
            if (objectArray4[0] != null && objectArray4[0] instanceof boolean[] && ((boolean[])objectArray4[0]).length > 0 && (objectArray3 = (boolean[])objectArray4[0])[0]) {
                this.setLayoutUntitled();
            }
            this.fHandle = objectArray4[1];
            this.fBean = objectArray4[2];
            this.fLayoutArea.setFigure(this.fHandle);
            this.fLayoutArea.setRootObject(this.fBean);
            objectArray3 = new Object[2];
            objectArray3[0] = objectArray4[3];
            objectArray3[1] = objectArray4[4];
            this.fLayoutArea.setProperties(objectArray3);
            String[] stringArray = (String[])objectArray4[5];
            this.fLayoutArea.setCallbackNames(stringArray);
            double[] dArray = (double[])objectArray4[6];
            int n2 = (int)dArray[0];
            int n3 = (int)dArray[1];
            int n4 = (int)dArray[2];
            int n5 = (int)dArray[3];
            this.fRuntimeArea.setRuntimeBounds(new Rectangle(n2, n3, n4, n5));
            if (n4 != 560 || n5 != 420) {
                this.fLayoutArea.getVRuler().setLabelStart(n5);
            }
            Dimension dimension = this.getParent().getPreferredSize();
            this.fEditorFrame.setContentSize(dimension.width + this.DEFAULT_PADDING, dimension.height + this.DEFAULT_PADDING);
            if (this.fBean != null && this.fBean instanceof UDDObject && (objectArray2 = HGControl.getPropertyValueForCompatibility((UDDObject)this.fBean, "Color")) != null && objectArray2 instanceof HGColor) {
                objectArray = objectArray2;
                this.fLayoutArea.setBackground(HGColor.getColor((HGColor)objectArray));
            }
            if (this.fBean != null && this.fBean instanceof UDDObject && this.fHandle != null && (objectArray2 = HGControl.getPropertyValueForCompatibility((UDDObject)this.fBean, "FileName")) != null && objectArray2 instanceof String) {
                LayoutMRUFiles.addItem((String)objectArray2);
            }
            this.setLayoutOptions((Object[])objectArray4[7], (Object[])objectArray4[8]);
            this.registerObject(this.fBean);
            if (objectArray4.length == 18) {
                objectArray2 = (Object[])objectArray4[9];
                objectArray = (Object[])objectArray4[10];
                Object[] objectArray5 = (Object[])objectArray4[11];
                Object[] objectArray6 = (Object[])objectArray4[12];
                Object[] objectArray7 = (Object[])objectArray4[13];
                int n6 = objectArray2.length;
                for (int i = 0; i < n6; ++i) {
                    this.fLayoutArea.addMLObject((MObjectProxy)objectArray5[i], objectArray2[i], objectArray[i], objectArray6[i], objectArray7[i], -1);
                }
                this.addMenus((Object[])objectArray4[14], (Object[])objectArray4[15]);
                this.addToolbars((Object[])objectArray4[16], (Object[])objectArray4[17]);
            }
            this.selectionChanged();
            this.updateAction(LayoutActionEnum.MENU_EDITOR);
            this.updateAction(LayoutActionEnum.MFILE_EDITOR);
            this.updateAction(LayoutActionEnum.GUI_EXPORT);
            this.updateAction(LayoutActionEnum.TAB_ORDER);
            this.fRuntimeArea.addComponentListener(new RuntimeResized());
            this.decideTestMode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LayoutEditor.this.fLayoutArea.setObjectPopup(LayoutEditor.this.buildObjectPopup());
                    LayoutEditor.this.fLayoutArea.setWindowPopup(LayoutEditor.this.buildWindowPopup());
                    LayoutEditor.this.setDirty(false);
                    LayoutEditor.this.showWindow();
                }
            });
        } else {
            System.out.println(ResourceManager.getString("alert.couldnotcreatefigure"));
            System.out.println(LayoutWorker.isRunOnMatlabThreadSuccessful(n));
        }
    }

    private void decideTestMode() {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                Object object = 7.feval((String)"isappdata", (Object[])new Object[]{0.0, "MathWorks_GUIDE_testmode"}, (int)1);
                LayoutEditor.this.fTestMode = ((boolean[])object)[0];
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }

    void addMenus(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ObjectRegistry.getLayoutRegistry().register(objectArray[i], objectArray2[i], -1, (ObjectOwner)this, true);
            }
        }
    }

    void addToolbars(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ObjectRegistry.getLayoutRegistry().register(objectArray[i], objectArray2[i], -1, (ObjectOwner)this, true);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            LayoutEditor.newLayoutEditor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private JMenuItem findCallbackMenu(MenuElement menuElement, Action action) {
        MenuElement[] menuElementArray;
        for (MenuElement menuElement2 : menuElementArray = menuElement.getSubElements()) {
            if (!(menuElement2 instanceof JMenuItem) || !action.equals(((JMenuItem)menuElement2).getAction())) continue;
            return (JMenuItem)menuElement2;
        }
        return null;
    }

    private void updateCallbackMenu(MJPopupMenu mJPopupMenu) {
        JMenuItem jMenuItem = this.findCallbackMenu((MenuElement)mJPopupMenu, (Action)this.fActionManager.getAction(LayoutActionEnum.CALLBACK_CMDS));
        if (jMenuItem != null && jMenuItem instanceof MJMenu && this.fLayoutArea != null) {
            MJMenu mJMenu = (MJMenu)jMenuItem;
            mJMenu.removeAll();
            Vector vector = this.getCommonCallback();
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    CallbackAction callbackAction = new CallbackAction(this, (String)vector.elementAt(i));
                    mJMenu.add((JMenuItem)new MJMenuItem((Action)((Object)callbackAction)));
                }
                mJMenu.setEnabled(true);
            } else {
                mJMenu.setEnabled(false);
            }
        }
    }

    private Vector getCommonCallback() {
        Object object = null;
        Vector<LOControlWrapper> vector = this.fLayoutArea.getSelectedControls();
        if (vector == null || vector.size() == 0) {
            vector = new Vector(1);
            vector.addElement((LOControlWrapper)((Object)this.fLayoutArea));
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof MObjectWrapper) && vector.elementAt(i) != this.fLayoutArea) {
                object = null;
                break;
            }
            String[] stringArray = vector.elementAt(i) == this.fLayoutArea ? this.fLayoutArea.getCallbackNames() : ((MObjectWrapper)vector.elementAt(i)).getCallbackNames();
            if (stringArray == null || stringArray.length == 0) {
                object = null;
                break;
            }
            Vector<String> vector2 = new Vector<String>(stringArray.length);
            for (String string : stringArray) {
                vector2.addElement(string);
            }
            Object object2 = i == 0 ? vector2 : object;
            if (object2 == null || ((Vector)object2).size() == 0) {
                object = null;
                break;
            }
            Object object3 = new Vector();
            if (vector2 == object2) {
                object3 = object2;
            } else {
                for (int j = 0; j < ((Vector)object2).size(); ++j) {
                    if (vector2.indexOf(((Vector)object2).elementAt(j)) < 0) continue;
                    ((Vector)object3).addElement(((Vector)object2).elementAt(j));
                }
            }
            object = object3;
        }
        return object;
    }

    private void updateEditPropertiesMenuItem(JMenuItem jMenuItem) {
        MJAbstractAction mJAbstractAction = (MJAbstractAction)jMenuItem.getAction();
        int n = Integer.MIN_VALUE;
        if (mJAbstractAction.getValue("MTYPE") != null) {
            n = (Integer)mJAbstractAction.getValue("MTYPE");
        }
        int n2 = Integer.MIN_VALUE;
        if (mJAbstractAction.getValue("GTYPE") != null) {
            n2 = (Integer)mJAbstractAction.getValue("GTYPE");
        }
        String string = null;
        switch (n) {
            case 1: 
            case 3: {
                string = this.getControlTitleKey(n2);
                break;
            }
            case -2: {
                string = "control.control";
                break;
            }
            case -1: {
                string = "control.figure";
                break;
            }
            case 2: {
                string = "uicontrol.axes";
                break;
            }
            case 6: {
                string = "control.activex";
                break;
            }
            default: {
                string = "control.control";
            }
        }
        if (string != null) {
            String string2 = ResourceManager.getString("menu.edit_properties");
            String string3 = ResourceManager.getString(string);
            String string4 = MessageFormat.format(string2, string3);
            jMenuItem.setText(string4);
            string2 = ResourceManager.getString("tip.edit_properties");
            string4 = MessageFormat.format(string2, string3);
            jMenuItem.setToolTipText(string4);
        }
    }

    private String getControlTitleKey(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "uicontrol.pushbutton";
                break;
            }
            case 1: {
                string = "uicontrol.slider";
                break;
            }
            case 2: {
                string = "uicontrol.radiobutton";
                break;
            }
            case 3: {
                string = "uicontrol.checkbox";
                break;
            }
            case 4: {
                string = "uicontrol.edit";
                break;
            }
            case 5: {
                string = "uicontrol.text";
                break;
            }
            case 6: {
                string = "uicontrol.frame";
                break;
            }
            case 7: {
                string = "uicontrol.popupmenu";
                break;
            }
            case 8: {
                string = "uicontrol.listbox";
                break;
            }
            case 9: {
                string = "uicontrol.togglebutton";
                break;
            }
            case 10: {
                string = "uicontrol.table";
                break;
            }
            case 13: {
                string = "uicontrol.panel";
                break;
            }
            case 14: {
                string = "uicontrol.buttongroup";
                break;
            }
            case 12: {
                string = "uicontrol.container";
            }
        }
        return string;
    }

    public void add(Object[] objectArray, Object object, int n) {
    }

    public void remove(Object[] objectArray) {
    }

    public void move(Object[] objectArray, Object object, int n) {
    }

    public void copy(Object[] objectArray) {
    }

    public void paste(Object object, int n) {
    }

    public void refresh(Object[] objectArray) {
    }

    public void setSelected(Object[] objectArray, boolean bl, boolean bl2) {
    }

    public void setSelected(Object[] objectArray, boolean bl) {
    }

    public static void setLayoutCursor(final Cursor cursor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sCurrentLayout != null) {
                    sCurrentLayout.getFrame().setCursor(cursor);
                }
            }
        });
    }

    private void addMenuItem(JMenu jMenu, LayoutActionEnum layoutActionEnum, String string) {
        JMenuItem jMenuItem = jMenu.add((Action)this.fActionManager.getAction(layoutActionEnum));
        jMenuItem.setName(ResourceManager.getUntranslatedString(string));
    }

    private void addCheckBoxMenuItem(JMenu jMenu, LayoutActionEnum layoutActionEnum, String string, boolean bl) {
        MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem((Action)this.fActionManager.getAction(layoutActionEnum));
        mJCheckBoxMenuItem.setName(ResourceManager.getUntranslatedString(string));
        mJCheckBoxMenuItem.setSelected(bl);
        jMenu.add((JMenuItem)mJCheckBoxMenuItem);
    }

    static {
        sHorizontalLocation = 20;
        sVerticalLocation = 60;
        sLayoutEditors = new Vector();
        sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    }

    private class LayoutPrintJob
    implements Printable {
        private LayoutPrintJob() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            if (n == 0) {
                LayoutArea layoutArea = LayoutEditor.this.fLayoutArea;
                ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                graphics.setFont(layoutArea.getFont());
                Dimension dimension = layoutArea.getSize();
                graphics.drawRect(0, 0, dimension.width + 1, dimension.height + 1);
                if (PlatformInfo.getPlatform() == 1) {
                    graphics.setClip(-16000, -16000, 32000, 32000);
                } else {
                    graphics.setClip(0, 0, dimension.width, dimension.height);
                }
                ((Component)layoutArea).print(graphics);
                return 0;
            }
            return 1;
        }
    }

    private static class ReadFigureCompleted
    implements CompletionObserver {
        private LayoutEditor fEditor;
        private File fFile;

        public ReadFigureCompleted(LayoutEditor layoutEditor, File file) {
            this.fEditor = layoutEditor;
            this.fFile = file;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null) {
                this.fEditor.readCompleted(this.fFile);
                this.fEditor.completed(n, object);
            }
        }
    }

    private class SnapMenuItem
    extends MJCheckBoxMenuItem
    implements LayoutGridTarget {
        SnapMenuItem(Action action) {
            super(action);
        }

        @Override
        public void snapToGridChanged(boolean bl) {
            this.setState(bl);
        }
    }

    private class LayoutFrame {
        private MJFrame fFrame = new MJFrame();
        private WindowFocusListener fWindowListener;

        public LayoutFrame() {
            this.fWindowListener = new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    sCurrentLayout = LayoutFrame.this;
                }

                @Override
                public void windowLostFocus(WindowEvent windowEvent) {
                    LayoutFrame.this.fFrame.setCursor(Cursor.getDefaultCursor());
                    if (sCurrentLayout != null && LayoutFrame.this.fFrame.equals(sCurrentLayout.fFrame)) {
                        sCurrentLayout = null;
                    }
                }
            };
            this.fFrame.addWindowFocusListener(this.fWindowListener);
        }

        Frame getFrame() {
            return this.fFrame;
        }

        void close() {
            if (this.fFrame != null) {
                this.fFrame.setJMenuBar(null);
                this.fFrame.remove((Component)this.fFrame.getRootPane());
                this.fFrame.removeAll();
                this.fFrame.removeWindowFocusListener(this.fWindowListener);
                this.fFrame.dispose();
                if (sCurrentLayout != null && this.fFrame.equals(sCurrentLayout.fFrame)) {
                    sCurrentLayout = null;
                }
            }
        }

        void setContentLocation(int n, int n2) {
            this.fFrame.setLocation(n, n2);
        }

        void setContentSize(int n, int n2) {
            this.fFrame.pack();
            int n3 = this.fFrame.getHeight() - this.fFrame.getContentPane().getHeight();
            int n4 = this.fFrame.getWidth() - this.fFrame.getContentPane().getWidth();
            this.fFrame.setSize(n + n4, n2 + n3);
        }

        Point getContentLocation() {
            return this.fFrame.getLocation();
        }

        void addLayoutMenuBar() {
            this.fFrame.setJMenuBar((JMenuBar)this.buildJMenuBar());
        }

        Component createLayoutToolbar() {
            return this.buildJToolbar();
        }

        private MJToolBar buildJToolbar() {
            MJToolBar mJToolBar = new MJToolBar();
            mJToolBar.setFloatable(false);
            mJToolBar.setName(ResourceManager.getUntranslatedString("toolbar.toolbar"));
            this.addToolbarButton(mJToolBar, LayoutActionEnum.NEW, "toolbar.new");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.OPEN, "toolbar.open");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.SAVE, "toolbar.save");
            mJToolBar.addSeparator();
            this.addToolbarButton(mJToolBar, LayoutActionEnum.CUT, "toolbar.cut");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.COPY, "toolbar.copy");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.PASTE, "toolbar.paste");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.UNDO, "toolbar.undo");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.REDO, "toolbar.redo");
            mJToolBar.addSeparator();
            this.addToolbarButton(mJToolBar, LayoutActionEnum.ALIGN_OBJECTS, "toolbar.alignobjects");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.MENU_EDITOR, "toolbar.menueditor");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.TAB_ORDER, "toolbar.taborder");
            LayoutToolInfo[] layoutToolInfoArray = LayoutToolRegistry.getTools();
            for (int i = 0; i < layoutToolInfoArray.length; ++i) {
                if (!layoutToolInfoArray[i].isToolbarEntry()) continue;
                JButton jButton = mJToolBar.add((Action)LayoutEditor.this.fActionManager.getAction(10000 + i));
                jButton.setName("TOOLBAR_" + layoutToolInfoArray[i].getCommand().toUpperCase());
            }
            mJToolBar.addSeparator();
            this.addToolbarButton(mJToolBar, LayoutActionEnum.MFILE_EDITOR, "toolbar.mfile");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.PROPERTY_INSPECTOR, "toolbar.inspector");
            this.addToolbarButton(mJToolBar, LayoutActionEnum.OBJECT_BROWSER, "toolbar.objectbrowser");
            mJToolBar.addSeparator();
            this.addToolbarButton(mJToolBar, LayoutActionEnum.RUN, "toolbar.run");
            mJToolBar.setBorder((Border)new BottomBorder());
            return mJToolBar;
        }

        private void addToolbarButton(MJToolBar mJToolBar, LayoutActionEnum layoutActionEnum, String string) {
            JButton jButton = mJToolBar.add((Action)LayoutEditor.this.fActionManager.getAction(layoutActionEnum));
            jButton.setName(ResourceManager.getUntranslatedString(string));
        }

        private MJMenuBar buildJMenuBar() {
            JMenuItem jMenuItem;
            DynamicFileMJMenu dynamicFileMJMenu = new DynamicFileMJMenu(ResourceManager.getString("menu.file"));
            dynamicFileMJMenu.setName(ResourceManager.getUntranslatedString("menuname.file"));
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.NEW, "filemenu.new");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.OPEN, "filemenu.open");
            dynamicFileMJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.CLOSE, "filemenu.close");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.SAVE, "filemenu.save");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.SAVE_AS, "filemenu.saveas");
            dynamicFileMJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.GUI_EXPORT, "filemenu.export");
            dynamicFileMJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.PREFERENCES, "filemenu.preferences");
            dynamicFileMJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicFileMJMenu), LayoutActionEnum.PRINT, "filemenu.print");
            MJMenu mJMenu = new MJMenu(ResourceManager.getString("menu.edit"));
            mJMenu.setName(ResourceManager.getUntranslatedString("menuname.edit"));
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.UNDO, "editmenu.undo");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.REDO, "editmenu.redo");
            mJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.CUT, "editmenu.cut");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.COPY, "editmenu.copy");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.PASTE, "editmenu.paste");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.CLEAR, "editmenu.clear");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.SELECT_ALL, "editmenu.selectall");
            mJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)mJMenu, LayoutActionEnum.DUPLICATE, "editmenu.duplicate");
            DynamicViewMJMenu dynamicViewMJMenu = new DynamicViewMJMenu(ResourceManager.getString("menu.view"));
            dynamicViewMJMenu.setName(ResourceManager.getUntranslatedString("menuname.view"));
            LayoutEditor.this.addCheckBoxMenuItem((JMenu)((Object)dynamicViewMJMenu), LayoutActionEnum.SHOW_TOOLBAR, "viewmenu.toolbar", LayoutEditor.this.fShowToolBar);
            LayoutEditor.this.addCheckBoxMenuItem((JMenu)((Object)dynamicViewMJMenu), LayoutActionEnum.SHOW_STATUSBAR, "viewmenu.statusbar", LayoutEditor.this.fShowStatusBar);
            dynamicViewMJMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicViewMJMenu), LayoutActionEnum.PROPERTY_INSPECTOR, "viewmenu.inspector");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicViewMJMenu), LayoutActionEnum.OBJECT_BROWSER, "viewmenu.objectbrowser");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicViewMJMenu), LayoutActionEnum.MFILE_EDITOR, "viewmenu.mfile");
            MJMenu mJMenu2 = new MJMenu(ResourceManager.getString("menu.layout"));
            mJMenu2.setName(ResourceManager.getUntranslatedString("menuname.layout"));
            SnapMenuItem snapMenuItem = new SnapMenuItem((Action)LayoutEditor.this.fActionManager.getAction(LayoutActionEnum.SNAP_TO_GRID));
            LayoutEditor.this.fLayoutGrid.addLayoutGridTarget(snapMenuItem);
            mJMenu2.add((JMenuItem)((Object)snapMenuItem));
            snapMenuItem.setName(ResourceManager.getUntranslatedString("layoutmenu.snap"));
            mJMenu2.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)mJMenu2, LayoutActionEnum.MOVE_TO_FRONT, "layoutmenu.front");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu2, LayoutActionEnum.MOVE_TO_BACK, "layoutmenu.back");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu2, LayoutActionEnum.MOVE_FORWARD, "layoutmenu.forward");
            LayoutEditor.this.addMenuItem((JMenu)mJMenu2, LayoutActionEnum.MOVE_BACKWARD, "layoutmenu.backward");
            MJAbstractAction mJAbstractAction = LayoutEditor.this.fActionManager.getAction(LayoutActionEnum.EDIT_PROPERTIES);
            MJMenuItem mJMenuItem = new MJMenuItem((Action)mJAbstractAction);
            LayoutEditor.this.saveControlTypeInAction(mJAbstractAction);
            DynamicToolsMenu dynamicToolsMenu = new DynamicToolsMenu(ResourceManager.getString("menu.tools"), (JMenuItem)mJMenuItem);
            dynamicToolsMenu.setName(ResourceManager.getUntranslatedString("menuname.tools"));
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.RUN, "toolsmenu.run");
            dynamicToolsMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.ALIGN_OBJECTS, "toolsmenu.alignobjects");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.GRID_RULERS, "toolsmenu.gridrulers");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.MENU_EDITOR, "toolsmenu.menueditor");
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.TAB_ORDER, "toolsmenu.taborder");
            LayoutToolInfo[] layoutToolInfoArray = LayoutToolRegistry.getTools();
            for (int i = 0; i < layoutToolInfoArray.length; ++i) {
                if (!layoutToolInfoArray[i].isToolbarEntry()) continue;
                jMenuItem = dynamicToolsMenu.add((Action)LayoutEditor.this.fActionManager.getAction(10000 + i));
                jMenuItem.setName("TOOLSMENU_" + layoutToolInfoArray[i].getCommand().toUpperCase());
            }
            dynamicToolsMenu.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)((Object)dynamicToolsMenu), LayoutActionEnum.APP_OPTIONS, "toolsmenu.guioptions");
            dynamicToolsMenu.addSeparator();
            JMenuItem jMenuItem2 = dynamicToolsMenu.add((JMenuItem)mJMenuItem);
            jMenuItem2.setName(ResourceManager.getUntranslatedString("toolsmenu.properties"));
            jMenuItem = new MJMenu(ResourceManager.getString("menu.help"));
            jMenuItem.setName(ResourceManager.getUntranslatedString("menuname.help"));
            LayoutEditor.this.addMenuItem((JMenu)jMenuItem, LayoutActionEnum.GETTING_STARTED, "helpmenu.started");
            jMenuItem.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)jMenuItem, LayoutActionEnum.HELP_LAYING_OUT_GUIS, "helpmenu.layout");
            LayoutEditor.this.addMenuItem((JMenu)jMenuItem, LayoutActionEnum.HELP_PROGRAMMING_GUIS, "helpmenu.programming");
            jMenuItem.addSeparator();
            LayoutEditor.this.addMenuItem((JMenu)jMenuItem, LayoutActionEnum.EXAMPLE_GUIS, "helpmenu.examples");
            LayoutEditor.this.addMenuItem((JMenu)jMenuItem, LayoutActionEnum.ONLINE_VIDEOS, "helpmenu.demos");
            MJMenuBar mJMenuBar = new MJMenuBar();
            mJMenuBar.add((JMenu)((Object)dynamicFileMJMenu));
            mJMenuBar.add((JMenu)mJMenu);
            mJMenuBar.add((JMenu)((Object)dynamicViewMJMenu));
            mJMenuBar.add((JMenu)mJMenu2);
            mJMenuBar.add((JMenu)((Object)dynamicToolsMenu));
            mJMenuBar.add((JMenu)jMenuItem);
            return mJMenuBar;
        }
    }

    private class DynamicFileMJMenu
    extends MJMenu {
        public DynamicFileMJMenu(String string) {
            super(string);
        }

        public void setPopupMenuVisible(boolean bl) {
            if (bl) {
                this.removeExistingItems();
                String[] stringArray = LayoutMRUFiles.getMRUMenuNames();
                int n = 5000;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (i == 0) {
                        this.addSeparator();
                    }
                    OpenMRUAction openMRUAction = new OpenMRUAction(n, stringArray[i]);
                    this.add((Action)((Object)openMRUAction));
                    ++n;
                }
            }
            super.setPopupMenuVisible(bl);
        }

        private void removeExistingItems() {
            int n = this.getItemCount();
            boolean bl = false;
            for (int i = n - 1; i >= 0; --i) {
                JMenuItem jMenuItem = this.getItem(i);
                if (jMenuItem != null) {
                    Action action = jMenuItem.getAction();
                    if (action != null && action instanceof OpenMRUAction) {
                        bl = true;
                        this.remove(jMenuItem);
                        continue;
                    }
                    if (i != n - 1) continue;
                    break;
                }
                if (!bl) break;
                this.remove(i);
                break;
            }
        }
    }

    private class DynamicObjectMenu
    extends MJPopupMenu {
        private JMenuItem itemEditProperties;

        public DynamicObjectMenu(String string, JMenuItem jMenuItem) {
            super(string);
            this.itemEditProperties = jMenuItem;
        }

        public void show(Component component, int n, int n2) {
            LayoutEditor.this.updateCallbackMenu(this);
            LayoutEditor.this.updateEditPropertiesMenuItem(this.itemEditProperties);
            super.show(component, n, n2);
        }
    }

    private class DynamicToolsMenu
    extends MJMenu {
        private JMenuItem itemEditProperties;

        public DynamicToolsMenu(String string, JMenuItem jMenuItem) {
            super(string);
            this.itemEditProperties = jMenuItem;
        }

        public void setPopupMenuVisible(boolean bl) {
            if (bl) {
                LayoutEditor.this.updateEditPropertiesMenuItem(this.itemEditProperties);
            }
            super.setPopupMenuVisible(bl);
        }
    }

    private class DynamicViewMJMenu
    extends MJMenu {
        private MJMenu fViewCallback;

        public DynamicViewMJMenu(String string) {
            super(string);
        }

        public void setPopupMenuVisible(boolean bl) {
            if (this.fViewCallback == null) {
                this.addCallbackSubmenu();
            }
            this.fViewCallback.removeAll();
            if (bl) {
                this.addCallbackItems();
            }
            this.fViewCallback.setEnabled(this.fViewCallback.getMenuComponentCount() > 0);
            super.setPopupMenuVisible(bl);
        }

        private void addCallbackSubmenu() {
            MJAbstractAction mJAbstractAction = LayoutEditor.this.fActionManager.getAction(LayoutActionEnum.CALLBACK_CMDS);
            mJAbstractAction.setEnabled(true);
            this.fViewCallback = new MJMenu((Action)mJAbstractAction);
            this.fViewCallback.setName(ResourceManager.getUntranslatedString("menuname.view_callback"));
            this.addSeparator();
            this.add((JMenuItem)this.fViewCallback);
        }

        private void addCallbackItems() {
            Vector vector = LayoutEditor.this.getCommonCallback();
            if (vector != null && vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    CallbackAction callbackAction = new CallbackAction(LayoutEditor.this.fActionManager.getLayoutEditor(), (String)vector.elementAt(i));
                    this.fViewCallback.add((Action)((Object)callbackAction));
                }
            }
        }
    }

    class DynamicMenu
    extends MJPopupMenu {
        public DynamicMenu(String string) {
            super(string);
        }

        public void show(Component component, int n, int n2) {
            LayoutEditor.this.updateCallbackMenu(this);
            super.show(component, n, n2);
        }
    }

    private class PrefChanged
    implements PrefListener {
        private PrefChanged() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            LayoutEditor.this.updatePrefs();
        }
    }

    private class SnapChanged
    implements LayoutGridTarget {
        private JMenuItem fItem;

        SnapChanged(JMenuItem jMenuItem) {
            this.fItem = jMenuItem;
        }

        @Override
        public void snapToGridChanged(boolean bl) {
            this.fItem.setSelected(bl);
        }
    }

    private class RuntimeResized
    extends ComponentAdapter {
        private RuntimeResized() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            LayoutEditor.this.runtimeResized();
        }
    }

    private class FrameMoved
    extends ComponentAdapter {
        private FrameMoved() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            LayoutEditor.this.frameResized();
        }
    }

    private class MenuEditorClosed
    extends WindowAdapter {
        private MenuEditorClosed() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            window.removeWindowListener(this);
            LayoutEditor.this.setMenuEditor(null);
        }
    }

    private class CloseCompleted
    implements CompletionObserver {
        private CloseCompleted() {
        }

        public void completed(int n, Object object) {
            LayoutEditor.this.fActionManager = null;
            LayoutEditor.this.fAlignmentFrame = null;
            LayoutEditor.this.fAlignToolbar = null;
            LayoutEditor.this.fBean = null;
            LayoutEditor.this.fEditorFrame = null;
            LayoutEditor.this.fFile = null;
            LayoutEditor.this.fGridDialog = null;
            LayoutEditor.this.fGridFrame = null;
            LayoutEditor.this.fHandle = null;
            LayoutEditor.this.fLayoutArea = null;
            LayoutEditor.this.fLayoutBounds = null;
            LayoutEditor.this.fLayoutGrid = null;
            LayoutEditor.this.fMenuEditor = null;
            LayoutEditor.this.fPrefListener = null;
            LayoutEditor.this.fRuntimeArea = null;
            LayoutEditor.this.fRuntimeBounds = null;
            LayoutEditor.this.fTabEditor = null;
            LayoutEditor.this.fTabFrame = null;
            LayoutEditor.this.fTogglePanel = null;
            LayoutEditor.this.fToolbar = null;
            LayoutEditor.this.fToolPalette = null;
            LayoutEditor.this.fUndoManager = null;
        }
    }

    class WindowHandler
    extends DTWindowHandler {
        WindowHandler(Window window) {
            super(window);
        }

        public boolean canClose() {
            return LayoutEditor.this.checkIfDirty() != 2;
        }

        public void close() {
            LayoutEditor.this.closeWindow(1);
        }

        public void windowActivated(WindowEvent windowEvent) {
            LayoutEditor.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            LayoutEditor.this.setActive(false);
        }
    }

    private class ActivateCompleted
    implements CompletionObserver {
        private ActivateCompleted() {
        }

        public void completed(int n, Object object) {
            LayoutEditor.this.setCurrentlyRunning(false);
        }
    }
}

