/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.discovery;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupLocator
implements Serializable {
    private static final long serialVersionUID = 1448769379829432795L;
    private static final short discoveryPort = 4160;
    private static final int protoVersion = 1;
    protected String host;
    protected int port;
    static final int defaultTimeout = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            int n = 60000;
            try {
                return Integer.getInteger("net.jini.discovery.timeout", n);
            }
            catch (SecurityException securityException) {
                return new Integer(n);
            }
        }
    });

    public LookupLocator(String string) throws MalformedURLException {
        block8: {
            int n;
            if (!string.toLowerCase().startsWith("jini://")) {
                throw new MalformedURLException("not a jini-scheme URL");
            }
            int n2 = string.length();
            char c = '\u0000';
            for (n = 7; n < n2 && (c = string.charAt(n)) != ':' && c != '/'; ++n) {
            }
            if (n == 7) {
                throw new MalformedURLException("empty hostname");
            }
            this.host = string.substring(7, n);
            if (c == ':') {
                int n3;
                for (n3 = n + 1; n3 < n2 && (c = string.charAt(n3)) != '/'; ++n3) {
                }
                try {
                    this.port = Integer.parseInt(string.substring(n + 1, n3));
                    if (this.port <= 0 || this.port >= 65536) {
                        throw new MalformedURLException("port number out of range");
                    }
                    break block8;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("malformed port number");
                }
            }
            this.port = 4160;
        }
    }

    public LookupLocator(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (n <= 0 || n >= 65536) {
            throw new IllegalArgumentException("port number out of range");
        }
        this.host = string;
        this.port = n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServiceRegistrar getRegistrar() throws IOException, ClassNotFoundException {
        return this.getRegistrar(defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistrar getRegistrar(int n) throws IOException, ClassNotFoundException {
        Socket socket = new Socket(this.host, this.port);
        try {
            socket.setSoTimeout(n);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeInt(1);
            dataOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            ServiceRegistrar serviceRegistrar = (ServiceRegistrar)((MarshalledObject)objectInputStream.readObject()).get();
            int n2 = objectInputStream.readInt();
            while (--n2 >= 0) {
                objectInputStream.readUTF();
            }
            ServiceRegistrar serviceRegistrar2 = serviceRegistrar;
            return serviceRegistrar2;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        if (this.port != 4160) {
            return "jini://" + this.host + ":" + this.port + "/";
        }
        return "jini://" + this.host + "/";
    }

    public boolean equals(Object object) {
        if (object instanceof LookupLocator) {
            LookupLocator lookupLocator = (LookupLocator)object;
            return this.port == lookupLocator.port && this.host.equalsIgnoreCase(lookupLocator.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.toLowerCase().hashCode() ^ this.port;
    }
}

