/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedProvider;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ServerSocketFactory;
import javax.security.auth.Subject;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.io.context.ClientSubject;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;

public abstract class EndpointBasedServer
extends EndpointBasedProvider
implements UnicastDiscoveryServer {
    protected EndpointBasedServer(String string, EndpointInternals endpointInternals) {
        super(string, endpointInternals);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        ServerEndpoint serverEndpoint = this.getServerEndpoint(null);
        EndpointBasedServer.checkIntegrity(serverEndpoint.checkConstraints(invocationConstraints));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUnicastDiscovery(UnicastResponse unicastResponse, Socket socket, InvocationConstraints invocationConstraints, ClientSubjectChecker clientSubjectChecker, Collection collection, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        if (unicastResponse == null || socket == null || byteBuffer == null || byteBuffer2 == null) {
            throw new NullPointerException();
        }
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        ServerEndpoint serverEndpoint = this.getServerEndpoint(new PrearrangedServerSocketFactory(socket));
        ServerConnManagerImpl serverConnManagerImpl = new ServerConnManagerImpl();
        this.endpointInternals.setServerConnManager(serverEndpoint, serverConnManagerImpl);
        ListenContextImpl listenContextImpl = new ListenContextImpl();
        serverEndpoint.enumerateListenEndpoints(listenContextImpl);
        ServerConnection serverConnection = serverConnManagerImpl.getServerConnection();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(serverConnection.getInputStream());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(serverConnection.getOutputStream());
            InboundRequestHandle inboundRequestHandle = serverConnection.processRequestData(bufferedInputStream, bufferedOutputStream);
            serverConnection.checkPermissions(inboundRequestHandle);
            EndpointBasedServer.checkIntegrity(serverConnection.checkConstraints(inboundRequestHandle, invocationConstraints));
            if (clientSubjectChecker != null) {
                clientSubjectChecker.checkClientSubject(EndpointBasedServer.getClientSubject(serverConnection, inboundRequestHandle));
            }
            byte[] byArray = EndpointBasedServer.calcHandshakeHash(byteBuffer, byteBuffer2);
            byte[] byArray2 = new byte[byArray.length];
            new DataInputStream(bufferedInputStream).readFully(byArray2);
            if (!Arrays.equals(byArray2, byArray)) {
                throw new DiscoveryProtocolException("handshake hash mismatch");
            }
            Plaintext.writeUnicastResponse(bufferedOutputStream, unicastResponse, collection);
            ((OutputStream)bufferedOutputStream).flush();
        }
        finally {
            serverConnection.close();
            listenContextImpl.getListenHandle().close();
        }
    }

    protected abstract ServerEndpoint getServerEndpoint(ServerSocketFactory var1) throws UnsupportedConstraintException;

    private static Subject getClientSubject(ServerConnection serverConnection, InboundRequestHandle inboundRequestHandle) {
        ArrayList arrayList = new ArrayList();
        serverConnection.populateContext(inboundRequestHandle, arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ClientSubject)) continue;
            return ((ClientSubject)e).getClientSubject();
        }
        return null;
    }

    private static class PrearrangedServerSocketFactory
    extends ServerSocketFactory {
        private final ServerSocket ssocket;

        PrearrangedServerSocketFactory(Socket socket) throws IOException {
            this.ssocket = new PrearrangedServerSocket(socket);
        }

        public ServerSocket createServerSocket() throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int n) throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int n, int n2) throws IOException {
            return this.ssocket;
        }

        public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
            return this.ssocket;
        }
    }

    private static class PrearrangedServerSocket
    extends ServerSocket {
        private Socket socket;
        private boolean closed = false;

        PrearrangedServerSocket(Socket socket) throws IOException {
            this.socket = socket;
        }

        public synchronized Socket accept() throws IOException {
            if (!this.closed && this.socket != null) {
                Socket socket = this.socket;
                this.socket = null;
                return socket;
            }
            while (!this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new SocketException("socket closed");
        }

        public int getLocalPort() {
            return 1;
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.notifyAll();
            }
        }
    }

    private static class ListenContextImpl
    implements ServerEndpoint.ListenContext {
        private ServerEndpoint.ListenHandle handle = null;

        private ListenContextImpl() {
        }

        public ServerEndpoint.ListenCookie addListenEndpoint(ServerEndpoint.ListenEndpoint listenEndpoint) throws IOException {
            this.handle = listenEndpoint.listen(new RequestDispatcher(){

                public void dispatch(InboundRequest inboundRequest) {
                    throw new AssertionError((Object)"dispatch should not occur");
                }
            });
            return this.handle.getCookie();
        }

        ServerEndpoint.ListenHandle getListenHandle() {
            return this.handle;
        }
    }

    private static class ServerConnManagerImpl
    implements ServerConnManager {
        private ServerConnection conn = null;

        ServerConnManagerImpl() {
        }

        public synchronized void handleConnection(ServerConnection serverConnection, RequestDispatcher requestDispatcher) {
            if (serverConnection == null || requestDispatcher == null) {
                throw new NullPointerException();
            }
            this.conn = serverConnection;
            this.notifyAll();
        }

        synchronized ServerConnection getServerConnection() {
            while (this.conn == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.conn;
        }
    }
}

