/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.vhdl;

import com.mathworks.widgets.text.vhdl.VHDLTokenContext;
import java.util.HashMap;
import java.util.Locale;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenID;

public class VHDLSyntax
extends Syntax {
    private static final HashMap<String, TokenID> sKeywordsMap = new HashMap();
    private static final int ISI_WHITE_SPACE = 1;
    private static final int ISI_LINE_COMMENT = 2;
    private static final int ISI_IDENTIFIER = 3;
    private static final int ISA_SLASH = 4;
    private static final int ISA_GT = 5;
    private static final int ISA_LT = 6;
    private static final int ISA_MINUS = 7;
    private static final int ISA_STAR = 8;
    private static final int ISI_STRING = 9;
    private static final int ISA_COLUMN = 10;

    public VHDLSyntax() {
        this.tokenContextPath = VHDLTokenContext.contextPath;
    }

    protected TokenID parseToken() {
        while (this.offset < this.stopOffset) {
            char c = this.buffer[this.offset];
            block0 : switch (this.state) {
                case -1: {
                    switch (c) {
                        case '/': {
                            this.state = 4;
                            break block0;
                        }
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                        case '>': {
                            this.state = 5;
                            break block0;
                        }
                        case '<': {
                            this.state = 6;
                            break block0;
                        }
                        case '+': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                        case '-': {
                            this.state = 7;
                            break block0;
                        }
                        case ':': {
                            this.state = 10;
                            break block0;
                        }
                        case '*': {
                            this.state = 8;
                            break block0;
                        }
                        case '&': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                        case '\"': {
                            this.state = 9;
                            break block0;
                        }
                        case '#': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ',': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case ';': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.VALID_CHAR;
                        }
                        case '\n': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.END_OF_LINE;
                        }
                    }
                    if (VHDLSyntax.isIdentifierStart(c)) {
                        this.state = 3;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = 1;
                        break;
                    }
                    this.state = -1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace(c)) break;
                    this.state = -1;
                    return VHDLTokenContext.WHITE_SPACE;
                }
                case 4: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 5: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 6: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 7: {
                    switch (c) {
                        case '-': {
                            this.state = 2;
                            break block0;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 10: {
                    switch (c) {
                        case '=': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 8: {
                    switch (c) {
                        case '*': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.OPERATOR;
                        }
                    }
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 9: {
                    switch (c) {
                        case '\n': 
                        case '\"': {
                            ++this.offset;
                            this.state = -1;
                            return VHDLTokenContext.STRING;
                        }
                    }
                    break;
                }
                case 3: {
                    if (VHDLSyntax.isIdentifierPart(c)) break;
                    this.state = -1;
                    TokenID tokenID = VHDLSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : VHDLTokenContext.IDENTIFIER;
                }
                case 2: {
                    switch (c) {
                        case '\n': {
                            this.state = -1;
                            return VHDLTokenContext.LINE_COMMENT;
                        }
                    }
                }
            }
            ++this.offset;
        }
        if (this.lastBuffer) {
            switch (this.state) {
                case 4: {
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 5: {
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 6: {
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 7: {
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 8: {
                    this.state = -1;
                    return VHDLTokenContext.OPERATOR;
                }
                case 9: {
                    this.state = -1;
                    return VHDLTokenContext.STRING;
                }
                case 3: {
                    this.state = -1;
                    TokenID tokenID = VHDLSyntax.matchKeyword(this.buffer, this.tokenOffset, this.offset - this.tokenOffset);
                    return tokenID != null ? tokenID : VHDLTokenContext.IDENTIFIER;
                }
                case 1: {
                    this.state = -1;
                    return VHDLTokenContext.WHITE_SPACE;
                }
                case 2: {
                    this.state = -1;
                    return VHDLTokenContext.LINE_COMMENT;
                }
            }
        }
        return null;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '\\';
    }

    private static boolean isIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private static TokenID matchKeyword(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        return sKeywordsMap.get(string.toUpperCase(Locale.ENGLISH));
    }

    static {
        sKeywordsMap.put("ABS", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("ACCESS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("AFTER", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ALIAS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ALL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("AND", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("ARCHITECTURE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ARRAY", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ASSERT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ATTRIBUTE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("BEGIN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("BLOCK", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("BODY", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("BUFFER", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("BUS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("CASE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("COMPONENT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("CONFIGURATION", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("CONSTANT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("DISCONNECT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("DOWNTO", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ELSE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ELSIF", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("END", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ENTITY", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("EXIT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("FILE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("FOR", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("FUNCTION", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("GENERATE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("GENERIC", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("GROUP", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("GUARDED", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("IF", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("IMPURE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("IN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("INERTIAL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("INOUT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("IS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("LABEL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("LIBRARY", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("LINKAGE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("LITERAL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("LOOP", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("MAP", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("MOD", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("NAND", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("NEW", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("NEXT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("NOR", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("NOT", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("NULL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("OF", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ON", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("OPEN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("OR", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("OTHERS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("OUT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("PACKAGE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("PORT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("POSTPONED", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("PROCEDURE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("PROCESS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("PURE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("RANGE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("RECORD", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("REGISTER", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("REJECT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("REM", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("REPORT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("RETURN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("ROL", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("ROR", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("SELECT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("SEVERITY", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("SIGNAL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("SLA", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("SLL", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("SRA", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("SRL", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("SUBTYPE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("THEN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("TO", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("TRANSPORT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("TYPE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("UNAFFECTED", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("UNITS", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("UNTIL", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("USE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("VARIABLE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("WAIT", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("WHEN", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("WHILE", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("WITH", (TokenID)VHDLTokenContext.KEYWORD);
        sKeywordsMap.put("XNOR", (TokenID)VHDLTokenContext.OPERATOR);
        sKeywordsMap.put("XOR", (TokenID)VHDLTokenContext.OPERATOR);
    }
}

