/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.api.UndoListener;
import com.mathworks.widgets.messagepanel.AbstractMessageModel;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.text.ColoringDrawLayer;
import com.mathworks.widgets.text.ColoringFactory;
import com.mathworks.widgets.text.LayerMarkList;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPModelInterface;
import com.mathworks.widgets.text.layer.DefaultEditorMessage;
import com.mathworks.widgets.text.mcode.variables.HighlightEvent;
import com.mathworks.widgets.text.mcode.variables.Variable;
import com.mathworks.widgets.text.mcode.variables.VariableEvent;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightData;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightDataFactory;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightDataListener;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import com.mathworks.widgets.text.mcode.variables.VariableQuickRenameMessage;
import com.mathworks.widgets.text.mcode.variables.VariableRenameUtils;
import com.mathworks.widgets.text.mcode.variables.VariableStatusBarUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;

public final class VariableHighlightingLayer
implements EditorLayer {
    public static final String LAYER_NAME = "Variable Highlighting Layer";
    private static final String RESET_STATUS_BAR_MSG = "";
    private final CaretListener fCaretListener;
    private final DocumentListener fDocumentListener;
    private final KeyListener fKeyListener;
    private final MouseAdapter fMouseAdapter;
    private final ActionListener fSettingsListener;
    private LayerMarkList fMarkList;
    private AbstractMessageModel fMessageModel;
    private VariableHighlightDataListener fVariableHighlightDataListener = new VariableHighlightDataListener(){

        @Override
        public void highlightReceived(HighlightEvent highlightEvent) {
            int n = highlightEvent.getVariable().getOtherInstances().size() + 1;
            Map map = VariableHighlightingLayer.getLengthsToHighlightByPosition(VariableHighlightingLayer.this.fTextPane, highlightEvent.getVariable());
            if (highlightEvent.isRenaming()) {
                VariableHighlightingLayer.this.addHighlightToVariableMap(map);
                if (VariableHighlightUtils.isActiveEditor(VariableHighlightingLayer.this.fTextPane)) {
                    List<EditorMessage> list = VariableHighlightingLayer.this.createRenameNowToolTipMessage(highlightEvent.getVariable().getText(), highlightEvent.getVariable().getStartPosition(), highlightEvent.getLastVariable().getText(), n);
                    VariableHighlightingLayer.this.getToolTipSupport().makeTip(list, (JTextComponent)((Object)VariableHighlightingLayer.this.fTextPane), true);
                }
            } else if (VariableHighlightingLayer.this.shouldHighlight(n, highlightEvent.alwaysHighlight())) {
                VariableHighlightingLayer.this.addHighlightToVariableMap(map);
            }
            VariableHighlightingLayer.this.setVariableHighlightStatusBar(VariableHighlightingLayer.this.createStatusBarMessage(highlightEvent.getLastVariable().getText(), n, VariableHighlightingLayer.this.isHighlighting()));
        }

        @Override
        public void renameReceived(VariableEvent variableEvent) {
            if (!VariableHighlightUtils.isActiveEditor(VariableHighlightingLayer.this.fTextPane)) {
                return;
            }
            VariableRenameUtils.renameAllTo(VariableHighlightingLayer.this.fTextPane, variableEvent.getVariable());
        }

        @Override
        public void clearRenameReceived() {
            if (VariableHighlightingLayer.this.fTextPane == null) {
                return;
            }
            VariableHighlightingLayer.this.getToolTipSupport().cleanupTip();
        }

        @Override
        public void clearHighlightRecieved() {
            if (VariableHighlightingLayer.this.fTextPane == null) {
                return;
            }
            VariableHighlightingLayer.this.clearHighlights();
            VariableHighlightingLayer.this.clearStatus();
        }
    };
    private UndoListener fUndoListener;
    private PropertyChangeListener fPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                VariableHighlightingLayer.this.fVariableHighlightData = VariableHighlightDataFactory.createVariableHighlightData(VariableHighlightingLayer.this.fTextPane.getDocument());
                VariableHighlightingLayer.this.fVariableHighlightData.addVariableHighlightDataListener(VariableHighlightingLayer.this.fVariableHighlightDataListener);
                VariableHighlightingLayer.this.fTextPane.getDocument().addDocumentListener(VariableHighlightingLayer.this.fDocumentListener);
            }
        }
    };
    private ColoringDrawLayer fDrawLayer;
    private EditorMessageBarContributor fContributor;
    private VariableHighlightData fVariableHighlightData;
    private STPBaseInterface fTextPane;
    private boolean fEnabled = false;
    private boolean fEscapePressed = false;
    private boolean fAlwaysHighlight = false;
    private boolean fIgnoreCaretUpdate = false;
    private String fLastStatusMessage = "";

    public VariableHighlightingLayer() {
        this.fSettingsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!VariableHighlightingLayer.this.fEnabled) {
                            return;
                        }
                        VariableHighlightingLayer.this.resetHighlight();
                    }
                });
            }
        };
        this.fUndoListener = new UndoListener(){

            private void updateAndHighlightOnEDT() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!VariableHighlightingLayer.this.fEnabled) {
                            return;
                        }
                        VariableHighlightingLayer.this.updateAndHighlight();
                    }
                });
            }

            private void cancelOnEDT() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!VariableHighlightingLayer.this.fEnabled) {
                            return;
                        }
                        VariableHighlightingLayer.this.fVariableHighlightData.cancelHighlight();
                    }
                });
            }

            public void undo() {
                this.cancelOnEDT();
                this.updateAndHighlightOnEDT();
            }

            public void redo() {
                this.updateAndHighlightOnEDT();
            }
        };
        this.fCaretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                VariableHighlightingLayer.this.setVariableHighlightStatusBar(VariableHighlightingLayer.this.fLastStatusMessage);
                if (VariableHighlightingLayer.this.fEscapePressed) {
                    VariableHighlightingLayer.this.fEscapePressed = false;
                    return;
                }
                if (VariableHighlightingLayer.this.fIgnoreCaretUpdate) {
                    VariableHighlightingLayer.this.fIgnoreCaretUpdate = false;
                    VariableHighlightingLayer.this.fVariableHighlightData.update(VariableHighlightingLayer.this.fTextPane, VariableHighlightData.VariableHighlightEventType.OTHER, VariableHighlightData.VariableHighlightAction.NONE, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_LATER);
                } else {
                    VariableHighlightingLayer.this.fVariableHighlightData.update(VariableHighlightingLayer.this.fTextPane, VariableHighlightData.VariableHighlightEventType.OTHER, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_LATER);
                }
                if (VariableHighlightUtils.wasNavigationKeyPressed((JComponent)caretEvent.getSource())) {
                    VariableHighlightingLayer.this.fVariableHighlightData.highlightNow(true);
                }
            }
        };
        this.fDocumentListener = new DocumentListener(){

            private void updateOnEDT(final VariableHighlightData.VariableHighlightEventType variableHighlightEventType) {
                VariableHighlightingLayer.this.fIgnoreCaretUpdate = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (VariableHighlightingLayer.this.fTextPane == null || !VariableHighlightingLayer.this.fEnabled) {
                            return;
                        }
                        if (VariableHighlightingLayer.this.isHighlightingOrStatusBar()) {
                            VariableHighlightingLayer.this.fVariableHighlightData.update(VariableHighlightingLayer.this.fTextPane, variableHighlightEventType, VariableHighlightData.VariableHighlightAction.UPDATE_LATER, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_NOW);
                        } else {
                            VariableHighlightingLayer.this.fVariableHighlightData.update(VariableHighlightingLayer.this.fTextPane, variableHighlightEventType, VariableHighlightData.VariableHighlightAction.UPDATE_LATER, VariableHighlightData.VariableHighlightPostAction.NONE);
                        }
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateOnEDT(VariableHighlightData.VariableHighlightEventType.DOCUMENT_UPDATE);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateOnEDT(VariableHighlightData.VariableHighlightEventType.DOCUMENT_UPDATE);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        this.fKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    VariableHighlightingLayer.this.escapeKeyAction();
                    return;
                }
                VariableHighlightingLayer.this.setVariableHighlightStatusBar(VariableHighlightingLayer.this.fLastStatusMessage);
            }
        };
        this.fMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                VariableHighlightingLayer.this.updateAndHighlight(VariableHighlightData.VariableHighlightEventType.MOUSE_CLICK);
            }
        };
    }

    private void updateAndHighlight() {
        this.updateAndHighlight(VariableHighlightData.VariableHighlightEventType.OTHER);
    }

    private void updateAndHighlight(VariableHighlightData.VariableHighlightEventType variableHighlightEventType) {
        this.fVariableHighlightData.update(this.fTextPane, variableHighlightEventType, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_NOW);
    }

    public void setAlwaysHighlight(boolean bl) {
        this.fAlwaysHighlight = bl;
        this.updateAndHighlight();
    }

    private static Map<Integer, Integer> getLengthsToHighlightByPosition(STPBaseInterface sTPBaseInterface, Variable variable) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        String string = variable.getOldName();
        if (VariableHighlightUtils.variableExists(sTPBaseInterface, variable.getStartPosition(), variable.getText())) {
            treeMap.put(variable.getStartPosition(), variable.getText().length());
        }
        for (Position position : variable.getOtherInstances()) {
            if (!VariableHighlightUtils.variableExists(sTPBaseInterface, position.getOffset(), string)) continue;
            treeMap.put(position.getOffset(), string.length());
        }
        return treeMap;
    }

    public void renameNow() {
        this.fVariableHighlightData.renameNow(this.fTextPane);
    }

    private MWToolTipSupport getToolTipSupport() {
        return (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)((JTextComponent)((Object)this.fTextPane))).getToolTipSupport();
    }

    private boolean shouldHighlight(int n, boolean bl) {
        return this.fAlwaysHighlight || n > 1 && (bl || this.isAutoHighlighting());
    }

    public void highlightIfAppropriate() {
        this.updateAndHighlight();
    }

    public void updateNow(VariableHighlightData.VariableHighlightEventType variableHighlightEventType) {
        this.fVariableHighlightData.update(this.fTextPane, variableHighlightEventType, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.NONE);
    }

    public void highlightNow() {
        this.fVariableHighlightData.update(this.fTextPane, VariableHighlightData.VariableHighlightEventType.OTHER, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_NOW_UNCONDITIONAL);
    }

    public void escapeKeyAction() {
        this.fEscapePressed = true;
        this.fVariableHighlightData.cancelHighlight();
    }

    public VariableHighlightData.VHDataCurrentState getCurrentState() {
        return this.fVariableHighlightData.getCurrentState();
    }

    private void setVariableHighlightStatusBar(String string) {
        String string2 = Utilities.getStatusText((JTextComponent)this.fTextPane.getActiveTextComponent());
        if (!VariableStatusBarUtils.statusCanBeChanged(string2, this.fLastStatusMessage)) {
            return;
        }
        this.fLastStatusMessage = string;
        if (!this.fLastStatusMessage.equals(string2)) {
            VariableStatusBarUtils.setStatusBarMessage((JTextComponent)((Object)this.fTextPane), this.fLastStatusMessage);
        }
    }

    private boolean isHighlighting() {
        return !this.fMarkList.isEmpty();
    }

    private boolean isHighlightingOrStatusBar() {
        return !this.fMarkList.isEmpty() && !this.fLastStatusMessage.isEmpty();
    }

    public String createStatusBarMessage(String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(VariableStatusBarUtils.getStatusBarMessage(string, n));
        if (!this.isAutoHighlighting() && !bl) {
            stringBuilder.append(VariableStatusBarUtils.getStatusBarKeyBindingMessage());
        }
        return stringBuilder.toString();
    }

    private boolean isAutoHighlighting() {
        return (Boolean)SettingsUtil.getValue(this.fTextPane.getEditorKit().getClass(), (String)"Editor.VariableHighlighting.Automatic", (Object)VariableHighlightPrefs.isAutoHighlighting());
    }

    private void clearHighlights() {
        this.fMessageModel.update(Collections.EMPTY_LIST, this.fTextPane.getNumLines());
        this.fMarkList.clear();
    }

    private void clearStatus() {
        String string = Utilities.getStatusText((JTextComponent)this.fTextPane.getActiveTextComponent());
        if (string == null) {
            return;
        }
        if (VariableStatusBarUtils.statusIsLastVariableHighlightingMessage(string, this.fLastStatusMessage)) {
            VariableStatusBarUtils.setStatusBarMessage(this.fTextPane.getActiveTextComponent(), RESET_STATUS_BAR_MSG);
        }
        this.fLastStatusMessage = RESET_STATUS_BAR_MSG;
    }

    private void clear() {
        this.clearHighlights();
        this.clearStatus();
    }

    public List<EditorMessage> createRenameNowToolTipMessage(String string, int n, String string2, int n2) {
        String string3 = VariableHighlightUtils.createRenameNowToolTipMessage(string, string2, n2);
        int n3 = n + string.length();
        VariableQuickRenameMessage variableQuickRenameMessage = new VariableQuickRenameMessage(string3, n, n3, (BaseDocument)this.fTextPane.getDocument(), this.getContrastingColor());
        return Collections.singletonList(variableQuickRenameMessage);
    }

    private void addHighlightToVariableMap(Map<Integer, Integer> map) {
        ArrayList<DefaultEditorMessage> arrayList = new ArrayList<DefaultEditorMessage>();
        for (int n : map.keySet()) {
            int n2 = map.get(n);
            this.fMarkList.addMark(LAYER_NAME, n, n2);
            String string = VariableHighlightUtils.highlightAndTrimLine(n, n2, this.fTextPane, this.getHighlightingColor());
            if (n + n2 > this.fTextPane.getDocument().getLength()) continue;
            arrayList.add(new DefaultEditorMessage(string, n, n + n2, (BaseDocument)this.fTextPane.getDocument(), this.getContrastingColor(), false));
        }
        this.fMessageModel.update(arrayList, this.fTextPane.getNumLines());
    }

    public void updateDocuments(Document document, Document document2) {
        if (this.fEnabled) {
            this.clear();
            document.removeDocumentListener(this.fDocumentListener);
            document2.addDocumentListener(this.fDocumentListener);
        }
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    public boolean supportsMessageBar() {
        return this.fEnabled;
    }

    public void enable(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent);
        if (!this.fEnabled && VariableHighlightingLayer.shouldShow()) {
            this.fContributor = new EditorMessageBarContributor(){

                public void configureModel(Editor editor) {
                }

                public Object getModel() {
                    return VariableHighlightingLayer.this.fMessageModel;
                }

                public void contributeToContextMenu(MenuBuilder menuBuilder) {
                }

                public boolean isPaintingSummary() {
                    return false;
                }

                public Paint getSummaryPaint() {
                    return null;
                }

                public EditorMessageBarContributor.Priority getPriority() {
                    return EditorMessageBarContributor.Priority.TRANSIENT;
                }

                public String getSummaryText() {
                    return null;
                }

                public boolean isValid() {
                    return true;
                }
            };
            this.fMessageModel = new VariableHighlightMessageModel();
            this.fTextPane = (STPBaseInterface)((Object)jTextComponent);
            ((Component)((Object)this.fTextPane)).addPropertyChangeListener(this.fPropertyChangeListener);
            this.fDrawLayer = new ColoringDrawLayer(LAYER_NAME, ColoringFactory.createTextHighlight(this.getHighlightingColor()));
            this.fTextPane.getEditorUI().addLayer((DrawLayer)this.fDrawLayer, 9000);
            this.fMarkList = new LayerMarkList(this.fTextPane);
            this.fTextPane.addCaretListener(this.fCaretListener);
            this.fTextPane.getDocument().addDocumentListener(this.fDocumentListener);
            this.fTextPane.addKeyListener(this.fKeyListener);
            this.fTextPane.addMouseListener(this.fMouseAdapter);
            VariableHighlightPrefs.addSettingChangeListener(this.fSettingsListener);
            this.fVariableHighlightData = VariableHighlightDataFactory.createVariableHighlightData(this.fTextPane.getDocument());
            this.fVariableHighlightData.addVariableHighlightDataListener(this.fVariableHighlightDataListener);
            if (this.fTextPane instanceof STPModelInterface) {
                ((STPModelInterface)((Object)this.fTextPane)).getUndoManager().addUndoListener(this.fUndoListener);
            }
            this.fEnabled = true;
        }
    }

    private Color getContrastingColor() {
        return ColorUtils.getContrastingForegroundVariant((Color)new MJPanel().getBackground(), (Color)this.getHighlightingColor());
    }

    private Color getHighlightingColor() {
        assert (this.fTextPane != null) : "should only be called when the layer is enabled";
        return (Color)SettingsUtil.getValue(this.fTextPane.getEditorKit().getClass(), (String)"Editor.VariableHighlighting.Color", (Object)VariableHighlightPrefs.getPreferredHighlightColor());
    }

    public void disable() {
        if (this.fEnabled) {
            this.fEnabled = false;
            this.fTextPane.removeCaretListener(this.fCaretListener);
            this.fTextPane.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fMarkList.clear();
            ((Component)((Object)this.fTextPane)).removePropertyChangeListener(this.fPropertyChangeListener);
            this.fTextPane.getEditorUI().removeLayer(LAYER_NAME);
            this.fTextPane.removeKeyListener(this.fKeyListener);
            this.fTextPane.removeMouseListener(this.fMouseAdapter);
            VariableHighlightPrefs.removeSettingChangeListener(this.fSettingsListener);
            this.fContributor = null;
            this.fVariableHighlightData.removeVariableHighlightDataListener(this.fVariableHighlightDataListener);
            this.fVariableHighlightData = null;
            if (this.fTextPane instanceof STPModelInterface) {
                ((STPModelInterface)((Object)this.fTextPane)).getUndoManager().removeUndoListener(this.fUndoListener);
            }
        }
    }

    private static boolean shouldShow() {
        return VariableHighlightPrefs.isVariableHighlightingEnabled();
    }

    public void settingsChanged(String string, ExtEditorUI extEditorUI) {
        if (this.fEnabled && string != null && this.fDrawLayer != null && string.equals("Editor.VariableHighlighting.Color")) {
            this.fDrawLayer.setColoring(ColoringFactory.createTextHighlight(this.getHighlightingColor()));
        }
        if (this.fAlwaysHighlight) {
            this.resetHighlight();
        }
    }

    private void resetHighlight() {
        this.clear();
        this.updateAndHighlight();
    }

    public void cleanup() {
        this.disable();
        this.fTextPane = null;
    }

    public List<EditorMessage> getMessagesAtPosition(int n, int n2) {
        return Collections.emptyList();
    }

    public EditorMessageBarContributor getMessageBarContributor() {
        return this.fContributor;
    }

    private boolean caretInAHighlightedVariable() {
        return this.fEnabled && !this.fMarkList.isEmpty() && this.fMarkList.textSelectionWithinAMark();
    }

    void highlightOrClear() {
        if (this.caretInAHighlightedVariable()) {
            if (!this.fAlwaysHighlight) {
                this.fVariableHighlightData.update(this.fTextPane, VariableHighlightData.VariableHighlightEventType.OTHER, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.CANCEL_HIGHLIGHT);
            } else {
                this.updateAndHighlight();
            }
        } else {
            this.fVariableHighlightData.update(this.fTextPane, VariableHighlightData.VariableHighlightEventType.OTHER, VariableHighlightData.VariableHighlightAction.UPDATE_NOW, VariableHighlightData.VariableHighlightPostAction.HIGHLIGHT_NOW_UNCONDITIONAL);
        }
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public LayerMarkList getMarks() {
        return this.fMarkList;
    }

    public boolean isCurrentlyHighlighting() {
        return !this.fMarkList.isEmpty();
    }

    private static class VariableHighlightMessageModel
    extends AbstractMessageModel {
        private VariableHighlightMessageModel() {
        }

        @Override
        public String getTextAt(int n) {
            return null;
        }

        @Override
        public int getLineNumberAt(int n) {
            return ((EditorMessage)this.getMessageAt(n)).getLineNumber();
        }

        @Override
        public int getPriorityAt(int n) {
            return 0;
        }

        @Override
        public MessageModel.Priority getModelPriority(int n) {
            return MessageModel.Priority.TRANSIENT_LAYER;
        }
    }
}

