/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.widgets.text.matlab.LexicalAccumulator;
import com.mathworks.widgets.text.matlab.MatlabLexer;
import com.mathworks.widgets.text.matlab.MatlabState;
import com.mathworks.widgets.text.mcode.MLexicalAccumulator;

public final class MLexer
extends MatlabLexer {
    private MatlabState fInitialCommandLineTokenizerState;
    private static final MLexer INSTANCE = new MLexer();

    private MLexer() {
        System.loadLibrary("nativelex");
        MLexer.initializeTokenizer();
        this.setInitialTokenizerState(MatlabState.getMatlabStateInstance(MLexer.nativeGetInitialState(), false, false));
        this.fInitialCommandLineTokenizerState = MatlabState.getMatlabStateInstance(MLexer.nativeGetCommandLineInitialState(), false, false);
    }

    public static MLexer getInstance() {
        return INSTANCE;
    }

    public static boolean isExpression(String string) {
        return MLexer.nativeIsLegalExpression(string);
    }

    public static boolean isValidMessageIdentifier(String string) {
        return MLexer.nativeIsValidMessageIdentifier(string);
    }

    public MatlabState getCommandLineInitialTokenizerState() {
        return this.fInitialCommandLineTokenizerState;
    }

    @Override
    public boolean isLineContinuation(MatlabState matlabState) {
        byte[] byArray = matlabState.getState();
        int n = MLexer.nativeIsContinLine(byArray);
        return n != 0;
    }

    @Override
    protected LexicalAccumulator createLexicalAccumulator(int n, byte[] byArray) {
        return new MLexicalAccumulator(n, byArray);
    }

    private static int[] getNestingInfo(MatlabState matlabState) {
        return MLexer.nativeLexNesting(matlabState.getState());
    }

    public static boolean isNewStyle(MatlabState matlabState) {
        return MLexer.getNestingInfo(matlabState)[0] == 1;
    }

    public static boolean areStatesEqual(MatlabState matlabState, MatlabState matlabState2) {
        if (matlabState == matlabState2) {
            return true;
        }
        byte[] byArray = matlabState.getState();
        byte[] byArray2 = matlabState2.getState();
        if (matlabState.isExecutable() != matlabState2.isExecutable()) {
            return false;
        }
        if (matlabState.isImplicitEOL() != matlabState2.isImplicitEOL()) {
            return false;
        }
        int n = MLexer.nativeAreStatesEqual(byArray, byArray2);
        return n == 1;
    }

    private static void initializeTokenizer() {
        MLexer.nativeInitializeMtok();
    }

    private static native boolean nativeIsLegalExpression(String var0);

    private static native boolean nativeIsValidMessageIdentifier(String var0);

    static native int[] nativeLexLine(int[] var0, int var1, byte[] var2, byte[] var3, int var4, int var5);

    private static native void nativeInitializeMtok();

    private static native int nativeIsContinLine(byte[] var0);

    private static native byte[] nativeGetInitialState();

    private static native byte[] nativeGetCommandLineInitialState();

    private static native int nativeAreStatesEqual(byte[] var0, byte[] var1);

    private static native int[] nativeLexNesting(byte[] var0);
}

