/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.mcode.MTokenUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeBaseDocumentCache;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class MDocumentUtils {
    private MDocumentUtils() {
    }

    public static MTree getMTree(BaseDocument baseDocument) {
        return MTreeBaseDocumentCache.getMTree(baseDocument);
    }

    public static String getFirstFunctionName(MTree mTree) {
        MTree.Node node = MDocumentUtils.getFirstFunctionNode(mTree);
        return node == null ? null : MDocumentUtils.getFunctionName(node);
    }

    public static String getFunctionName(MTree mTree, int n) {
        List<MTree.Node> list = mTree.findAsList(MTree.NodeType.FUNCTION);
        for (MTree.Node node : list) {
            if (node.getStartLine() != n + 1) continue;
            return MDocumentUtils.getFunctionName(node);
        }
        return null;
    }

    public static String getContainingFunctionName(List<MTree.Node> list, BaseDocument baseDocument, int n) throws BadLocationException {
        assert (SwingUtilities.isEventDispatchThread()) : "This method must be called on the EDT";
        MTree.Node node = null;
        for (MTree.Node node2 : list) {
            int n2;
            assert (node2.getType() == MTree.NodeType.FUNCTION) : "List should only contain functions";
            int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node2.getStartLine() - 1));
            int n4 = MDocumentUtils.findEndOfFunction(baseDocument, node2);
            if (n3 == -1 || n4 == -1 || (n2 = n3 + node2.getStartColumn() - 1) > n || n4 < n) continue;
            if (node == null) {
                node = node2;
                continue;
            }
            int n5 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node.getStartLine() - 1));
            if (n5 == -1 || n2 < n5 + node.getStartColumn() - 1) continue;
            node = node2;
        }
        return node == null ? null : MDocumentUtils.getFunctionName(node);
    }

    public static String getContainingFunctionName(BaseDocument baseDocument, int n) throws BadLocationException {
        return MDocumentUtils.getContainingFunctionName(MTreeBaseDocumentCache.getMTree(baseDocument).findAsList(MTree.NodeType.FUNCTION), baseDocument, n);
    }

    static int findEndOfFunction(BaseDocument baseDocument, MTree.Node node) throws BadLocationException {
        int n;
        assert (SwingUtilities.isEventDispatchThread()) : "This method must be called on the EDT";
        if (node.getType() != MTree.NodeType.FUNCTION) {
            throw new IllegalArgumentException("This method should only be used with function nodes.");
        }
        if (node.hasEnd()) {
            int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(node.getEndLine() - 1));
            n = n2 == -1 ? -1 : n2 + node.getEndColumn();
        } else {
            int n3 = Math.max(node.getStartLine(), MDocumentUtils.findEndOfOldStyleFunction(node));
            n = DocumentUtils.getRowEndFromLine(baseDocument, n3 - 1);
        }
        return n;
    }

    private static String getFunctionName(MTree.Node node) {
        assert (node.getType() == MTree.NodeType.FUNCTION);
        return node.getFunctionName().getText();
    }

    public static List<String> getFunctionArgumentList(MTree.Node node) {
        Validate.notNull((Object)node);
        Validate.isTrue((boolean)node.getType().isFunction(), (String)"Input node must be a function");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MTree.Node node2 : node.getInputArguments()) {
            arrayList.add(node2.getType().equals((Object)MTree.NodeType.NOT) ? "~" : node2.getText());
        }
        return arrayList;
    }

    public static List<String> getFirstFunctionArgumentList(MTree mTree) {
        MTree.Node node = MDocumentUtils.getFirstFunctionNode(mTree);
        return node == null ? null : MDocumentUtils.getFunctionArgumentList(node);
    }

    public static String getFirstClassName(MTree mTree) {
        String string = null;
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (!node.getType().isClass()) continue;
            string = MTreeUtils.getClassNameNode(node).getText();
            break;
        }
        return string;
    }

    public static List<String> getClassConstructorArgumentList(MTree mTree) {
        List<MTree.Node> list;
        List<String> list2 = new ArrayList<String>();
        String string = MDocumentUtils.getFirstClassName(mTree);
        if (string != null && (list = mTree.findAsList(MTree.NodeType.METHODS)).size() > 0) {
            block0: for (MTree.Node node : list) {
                List<MTree.Node> list3 = node.getSubtree();
                for (MTree.Node node2 : list3) {
                    if (!node2.getType().equals((Object)MTree.NodeType.FUNCTION) || !node2.getFunctionName().getText().equals(string)) continue;
                    list2 = MDocumentUtils.getFunctionArgumentList(node2);
                    continue block0;
                }
            }
        }
        return list2;
    }

    public static int findEndOfOldStyleFunction(MTree.Node node) {
        Validate.isTrue((node.getType() == MTree.NodeType.FUNCTION && !node.hasEnd() ? 1 : 0) != 0, (String)"This method should only be used with old-style function nodes.");
        List<MTree.Node> list = node.getBody().getListOfNextNodes();
        int n = node.getStartLine();
        for (MTree.Node node2 : list) {
            if (node2.getType().isComment()) continue;
            n = Math.max(n, Math.max(node2.getStartLine(), node2.getEndLine()));
        }
        return n;
    }

    public static String getDefaultFilename(MTree mTree) {
        String string = MDocumentUtils.getFirstClassName(mTree);
        return string != null ? string : MDocumentUtils.getFirstFunctionName(mTree);
    }

    public static MTree.Node getFirstFunctionNode(MTree mTree) {
        Validate.notNull((Object)mTree);
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (!node.getType().isFunction()) continue;
            return node;
        }
        return null;
    }

    public static MTree.Node getSemanticalRoot(MTree mTree) {
        Validate.notNull((Object)mTree);
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (!node.getType().isFunction() && !node.getType().isClass()) continue;
            return node;
        }
        return null;
    }

    public static String getStatementUpToPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        MJUtilities.assertIsEventThread();
        int n2 = MTokenUtils.getMLineStart(baseDocument, n);
        return baseDocument.getText(n2, n - n2);
    }

    public static String getFunctionName(BaseDocument baseDocument, int n) {
        MJUtilities.assertIsEventThread();
        MTree mTree = MDocumentUtils.getMTree(baseDocument);
        return MDocumentUtils.getFunctionName(mTree, n);
    }

    public static List<String> getFunctionNames(BaseDocument baseDocument) {
        MJUtilities.assertIsEventThread();
        int[] nArray = MDocumentUtils.getZeroBasedLineNumbersOfFunctions(baseDocument);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int n : nArray) {
            arrayList.add(MDocumentUtils.getFunctionName(baseDocument, n));
        }
        return arrayList;
    }

    public static int[] getZeroBasedLineNumbersOfFunctions(BaseDocument baseDocument) {
        MJUtilities.assertIsEventThread();
        int[] nArray = MDocumentUtils.getOneBasedLineNumbersOfFunctions(baseDocument);
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    public static int[] getOneBasedLineNumbersOfFunctions(BaseDocument baseDocument) {
        MTree mTree = MDocumentUtils.getMTree(baseDocument);
        List<MTree.Node> list = mTree.findAsList(MTree.NodeType.FUNCTION);
        int[] nArray = new int[list.size()];
        int n = 0;
        for (MTree.Node node : list) {
            nArray[n++] = node.getStartLine();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public static int getFunctionLineNumber(BaseDocument baseDocument, String string) {
        MJUtilities.assertIsEventThread();
        Validate.notNull((Object)string, (String)"The function name cannot be null.");
        Validate.notEmpty((String)string, (String)"The function name cannot be empty.");
        int[] nArray = MDocumentUtils.getZeroBasedLineNumbersOfFunctions(baseDocument);
        int n = -1;
        for (int n2 : nArray) {
            String string2 = MDocumentUtils.getFunctionName(baseDocument, n2);
            if (!string.equals(string2)) continue;
            n = n2;
        }
        return n;
    }
}

