/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import org.apache.commons.lang.ArrayUtils;

public class LexicalBuffer {
    private static final int EXTRA_GROW_SIZE = 200;
    private static final int MAX_BUFFER_LENGTH = 20000;
    private static final byte NEWLINE_BYTE = 10;
    private final byte[] fEntireBuffer;
    private boolean fDone;
    private int fCurrentLineOffset;
    private int fCurrentLineLength;
    private int fLastPosition;
    private byte[] fCurrentLineBuffer;
    private byte[] fCurrentBufferToTokenize;
    private int fStartIndex;
    private int fNewLinePosition;

    LexicalBuffer(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        this.fEntireBuffer = LexicalBuffer.combineBuffers(cArray, n, n2, cArray2, n3, n4);
        this.fLastPosition = this.fEntireBuffer.length - 1;
        this.fCurrentLineBuffer = ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public boolean nextLine() {
        if (this.fDone) {
            return false;
        }
        this.computeNextPosition();
        this.updateCurrentBuffer();
        this.fCurrentLineOffset = this.fNewLinePosition + 1;
        return true;
    }

    public int getTotalSize() {
        return this.fEntireBuffer.length;
    }

    public int getLineSize() {
        return this.fCurrentLineLength;
    }

    public byte[] getLineToTokenize() {
        return this.fCurrentBufferToTokenize;
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    private void computeNextPosition() {
        int n;
        this.fNewLinePosition = ArrayUtils.indexOf((byte[])this.fEntireBuffer, (byte)10, (int)this.fCurrentLineOffset);
        if (this.fNewLinePosition == -1 || this.fNewLinePosition == this.fLastPosition) {
            this.fDone = true;
            n = this.fLastPosition;
        } else {
            n = this.fNewLinePosition;
        }
        this.fCurrentLineLength = n - this.fCurrentLineOffset + 1;
    }

    private void updateCurrentBuffer() {
        if (this.fEntireBuffer.length > 20000 && this.fCurrentLineLength < 20000) {
            if (this.fCurrentLineLength > this.fCurrentLineBuffer.length || this.fCurrentLineBuffer.length > 20000) {
                this.fCurrentLineBuffer = new byte[this.fCurrentLineLength + 200];
            }
            System.arraycopy(this.fEntireBuffer, this.fCurrentLineOffset, this.fCurrentLineBuffer, 0, this.fCurrentLineLength);
            this.fStartIndex = 0;
            this.fCurrentBufferToTokenize = this.fCurrentLineBuffer;
        } else {
            this.fStartIndex = this.fCurrentLineOffset;
            this.fCurrentBufferToTokenize = this.fEntireBuffer;
        }
    }

    private static byte[] combineBuffers(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6;
        byte[] byArray = new byte[n2 + n4];
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = cArray[n6 + n];
            byArray[n6] = (byte)(n5 <= 127 ? n5 : 35);
        }
        if (n4 > 0) {
            for (n6 = 0; n6 < n4; ++n6) {
                n5 = cArray2[n6 + n3];
                byArray[n6 + n2] = (byte)(n5 <= 127 ? n5 : 35);
            }
        }
        return byArray;
    }
}

