/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.fold;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.mcode.MFoldType;
import com.mathworks.widgets.text.mcode.MKit;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;

public final class CodeFoldingUtilities {
    public static final String PREF_FOLD_ENABLE = "Editorcode-folding-enable";

    private CodeFoldingUtilities() {
    }

    public static boolean isWithinCollapsedFold(JTextComponent jTextComponent, int n) {
        Fold fold;
        boolean bl = false;
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        if (foldHierarchy != null && (fold = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n)) != null && fold.isCollapsed()) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncViewCodeFoldingStates(JTextComponent jTextComponent, JTextComponent jTextComponent2) {
        assert (jTextComponent.getDocument() == jTextComponent2.getDocument()) : "This method assumes that the panes share the same document and thus have the same folds.";
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        FoldHierarchy foldHierarchy2 = FoldHierarchy.get((JTextComponent)jTextComponent2);
        if (foldHierarchy != null && foldHierarchy2 != null) {
            Fold fold;
            List list = FoldUtilities.findRecursive((Fold)foldHierarchy.getRootFold());
            List list2 = FoldUtilities.findRecursive((Fold)foldHierarchy2.getRootFold());
            assert (list.size() == list2.size()) : "The number of folds in the 2 views must be the same";
            ArrayList<Fold> arrayList = new ArrayList<Fold>();
            ArrayList<Fold> arrayList2 = new ArrayList<Fold>();
            for (int i = 0; i < list.size(); ++i) {
                fold = (Fold)list.get(i);
                Fold fold2 = (Fold)list2.get(i);
                if (fold.isCollapsed()) {
                    arrayList.add(fold2);
                    continue;
                }
                arrayList2.add(fold2);
            }
            Document document = jTextComponent2.getDocument();
            if (document instanceof BaseDocument) {
                fold = (BaseDocument)document;
                fold.readLock();
                try {
                    foldHierarchy2.lock();
                    try {
                        foldHierarchy2.collapse(arrayList);
                        foldHierarchy2.expand(arrayList2);
                    }
                    finally {
                        foldHierarchy2.unlock();
                    }
                }
                finally {
                    fold.readUnlock();
                }
            }
        }
    }

    public static Map<MFoldType, Boolean[]> getCurrentFoldPrefValuesForTest() {
        HashMap<MFoldType, Boolean[]> hashMap = new HashMap<MFoldType, Boolean[]>();
        for (MFoldType mFoldType : MFoldType.values()) {
            hashMap.put(mFoldType, new Boolean[]{mFoldType.isFoldEnabled(), mFoldType.isFoldedUponOpen()});
        }
        return hashMap;
    }

    public static void restoreFoldPrefOrigValuesForTest(final Map<MFoldType, Boolean[]> map, final boolean bl) throws InterruptedException, InvocationTargetException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Set set = map.keySet();
                for (MFoldType mFoldType : set) {
                    Boolean[] booleanArray = (Boolean[])map.get((Object)mFoldType);
                    mFoldType.setFoldEnabled(booleanArray[0]);
                    mFoldType.setFoldedUponOpen(booleanArray[1]);
                }
                Prefs.setBooleanPref((String)CodeFoldingUtilities.PREF_FOLD_ENABLE, (boolean)bl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void setupFoldTestValues() {
        if (!EditorPrefsAccessor.isCodeFoldingEnabled()) {
            Prefs.setBooleanPref((String)PREF_FOLD_ENABLE, (boolean)true);
        }
        for (MFoldType mFoldType : MFoldType.values()) {
            mFoldType.setFoldEnabled(true);
            mFoldType.setFoldedUponOpen(false);
        }
    }

    public static void disableAllFoldsForTests() {
        if (EditorPrefsAccessor.isCodeFoldingEnabled()) {
            Prefs.setBooleanPref((String)PREF_FOLD_ENABLE, (boolean)false);
        }
        for (MFoldType mFoldType : MFoldType.values()) {
            mFoldType.setFoldEnabled(false);
            mFoldType.setFoldedUponOpen(false);
        }
    }

    public static boolean isFoldSideBarVisibleForTest(Component[] componentArray) {
        boolean bl = false;
        try {
            if (componentArray != null) {
                for (Component component : componentArray) {
                    MJPanel mJPanel;
                    Component[] componentArray2;
                    MJScrollPane mJScrollPane;
                    Component component2;
                    if (!(component instanceof MJScrollPane) || !((component2 = (mJScrollPane = (MJScrollPane)component).getRowHeader().getView()) instanceof MJPanel) || (componentArray2 = (mJPanel = (MJPanel)component2).getComponents()) == null) continue;
                    for (Component component3 : componentArray2) {
                        if (!component3.getName().equals("MWCodeFoldingSideBar")) continue;
                        bl = component3.isVisible();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public static class CodeFoldingMKitForTest
    extends MKit {
        @Override
        public String getContentType() {
            return MKit.M_MIME_TYPE;
        }

        @Override
        public boolean supportsCodeFolding() {
            return true;
        }
    }
}

