/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.incSearch.IncSearchData;
import com.mathworks.widgets.incSearch.IncSearchInterface;
import com.mathworks.widgets.text.STPViewInterface;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Utilities;

public class STPIncSearch
implements IncSearchInterface {
    private int fLastFindPos = -1;
    private int fLastFindLength = -1;
    private STPViewInterface fStp = null;
    private static final int UNSET = -1;
    private int fPosBeforeInc = -1;
    private int fSearchStartOffset;
    private int fSelStartb4SearchStart;
    private int fSelEndb4SearchStart;

    public STPIncSearch(STPViewInterface sTPViewInterface) {
        this.fStp = sTPViewInterface;
    }

    public void startingIncSearch() {
        this.fPosBeforeInc = this.fStp.getCaretPosition();
        this.initSearchContext();
    }

    private void initSearchContext() {
        JTextComponent jTextComponent = this.getLastActiveComponent();
        if (jTextComponent != null) {
            this.fSelStartb4SearchStart = jTextComponent.getSelectionStart();
            this.fSelEndb4SearchStart = jTextComponent.getSelectionEnd();
        }
        this.fSearchStartOffset = this.fPosBeforeInc;
    }

    @Override
    public IncSearchData find(String string, boolean bl) {
        JTextComponent jTextComponent = this.getLastActiveComponent();
        if (this.fLastFindPos != -1 && this.fLastFindLength != -1) {
            if (bl && jTextComponent.getCaret().getDot() != this.fLastFindPos + this.fLastFindLength) {
                jTextComponent.getCaret().setDot(this.fLastFindPos + this.fLastFindLength);
            } else if (!bl && jTextComponent.getCaret().getDot() != this.fLastFindPos) {
                jTextComponent.getCaret().setDot(this.fLastFindPos);
            }
        }
        boolean bl2 = SyntaxTextPaneUtilities.findString(string, !bl, false, true, !string.equals(string.toLowerCase()));
        this.fLastFindPos = jTextComponent.getSelectionStart();
        this.fLastFindLength = jTextComponent.getSelectionEnd() - this.fLastFindPos;
        return new IncSearchData(string, bl2, this.fLastFindPos, this.fLastFindLength, bl);
    }

    @Override
    public IncSearchData incSearch(String string, boolean bl) {
        Boolean bl2 = new Boolean(!bl);
        FindSupport findSupport = FindSupport.getFindSupport();
        Map map = findSupport.getDefaultFindProperties();
        findSupport.putFindProperty("find-backward-search", (Object)bl2);
        findSupport.putFindProperty("find-highlight-search", (Object)new Boolean(false));
        findSupport.putFindProperty("find-inc-search", (Object)new Boolean(true));
        findSupport.putFindProperty("find-what", (Object)string);
        findSupport.putFindProperty("find-wrap-search", (Object)new Boolean(true));
        findSupport.putFindProperty("find-match-case", (Object)new Boolean(!string.equals(string.toLowerCase())));
        Map map2 = findSupport.getFindProperties();
        this.fSearchStartOffset = bl ? Math.min(this.fSelStartb4SearchStart, this.fSelEndb4SearchStart) : Math.max(this.fSelStartb4SearchStart, this.fSelEndb4SearchStart);
        FindSupport.IncSearchReturn incSearchReturn = findSupport.incSearch(map2, this.fSearchStartOffset);
        if (incSearchReturn.getFoundText()) {
            this.fLastFindPos = incSearchReturn.getPos();
            this.fLastFindLength = incSearchReturn.getLength();
            JTextComponent jTextComponent = this.getLastActiveComponent();
            jTextComponent.getCaret().setDot(this.fLastFindPos);
        } else {
            this.fLastFindPos = -1;
            this.fLastFindLength = -1;
        }
        findSupport.putFindProperties(map);
        return new IncSearchData(string, incSearchReturn.getFoundText(), incSearchReturn.getPos(), incSearchReturn.getLength(), bl);
    }

    @Override
    public String incSearchNextWord(String string) {
        String string2 = string;
        if (this.fLastFindPos != -1 && this.fLastFindLength != -1) {
            try {
                JTextComponent jTextComponent = Utilities.getLastActiveComponent();
                int n = this.fLastFindPos;
                int n2 = this.fLastFindLength;
                boolean bl = false;
                int n3 = Utilities.getWordEnd((JTextComponent)jTextComponent, (int)(n += n2));
                if (n3 != n) {
                    string2 = jTextComponent.getDocument().getText(this.fLastFindPos, n3 - this.fLastFindPos);
                } else {
                    if (bl) {
                        System.out.println("Word2 (getNextWord) end offset is: " + Utilities.getNextWord((JTextComponent)jTextComponent, (int)n));
                    }
                    n = Utilities.getNextWord((JTextComponent)jTextComponent, (int)n);
                    String string3 = Utilities.getIdentifier((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n);
                    if (bl) {
                        System.out.println("Word3 (newsearchWord) end offset is: " + Utilities.getNextWord((JTextComponent)jTextComponent, (int)n));
                    }
                    if (string3 == null) {
                        n = Utilities.getNextWord((JTextComponent)jTextComponent, (int)n);
                    }
                    string2 = jTextComponent.getDocument().getText(this.fLastFindPos, Utilities.getWordEnd((JTextComponent)jTextComponent, (int)n) - this.fLastFindPos);
                    if (bl) {
                        System.out.println("new searchstring: " + string2);
                    }
                }
                jTextComponent.select(this.fLastFindPos, this.fLastFindPos + string2.length());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string2;
    }

    @Override
    public String incSearchEOL(String string) {
        return string;
    }

    @Override
    public void endIncSearch() {
        this.incSearchEnded();
    }

    @Override
    public void endIncSearchMoveCaret() {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        if (jTextComponent != null && this.fLastFindPos != -1 && this.fLastFindLength != -1) {
            jTextComponent.getCaret().setDot(this.fLastFindPos + this.fLastFindLength);
        }
        this.incSearchEnded();
    }

    private void incSearchEnded() {
        JTextComponent jTextComponent = this.getLastActiveComponent();
        FindSupport findSupport = FindSupport.getFindSupport();
        findSupport.incSearchReset();
        this.fStp.endIncSearch();
        this.fLastFindPos = -1;
        this.fLastFindLength = -1;
        jTextComponent.repaint();
    }

    @Override
    public JTextComponent getLastActiveComponent() {
        return SyntaxTextPaneUtilities.getLastActiveComponent();
    }

    @Override
    public boolean getMacSupport() {
        return false;
    }

    @Override
    public void clearSearch() {
        FindSupport findSupport = FindSupport.getFindSupport();
        findSupport.incSearchReset();
        JTextComponent jTextComponent = this.getLastActiveComponent();
        if (this.fPosBeforeInc != -1) {
            jTextComponent.setCaretPosition(this.fPosBeforeInc);
        }
        this.fLastFindPos = -1;
    }
}

