/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.format.BooleanFormatter;
import com.mathworks.widgets.spreadsheet.format.BooleanFormatterFactory;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatterFactory;
import com.mathworks.widgets.spreadsheet.format.CompositeFormatter;
import com.mathworks.widgets.spreadsheet.format.Formatter;

public enum FormatIdentifier {
    SHORT("short", "3.1416"),
    LONG("long", "3.141592653589793"),
    SHORT_E("short e", "3.1416e+00"),
    LONG_E("long e", "3.141592653589793e+00"),
    SHORT_G("short g", "3.1416"),
    LONG_G("long g", "3.14159265358979"),
    SHORT_ENG("short eng", "3.1416e+000"),
    LONG_ENG("long eng", "3.14159265358979e+000"),
    BANK("bank", "3.14"),
    PLUS("+", "+, -, blank"),
    RATIONAL("rat", "355/113");

    private final String fName;
    private final String fSample;

    private FormatIdentifier(String string2, String string3) {
        this.fName = string2;
        this.fSample = string3;
    }

    @Deprecated
    public String getName() {
        return this.toString();
    }

    public Formatter getFormatter(char c) {
        ComplexScalarFormatter complexScalarFormatter = ComplexScalarFormatterFactory.getInstance(this, c);
        BooleanFormatter booleanFormatter = this.equals((Object)PLUS) ? BooleanFormatterFactory.getPlusInstance() : BooleanFormatterFactory.getNumericInstance();
        return new CompositeFormatter(complexScalarFormatter, booleanFormatter);
    }

    public Formatter getFormatter() {
        return this.getFormatter('.');
    }

    public FormatIdentifier getEditorIdentifier() {
        switch (this) {
            case SHORT: {
                return LONG;
            }
            case SHORT_E: {
                return LONG_E;
            }
            case SHORT_G: {
                return LONG_G;
            }
            case SHORT_ENG: {
                return LONG_ENG;
            }
            case LONG: 
            case LONG_E: 
            case LONG_G: 
            case LONG_ENG: {
                return this;
            }
            case BANK: 
            case PLUS: 
            case RATIONAL: {
                return LONG;
            }
        }
        return null;
    }

    public static FormatIdentifier getDefaultInstance() {
        return SHORT;
    }

    public static FormatIdentifier fromString(String string) {
        return FormatIdentifier.valueOf(string.replaceAll(" ", "_").toUpperCase());
    }

    public String toString() {
        return this.fName;
    }

    public String getSample() {
        return this.fSample;
    }
}

