/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarByte;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarDouble;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarFloat;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarInteger;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarLong;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarShort;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;
import com.mathworks.widgets.spreadsheet.format.PlusFormatter;
import com.mathworks.widgets.spreadsheet.format.PrintMat;
import com.mathworks.widgets.spreadsheet.format.RationalFormatter;

public final class ComplexScalarFormatterFactory {
    private ComplexScalarFormatterFactory() {
    }

    public static ComplexScalarFormatter getInstance(FormatIdentifier formatIdentifier) {
        return ComplexScalarFormatterFactory.getInstance(formatIdentifier, '.');
    }

    public static ComplexScalarFormatter getInstance(FormatIdentifier formatIdentifier, char c) {
        switch (formatIdentifier) {
            case SHORT: {
                return new GEBestFormatter(FormatIdentifier.SHORT, c);
            }
            case LONG: {
                return new GEBestFormatter(FormatIdentifier.LONG, c);
            }
            case SHORT_E: {
                return new GEBestFormatter(FormatIdentifier.SHORT_E, c);
            }
            case LONG_E: {
                return new GEBestFormatter(FormatIdentifier.LONG_E, c);
            }
            case SHORT_G: {
                return new GEBestFormatter(FormatIdentifier.SHORT_G, c);
            }
            case LONG_G: {
                return new GEBestFormatter(FormatIdentifier.LONG_G, c);
            }
            case SHORT_ENG: {
                return new GEBestFormatter(FormatIdentifier.SHORT_ENG, c);
            }
            case LONG_ENG: {
                return new GEBestFormatter(FormatIdentifier.LONG_ENG, c);
            }
            case PLUS: {
                return new PlusFormatter();
            }
            case RATIONAL: {
                return new RationalFormatter();
            }
            case BANK: {
                return new GEBestFormatter(FormatIdentifier.BANK, c);
            }
        }
        throw new IllegalArgumentException("ComplexScalarFormatFactory cannot acccept " + (Object)((Object)formatIdentifier));
    }

    public static ComplexScalarFormatter getInstance() {
        return ComplexScalarFormatterFactory.getInstance(FormatIdentifier.SHORT);
    }

    private static class GEBestFormatter
    implements ComplexScalarFormatter {
        private final FormatIdentifier fFormatIdentifier;
        private final char fDecimalSeparator;

        protected GEBestFormatter(FormatIdentifier formatIdentifier, char c) {
            this.fFormatIdentifier = formatIdentifier;
            this.fDecimalSeparator = c;
        }

        @Override
        public final String format(ComplexScalar complexScalar) {
            ComplexScalar complexScalar2 = this.fFormatIdentifier == FormatIdentifier.BANK && !complexScalar.isReal() ? GEBestFormatter.deriveRealCSFromCS(complexScalar) : complexScalar;
            if (FormatUtils.isFloatingPointType(complexScalar2)) {
                return PrintMat.format(complexScalar2, this.fFormatIdentifier).replace('.', this.fDecimalSeparator);
            }
            return ((ComplexIntegralScalar)complexScalar2).formatAsIntegral();
        }

        @Override
        public final String format(Number number) {
            return PrintMat.format(number, this.fFormatIdentifier).replace('.', this.fDecimalSeparator);
        }

        public final String toString() {
            return "ComplexScalarFormatter: " + this.fFormatIdentifier.getName() + ')';
        }

        @Override
        public final ComplexScalarFormatter getEditingComplexScalarFormatter() {
            return ComplexScalarFormatterFactory.getInstance(this.fFormatIdentifier.getEditorIdentifier());
        }

        @Override
        public String getName() {
            return this.fFormatIdentifier.getName();
        }

        private static ComplexScalar deriveRealCSFromCS(ComplexScalar complexScalar) {
            if (complexScalar instanceof ComplexScalarDouble) {
                return ComplexScalarDouble.valueOf(complexScalar.doubleValueReal());
            }
            if (complexScalar instanceof ComplexScalarFloat) {
                return ComplexScalarFloat.valueOf((float)complexScalar.doubleValueReal());
            }
            if (complexScalar instanceof ComplexScalarLong) {
                return ComplexScalarLong.valueOf(complexScalar.longValueReal());
            }
            if (complexScalar instanceof ComplexScalarInteger) {
                return ComplexScalarInteger.valueOf((int)complexScalar.longValueReal());
            }
            if (complexScalar instanceof ComplexScalarByte) {
                return ComplexScalarByte.valueOf((byte)complexScalar.longValueReal());
            }
            if (complexScalar instanceof ComplexScalarShort) {
                return ComplexScalarShort.valueOf((short)complexScalar.longValueReal());
            }
            return null;
        }
    }
}

