/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarByte;
import java.util.Arrays;

public final class ComplexArrayByte
extends ComplexArray {
    private final byte[][] fR;
    private final byte[][] fI;

    public static ComplexArrayByte valueOf(byte[][] byArray) {
        return ComplexArrayByte.valueOf(byArray, true);
    }

    public static ComplexArrayByte valueOf(byte[][] byArray, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)byArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayByte(byArray, bl);
    }

    public static ComplexArrayByte valueOf(byte[][] byArray, byte[][] byArray2) {
        return ComplexArrayByte.valueOf(byArray, byArray2, true);
    }

    public static ComplexArrayByte valueOf(byte[][] byArray, byte[][] byArray2, boolean bl) {
        if (byArray == null || byArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((byte[][])byArray), ArrayUtils.getLengths((byte[][])byArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayByte(byArray, byArray2, bl);
    }

    private ComplexArrayByte(byte[][] byArray, boolean bl) {
        super(bl);
        this.fR = byArray;
        this.fI = null;
    }

    private ComplexArrayByte(byte[][] byArray, byte[][] byArray2, boolean bl) {
        super(bl);
        this.fR = byArray;
        this.fI = byArray2;
    }

    public byte[][] byteValueReal() {
        return this.fR;
    }

    public byte[][] byteValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((byte[][])this.fR);
    }

    @Override
    public ComplexScalarByte getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarByte.valueOf(this.fR[n][n2], this.isSigned());
        }
        return ComplexScalarByte.valueOf(this.fR[n][n2], this.fI[n][n2], this.isSigned());
    }
}

