/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.recordlist.ActionUtils;
import com.mathworks.widgets.recordlist.CustomIconListCellRenderer;
import com.mathworks.widgets.recordlist.DefaultSelectionPopupMenu;
import com.mathworks.widgets.recordlist.IActionProvider;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.ICreationObserver;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IDuplicationObserver;
import com.mathworks.widgets.recordlist.IOpeningObserver;
import com.mathworks.widgets.recordlist.IRecordContainer;
import com.mathworks.widgets.recordlist.IRecordFilter;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.InternalActionHelper;
import com.mathworks.widgets.recordlist.ObserverAdapter;
import com.mathworks.widgets.recordlist.RecordlistSelectionTracker;
import com.mathworks.widgets.recordlist.RecordlistTableModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RecordlistList
extends MJList
implements IRecordContainer,
IActionProvider {
    protected MJAbstractAction fCopyingAction = null;
    protected MJAbstractAction fCreationAction = null;
    protected MJAbstractAction fDeletionAction = null;
    protected MJAbstractAction fDuplicationAction = null;
    protected MJAbstractAction fOpeningAction = null;
    protected MJAbstractAction fSelectAllAction = null;
    protected RecordlistTableModel fRLTM = null;
    protected IRecordIconProvider fRIP = null;
    protected MJPopupMenu fSelectionPopupMenu = null;
    protected CustomIconListCellRenderer fCLCR = null;
    protected RecordlistSelectionTracker fRLST = null;
    private boolean fInUpdate = false;
    private List<Integer> fSelectionList = null;
    private final MInputMap fInputMap = ActionUtils.createMInputMap((JComponent)((Object)this));
    private final InternalActionHelper fActionHelper = new ActionHelper();

    public RecordlistList(IRecordlistModel iRecordlistModel) {
        this(new RecordlistTableModel(iRecordlistModel));
    }

    public RecordlistList(RecordlistTableModel recordlistTableModel) {
        super((ListModel)recordlistTableModel);
        this.setCellViewerEnabled(true);
        this.setRightSelectionEnabled(true);
        if (recordlistTableModel.isRecordIconProvider()) {
            this.fRIP = recordlistTableModel;
            this.fCLCR = new CustomIconListCellRenderer(this.fRIP);
            this.setCellRenderer(this.fCLCR);
        }
        this.fRLTM = recordlistTableModel;
        this.fRLTM.setPrivateDeletionObserver(new ObserverAdapter());
        this.fRLST = new RecordlistSelectionTracker();
        InputEventListener inputEventListener = new InputEventListener();
        this.createActions();
        this.fSelectionPopupMenu = new DefaultSelectionPopupMenu(this);
        this.addMouseListener(inputEventListener);
        this.getSelectionModel().addListSelectionListener(new SelectionRecorder());
        recordlistTableModel.addListDataListener(new SelectionSetter());
    }

    public MJPopupMenu getSelectionPopupMenu() {
        return this.fSelectionPopupMenu;
    }

    public void setSelectionPopupMenu(MJPopupMenu mJPopupMenu) {
        this.fSelectionPopupMenu = mJPopupMenu;
    }

    @Override
    public int getRecordCount() {
        return this.fRLTM.getRowCount();
    }

    public boolean isRecordCreator() {
        return this.fRLTM.isRecordCreator();
    }

    public void createRecord() {
        this.prepSelectionTrackerForCreate();
        this.fRLTM.createRecord();
    }

    public void setCreationObserver(ICreationObserver iCreationObserver) {
        this.fRLTM.setCreationObserver(iCreationObserver);
    }

    public boolean isRecordDeleter() {
        return this.fRLTM.isRecordDeleter();
    }

    public boolean areRecordsDeletable(int[] nArray) {
        return this.fRLTM.areRecordsDeletable(nArray);
    }

    public void deleteRecords(int[] nArray) {
        this.fRLTM.deleteRecords(nArray);
    }

    public void setDeletionObserver(IDeletionObserver iDeletionObserver) {
        this.fRLTM.setDeletionObserver(iDeletionObserver);
    }

    public boolean isRecordDuplicator() {
        return this.fRLTM.isRecordDuplicator();
    }

    public boolean areRecordsDuplicatable(int[] nArray) {
        return this.fRLTM.areRecordsDuplicatable(nArray);
    }

    public void duplicateRecords(int[] nArray) {
        this.prepSelectionTrackerForDuplicate();
        this.fRLTM.duplicateRecords(nArray);
    }

    public void setDuplicationObserver(IDuplicationObserver iDuplicationObserver) {
        this.fRLTM.setDuplicationObserver(iDuplicationObserver);
    }

    @Override
    public MJAbstractAction getAction(int n) {
        MJAbstractAction mJAbstractAction = null;
        switch (n) {
            case 0: {
                mJAbstractAction = this.fCopyingAction;
                break;
            }
            case 10: {
                mJAbstractAction = this.fCreationAction;
                break;
            }
            case 20: {
                mJAbstractAction = this.fDeletionAction;
                break;
            }
            case 30: {
                mJAbstractAction = this.fDuplicationAction;
                break;
            }
            case 40: {
                mJAbstractAction = this.fOpeningAction;
            }
        }
        return mJAbstractAction;
    }

    @Override
    public MJAbstractAction[] getEditingActions() {
        return null;
    }

    @Override
    public MJAbstractAction[] getInsertActions() {
        return null;
    }

    public boolean isRecordOpener() {
        return this.fRLTM.isRecordOpener();
    }

    public boolean areRecordsOpenable(int[] nArray) {
        return this.fRLTM.areRecordsOpenable(nArray);
    }

    public void openRecords(int[] nArray) {
        this.fRLTM.openRecords(nArray);
    }

    public void setOpeningObserver(IOpeningObserver iOpeningObserver) {
        this.fRLTM.setOpeningObserver(iOpeningObserver);
    }

    public boolean isRecordCopier() {
        return this.fRLTM.isRecordCopier();
    }

    public boolean areRecordsCopyable(int[] nArray) {
        return this.fRLTM.areRecordsCopyable(nArray);
    }

    public void copyRecords(int[] nArray) {
        this.fRLTM.copyRecords(nArray);
    }

    public void setCopyingObserver(ICopyingObserver iCopyingObserver) {
        this.fRLTM.setCopyingObserver(iCopyingObserver);
    }

    public int getRowCount() {
        return this.getRecordCount();
    }

    public void setFilter(IRecordFilter iRecordFilter, int n) {
        this.fRLTM.setFilter(iRecordFilter, n);
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getRowCount());
    }

    public IRecordFilter getFilter(int n) {
        return this.fRLTM.getFilter(n);
    }

    public void setIconVisibility(boolean bl) {
        this.fCLCR.setIconVisibility(bl);
    }

    public boolean getIconVisibility() {
        return this.fCLCR.getIconVisibility();
    }

    private void copySelection() {
        this.copyRecords(this.getSelectedIndicesInChronOrder());
    }

    private void deleteSelection() {
        this.deleteRecords(this.getSelectedIndicesInChronOrder());
    }

    private void duplicateSelection() {
        this.duplicateRecords(this.getSelectedIndicesInChronOrder());
    }

    private void openSelection() {
        this.openRecords(this.getSelectedIndicesInChronOrder());
    }

    private void createActions() {
        if (this.isRecordOpener()) {
            this.fOpeningAction = new ActionUtils.OpeningAction(this.fActionHelper);
        }
        if (this.isRecordCreator()) {
            this.fCreationAction = new ActionUtils.CreationAction(this.fActionHelper);
        }
        if (this.isRecordCopier()) {
            this.fCopyingAction = new ActionUtils.CopyingAction(this.fActionHelper);
        }
        if (this.isRecordDuplicator()) {
            this.fDuplicationAction = new ActionUtils.DuplicationAction(this.fActionHelper);
        }
        if (this.isRecordDeleter()) {
            this.fDeletionAction = new ActionUtils.DeletionAction(this.fActionHelper);
        }
        this.fSelectAllAction = new ActionUtils.SelectAllAction(this.fActionHelper);
    }

    protected void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
        ActionUtils.registerWithInputAndActionMaps(mJAbstractAction, (ExtendedInputMap)this.fInputMap, this.getActionMap());
    }

    protected void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction, KeyStroke keyStroke) {
        this.getInputMap().put(keyStroke, mJAbstractAction.getValue("Name"));
        this.getActionMap().put(mJAbstractAction.getValue("Name"), (Action)mJAbstractAction);
    }

    private void processPopup(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            this.fSelectionPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void rememberSelectedRecords() {
        if (this.fRLST != null) {
            this.fRLST.recordSelection(this.getSelectedValues());
        }
    }

    protected void rememberAllRecords() {
        if (this.fRLST != null) {
            this.fRLST.recordAllExisting(this.getPrimaryRecordIdentifiers());
        }
    }

    protected void prepSelectionTrackerForCreate() {
        this.rememberAllRecords();
        this.fRLST.setCreationPending(true);
    }

    protected void prepSelectionTrackerForDuplicate() {
        this.rememberAllRecords();
        this.fRLST.setDuplicationPending(true);
    }

    Object[] getPrimaryRecordIdentifiers() {
        Object[] objectArray = new Object[this.getModel().getSize()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getModel().getElementAt(i);
        }
        return objectArray;
    }

    protected int[] getSelectedIndicesInChronOrder() {
        if (this.fSelectionList == null) {
            return ArrayUtils.EmptyPrimitives.INT;
        }
        int[] nArray = new int[this.fSelectionList.size()];
        for (int i = 0; i < this.fSelectionList.size(); ++i) {
            nArray[i] = this.fSelectionList.get(i);
        }
        return nArray;
    }

    private class ActionHelper
    implements InternalActionHelper {
        private ActionHelper() {
        }

        @Override
        public void selectAll() {
            RecordlistList.this.selectAll();
        }

        @Override
        public void openSelection() {
            RecordlistList.this.openSelection();
        }

        @Override
        public void createRecord() {
            RecordlistList.this.createRecord();
        }

        @Override
        public void duplicateSelection() {
            RecordlistList.this.duplicateSelection();
        }

        @Override
        public void deleteSelection() {
            RecordlistList.this.deleteSelection();
        }

        @Override
        public void copySelection() {
            RecordlistList.this.copySelection();
        }

        @Override
        public MInputMap getMInputMap() {
            return RecordlistList.this.fInputMap;
        }

        @Override
        public ActionMap getActionMap() {
            return RecordlistList.this.getActionMap();
        }
    }

    private class SelectionSetter
    implements ListDataListener {
        private SelectionSetter() {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (RecordlistList.this.fRLST != null) {
                int n;
                Object[] objectArray = RecordlistList.this.fRLST.getNewSelectionFromExisting(RecordlistList.this.getPrimaryRecordIdentifiers());
                int n2 = RecordlistList.this.getSelectedIndex();
                ListSelectionModel listSelectionModel = RecordlistList.this.getSelectionModel();
                if (objectArray.length > 0) {
                    listSelectionModel.clearSelection();
                    for (Object object : objectArray) {
                        for (int i = 0; i < RecordlistList.this.getRecordCount(); ++i) {
                            if (!RecordlistList.this.fRLTM.getValueAt(i, RecordlistList.this.fRLTM.getPrimaryFieldIndex()).equals(object)) continue;
                            listSelectionModel.addSelectionInterval(i, i);
                        }
                    }
                    RecordlistList.this.fRLST.setCreationPending(false);
                    RecordlistList.this.fRLST.setDuplicationPending(false);
                    n = RecordlistList.this.getSelectedIndex();
                    if (n != -1) {
                        try {
                            RecordlistList.this.ensureIndexIsVisible(n);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                n = RecordlistList.this.getModel().getSize();
                int n3 = RecordlistList.this.getSelectedIndex();
                if (n3 == -1 || n3 >= n) {
                    int n4 = Math.min(n - 1, n2);
                    try {
                        RecordlistList.this.setSelectedIndex(n4);
                        RecordlistList.this.ensureIndexIsVisible(n4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    private class SelectionRecorder
    implements ListSelectionListener {
        private SelectionRecorder() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray;
            int n5;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (!RecordlistList.this.fInUpdate) {
                RecordlistList.this.rememberSelectedRecords();
            }
            if (RecordlistList.this.fSelectionList == null) {
                RecordlistList.this.fSelectionList = new ArrayList();
            }
            if ((n5 = (nArray = RecordlistList.this.getSelectedIndices()).length) == 0) {
                RecordlistList.this.fSelectionList.clear();
                return;
            }
            if (n5 == 1) {
                RecordlistList.this.fSelectionList.clear();
                RecordlistList.this.fSelectionList.add(nArray[0]);
                return;
            }
            Integer[] integerArray = RecordlistList.this.fSelectionList.toArray(new Integer[RecordlistList.this.fSelectionList.size()]);
            for (int i = integerArray.length - 1; i >= 0; --i) {
                n4 = integerArray[i];
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    n = nArray[n2];
                    if (n4 != n) continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) continue;
                RecordlistList.this.fSelectionList.remove(i);
            }
            Integer[] integerArray2 = RecordlistList.this.fSelectionList.toArray(new Integer[RecordlistList.this.fSelectionList.size()]);
            n4 = integerArray2.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = nArray[n3];
                n = 0;
                for (int i = n4 - 1; i >= 0; --i) {
                    int n6 = integerArray2[i];
                    if (n6 != n2) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                RecordlistList.this.fSelectionList.add(n2);
            }
        }
    }

    private class InputEventListener
    extends MouseAdapter {
        private InputEventListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() | 0x10) == 16 && RecordlistList.this.isRecordOpener()) {
                RecordlistList.this.openSelection();
                mouseEvent.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (mouseEvent.isPopupTrigger()) {
                RecordlistList.this.processPopup(mouseEvent);
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (mouseEvent.isPopupTrigger()) {
                RecordlistList.this.processPopup(mouseEvent);
                mouseEvent.consume();
            }
        }
    }
}

