/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.menus;

import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class DefaultMenuBuilder
implements MenuBuilder {
    private final MenuContainer fMenuContainer;
    private final Map<MenuGroupID, MenuGroup> fGroups;
    private final List<MenuGroupID> fGroupList;
    private static final String ADDED_BY_DEFAULT_MENU_BUILDER = "addedByDefaultMenuBuilder";

    public DefaultMenuBuilder(MenuGroupID ... menuGroupIDArray) {
        this(new MJMenu(), menuGroupIDArray);
    }

    public DefaultMenuBuilder(String string, String string2, MenuGroupID ... menuGroupIDArray) {
        this(new MJMenu(string), menuGroupIDArray);
        this.getMenu().setName(string2);
    }

    public DefaultMenuBuilder(Action action, String string, MenuGroupID ... menuGroupIDArray) {
        this(new MJMenu(action), menuGroupIDArray);
        this.getMenu().setName(string);
    }

    public DefaultMenuBuilder(DTMenuMergeTag dTMenuMergeTag, MenuGroupID ... menuGroupIDArray) {
        this(new MJMenu(), menuGroupIDArray);
        dTMenuMergeTag.setTag((JMenuItem)((MenuMenuContainer)this.fMenuContainer).getMenu());
    }

    public DefaultMenuBuilder(MJMenu mJMenu, MenuGroupID ... menuGroupIDArray) {
        this(new MenuMenuContainer(mJMenu), menuGroupIDArray);
    }

    public DefaultMenuBuilder(MJPopupMenu mJPopupMenu, MenuGroupID ... menuGroupIDArray) {
        this(new PopupMenuMenuContainer(mJPopupMenu), menuGroupIDArray);
    }

    private DefaultMenuBuilder(MenuContainer menuContainer, MenuGroupID ... menuGroupIDArray) {
        this.fMenuContainer = menuContainer;
        this.fGroups = new HashMap<MenuGroupID, MenuGroup>();
        this.fGroupList = new ArrayList<MenuGroupID>();
        for (MenuGroupID menuGroupID : menuGroupIDArray) {
            this.insertNextGroup(menuGroupID);
        }
    }

    public MJMenuItem add(MenuGroupID menuGroupID, Action action) {
        MJMenuItem mJMenuItem = this.getGroup(menuGroupID).add(action);
        this.refresh();
        return mJMenuItem;
    }

    public Component add(MenuGroupID menuGroupID, Component component) {
        this.getGroup(menuGroupID).add(component);
        this.refresh();
        return component;
    }

    public void insertNextGroup(MenuGroupID menuGroupID) {
        this.insertGroup(this.fGroupList.size(), menuGroupID);
    }

    public void insertGroupBefore(MenuGroupID menuGroupID, MenuGroupID menuGroupID2) {
        int n = this.fGroupList.indexOf(menuGroupID);
        if (n == -1) {
            throw new IllegalArgumentException("Group ID \"" + menuGroupID + "\" is not in the list of groups");
        }
        this.insertGroup(this.fGroupList.indexOf(menuGroupID), menuGroupID2);
    }

    public void insertGroupAfter(MenuGroupID menuGroupID, MenuGroupID menuGroupID2) {
        int n = this.fGroupList.indexOf(menuGroupID);
        if (n == -1) {
            throw new IllegalArgumentException("Group ID \"" + menuGroupID + "\" is not in the list of groups");
        }
        this.insertGroup(n + 1, menuGroupID2);
    }

    public MJMenu getMenu() {
        if (!(this.fMenuContainer instanceof MenuMenuContainer)) {
            throw new IllegalStateException("This MenuBuilder was not constructed to return a JMenu.");
        }
        return ((MenuMenuContainer)this.fMenuContainer).getMenu();
    }

    public MJPopupMenu getPopupMenu() {
        if (!(this.fMenuContainer instanceof PopupMenuMenuContainer)) {
            throw new IllegalStateException("This MenuBuilder was not constructed to return a JPopupMenu.");
        }
        return ((PopupMenuMenuContainer)this.fMenuContainer).getPopup();
    }

    public boolean isEmpty() {
        boolean bl = true;
        for (MenuGroup menuGroup : this.fGroups.values()) {
            bl &= menuGroup.isEmpty();
        }
        return bl;
    }

    public void clearContents() {
        for (MenuGroupID menuGroupID : this.fGroupList) {
            this.fGroups.get(menuGroupID).clear();
        }
        this.refresh();
    }

    private void insertGroup(int n, MenuGroupID menuGroupID) {
        if (this.fGroups.containsKey(menuGroupID)) {
            throw new IllegalArgumentException("Group ID \"" + menuGroupID + "\" already exists in the list of groups");
        }
        this.fGroups.put(menuGroupID, new MenuGroup());
        this.fGroupList.add(n, menuGroupID);
    }

    private MenuGroup getGroup(MenuGroupID menuGroupID) {
        MenuGroup menuGroup = this.fGroups.get(menuGroupID);
        if (menuGroup == null) {
            throw new IllegalArgumentException("Group \"" + menuGroupID + "\" doesn't exist; must be created via insertGroupAfter or " + "insertGroupBefore");
        }
        return menuGroup;
    }

    private void refresh() {
        this.fMenuContainer.removeAddedItems();
        for (MenuGroupID menuGroupID : this.fGroupList) {
            MenuGroup menuGroup = this.fGroups.get(menuGroupID);
            menuGroup.addToMenuContainer(this.fMenuContainer);
        }
    }

    private static void markAsAdded(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(ADDED_BY_DEFAULT_MENU_BUILDER, true);
        }
    }

    private static boolean shouldRemoveComponent(Component component) {
        return component instanceof JComponent && ((JComponent)component).getClientProperty(ADDED_BY_DEFAULT_MENU_BUILDER) != null;
    }

    private static void addSeparatorAndMarkAsAdded(JPopupMenu jPopupMenu) {
        jPopupMenu.addSeparator();
        int n = jPopupMenu.getComponentCount() - 1;
        JComponent jComponent = (JComponent)jPopupMenu.getComponents()[n];
        DefaultMenuBuilder.markAsAdded(jComponent);
    }

    private static void removeAddedItems(JPopupMenu jPopupMenu) {
        for (Component component : jPopupMenu.getComponents()) {
            if (!DefaultMenuBuilder.shouldRemoveComponent(component)) continue;
            jPopupMenu.remove(component);
        }
    }

    private static Component getLastItem(JPopupMenu jPopupMenu) {
        return jPopupMenu.getComponentCount() == 0 ? null : jPopupMenu.getComponents()[jPopupMenu.getComponentCount() - 1];
    }

    private static class PopupMenuMenuContainer
    implements MenuContainer {
        private final MJPopupMenu fPopup;

        private PopupMenuMenuContainer(MJPopupMenu mJPopupMenu) {
            this.fPopup = mJPopupMenu;
        }

        public MJPopupMenu getPopup() {
            return this.fPopup;
        }

        @Override
        public int getMenuItemCount() {
            return this.fPopup.getComponentCount();
        }

        @Override
        public void addMenuItem(Component component) {
            this.fPopup.add(component);
        }

        @Override
        public void addSeparator() {
            DefaultMenuBuilder.addSeparatorAndMarkAsAdded((JPopupMenu)this.fPopup);
        }

        @Override
        public void removeAddedItems() {
            DefaultMenuBuilder.removeAddedItems((JPopupMenu)this.fPopup);
        }

        @Override
        public Component getLastItem() {
            return DefaultMenuBuilder.getLastItem((JPopupMenu)this.fPopup);
        }
    }

    private static class MenuMenuContainer
    implements MenuContainer {
        private final MJMenu fMenu;

        private MenuMenuContainer(MJMenu mJMenu) {
            this.fMenu = mJMenu;
        }

        public MJMenu getMenu() {
            return this.fMenu;
        }

        @Override
        public int getMenuItemCount() {
            return this.fMenu.getMenuComponentCount();
        }

        @Override
        public void addMenuItem(Component component) {
            this.fMenu.add(component);
        }

        @Override
        public void addSeparator() {
            DefaultMenuBuilder.addSeparatorAndMarkAsAdded(this.fMenu.getPopupMenu());
        }

        @Override
        public void removeAddedItems() {
            DefaultMenuBuilder.removeAddedItems(this.fMenu.getPopupMenu());
        }

        @Override
        public Component getLastItem() {
            return DefaultMenuBuilder.getLastItem(this.fMenu.getPopupMenu());
        }
    }

    private static interface MenuContainer {
        public int getMenuItemCount();

        public void addMenuItem(Component var1);

        public void addSeparator();

        public void removeAddedItems();

        public Component getLastItem();
    }

    private static class MenuGroup {
        private final List<Component> fItems = new ArrayList<Component>();

        private MenuGroup() {
        }

        private MJMenuItem add(Action action) {
            MJMenuItem mJMenuItem = new MJMenuItem(action);
            this.add((Component)mJMenuItem);
            return mJMenuItem;
        }

        private Component add(Component component) {
            DefaultMenuBuilder.markAsAdded(component);
            this.fItems.add(component);
            return component;
        }

        private boolean isEmpty() {
            return this.fItems.isEmpty();
        }

        private void clear() {
            this.fItems.clear();
        }

        private void addToMenuContainer(MenuContainer menuContainer) {
            if (!this.isEmpty()) {
                if (menuContainer.getMenuItemCount() > 0 && !(menuContainer.getLastItem() instanceof JPopupMenu.Separator)) {
                    menuContainer.addSeparator();
                }
                for (Component component : this.fItems) {
                    menuContainer.addMenuItem(component);
                }
            }
        }
    }
}

