/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.grouptable.DisplayEffects;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import com.mathworks.widgets.grouptable.GroupingTableUtils;
import com.mathworks.widgets.grouptable.IconAndText;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;

final class GroupingTableCellRenderer<T>
extends DefaultTableCellRenderer
implements NonRectangularCellRenderer {
    private final GroupingTableColumn<T> fColumn;
    private final boolean fPairing;
    private final boolean fShowVerticalAttributes;
    private final MJPanel fPanel;
    private final MJLabel fAttributeLabel;
    private final MJLabel fJawsLabel = new MJLabel();
    private final MJCheckBox fCheckBox;
    private int fMaximumPreferredWidth;
    private GroupingTable<T> fTable;
    private Group<T> fGroupToPaintHeader;
    private Rectangle fCell;
    private boolean fHasFocus;
    private boolean fIsSelected;
    private int fColumnIndex;
    private int fRowIndex;
    private GroupingTableRow<T> fRowObject;
    private boolean fAnyVerticalAttributes;
    private DisplayEffects fDisplayEffects;
    private Rectangle fMainDataRect;
    private Area fDataArea;
    private int fIndentation;
    private boolean fForceNoFocus;
    private int fIconWidthInCurrentColumn;

    GroupingTableCellRenderer(GroupingTableColumn<T> groupingTableColumn, boolean bl, boolean bl2) {
        this.fShowVerticalAttributes = bl2;
        this.fColumn = groupingTableColumn;
        this.fPairing = bl;
        this.fCheckBox = !groupingTableColumn.getType().equals(Boolean.class) ? null : new FocusableCheckBox();
        this.fPanel = new MJPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(GroupingTableCellRenderer.this.fMaximumPreferredWidth, GroupingTableCellRenderer.this.fShowVerticalAttributes ? (int)GroupingTableCellRenderer.this.fCell.getHeight() : GroupingTableCellRenderer.this.fTable.getLineHeight());
            }

            public void paint(Graphics graphics) {
                if (GroupingTableCellRenderer.this.fGroupToPaintHeader != null) {
                    GroupingTableCellRenderer.this.paintGroupHeader((Component)((Object)this), graphics);
                } else {
                    GroupingTableCellRenderer.this.paintDataAndVerticalAttributes(GroupingTableCellRenderer.this.fTable, GroupingTableCellRenderer.this.fRowObject, GroupingTableCellRenderer.this.fCell, graphics);
                }
                if (GroupingTableCellRenderer.this.rowHasFocus() && (GroupingTableCellRenderer.this.fTable.getConfiguration().getExpansionProviders().isEmpty() || GroupingTableCellRenderer.this.fColumnIndex > 0)) {
                    GroupingTableCellRenderer.paintFocus((JComponent)((Object)this), graphics, GroupingTableCellRenderer.this.fColumnIndex >= GroupingTableCellRenderer.this.fTable.getColumnCount() - 1);
                }
            }
        };
        this.fAttributeLabel = new MJLabel();
        this.fAttributeLabel.setOpaque(true);
    }

    public Component getUnfocusedRenderer(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.fForceNoFocus = true;
        Component component = this.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        this.fForceNoFocus = false;
        return component;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n < 0 || n >= jTable.getRowCount() || n2 < 0 || n2 >= jTable.getColumnCount()) {
            return super.getTableCellRendererComponent(jTable, object, bl, this.fHasFocus, n, n2);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            this.fJawsLabel.setText(GroupingTableCellRenderer.getAccessibleText((GroupingTable)((Object)jTable), n));
            this.fJawsLabel.getAccessibleContext().setAccessibleName(this.fJawsLabel.getText());
            return this.fJawsLabel;
        }
        this.fGroupToPaintHeader = null;
        this.fColumnIndex = n2;
        this.fRowIndex = n;
        this.fTable = (GroupingTable)((Object)jTable);
        this.fHasFocus = this.fCheckBox != null ? this.rowHasFocus() : bl2;
        if (this.fForceNoFocus) {
            this.fHasFocus = false;
        }
        super.getTableCellRendererComponent(jTable, object, bl, this.fHasFocus, n, n2);
        this.fIsSelected = bl;
        this.fAnyVerticalAttributes = this.fTable.getConfiguration().getVisibleVerticalAttributeCount() > 0;
        this.fRowObject = this.fTable.getRowAt(n);
        this.fIndentation = this.fRowObject.getLevel() + 1;
        T t = this.fTable.get(n);
        this.fDisplayEffects = this.fTable.getAffordanceManager().getEffects(this.fRowObject);
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
        } else if (this.fDisplayEffects != null && this.fDisplayEffects.getColumnSpecificColorStyle(this.fColumn.getKey()) != null) {
            this.setForeground(this.fDisplayEffects.getColumnSpecificColorStyle(this.fColumn.getKey()).getForegroundColor(jTable));
        } else {
            this.setForeground(this.fDisplayEffects == null ? jTable.getForeground() : this.fDisplayEffects.getColorStyle().getForegroundColor(jTable));
        }
        this.displayActualCellData(this.fTable, t, object, n, n2);
        if (this.fCell == null) {
            this.setCellRect(this.fTable, this.fRowObject, n2, jTable.getCellRect(n, n2, false));
        }
        if (object instanceof Boolean && this.fCheckBox != null) {
            this.fCheckBox.setSelected(((Boolean)object).booleanValue());
            this.fCheckBox.setBackground(this.getBackground());
            return this.fCheckBox;
        }
        this.setFont(this.fTable.getFont());
        this.fPanel.getAccessibleContext().setAccessibleName(GroupingTableCellRenderer.getAccessibleText(this.fTable, n));
        this.fPanel.setBackground(this.getBackground());
        if (this.fPairing || this.fShowVerticalAttributes && this.fAnyVerticalAttributes && this.fRowObject.getLoadedVerticalAttributeCount() > 0) {
            this.setSize(this.fPanel.getPreferredSize());
            return this.fPanel;
        }
        return this;
    }

    boolean rowHasFocus() {
        return this.fTable.isFocusOwner() && this.fTable.getSelectionModel().getLeadSelectionIndex() == this.fRowIndex && (!this.fTable.isEditing() || this.fTable.getEditingRow() != this.fRowIndex || this.fTable.getColumnClass(this.fTable.getEditingColumn()) != String.class);
    }

    void setCellRect(Rectangle rectangle) {
        this.fCell = rectangle;
    }

    void setCellRect(GroupingTable<T> groupingTable, GroupingTableRow<T> groupingTableRow, int n, Rectangle rectangle) {
        this.fCell = rectangle;
        if (this.fCell != null) {
            if (n == 0 && !groupingTable.getConfiguration().getExpansionProviders().isEmpty()) {
                int n2 = groupingTable.getIndent() * (groupingTableRow.getLevel() + 1);
                this.fCell = new Rectangle((int)(this.fCell.getX() + (double)n2), (int)this.fCell.getY(), (int)(this.fCell.getWidth() - (double)n2 - 1.0), (int)this.fCell.getHeight());
            }
            this.fMaximumPreferredWidth = (int)this.fCell.getWidth();
        }
    }

    @Override
    public void setForeground(Color color) {
        if (color instanceof ColorUIResource) {
            super.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        } else {
            super.setForeground(color);
        }
    }

    private static void paintFocus(JComponent jComponent, Graphics graphics, boolean bl) {
        Border border = UIDefaultsLookup.getBorder((Object)"Table.focusCellHighlightBorder");
        if (border != null) {
            Insets insets = border.getBorderInsets(jComponent);
            if (bl) {
                border.paintBorder(jComponent, graphics, -insets.left, 0, jComponent.getWidth() + insets.left, jComponent.getHeight());
            } else {
                border.paintBorder(jComponent, graphics, -insets.left, 0, jComponent.getWidth() + insets.left + insets.right, jComponent.getHeight());
            }
        }
    }

    private void paintGroupHeader(Component component, Graphics graphics) {
        Icon icon;
        Rectangle rectangle = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(GroupingTableUtils.getGroupHeaderGradient(rectangle));
        graphics2D.fill(rectangle);
        graphics2D.setPaint(paint);
        graphics2D.setFont(font.deriveFont(1));
        RenderingHints renderingHints = null;
        RenderingHints renderingHints2 = GraphicsUtils.getAntialiasingRenderingHints();
        if (renderingHints2 != null) {
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.addRenderingHints(renderingHints2);
        }
        if ((icon = this.fGroupToPaintHeader.getIcon()) != null) {
            icon.paintIcon(component, graphics2D, 2, this.getHeight() / 2 - icon.getIconHeight() / 2);
            rectangle.setBounds((int)(rectangle.getX() + (double)icon.getIconWidth() + 6.0), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        graphics2D.setColor(UIManager.getColor("Label.foreground"));
        graphics2D.drawString(this.fGroupToPaintHeader.getName(), (float)(rectangle.getX() + 1.0), (float)(rectangle.getHeight() / 2.0 + (double)(graphics2D.getFontMetrics().getAscent() / 2) - 1.0));
        graphics2D.setFont(font);
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    private <T> void paintDataAndVerticalAttributes(GroupingTable<T> groupingTable, GroupingTableRow<T> groupingTableRow, Rectangle rectangle, Graphics graphics) {
        int n;
        int n2;
        this.fAttributeLabel.setFont(this.getFont());
        this.fAttributeLabel.setBackground(this.getBackground());
        int n3 = this.fColumnIndex == 0 || this.fColumnIndex >= this.fTable.getColumnCount() - 1 ? 0 : 1;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth() - n3, this.getHeight());
        if (this.getIcon() != null) {
            this.fIconWidthInCurrentColumn = this.getIcon().getIconWidth() + 3;
            n2 = Math.max(0, this.fTable.getLineHeight() / 2 - this.getIcon().getIconHeight() / 2);
            n = 3;
            this.getIcon().paintIcon(this, graphics, n, n2);
        }
        n2 = 0;
        if (!groupingTable.getConfiguration().getExpansionProviders().isEmpty()) {
            n2 += groupingTable.getIndent() * (groupingTableRow.getLevel() + 1);
        }
        n = 0;
        if (groupingTable.getConfiguration().getVisibleColumns().get(0).getType() == Icon.class) {
            n = 23;
            n2 += n;
        }
        LinkedHashMap<VerticalAttribute<T>, String> linkedHashMap = groupingTableRow.getLoadedVerticalAttributes();
        int n4 = (int)(rectangle.getHeight() / 2.0 - (double)(groupingTable.getLineHeight() * (1 + linkedHashMap.size()) / 2));
        if (!linkedHashMap.isEmpty()) {
            ++n4;
        }
        Graphics graphics2 = graphics.create();
        this.fAttributeLabel.setForeground(this.getForeground());
        this.fAttributeLabel.setText(this.getText(), false);
        int n5 = (int)(this.fColumnIndex == 0 ? -rectangle.getX() + (double)n2 : (double)this.fIconWidthInCurrentColumn);
        graphics2.translate(n5, n4);
        this.fAttributeLabel.setSize(new Dimension((int)rectangle.getWidth() - n5 - n3, linkedHashMap.isEmpty() ? this.getHeight() : groupingTable.getLineHeight()));
        this.fMaximumPreferredWidth = (int)Math.max((double)this.fMaximumPreferredWidth, this.fAttributeLabel.getPreferredSize().getWidth() + (double)n2);
        this.fAttributeLabel.paint(graphics2);
        int n6 = this.fColumnIndex > 1 ? 0 : n;
        this.fMainDataRect = new Rectangle(this.fIndentation, n4, (int)this.fAttributeLabel.getPreferredSize().getWidth() + n6, this.fAttributeLabel.getHeight());
        this.fDataArea = new Area();
        this.fDataArea.add(new Area(new Rectangle(this.fMainDataRect)));
        graphics2.dispose();
        this.fAttributeLabel.setSize(new Dimension(groupingTable.getWidth() - n2 - n3, linkedHashMap.isEmpty() ? this.getHeight() : groupingTable.getLineHeight()));
        if (this.fAnyVerticalAttributes) {
            Color color = null;
            if (this.fIsSelected) {
                color = this.getForeground();
            }
            int n7 = 0;
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                VerticalAttribute verticalAttribute = (VerticalAttribute)entry.getKey();
                int n8 = n4 + groupingTable.getLineHeight() * (n7 + 1);
                graphics2 = graphics.create();
                graphics2.translate((int)(-rectangle.getX() + (double)n2), n8);
                if (color != null) {
                    this.fAttributeLabel.setForeground(color);
                } else {
                    this.fAttributeLabel.setForeground(verticalAttribute.getForegroundColor());
                }
                if (verticalAttribute.getFont() != null) {
                    this.fAttributeLabel.setFont(verticalAttribute.getFont());
                } else {
                    this.fAttributeLabel.setFont(this.getFont());
                }
                this.fAttributeLabel.setText((String)entry.getValue(), false);
                this.fMaximumPreferredWidth = (int)Math.max((double)this.fMaximumPreferredWidth, this.fAttributeLabel.getPreferredSize().getWidth() + (double)n2);
                this.fAttributeLabel.setSize(new Dimension(groupingTable.getWidth() - n2, groupingTable.getLineHeight()));
                this.fAttributeLabel.paint(graphics2);
                this.fDataArea.add(new Area(new Rectangle(this.fIndentation + 3, n8, (int)this.fAttributeLabel.getPreferredSize().getWidth() + n, this.fAttributeLabel.getHeight())));
                ++n7;
                graphics2.dispose();
            }
        }
    }

    private static <T> String getAccessibleText(GroupingTable<T> groupingTable, int n) {
        String string = "";
        for (int i = 0; i < groupingTable.getGroupingModel().getColumnCount(); ++i) {
            Object object = groupingTable.getGroupingModel().getValueAt(n, i);
            String string2 = groupingTable.getGroupingModel().getColumnName(i);
            if (object == null || object instanceof Icon) continue;
            string = string + ", " + string2 + " " + object;
        }
        return string;
    }

    private void displayActualCellData(GroupingTable<T> groupingTable, T t, Object object, int n, int n2) {
        this.setIcon(null);
        if (t != null) {
            if (Icon.class.isAssignableFrom(this.fColumn.getType()) && object instanceof Icon) {
                Icon icon;
                Object object2;
                if (this.fRowObject != null && this.fRowObject.isExpanded() && n2 == 0 && (object2 = this.fRowObject.getExpansionContext()) != null && (icon = object2.getOpenIcon(t)) != null) {
                    object = icon;
                }
                this.setIcon(this.determineIcon(object));
                object2 = null;
                if (this.fPairing && groupingTable.getGroupingModel().getCellSpanAt(n, n2).getColumnSpan() == 2) {
                    object2 = groupingTable.getGroupingModel().getPairedValue(n, n2).toString();
                }
                if (object2 != null) {
                    this.setText((String)object2);
                    this.setFont(groupingTable.getFont());
                } else {
                    this.setText("");
                    this.setFont(groupingTable.getFont());
                }
            } else if (IconAndText.class.isAssignableFrom(this.fColumn.getType()) && object instanceof IconAndText) {
                IconAndText iconAndText = (IconAndText)object;
                this.setIcon(this.determineIcon(object));
                this.setText(iconAndText.getText());
                this.setFont(groupingTable.getFont());
            } else {
                this.setFont(groupingTable.getFont());
            }
            this.setBorder(new EmptyBorder(6, 3, 6, 4));
        } else if (n2 == 0) {
            this.setFont(this.getFont().deriveFont(1));
            this.fGroupToPaintHeader = groupingTable.getGroupingModel().getGroupRows().get(n);
        }
    }

    @Override
    public Rectangle getRightClickSelectionBoundingRect() {
        return this.fDataArea != null ? this.fDataArea.getBounds() : new Rectangle(0, 0, 0, 0);
    }

    @Override
    public boolean allowRightClickSelection(Point point) {
        return this.fDataArea != null && this.fDataArea.contains(point);
    }

    @Override
    public boolean allowToolTip(Point point) {
        return this.fMainDataRect != null && this.fMainDataRect.contains(point) || this.fColumnIndex > 0 && Icon.class.isAssignableFrom(this.fColumn.getType()) && point.x <= this.getIcon().getIconWidth() && point.y <= this.getIcon().getIconHeight();
    }

    private Icon determineIcon(Object object) {
        Icon icon;
        Icon icon2 = icon = object instanceof Icon ? (Icon)object : ((IconAndText)object).getIcon();
        if (this.fDisplayEffects != null) {
            if (this.fDisplayEffects.getColumnSpecificColorStyle(this.fColumn.getKey()) != null) {
                return this.fDisplayEffects.getColumnSpecificColorStyle(this.fColumn.getKey()).getIcon(this, icon);
            }
            return this.fDisplayEffects.getColorStyle().getIcon(this, icon);
        }
        return icon;
    }

    private class FocusableCheckBox
    extends MJCheckBox {
        private FocusableCheckBox() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (GroupingTableCellRenderer.this.rowHasFocus()) {
                GroupingTableCellRenderer.paintFocus((JComponent)((Object)this), graphics, GroupingTableCellRenderer.this.fColumnIndex >= GroupingTableCellRenderer.this.fTable.getColumnCount() - 1);
            }
        }
    }

    public static class FocusBoundCheckBox
    extends MJCheckBox {
        private JTable iTable;
        private boolean iHasFocus;
        private int iColumnIndex;

        void setup(JTable jTable, boolean bl, int n) {
            this.iTable = jTable;
            this.iHasFocus = bl;
            this.iColumnIndex = n;
            this.setFocusable(false);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.iHasFocus) {
                GroupingTableCellRenderer.paintFocus((JComponent)((Object)this), graphics, this.iColumnIndex >= this.iTable.getColumnCount() - 1);
            }
        }
    }
}

