/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.validation.Validity;
import com.mathworks.widgets.ValidityWithHelp;
import com.mathworks.widgets.grouptable.CloseableEditor;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableCellRenderer;
import com.mathworks.widgets.grouptable.GroupingTableEditor;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public abstract class CheckBoxEditor<T>
implements GroupingTableEditor<T> {
    @Override
    public boolean isEditable(T t) {
        return true;
    }

    @Override
    public ValidityWithHelp validateEdit(T t, String string) {
        return new ValidityWithHelp(Validity.VALID);
    }

    @Override
    public CloseableEditor createCellEditor(GroupingTable<T> groupingTable) {
        return new Editor(groupingTable);
    }

    private class Editor
    implements CloseableEditor {
        private final GroupingTable<T> iTable;
        private final List<CellEditorListener> iListeners;
        private final GroupingTableCellRenderer.FocusBoundCheckBox iCheckBox;
        private boolean iInitialValue;
        private T iLastItem;

        Editor(GroupingTable<T> groupingTable) {
            this.iTable = groupingTable;
            this.iCheckBox = new GroupingTableCellRenderer.FocusBoundCheckBox();
            this.iListeners = new ArrayList<CellEditorListener>();
            this.iCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    CheckBoxEditor.this.edit((Component)((Object)Editor.this.iTable), Editor.this.iLastItem, Boolean.toString(Editor.this.iCheckBox.isSelected()));
                }
            });
        }

        @Override
        public void close() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.iLastItem = ((GroupingTable)((Object)jTable)).get(n);
            NonRectangularCellRenderer nonRectangularCellRenderer = this.iTable.setupRenderer(n, n2, bl);
            Component component = nonRectangularCellRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            if (nonRectangularCellRenderer instanceof GroupingTableCellRenderer) {
                this.iCheckBox.setup(jTable, ((GroupingTableCellRenderer)nonRectangularCellRenderer).rowHasFocus(), n2);
            }
            this.iCheckBox.setSelected((Boolean)object);
            this.iCheckBox.setBackground(component.getBackground());
            this.iCheckBox.setForeground(component.getForeground());
            this.iCheckBox.setOpaque(true);
            this.iInitialValue = this.iCheckBox.isSelected();
            return this.iCheckBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.iCheckBox.isSelected();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.iInitialValue != this.iCheckBox.isSelected()) {
                for (CellEditorListener cellEditorListener : new ArrayList<CellEditorListener>(this.iListeners)) {
                    cellEditorListener.editingStopped(new ChangeEvent(this));
                }
            } else {
                this.cancelCellEditing();
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : new ArrayList<CellEditorListener>(this.iListeners)) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.iListeners.add(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.iListeners.remove(cellEditorListener);
        }
    }
}

