/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.widgets.desk.DTLocation;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTTiledLocation
extends DTLocation {
    private int fTile;
    private static final String TILE_ATTRIBUTE = "Tile";

    DTTiledLocation(int n) {
        this.fTile = n;
    }

    DTTiledLocation(DTTiledLocation dTTiledLocation) {
        super(dTTiledLocation);
        this.fTile = dTTiledLocation.fTile;
    }

    void setTile(int n) {
        if (n != this.fTile) {
            this.fTile = n;
            this.fireChangeEvent();
        }
    }

    @Override
    public int getTile() {
        return this.fTile;
    }

    @Override
    public boolean isMinimized() {
        return this.fTile == -1;
    }

    public String toString() {
        return "Tile " + this.fTile;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DTTiledLocation && super.equals(object) && this.fTile == ((DTTiledLocation)object).fTile;
    }

    public int hashCode() {
        return this.fTile;
    }

    @Override
    public Element toXML(Document document) {
        Element element = super.toXML(document);
        element.setAttribute("Type", "tiled");
        element.setAttribute(TILE_ATTRIBUTE, Integer.toString(this.fTile));
        return element;
    }

    DTTiledLocation(SimpleElement simpleElement) throws DataFormatException {
        String string = simpleElement.getAttribute(TILE_ATTRIBUTE);
        try {
            this.fTile = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataFormatException("Invalid Tile: " + string);
        }
    }
}

