/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDesktopMenu;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTPlaceHolderAction;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTWindowMenu;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class DTMenuBar
extends MJMenuBar {
    protected Desktop fDesktop;
    protected DTFrame fFrame;
    protected DTClient fClient;
    protected DTGroup fGroup;
    protected int fMergeInsertionIndex = 2;
    protected final Action fExitAction;
    @Deprecated
    public static final Action sUndoAction = DTPlaceHolderAction.getUndoPlaceHolder(null);
    @Deprecated
    public static final Action sRedoAction = DTPlaceHolderAction.getRedoPlaceHolder(null);
    @Deprecated
    public static final Action sCutAction = DTPlaceHolderAction.getCutPlaceHolder(null);
    @Deprecated
    public static final Action sCopyAction = DTPlaceHolderAction.getCopyPlaceHolder(null);
    @Deprecated
    public static final Action sPasteAction = DTPlaceHolderAction.getPastePlaceHolder(null);
    @Deprecated
    public static final Action sSelectAllAction = DTPlaceHolderAction.getSelectAllPlaceHolder(null);

    public DTMenuBar(Desktop desktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        JMenuBar jMenuBar;
        this.setName("DesktopMenuBar");
        this.setBorder(DTBorderFactory.createMenuBarBorder());
        this.fDesktop = desktop;
        this.fFrame = dTFrame;
        this.fClient = dTClient;
        this.fGroup = dTGroup;
        this.fExitAction = new ExitAction();
        this.populate();
        JMenuBar jMenuBar2 = this.getClientBar();
        if (jMenuBar2 != null) {
            this.merge(jMenuBar2);
        } else if (dTGroup != null && (jMenuBar = dTGroup.getMenuBar()) != null) {
            this.merge(jMenuBar);
        }
    }

    protected void populate() {
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
        if (!this.fDesktop.useToolstrip() && (this.fFrame.isMainFrame() || this.fDesktop.hasMainFrame())) {
            this.add((JMenu)((Object)this.fFrame.getDesktopMenu()));
        }
        this.add((JMenu)((Object)this.fFrame.getWindowMenu()));
    }

    protected JMenu createFileMenu() {
        DTMenu dTMenu = new DTMenu(this.fDesktop.getString("menu.File"));
        DTMenuMergeTag.FILE.setTag((JMenuItem)((Object)dTMenu));
        if (this.addFileCloseItems((JMenu)((Object)dTMenu)) > 0) {
            dTMenu.addSeparator();
        }
        dTMenu.add(this.fExitAction);
        return dTMenu;
    }

    protected int addFileCloseItems(JMenu jMenu) {
        JMenuItem jMenuItem;
        int n = 0;
        Object object = null;
        if (this.fFrame instanceof DTMultipleClientFrame) {
            Object object2;
            DTSelectable dTSelectable;
            if (!this.fFrame.isMainFrame()) {
                dTSelectable = ((DTMultipleClientFrame)this.fFrame).getGroup();
                if (dTSelectable == null || ((DTOccupant)dTSelectable).permitUserClose()) {
                    object = ((DTMultipleClientFrame)this.fFrame).getCloseAction();
                }
            } else if (this.fClient != null && this.fClient.getGroup() != null) {
                dTSelectable = this.fClient.getGroup();
                if (((DTOccupant)dTSelectable).permitUserClose() && ((DTGroup)dTSelectable).hasDocumentContainer()) {
                    object = ((DTGroup)dTSelectable).getCloseDockedAction();
                }
            } else {
                dTSelectable = ((DTMultipleClientFrame)this.fFrame).getMerged();
                if (dTSelectable instanceof DTOccupant && !(dTSelectable instanceof DTClient) && (!(dTSelectable instanceof DTGroup) || ((DTGroup)dTSelectable).permitUserClose())) {
                    object = ((DTOccupant)dTSelectable).getCloseAction();
                }
            }
            if (object != null) {
                object = new ChildAction((Action)object);
                object.putValue("SmallIcon", ChildAction.NULL_VALUE);
                int n2 = (Integer)object.getValue("MnemonicKey");
                if (n2 != 0) {
                    object.putValue("MnemonicKey", ChildAction.NULL_VALUE);
                    object2 = (String)object.getValue("Name");
                    object.putValue("Name", MJUtilities.removeMnemonicText((String)object2, (int)n2));
                }
                if (this.fClient == null) {
                    DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "close-item", (ExtendedAction)((MJAbstractAction)object));
                    object.putValue("Name", null);
                }
                jMenuItem = jMenu.add((Action)object);
                DTMenuMergeTag.CLOSE_GROUP.setTag(jMenuItem);
                ++n;
            }
            DTDocumentContainer dTDocumentContainer = null;
            if (this.fClient != null && this.fClient.getGroup() != null) {
                dTDocumentContainer = this.fClient.getGroup().getDocumentContainer();
            } else {
                object2 = ((DTMultipleClientFrame)this.fFrame).getMerged();
                if (object2 instanceof DTGroup) {
                    dTDocumentContainer = ((DTGroup)object2).getDocumentContainer();
                }
            }
            if (dTDocumentContainer != null) {
                jMenu.add(dTDocumentContainer.getCloseSelectAction());
                ++n;
            }
        }
        if (this.fClient != null && this.fClient.permitUserClose()) {
            object = new ChildAction((Action)this.fClient.getCloseAction());
            object.putValue("SmallIcon", ChildAction.NULL_VALUE);
            jMenuItem = jMenu.add((Action)object);
            DTMenuMergeTag.CLOSE.setTag(jMenuItem);
            ++n;
        }
        return n;
    }

    protected JMenu createEditMenu() {
        DTMenu dTMenu = new DTMenu(this.fDesktop.getString("menu.Edit"));
        DTMenuMergeTag.EDIT.setTag((JMenuItem)((Object)dTMenu));
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getUndoPlaceHolder(this.fDesktop)));
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getRedoPlaceHolder(this.fDesktop)));
        dTMenu.addSeparator();
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getCutPlaceHolder(this.fDesktop)));
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getCopyPlaceHolder(this.fDesktop)));
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getPastePlaceHolder(this.fDesktop)));
        dTMenu.addSeparator();
        dTMenu.add((Action)((Object)DTPlaceHolderAction.getSelectAllPlaceHolder(this.fDesktop)));
        return dTMenu;
    }

    void mainFrameCreated() {
        DTDesktopMenu dTDesktopMenu;
        boolean bl = this.hasMoreMenu();
        if (bl) {
            this.setMoreMenuEnabled(false);
        }
        if (((Component)((Object)(dTDesktopMenu = this.fFrame.getDesktopMenu()))).getParent() == null) {
            DTWindowMenu dTWindowMenu = this.fFrame.getWindowMenu();
            int n = this.getMenuCount();
            for (int i = 0; i < n; ++i) {
                if (this.getMenu(i) != dTWindowMenu) continue;
                this.add((Component)((Object)dTDesktopMenu), i);
                break;
            }
        }
        if (bl) {
            this.setMoreMenuEnabled(true);
        }
    }

    void mainFrameDestroyed() {
        boolean bl = this.hasMoreMenu();
        if (bl) {
            this.setMoreMenuEnabled(false);
        }
        this.remove((Component)((Object)this.fFrame.getDesktopMenu()));
        if (bl) {
            this.setMoreMenuEnabled(true);
        }
    }

    public void dispose() {
        Container container;
        MJMenu mJMenu = this.fFrame.getWindowMenu();
        if (mJMenu != null && (container = mJMenu.getParent()) != null) {
            container.remove((Component)mJMenu);
        }
        if ((mJMenu = this.fFrame.getDesktopMenu()) != null && (container = mJMenu.getParent()) != null) {
            container.remove((Component)mJMenu);
        }
        super.dispose();
    }

    protected JMenuBar getClientBar() {
        if (this.fClient != null) {
            return this.fClient.getMenuBar();
        }
        return null;
    }

    protected void merge(JMenuBar jMenuBar) {
        MJMenuBar mJMenuBar;
        boolean bl = false;
        if (jMenuBar instanceof MJMenuBar && (bl = (mJMenuBar = (MJMenuBar)jMenuBar).hasMoreMenu())) {
            mJMenuBar.setMoreMenuEnabled(false);
        }
        int n = this.fMergeInsertionIndex;
        int n2 = 0;
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = null;
            JMenu jMenu2 = jMenuBar.getMenu(i);
            DTMenuMergeTag dTMenuMergeTag = DTMenuMergeTag.getTag(jMenu2);
            if (dTMenuMergeTag != null) {
                jMenu = DTMenuBar.findMenu((JMenuBar)((Object)this), dTMenuMergeTag);
            }
            if (jMenu != null) {
                if (jMenu2 instanceof DTMenuOmission) {
                    this.remove(jMenu);
                    if (jMenu instanceof MJMenu) {
                        ((MJMenu)jMenu).dispose();
                    }
                    if (dTMenuMergeTag != DTMenuMergeTag.FILE && dTMenuMergeTag != DTMenuMergeTag.EDIT) continue;
                    --n;
                    continue;
                }
                if (jMenu2 instanceof DTMenuBoundary) {
                    int n3;
                    DTMenuBoundary dTMenuBoundary = (DTMenuBoundary)((Object)jMenu2);
                    DTMenuMergeTag dTMenuMergeTag2 = dTMenuBoundary.getTag();
                    if (dTMenuMergeTag2 == DTMenuMergeTag.START_OF_MENU) {
                        if (n2 > 0) {
                            this.moveBefore(0, n - n2, n2);
                        }
                        n = 0;
                        n2 = 0;
                        continue;
                    }
                    if (dTMenuMergeTag2 == DTMenuMergeTag.END_OF_MENU) {
                        n = this.getMenuCount();
                        continue;
                    }
                    int n4 = n3 = dTMenuMergeTag2 == null ? -1 : DTMenuBar.findMenuIndex((JMenuBar)((Object)this), dTMenuMergeTag2);
                    if (n3 == -1) continue;
                    if (n2 > 0) {
                        this.moveBefore(n3, n - n2, n2);
                    }
                    n = n3 + n2 + 1;
                    n2 = 0;
                    continue;
                }
                if (jMenu instanceof DTMenu) {
                    ((DTMenu)((Object)jMenu)).merge(jMenu2);
                    continue;
                }
                DTMenu.merge(jMenu, jMenu2);
                continue;
            }
            if (jMenu2 instanceof DTMenuOmission) continue;
            if (n > this.getMenuCount()) {
                n = this.getMenuCount();
            }
            this.add(DTMenu.clone(jMenu2), n++);
        }
        if (bl) {
            ((MJMenuBar)jMenuBar).setMoreMenuEnabled(true);
        }
    }

    protected static JMenu findMenu(JMenuBar jMenuBar, DTMenuMergeTag dTMenuMergeTag) {
        int n = DTMenuBar.findMenuIndex(jMenuBar, dTMenuMergeTag);
        return n == -1 ? null : jMenuBar.getMenu(n);
    }

    protected static int findMenuIndex(JMenuBar jMenuBar, DTMenuMergeTag dTMenuMergeTag) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (DTMenuMergeTag.getTag(jMenu) != dTMenuMergeTag) continue;
            return i;
        }
        return -1;
    }

    protected void moveBefore(int n, int n2, int n3) {
        assert (n < n2);
        while (n3 > 0) {
            JMenu jMenu = this.getMenu(n2);
            this.remove(n2);
            this.add(jMenu, n);
            ++n;
            --n3;
        }
    }

    class ExitAction
    extends MJAbstractAction {
        public ExitAction() {
            String string;
            if (DTMenuBar.this.fDesktop == null) {
                string = Desktop.getString((Desktop)null, "menuitem.Exit");
            } else {
                Object[] objectArray = new Object[]{DTMenuBar.this.fDesktop.getDesktopName()};
                string = MessageFormat.format(DTMenuBar.this.fDesktop.getString("menuitem.ExitThis"), objectArray);
            }
            this.setName(string);
            this.setComponentName("Exit");
            if (!PlatformInfo.isMacintosh()) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK));
            }
            DTMenuMergeTag.EXIT.setTag((Action)((Object)this));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTMenuBar.this.fDesktop.attemptClose();
        }
    }
}

