/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.StringTrimmer;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTSelectable;
import com.mathworks.widgets.desk.DTTitleBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

class DTClientFrame
extends DTInternalFrame {
    private DTClient fClient;
    private boolean fToolBarHasBeenBorrowed;
    private static final String CLOSE_ACTION = "close-document";

    DTClientFrame(DTClient dTClient) {
        this.setName(dTClient.getComponentName() + "InternalFrame");
        this.fToolBarContainer.setOfferToggles(dTClient.offerToolBarToggles());
        if (!dTClient.isSingleton() && dTClient.getGroup() != null) {
            this.fToolBarContainer.setAllowRearrangement(dTClient.getGroup().allowToolBarRearrangement());
        }
        this.add(dTClient, null);
        this.setKeyBindings();
        this.setBorderType(!dTClient.isSingleton());
        this.setBorderVisible(true);
    }

    private void setKeyBindings() {
        Serializable serializable;
        if (this.fClient.getDesktop().useToolstrip()) {
            this.setInputMap(1, DTKeyBindings.getInstance().getInputMap());
            serializable = this.getActionMap();
            if (this.fClient.isSingleton()) {
                ((ActionMap)serializable).put("dock", (Action)this.fClient.getDockAction());
                ((ActionMap)serializable).put("undock", (Action)this.fClient.getUndockAction());
                ((ActionMap)serializable).put("maximize", (Action)this.fClient.getMaximizeAction());
                ((ActionMap)serializable).put("minimize", (Action)this.fClient.getMinimizeAction());
            }
            ((ActionMap)serializable).put("close-item", (Action)this.fClient.getCloseAction());
        }
        if (PlatformInfo.isWindows() && !this.fClient.isSingleton()) {
            serializable = this.getInputMap(1);
            ((InputMap)serializable).put(KeyStroke.getKeyStroke(115, 2), CLOSE_ACTION);
            ActionMap actionMap = this.getActionMap();
            actionMap.put(CLOSE_ACTION, (Action)this.fClient.getCloseAction());
        }
    }

    @Override
    public DTOccupant getOccupant() {
        return this.fClient;
    }

    @Override
    DTClient getTopClient() {
        return this.fClient;
    }

    DTClient getClient() {
        return this.fClient;
    }

    @Override
    public void add(DTOccupant dTOccupant, DTLocation dTLocation) {
        assert (dTOccupant instanceof DTClient);
        this.fClient = (DTClient)dTOccupant;
        this.addToolBars();
        if (this.fClient.getComponent() != null) {
            this.fContentPane.add(this.fClient.getComponent(), "Center");
        }
        this.fClient.addPropertyListener(this);
    }

    @Override
    public void remove(DTOccupant dTOccupant) {
        assert (dTOccupant instanceof DTClient);
        dTOccupant.removePropertyListener(this);
        this.fContentPane.removeAll();
    }

    @Override
    public DTSelectable getNext(DTSelectable dTSelectable, boolean bl) {
        return dTSelectable == this.fClient ? null : this.fClient;
    }

    @Override
    public DTSelectable getPrevious(DTSelectable dTSelectable, boolean bl) {
        return this.getNext(dTSelectable, bl);
    }

    @Override
    public void replaceChild(Component component, Component component2) {
    }

    @Override
    public void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
    }

    void updateClientComponent() {
        this.setName(this.fClient.getComponentName() + "InternalFrame");
        int n = this.fContentPane.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.fContentPane.getComponent(i);
            if (component == this.fToolBarContainer) continue;
            this.fContentPane.remove(component);
        }
        this.fContentPane.add(this.fClient.getComponent(), "Center");
        this.addToolBars();
        if (this.fTitleBar != null) {
            this.fTitleBar.setTitle(this.fClient.getTitle());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected DTTitleBar createTitleBar() {
        Action action = this.getTitleBarUndockAction();
        Action action2 = this.getTitleBarCloseAction();
        Action action3 = this.getTitleBarMinimizeAction();
        Action action4 = this.getTitleBarMaximizeAction();
        return new DTTitleBar(action, action3, action4, action2, this.fClient.isSingleton(), this.fClient.isSingleton() && this.fClient.getGroup() != null, this.fClient.getDesktop().useToolstrip(), this.fClient.getName());
    }

    @Override
    protected void configureTitleBar(DTTitleBar dTTitleBar) {
        super.configureTitleBar(dTTitleBar);
        dTTitleBar.setName(this.fClient.getName() + "TitleBar");
        dTTitleBar.setTitle(this.fClient.getTitle());
        dTTitleBar.setShortTitle(this.fClient.getShortTitle());
        dTTitleBar.setTrimmer(this.fClient.getTitleTrimmer());
    }

    @Override
    protected Action getTitleBarMinimizeAction() {
        return this.fClient.isSingleton() ? super.getTitleBarMinimizeAction() : null;
    }

    @Override
    protected Action getTitleBarMaximizeAction() {
        return this.fClient.isSingleton() ? super.getTitleBarMaximizeAction() : null;
    }

    void borrowToolBars() {
        if (!this.fToolBarHasBeenBorrowed) {
            this.removeToolBars();
        }
        this.fToolBarHasBeenBorrowed = true;
    }

    void returnToolBars() {
        if (this.fToolBarHasBeenBorrowed) {
            this.addToolBars();
            this.fToolBarHasBeenBorrowed = false;
        }
    }

    private void addToolBars() {
        if (this.hasToolBar()) {
            this.removeToolBars();
        }
        JToolBar[] jToolBarArray = this.fClient.getToolBars();
        String[] stringArray = this.fClient.getToolBarKeys();
        String[] stringArray2 = this.fClient.getToolBarLabels();
        JComponent jComponent = this.fClient.getToolBarAlternative();
        this.fToolBarContainer.setToolBarAlternative(jComponent);
        for (int i = 0; i < jToolBarArray.length; ++i) {
            this.addToolBar(jToolBarArray[i], stringArray[i], stringArray2[i]);
        }
        DTGroup dTGroup = this.fClient.getGroup();
        Object object = !this.fClient.isSingleton() && dTGroup != null ? dTGroup.getToolBarState() : this.fClient.getToolBarState();
        if (object != null) {
            this.fToolBarContainer.restoreState(object);
        }
        if (this.fClient.isSingleton() && this.fToolBarContainer.getToolBarCount() > 0) {
            this.fClient.clearToolBarState();
        }
    }

    void showUndockedControls() {
        if (this.fClient.isDockable()) {
            this.getTitleBar().setDockListener((ActionListener)(this.fClient.getDesktop().hasMainFrame() ? this.fClient.getDockAction() : null), false);
        }
        JButton jButton = this.getTitleBar().createShowActionsButton();
        jButton.setOpaque(true);
        jButton.setBackground(Color.white);
        jButton.setName("Floating" + jButton.getName());
        this.addControlPalette(jButton);
    }

    void hideUndockedControls() {
        if (this.fControlPalette != null) {
            this.removeControlPalette();
            this.getTitleBar().setDockListener((ActionListener)(this.fClient.permitUserUndock() ? this.fClient.getUndockAction() : null), true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
        assert (dTClient == this.fClient);
        if (DTClientProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fTitleBar != null) {
                this.fTitleBar.setTitle((String)propertyChangeEvent.getNewValue());
            }
        } else if (DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fTitleBar != null) {
                this.fTitleBar.setShortTitle((String)propertyChangeEvent.getNewValue());
            }
        } else if (DTClientProperty.TITLE_TRIMMER.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fTitleBar != null) {
                this.fTitleBar.setTrimmer((StringTrimmer)propertyChangeEvent.getNewValue());
            }
        } else if (DTClientProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName()) || DTClientProperty.TOOL_BAR_ALTERNATIVE.toString().equals(propertyChangeEvent.getPropertyName())) {
            if (this.fToolBarHasBeenBorrowed) {
                return;
            }
            this.addToolBars();
            this.revalidate();
            this.repaint();
        } else if (DTClientProperty.OFFER_TOOLBAR_TOGGLES.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.fToolBarContainer.setOfferToggles((Boolean)propertyChangeEvent.getNewValue());
        }
    }
}

