/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.shapes.RoundedRectangularBalloonShape;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.ValidationListener;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.services.FontPrefs;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.ValidatableWithHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class TextFieldWithBalloonTip {
    private final ValidatableTextField fTextField;
    private final ValidatableWithHelp fValidatable;
    private final BalloonTip fTip;
    private final MultilineLabel fLabel;
    private final ReturnRunnable<Point> fPositioner;
    private final JComponent fBalloonParent;
    private boolean fShowsBalloon = true;
    private String fI18nComponentNameForFont;

    public TextFieldWithBalloonTip(ValidatableWithHelp validatableWithHelp) {
        this(null, validatableWithHelp, null);
    }

    public TextFieldWithBalloonTip(JComponent jComponent, final ValidatableWithHelp validatableWithHelp, ReturnRunnable<Point> returnRunnable) {
        this.fValidatable = validatableWithHelp;
        this.fTextField = new ValidatableTextField(new Validatable(){

            public Validity validateText(String string) {
                return validatableWithHelp.getValidity(string).getValidity();
            }

            public Validity getValidityWhenBlank() {
                return validatableWithHelp.getValidityWhenBlank().getValidity();
            }
        });
        this.fTextField.setIconPaintingEnabled(false);
        this.fLabel = new MultilineLabel();
        this.fPositioner = returnRunnable;
        this.fBalloonParent = jComponent;
        this.fLabel.setLineWrap(false);
        this.fTip = new BalloonTip((Component)this.fLabel){

            protected void customizePopup(JidePopup jidePopup) {
                super.customizePopup(jidePopup);
                jidePopup.setResizable(false);
                jidePopup.setReturnFocusToOwner(false);
            }
        };
        this.fTip.setShadowStyle(null);
        this.fTip.setBalloonShape((BalloonShape)new RoundedRectangularBalloonShape(){
            {
                this.setBalloonSizeRatio(0.8);
            }

            public Insets getInsets(Dimension dimension) {
                return new Insets(6, 6, 25, 6);
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TextFieldWithBalloonTip.this.fTip.isVisible()) {
                    TextFieldWithBalloonTip.this.fTip.hide();
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TextFieldWithBalloonTip.this.showTipIfAppropriate();
            }
        });
        this.fTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                TextFieldWithBalloonTip.this.showTipIfAppropriate();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.fTextField.addValidationListener(new ValidationListener(){

            public void validityChanged(Validity validity, Validity validity2) {
                TextFieldWithBalloonTip.this.showTipIfAppropriate();
            }
        });
    }

    public void setI18nComponentNameForFont(String string) {
        this.fI18nComponentNameForFont = string;
        this.fTextField.setFont(FontPrefs.getFontForComponent((String)string));
    }

    public void setShowsBalloon(boolean bl) {
        this.fShowsBalloon = bl;
        if (!this.fShowsBalloon) {
            this.fTip.hide();
        }
    }

    public String getCurrentMessage() {
        return this.fTextField.getText().length() == 0 ? this.fValidatable.getValidityWhenBlank().getMessage() : this.fValidatable.getValidity(this.fTextField.getText()).getMessage();
    }

    public ValidatableTextField getTextField() {
        return this.fTextField;
    }

    public BalloonTip getTip() {
        return this.fTip;
    }

    public void setText(String string) {
        this.fTextField.setText(string);
    }

    public String getText() {
        return this.fTextField.getText();
    }

    private void showTipIfAppropriate() {
        String string;
        if (this.fI18nComponentNameForFont != null) {
            this.fTextField.setFont(FontPrefs.getFontForComponent((String)this.fI18nComponentNameForFont));
        }
        if ((string = this.getCurrentMessage()) != null) {
            Point point;
            this.fLabel.setText(string);
            if (this.fPositioner != null) {
                point = (Point)this.fPositioner.run();
            } else {
                point = new Point(this.fTextField.getWidth() / 2, 4);
                Window window = SwingUtilities.windowForComponent((Component)this.fTextField);
                if (window != null) {
                    Point point2 = new Point(window.getWidth(), 0);
                    point2 = SwingUtilities.convertPoint(window, point2, (Component)this.fTextField);
                    while (point.getX() > 0.0 && this.fTip.getPreferredSize().getWidth() + point.getX() > point2.getX()) {
                        point.setLocation(point.getX() - 2.0, point.getY());
                    }
                }
            }
            if (this.fShowsBalloon && point != null) {
                this.fTip.show((JComponent)(this.fBalloonParent == null ? this.fTextField : this.fBalloonParent), (int)point.getX(), (int)point.getY());
            } else {
                this.fTip.hide();
            }
        } else {
            this.fTip.hide();
        }
    }

    static {
        MJUtilities.initJIDE();
    }
}

