/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.components.TSList;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeUnit;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ToolstripComboBoxUI
extends BasicComboBoxUI {
    public static final String DO_NOT_CLOSE_ON_SELECTION = "do.not.close.on.selection";

    public static ToolstripComboBoxUI createUI(JComponent jComponent) {
        return new ToolstripComboBoxUI();
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){

            protected JList createList() {
                TSList tSList = new TSList(this.comboBox.getModel()){

                    public void processMouseEvent(MouseEvent mouseEvent) {
                        if (mouseEvent.isControlDown()) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                        }
                        super.processMouseEvent(mouseEvent);
                    }
                };
                tSList.putClientProperty(ToolstripComboBoxUI.DO_NOT_CLOSE_ON_SELECTION, true);
                return tSList;
            }
        };
    }

    @Override
    protected void installDefaults() {
        Insets insets = UIManager.getInsets("ComboBox.padding");
        UIManager.put("ComboBox.padding", this.getDefaultInsets());
        super.installDefaults();
        UIManager.put("ComboBox.padding", insets);
        this.comboBox.setOpaque(true);
    }

    private Insets getDefaultInsets() {
        return new Insets(0, 2, 0, 2);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TSUtil.toolstripActionProcessed(ToolstripComboBoxUI.this.comboBox);
                    }
                }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        });
        this.comboBox.addKeyListener(new MyKeyListener(this.comboBox, this.listBox));
        jComponent.setBorder(new MyBorder());
        jComponent.setFont(ToolstripTheme.getInstance().getTSComboBoxFont());
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.arrowButton != null) {
            this.arrowButton.setBackground(this.editor.getBackground());
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.arrowButton != null) {
            this.arrowButton.setBackground(Color.white);
        }
    }

    protected ListCellRenderer createRenderer() {
        return new MyCellRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MyComboBoxEditor();
    }

    @Override
    protected JButton createArrowButton() {
        JButton jButton = new JButton(){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics2D.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n2);
                LAFUtil.paintDarkTriangle(graphics2D, (n - 7) / 2, (n2 - 4) / 2);
            }
        };
        jButton.setBackground(Color.white);
        jButton.setName("ComboBox.arrowButton");
        return jButton;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    @Override
    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        if (this.comboBox.isEnabled()) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        boolean bl2 = bl && !this.isPopupVisible(this.comboBox);
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl2, false);
        component.setFont(this.comboBox.getFont());
        boolean bl3 = false;
        if (component instanceof JPanel) {
            bl3 = true;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Insets insets = this.getDefaultInsets();
        if (insets != null) {
            n = rectangle.x + insets.left;
            n2 = rectangle.y + insets.top;
            n3 = rectangle.width - (insets.left + insets.right);
            n4 = rectangle.height - (insets.top + insets.bottom);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, n, n2, n3, n4, bl3);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    private class MyKeyListener
    implements KeyListener {
        private JComboBox fComboBox;
        private JList fMKLList;

        public MyKeyListener(JComboBox jComboBox, JList jList) {
            this.fComboBox = jComboBox;
            this.fMKLList = jList;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (!this.fComboBox.isPopupVisible() && n == 40) {
                this.fComboBox.setPopupVisible(true);
                this.fMKLList.setSelectedIndex(0);
                return;
            }
            if (this.fComboBox.isPopupVisible()) {
                int n2;
                int n3 = this.fMKLList.getModel().getSize();
                int n4 = this.fMKLList.getSelectedIndex();
                int n5 = n3;
                if (n == 40) {
                    do {
                        n4 = (n4 + 1) % n3;
                    } while (--n5 >= 0);
                    this.fMKLList.setSelectedIndex(n4);
                } else if (n == 38) {
                    do {
                        n4 = (n4 - 1 + n3) % n3;
                    } while (--n5 >= 0);
                    this.fMKLList.setSelectedIndex(n4);
                } else if (n == 10 && (n2 = this.fMKLList.getSelectedIndex()) >= 0) {
                    this.fComboBox.setSelectedItem(this.fMKLList.getModel().getElementAt(n2));
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private static class MyBorder
    extends AbstractBorder {
        private Color fBorderTop1 = ToolstripTheme.getInstance().getScrollPaneBorderDarkColor();
        private Color fBorderBottom = ToolstripTheme.getInstance().getScrollPaneBorderLightColor();

        MyBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(this.fBorderTop1);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.drawLine(1, 0, n3 - 1, 0);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.setColor(this.fBorderBottom);
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
            graphics.translate(-n, -n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class MyComboBoxEditor
    extends BasicComboBoxEditor
    implements PropertyChangeListener {
        private MyComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            TSTextField tSTextField = new TSTextField("", 9);
            tSTextField.setBorder(new EmptyBorder(0, 1, 0, 1));
            tSTextField.addPropertyChangeListener(this);
            return tSTextField;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ToolstripComboBoxUI.this.arrowButton != null && this.editor != null) {
                ToolstripComboBoxUI.this.arrowButton.setBackground(this.editor.getBackground());
            }
        }
    }

    private class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color fSelectionForeground;
        private Color fSelectionBackground = UIManager.getColor("List.selectionBackground");

        private MyCellRenderer() {
            this.fSelectionForeground = UIManager.getColor("List.selectionForeground");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = string = object != null ? object.toString() : "";
            if (string.length() == 0) {
                string = " ";
            }
            this.setText(string);
            if (bl) {
                this.setForeground(this.fSelectionForeground);
                this.setBackground(this.fSelectionBackground);
                this.setOpaque(true);
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
            return this;
        }
    }
}

