/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlUtils;
import com.mathworks.html.jxbrowser.HtmlTextWriter;
import com.mathworks.html.jxbrowser.StreamingTextUrlManager;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.WebPolicyDelegate;
import com.teamdev.jxbrowser.events.NavigationEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamingTextHandler
implements WebPolicyDelegate,
StreamingTextUrlManager {
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final Browser fBrowser;
    private final HtmlTextWriter fWriter;
    private final List<String> fHtmlTextList = new ArrayList<String>();
    private final List<Charset> fHtmlTextCharsets = new ArrayList<Charset>();
    private int fCurrentIndex = -1;

    public StreamingTextHandler(Browser browser, HtmlTextWriter htmlTextWriter) {
        this.fBrowser = browser;
        this.fWriter = htmlTextWriter;
    }

    public void dispose() {
        this.fWriter.dispose();
    }

    public void setFileDir(File file) {
        this.fWriter.setHtmlTextDir(file);
    }

    public String getHtmlTextUrl(String string) {
        Charset charset = HtmlUtils.getCharsetFromHtml(string);
        if (charset == null) {
            string = HtmlUtils.addCharsetMetaTag(DEFAULT_CHARSET_NAME, string);
            charset = DEFAULT_CHARSET;
        }
        this.fHtmlTextList.add(string);
        this.fHtmlTextCharsets.add(charset);
        return this.getUrlForIndex(this.fHtmlTextList.size() - 1);
    }

    @Override
    public String getUrlForIndex(int n) {
        return this.getBaseUrl() + "?" + String.valueOf(n);
    }

    public String getBaseUrl() {
        return StreamingTextHandler.getFileUrl(this.fWriter.getHtmlTextFile());
    }

    public static String getFileUrl(File file) {
        try {
            return file.toURI().toURL().toString();
        }
        catch (Exception exception) {
            String string = file.getAbsolutePath().replaceAll("\\\\", "/");
            StringBuilder stringBuilder = new StringBuilder("file://");
            if (!string.startsWith("/")) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string).append('?');
            return stringBuilder.toString();
        }
    }

    @Override
    public int getIndexFromUrl(String string) {
        Matcher matcher = this.getHtmlFilePattern().matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return string2 == null ? 0 : Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    public int getLastIndex() {
        return this.fHtmlTextList.size() - 1;
    }

    private Pattern getHtmlFilePattern() {
        return Pattern.compile(".*" + Pattern.quote(this.fWriter.getHtmlTextFile().getName()) + "(?:\\?(\\d+))?$");
    }

    public synchronized boolean allowNavigation(NavigationEvent navigationEvent) {
        int n = this.getIndexFromUrl(navigationEvent.getUrl());
        if (n >= 0 && n < this.fHtmlTextList.size() && n != this.fCurrentIndex) {
            String string = this.fHtmlTextList.get(n);
            Charset charset = this.fHtmlTextCharsets.get(n);
            try {
                this.fWriter.writeHtmlText(string, charset);
                this.fCurrentIndex = n;
            }
            catch (IOException iOException) {
                this.fCurrentIndex = -1;
                this.fBrowser.setContent(string);
                return false;
            }
        }
        return true;
    }

    public boolean allowMimeType(String string, NavigationEvent navigationEvent) {
        return true;
    }

    public HtmlTextWriter getHtmlTextWriter() {
        return this.fWriter;
    }
}

