/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlFileWriter;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.UrlResolver;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.PrintStrategy;
import java.awt.Desktop;
import java.io.File;
import java.net.URL;

public class DesktopPrintStrategy
implements PrintStrategy {
    private final boolean fPrintOnlinePages;
    private File fPrintFile;

    DesktopPrintStrategy(boolean bl) {
        this.fPrintOnlinePages = bl;
    }

    @Override
    public boolean print(JxBrowserPanel jxBrowserPanel) {
        String string = jxBrowserPanel.getCurrentLocation();
        if (string != null) {
            PrintUrlResolver printUrlResolver = new PrintUrlResolver(jxBrowserPanel);
            printUrlResolver.acceptUrl(string);
            return printUrlResolver.iSuccess;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.fPrintFile != null) {
            this.fPrintFile.delete();
        }
    }

    private class PrintUrlResolver
    extends UrlResolver {
        private final JxBrowserPanel iPanel;
        private boolean iSuccess = false;

        private PrintUrlResolver(JxBrowserPanel jxBrowserPanel) {
            this.iPanel = jxBrowserPanel;
        }

        @Override
        protected void handleFileLocation(File file) {
            this.printFile(file);
        }

        @Override
        protected void handleUrlLocation(URL uRL) {
            if (DesktopPrintStrategy.this.fPrintOnlinePages) {
                String string = this.iPanel.getBrowser().getContent();
                File file = this.getPrintFile();
                HtmlFileWriter htmlFileWriter = new HtmlFileWriter(file, string, uRL.toString(), false);
                htmlFileWriter.saveFile();
                if (file.exists()) {
                    this.printFile(file);
                }
            }
        }

        private File getPrintFile() {
            File file = HtmlPanel.getResourceDirectory();
            File file2 = new File(file, "browserprint.html");
            if (DesktopPrintStrategy.this.fPrintFile != null && !DesktopPrintStrategy.this.fPrintFile.equals(file2)) {
                DesktopPrintStrategy.this.fPrintFile.delete();
            }
            DesktopPrintStrategy.this.fPrintFile = file2;
            return file2;
        }

        private void printFile(File file) {
            try {
                Desktop.getDesktop().print(file);
                this.iSuccess = true;
            }
            catch (Exception exception) {
                this.iSuccess = false;
            }
        }
    }
}

