/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import java.util.HashSet;
import java.util.Set;

public class ProxySettings {
    private static ProxySettings sCurrentSettings = null;
    private static final Set<ProxySettingsListener> fListeners = new HashSet<ProxySettingsListener>();
    private final String fHost;
    private final int fPort;
    private final String fUsername;
    private final String fPassword;

    private ProxySettings(String string, int n, String string2, String string3) {
        this.fHost = string;
        this.fPort = n;
        this.fUsername = string2;
        this.fPassword = string3;
    }

    public static void addProxyListener(ProxySettingsListener proxySettingsListener) {
        fListeners.add(proxySettingsListener);
    }

    public static synchronized void clearProxySettings() {
        sCurrentSettings = null;
        ProxySettings.notifyListeners(null);
    }

    public static synchronized void configureProxy(String string, int n, String string2, String string3) {
        ProxySettings proxySettings;
        sCurrentSettings = proxySettings = new ProxySettings(string, n, string2, string3);
        ProxySettings.notifyListeners(proxySettings);
    }

    private static void notifyListeners(final ProxySettings proxySettings) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (ProxySettingsListener proxySettingsListener : fListeners) {
                    proxySettingsListener.proxySettingsChanged(proxySettings);
                }
            }
        };
        new Thread(runnable).start();
    }

    public static synchronized ProxySettings getCurrentSettings() {
        return sCurrentSettings;
    }

    public String getHost() {
        return this.fHost;
    }

    public int getPort() {
        return this.fPort;
    }

    public String getUsername() {
        return this.fUsername;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public static interface ProxySettingsListener {
        public void proxySettingsChanged(ProxySettings var1);
    }
}

