/*
 * Decompiled with CFR 0.152.
 */
package ice.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderUTF8
extends Reader {
    private InputStream OEAB;
    private byte[] available;
    private int close;
    private int read;
    public static final int LONGEST_UTF8_CHAR_BYTES_LENGTH = 6;
    public static final int BROKEN_UTF8_CHAR_MARK = 63;
    public static final int NONJAVA_CHAR_MARK = 191;
    private boolean setThrowOnBadUTF8;

    public ReaderUTF8(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public ReaderUTF8(InputStream inputStream, int n) {
        this.OEAB = inputStream;
        this.available = new byte[n];
        this.setThrowOnBadUTF8(true);
    }

    public boolean isThrowOnBadUTF8() {
        return this.setThrowOnBadUTF8;
    }

    public void setThrowOnBadUTF8(boolean bl) {
        this.setThrowOnBadUTF8 = bl;
    }

    public boolean ready() {
        int n = this.read - this.close;
        if (6 <= n) {
            return true;
        }
        try {
            if (this.OEAB.available() >= 6 - n) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int read() throws IOException {
        int n;
        if (this.close == this.read && !this.OEAB()) {
            return -1;
        }
        return (n = this.available[this.close++]) >= 0 ? n : this.available(n);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.close == this.read && !this.OEAB()) {
            return -1;
        }
        int n3 = n;
        int n4 = n + n2;
        do {
            int n5;
            int n6 = (n5 = this.available[this.close++]) >= 0 ? n5 : this.available(n5);
            cArray[n++] = (char)n6;
        } while (n != n4 && this.close != this.read);
        return n - n3;
    }

    public long skip(long l) throws IOException {
        if (l == 0L) {
            return 0L;
        }
        if (this.close == this.read && !this.OEAB()) {
            return -1L;
        }
        long l2 = l;
        do {
            byte by;
            if ((by = this.available[this.close++]) >= 0) continue;
            this.available(by);
        } while (--l != 0L && this.close != this.read);
        return l2 - l;
    }

    public void close() throws IOException {
        this.OEAB.close();
    }

    private boolean OEAB() throws IOException {
        int n = this.OEAB.read(this.available, 0, this.available.length);
        if (n < 0) {
            return false;
        }
        this.close = 0;
        this.read = n;
        return true;
    }

    private final int available(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        if ((0xC0 & n) != 192) {
            return this.setThrowOnBadUTF8();
        }
        if ((0x20 & n) == 0) {
            n4 = 1;
            n3 = 0x1F & n;
            n2 = 128;
        } else if ((0x10 & n) == 0) {
            n4 = 2;
            n3 = 0xF & n;
            n2 = 2048;
        } else if ((8 & n) == 0) {
            n4 = 3;
            n3 = 7 & n;
            n2 = 65536;
        } else if ((4 & n) == 0) {
            n4 = 4;
            n3 = 3 & n;
            n2 = 0x200000;
        } else if ((2 & n) == 0) {
            n4 = 5;
            n3 = 1 & n;
            n2 = 0x4000000;
        } else {
            return this.setThrowOnBadUTF8();
        }
        do {
            byte by;
            if (this.close == this.read && !this.OEAB()) {
                return this.OEAB(n3, n4, n2);
            }
            if (((by = this.available[this.close++]) & 0xC0) != 128) {
                --this.close;
                return this.setThrowOnBadUTF8();
            }
            n3 = n3 << 6 | 0x3F & by;
        } while (--n4 != 0);
        if (n3 < n2) {
            n3 = this.setThrowOnBadUTF8();
        } else if (n3 > 65535) {
            n3 = this.close(n3);
        }
        return n3;
    }

    private int setThrowOnBadUTF8() throws IOException {
        if (this.setThrowOnBadUTF8) {
            throw new IOException("Bad UTF-8 bytes");
        }
        return 63;
    }

    private int OEAB(int n, int n2, int n3) throws IOException {
        return this.setThrowOnBadUTF8();
    }

    private int close(int n) throws IOException {
        return 191;
    }
}

