/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.overlay;

import com.mathworks.desktop.overlay.AnchorPosition;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayType;
import com.mathworks.util.Predicate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public final class OverlayConstraints {
    private final Component fAnchorComponent;
    private final AnchorPosition fPosition;
    private final int fX;
    private final int fY;
    private final int fWidth;
    private final int fHeight;
    private final OverlayType fType;
    private final boolean fIgnoreMouseClicksOnAnchor;
    private boolean fAllowMultiSelect;
    private Rectangle fBounds;
    private Predicate<MouseEvent> fShouldConsumeDismissEvent;

    public OverlayConstraints(Component component, AnchorPosition anchorPosition, int n, int n2, int n3, int n4, int n5) {
        this(component, anchorPosition, n, n2, n3, n4, n5, Overlay.Mode.AUTO);
    }

    public OverlayConstraints(Component component, AnchorPosition anchorPosition, int n, int n2, int n3, int n4, int n5, Overlay.Mode mode) {
        this(component, anchorPosition, n, n2, n3, n4, new OverlayType(n5, mode, false));
    }

    private OverlayConstraints(Component component, AnchorPosition anchorPosition, int n, int n2, int n3, int n4, OverlayType overlayType) {
        this(component, anchorPosition, n, n2, n3, n4, overlayType, true);
    }

    private OverlayConstraints(Component component, AnchorPosition anchorPosition, int n, int n2, int n3, int n4, OverlayType overlayType, boolean bl) {
        this.fAnchorComponent = component;
        this.fPosition = anchorPosition;
        this.fX = n;
        this.fY = n2;
        this.fWidth = n3;
        this.fHeight = n4;
        this.fType = overlayType;
        this.fIgnoreMouseClicksOnAnchor = bl;
    }

    public Component getAnchorComponent() {
        return this.fAnchorComponent;
    }

    public AnchorPosition getPosition() {
        return this.fPosition;
    }

    public int getX() {
        return this.fX;
    }

    public int getY() {
        return this.fY;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public int getLayer() {
        return this.fType.getLayer();
    }

    public Overlay.Mode getMode() {
        return this.fType.getMode();
    }

    public boolean isPopup() {
        return this.fType.isPopup();
    }

    public OverlayType getType() {
        return this.fType;
    }

    public boolean isIgnoreMouseClicksOnAnchor() {
        return this.fIgnoreMouseClicksOnAnchor;
    }

    public boolean allowMultiSelect() {
        return this.fAllowMultiSelect;
    }

    public void setAllowMultiSelect(boolean bl) {
        this.fAllowMultiSelect = bl;
    }

    public void setBounds(Rectangle rectangle) {
        this.fBounds = rectangle == null ? null : (Rectangle)rectangle.clone();
    }

    public Rectangle getBounds(Window window) {
        if (this.fBounds == null) {
            Component component = this.getAnchorComponent();
            Rectangle rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), window);
            int n = this.getWidth() == -1 ? component.getWidth() : this.getWidth();
            int n2 = this.getHeight() == -1 ? component.getHeight() : this.getHeight();
            Rectangle rectangle2 = new Rectangle(this.getX(), this.getY(), n, n2);
            switch (this.getPosition()) {
                case NORTHWEST: {
                    rectangle2.x += rectangle.x;
                    rectangle2.y += rectangle.y;
                    break;
                }
                case NORTHEAST: {
                    rectangle2.x += rectangle.x + rectangle.width;
                    rectangle2.y += rectangle.y;
                    break;
                }
                case SOUTHEAST: {
                    rectangle2.x += rectangle.x + rectangle.width;
                    rectangle2.y += rectangle.y + rectangle.height;
                    break;
                }
                case SOUTHWEST: {
                    rectangle2.x += rectangle.x;
                    rectangle2.y += rectangle.y + rectangle.height;
                }
            }
            return rectangle2;
        }
        return (Rectangle)this.fBounds.clone();
    }

    public void setShouldConsumeDismissEvent(Predicate<MouseEvent> predicate) {
        this.fShouldConsumeDismissEvent = predicate;
    }

    public Predicate<MouseEvent> getShouldConsumeDismissEvent() {
        return this.fShouldConsumeDismissEvent;
    }

    public static OverlayConstraints popup(Component component, AnchorPosition anchorPosition, int n, int n2, int n3, int n4) {
        return new OverlayConstraints(component, anchorPosition, n, n2, n3, n4, new OverlayType(0, Overlay.Mode.AUTO, true));
    }

    public static OverlayConstraints popup(Component component, Component component2) {
        Dimension dimension = component2.getPreferredSize();
        return OverlayConstraints.popup(component, AnchorPosition.SOUTHWEST, 0, 0, dimension.width, dimension.height);
    }
}

