/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.tree;

import com.mathworks.util.Converter;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.ComponentTree;
import com.mathworks.util.tree.DefaultMutableTree;
import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.VisitStrategy;
import com.mathworks.util.tree.Visitor;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static <T> Tree<T> createWithUnknownRoot(final T t, final Tree<T> tree) {
        return new Tree<T>(){
            private T fRoot;

            @Override
            public T getRoot() {
                if (this.fRoot == null) {
                    this.fRoot = t;
                    while (this.getParent(this.fRoot) != null) {
                        this.fRoot = this.getParent(this.fRoot);
                    }
                }
                return this.fRoot;
            }

            @Override
            public int getChildCount(T t2) {
                return tree.getChildCount(t2);
            }

            @Override
            public T getChild(T t2, int n) {
                return tree.getChild(t2, n);
            }

            @Override
            public T getParent(T t2) {
                return tree.getParent(t2);
            }
        };
    }

    public static Tree<DefaultMutableTreeNode> createTree(final TreeModel treeModel) {
        return new Tree<DefaultMutableTreeNode>(){

            @Override
            public DefaultMutableTreeNode getRoot() {
                return (DefaultMutableTreeNode)treeModel.getRoot();
            }

            @Override
            public int getChildCount(DefaultMutableTreeNode defaultMutableTreeNode) {
                return defaultMutableTreeNode.getChildCount();
            }

            @Override
            public DefaultMutableTreeNode getChild(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
                return (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }

            @Override
            public DefaultMutableTreeNode getParent(DefaultMutableTreeNode defaultMutableTreeNode) {
                return (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            }
        };
    }

    public static <T> Predicate<T> yes() {
        return new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> yesWhileEmpty(final Collection<T> collection) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                return collection.size() == 0;
            }
        };
    }

    public static <T> Predicate<T> instanceOf(final Class clazz) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    public static <T> Predicate<? super T> or(final Predicate ... predicateArray) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                for (Predicate predicate : predicateArray) {
                    if (!predicate.accept(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<? super T> and(final Predicate ... predicateArray) {
        return new Predicate<T>(){

            @Override
            public boolean accept(T t) {
                for (Predicate predicate : predicateArray) {
                    if (predicate.accept(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T extends Component> T findAncestorComponent(Component component, Class<T> clazz) {
        return (T)TreeUtils.findAncestor(TreeUtils.createWithUnknownRoot(component, ComponentTree.getInstance(component)), component, TreeUtils.instanceOf(clazz));
    }

    public static <T extends Component> T findComponent(Component component, Class<T> clazz) {
        HashSet hashSet = TreeUtils.find(TreeUtils.subtree(ComponentTree.getInstance(component), component), new VisitStrategy<T>(TreeUtils.instanceOf(clazz)), new HashSet());
        if (hashSet.size() == 0) {
            return null;
        }
        return (T)((Component)hashSet.iterator().next());
    }

    public static <T extends Component> Collection<T> findComponents(Component component, Class<T> clazz) {
        return TreeUtils.find(TreeUtils.subtree(ComponentTree.getInstance(component), component), new VisitStrategy<T>(TreeUtils.instanceOf(clazz)), new HashSet());
    }

    public static Collection<Component> findComponents(Component component, Predicate<? super Component> predicate) {
        return TreeUtils.find(TreeUtils.subtree(ComponentTree.getInstance(component), component), new VisitStrategy<Component>(predicate), new HashSet());
    }

    public static <T> TreePath getPath(Tree<T> tree, T t) {
        if (t == null) {
            return null;
        }
        Stack<T> stack = new Stack<T>();
        Object object = t;
        while (object != null) {
            stack.push(object);
            object = tree.getParent(object);
        }
        object = new Object[stack.size()];
        for (int i = 0; i < ((T)object).length; ++i) {
            object[i] = stack.pop();
        }
        return new TreePath((Object[])object);
    }

    public static <T> int getIndexOfChild(Tree<T> tree, T t, T t2) {
        int n = tree.getChildCount(t);
        for (int i = 0; i < n; ++i) {
            if (!tree.getChild(t, i).equals(t2)) continue;
            return i;
        }
        return -1;
    }

    public static <T> T findAncestor(Tree<T> tree, T t, Predicate<? super T> predicate) {
        if (t == null) {
            return null;
        }
        if (predicate.accept(t)) {
            return t;
        }
        return TreeUtils.findAncestor(tree, tree.getParent(t), predicate);
    }

    public static <T, P> P findAmongAncestors(Tree<T> tree, T t, PropertyGetter<T, P> propertyGetter) {
        if (t == null) {
            return null;
        }
        P p = propertyGetter.get(t);
        if (p == null) {
            return TreeUtils.findAmongAncestors(tree, tree.getParent(t), propertyGetter);
        }
        return p;
    }

    public static <T> T findSingle(Tree<T> tree, VisitStrategy<T> visitStrategy) {
        LinkedList linkedList = new LinkedList();
        TreeUtils.find(tree, new VisitStrategy<T>(TreeUtils.and(TreeUtils.yesWhileEmpty(linkedList), visitStrategy.getRecursionCriteria()), TreeUtils.and(TreeUtils.yesWhileEmpty(linkedList), visitStrategy.getVisitCriteria())), linkedList);
        return linkedList.size() == 0 ? null : (T)linkedList.iterator().next();
    }

    public static <T, S extends T, C extends Collection<S>> C find(Tree<T> tree, VisitStrategy<T> visitStrategy, final C c) {
        TreeUtils.visit(tree, visitStrategy, new Visitor<T>(){

            @Override
            public void visit(T t) {
                c.add(t);
            }
        });
        return c;
    }

    public static <T> Tree<T> subtree(final Tree<T> tree, final T t) {
        return new Tree<T>(){

            @Override
            public T getRoot() {
                return t;
            }

            @Override
            public int getChildCount(T t2) {
                return tree.getChildCount(t2);
            }

            @Override
            public T getChild(T t2, int n) {
                return tree.getChild(t2, n);
            }

            @Override
            public T getParent(T t2) {
                if (t2 == t) {
                    return null;
                }
                return tree.getParent(t2);
            }
        };
    }

    public static <T> void visit(Tree<T> tree, Visitor<T> visitor) {
        TreeUtils.visit(tree, new VisitStrategy(), visitor);
    }

    public static <T> void visit(Tree<T> tree, VisitStrategy<T> visitStrategy, Visitor<T> visitor) {
        T t = tree.getRoot();
        if (visitStrategy.getRecursionCriteria().accept(t)) {
            if (visitStrategy.getVisitCriteria().accept(t)) {
                visitor.visit(t);
            }
            for (int i = 0; i < tree.getChildCount(t); ++i) {
                TreeUtils.visit(TreeUtils.subtree(tree, tree.getChild(t, i)), visitStrategy, visitor);
            }
        }
    }

    public static <T, P, C extends Collection<P>> C getAll(Tree<T> tree, VisitStrategy<T> visitStrategy, final PropertyGetter<T, P> propertyGetter, final C c) {
        TreeUtils.visit(tree, visitStrategy, new Visitor<T>(){

            @Override
            public void visit(T t) {
                c.add(propertyGetter.get(t));
            }
        });
        return c;
    }

    public static <T, P> List<P> union(Tree<T> tree, PropertyGetter<T, ? extends Collection<P>> propertyGetter) {
        return TreeUtils.union(tree, propertyGetter, new LinkedList());
    }

    public static <T, P, C extends Collection<P>> C union(Tree<T> tree, PropertyGetter<T, ? extends Collection<P>> propertyGetter, C c) {
        return TreeUtils.union(tree, new VisitStrategy(), propertyGetter, c);
    }

    public static <T, P, C extends Collection<P>> C union(Tree<T> tree, VisitStrategy<T> visitStrategy, final PropertyGetter<T, ? extends Collection<P>> propertyGetter, final C c) {
        TreeUtils.visit(tree, visitStrategy, new Visitor<T>(){

            @Override
            public void visit(T t) {
                c.addAll((Collection)propertyGetter.get(t));
            }
        });
        return c;
    }

    public static <T, K, V> Map<K, V> simpleMapUnion(Tree<T> tree, PropertyGetter<T, ? extends Map<K, V>> propertyGetter) {
        return TreeUtils.simpleMapUnion(tree, propertyGetter, new HashMap());
    }

    public static <T, K, V, M extends Map<K, V>> M simpleMapUnion(Tree<T> tree, PropertyGetter<T, ? extends Map<K, V>> propertyGetter, M m) {
        return TreeUtils.simpleMapUnion(tree, new VisitStrategy(), propertyGetter, m);
    }

    public static <T, K, V, M extends Map<K, V>> M simpleMapUnion(Tree<T> tree, VisitStrategy<T> visitStrategy, final PropertyGetter<T, ? extends Map<K, V>> propertyGetter, final M m) {
        TreeUtils.visit(tree, visitStrategy, new Visitor<T>(){

            @Override
            public void visit(T t) {
                m.putAll((Map)propertyGetter.get(t));
            }
        });
        return m;
    }

    public static <T, K, V> Map<K, List<V>> collectionMapUnion(Tree<T> tree, PropertyGetter<T, ? extends Map<K, ? extends Collection<V>>> propertyGetter) {
        return TreeUtils.collectionMapUnion(tree, propertyGetter, new HashMap());
    }

    public static <T, K, V, M extends Map<K, List<V>>> M collectionMapUnion(Tree<T> tree, PropertyGetter<T, ? extends Map<K, ? extends Collection<V>>> propertyGetter, M m) {
        return TreeUtils.collectionMapUnion(tree, new VisitStrategy(), propertyGetter, m);
    }

    public static <T, K, V, M extends Map<K, List<V>>> M collectionMapUnion(Tree<T> tree, VisitStrategy<T> visitStrategy, final PropertyGetter<T, ? extends Map<K, ? extends Collection<V>>> propertyGetter, final M m) {
        TreeUtils.visit(tree, visitStrategy, new Visitor<T>(){

            @Override
            public void visit(T t) {
                Map map = (Map)propertyGetter.get(t);
                for (Object k : map.keySet()) {
                    LinkedList linkedList = (LinkedList)m.get(k);
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                        m.put(k, linkedList);
                    }
                    linkedList.addAll((Collection)map.get(k));
                }
            }
        });
        return m;
    }

    public static <T, U> Tree<U> convertSnapshot(final Tree<T> tree, final Converter<T, U> converter) {
        final DefaultMutableTree<U> defaultMutableTree = new DefaultMutableTree<U>(converter.convert(tree.getRoot()));
        TreeUtils.visit(tree, new Visitor<T>(){

            @Override
            public void visit(T t) {
                if (t != tree.getRoot()) {
                    defaultMutableTree.addChild(converter.convert(tree.getParent(t)), converter.convert(t));
                }
            }
        });
        return defaultMutableTree;
    }

    public static interface PropertyGetter<T, P> {
        public P get(T var1);
    }
}

