/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.osgi;

import com.mathworks.util.Log;
import com.mathworks.util.osgi.BundleStarter;
import com.mathworks.util.osgi.OSGiUtils;
import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class StartLevelBundleStarter
implements BundleStarter {
    private static final String BUNDLE_START_LEVEL_ATTRIBUTE = "Bundle-Start-Level";

    @Override
    public void startBundles(Bundle bundle, Collection<Bundle> collection) {
        int n = StartLevelBundleStarter.adjustBundleStartLevels(bundle.getBundleContext(), collection);
        for (Bundle bundle2 : collection) {
            try {
                OSGiUtils.log("Starting " + bundle2);
                bundle2.start();
            }
            catch (BundleException bundleException) {
                Log.logException((Exception)((Object)bundleException));
            }
        }
        OSGiUtils.log("Setting system start level to " + n);
        OSGiUtils.getStartLevelService(bundle.getBundleContext()).setStartLevel(n);
    }

    private static int adjustBundleStartLevels(BundleContext bundleContext, Collection<Bundle> collection) {
        assert (OSGiUtils.getStartLevelService(bundleContext).getStartLevel() == 1) : "The system start level is not defaulted to 1; we assume that this is the case";
        int n = 1;
        for (Bundle bundle : collection) {
            int n2 = StartLevelBundleStarter.adjustStartLevel(bundleContext, bundle);
            n = Math.max(n, n2);
        }
        return n;
    }

    private static int adjustStartLevel(BundleContext bundleContext, Bundle bundle) {
        int n;
        String string = (String)bundle.getHeaders().get(BUNDLE_START_LEVEL_ATTRIBUTE);
        if (string != null) {
            n = Integer.parseInt(string);
            OSGiUtils.log("Setting start level for " + bundle + " to " + n);
        } else {
            n = OSGiUtils.getStartLevelService(bundleContext).getStartLevel() + 1;
            OSGiUtils.log("No Bundle-Start-Level Manifest attribute found for " + bundle + ", so setting to " + n);
        }
        OSGiUtils.getStartLevelService(bundleContext).setBundleStartLevel(bundle, n);
        return n;
    }
}

