/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.AsyncReceiver;
import java.util.concurrent.CountDownLatch;

public class LatchedReceiver<T>
extends AsyncReceiver<T> {
    private final CountDownLatch fLatch;
    private final AsyncReceiver<T> fRealReceiver;

    public LatchedReceiver() {
        this(null);
    }

    public LatchedReceiver(AsyncReceiver<T> asyncReceiver) {
        this.fRealReceiver = asyncReceiver;
        this.fLatch = new CountDownLatch(1);
    }

    public void await() {
        try {
            this.fLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    @Override
    public boolean receive(T t) {
        return this.fRealReceiver == null || this.fRealReceiver.receive(t);
    }

    @Override
    public void finished() {
        if (this.fRealReceiver != null) {
            this.fRealReceiver.finished();
        }
        this.fLatch.countDown();
    }
}

