/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.LineBuffer;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class TokenStream {
    static final int TSF_NEWLINES = 1;
    static final int TSF_FUNCTION = 2;
    static final int TSF_RETURN_EXPR = 4;
    static final int TSF_RETURN_VOID = 8;
    static final int TSF_REGEXP = 16;
    static final int TSF_DIRTYLINE = 32;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int GOTO = 6;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int REGEXP = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int THISFN = 87;
    public static final int JTHROW = 88;
    public static final int SEMI = 89;
    public static final int LB = 90;
    public static final int RB = 91;
    public static final int LC = 92;
    public static final int RC = 93;
    public static final int LP = 94;
    public static final int RP = 95;
    public static final int COMMA = 96;
    public static final int ASSIGN = 97;
    public static final int HOOK = 98;
    public static final int COLON = 99;
    public static final int OR = 100;
    public static final int AND = 101;
    public static final int EQOP = 102;
    public static final int RELOP = 103;
    public static final int SHOP = 104;
    public static final int UNARYOP = 105;
    public static final int INC = 106;
    public static final int DEC = 107;
    public static final int DOT = 108;
    public static final int PRIMARY = 109;
    public static final int FUNCTION = 110;
    public static final int EXPORT = 111;
    public static final int IMPORT = 112;
    public static final int IF = 113;
    public static final int ELSE = 114;
    public static final int SWITCH = 115;
    public static final int CASE = 116;
    public static final int DEFAULT = 117;
    public static final int WHILE = 118;
    public static final int DO = 119;
    public static final int FOR = 120;
    public static final int BREAK = 121;
    public static final int CONTINUE = 122;
    public static final int VAR = 123;
    public static final int WITH = 124;
    public static final int CATCH = 125;
    public static final int FINALLY = 126;
    public static final int RESERVED = 127;
    public static final int NOP = 128;
    public static final int NOT = 129;
    public static final int PRE = 130;
    public static final int POST = 131;
    public static final int VOID = 132;
    public static final int BLOCK = 133;
    public static final int ARRAYLIT = 134;
    public static final int OBJLIT = 135;
    public static final int LABEL = 136;
    public static final int TARGET = 137;
    public static final int LOOP = 138;
    public static final int ENUMDONE = 139;
    public static final int EXPRSTMT = 140;
    public static final int PARENT = 141;
    public static final int CONVERT = 142;
    public static final int JSR = 143;
    public static final int NEWLOCAL = 144;
    public static final int USELOCAL = 145;
    public static final int SCRIPT = 146;
    public static final int LAST_TOKEN = 146;
    private LineBuffer OEAB;
    int flags;
    String regExpFlags;
    private String arraycopy;
    private Scriptable charAt;
    private int constructError;
    private int doubleValue;
    private int eof;
    private String equals = "";
    private double getContext;
    private char[] getLine = new char[128];
    private int getLineno;

    public static String tokenToName(int n) {
        return "";
    }

    public String tokenToString(int n) {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private int OEAB(String string) {
        int n;
        block86: {
            int n2 = 121;
            int n3 = 116;
            int n4 = 122;
            int n5 = 117;
            int n6 = 31;
            int n7 = 119;
            int n8 = 114;
            int n9 = 111;
            int n10 = 13165;
            int n11 = 120;
            int n12 = 110;
            int n13 = 113;
            int n14 = 16231;
            int n15 = 30;
            int n16 = 12653;
            int n17 = 5;
            int n18 = 115;
            int n19 = 12909;
            int n20 = 13421;
            int n21 = 8297;
            int n22 = 123;
            int n23 = 33897;
            int n24 = 118;
            int n25 = 124;
            int n26 = 127;
            int n27 = 127;
            int n28 = 127;
            int n29 = 125;
            int n30 = 127;
            int n31 = 127;
            int n32 = 127;
            int n33 = 127;
            int n34 = 127;
            int n35 = 127;
            int n36 = 127;
            int n37 = 127;
            int n38 = 126;
            int n39 = 127;
            int n40 = 127;
            int n41 = 127;
            int n42 = 112;
            int n43 = 16487;
            int n44 = 127;
            int n45 = 127;
            int n46 = 127;
            int n47 = 127;
            int n48 = 127;
            int n49 = 127;
            int n50 = 127;
            int n51 = 127;
            int n52 = 127;
            int n53 = 127;
            int n54 = 127;
            int n55 = 127;
            int n56 = 62;
            int n57 = 127;
            int n58 = 127;
            int n59 = 75;
            int n60 = 127;
            String string2 = string;
            n = 0;
            String string3 = null;
            block0 : switch (string2.length()) {
                case 2: {
                    char c = string2.charAt(1);
                    if (c == 'f') {
                        if (string2.charAt(0) != 'i') break;
                        n = 113;
                        break block86;
                    } else if (c == 'n') {
                        if (string2.charAt(0) != 'i') break;
                        n = 16231;
                        break block86;
                    } else {
                        if (c != 'o' || string2.charAt(0) != 'd') break;
                        n = 119;
                    }
                    break block86;
                }
                case 3: {
                    switch (string2.charAt(0)) {
                        case 'f': {
                            if (string2.charAt(2) != 'r' || string2.charAt(1) != 'o') break;
                            n = 120;
                            break block86;
                        }
                        case 'i': {
                            if (string2.charAt(2) != 't' || string2.charAt(1) != 'n') break;
                            n = 127;
                            break block86;
                        }
                        case 'n': {
                            if (string2.charAt(2) != 'w' || string2.charAt(1) != 'e') break;
                            n = 30;
                            break block86;
                        }
                        case 't': {
                            if (string2.charAt(2) != 'y' || string2.charAt(1) != 'r') break;
                            n = 75;
                            break block86;
                        }
                        case 'v': {
                            if (string2.charAt(2) != 'r' || string2.charAt(1) != 'a') break;
                            n = 123;
                            break block86;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (string2.charAt(0)) {
                        case 'b': {
                            string3 = "byte";
                            n = 127;
                            break;
                        }
                        case 'c': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 's' || string2.charAt(1) != 'a') break;
                                n = 116;
                                break block86;
                            } else {
                                if (c != 'r' || string2.charAt(2) != 'a' || string2.charAt(1) != 'h') break;
                                n = 127;
                            }
                            break block86;
                        }
                        case 'e': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 's' || string2.charAt(1) != 'l') break;
                                n = 114;
                                break block86;
                            } else {
                                if (c != 'm' || string2.charAt(2) != 'u' || string2.charAt(1) != 'n') break;
                                n = 127;
                            }
                            break block86;
                        }
                        case 'g': {
                            string3 = "goto";
                            n = 127;
                            break;
                        }
                        case 'l': {
                            string3 = "long";
                            n = 127;
                            break;
                        }
                        case 'n': {
                            string3 = "null";
                            n = 12653;
                            break;
                        }
                        case 't': {
                            char c = string2.charAt(3);
                            if (c == 'e') {
                                if (string2.charAt(2) != 'u' || string2.charAt(1) != 'r') break;
                                n = 13421;
                                break block86;
                            } else {
                                if (c != 's' || string2.charAt(2) != 'i' || string2.charAt(1) != 'h') break;
                                n = 12909;
                            }
                            break block86;
                        }
                        case 'v': {
                            string3 = "void";
                            n = 33897;
                            break;
                        }
                        case 'w': {
                            string3 = "with";
                            n = 124;
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (string2.charAt(2)) {
                        case 'a': {
                            string3 = "class";
                            n = 127;
                            break;
                        }
                        case 'e': {
                            string3 = "break";
                            n = 121;
                            break;
                        }
                        case 'i': {
                            string3 = "while";
                            n = 118;
                            break;
                        }
                        case 'l': {
                            string3 = "false";
                            n = 13165;
                            break;
                        }
                        case 'n': {
                            char c = string2.charAt(0);
                            if (c == 'c') {
                                string3 = "const";
                                n = 127;
                                break;
                            }
                            if (c != 'f') break;
                            string3 = "final";
                            n = 127;
                            break;
                        }
                        case 'o': {
                            char c = string2.charAt(0);
                            if (c == 'f') {
                                string3 = "float";
                                n = 127;
                                break;
                            }
                            if (c != 's') break;
                            string3 = "short";
                            n = 127;
                            break;
                        }
                        case 'p': {
                            string3 = "super";
                            n = 127;
                            break;
                        }
                        case 'r': {
                            string3 = "throw";
                            n = 62;
                            break;
                        }
                        case 't': {
                            string3 = "catch";
                            n = 125;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (string2.charAt(1)) {
                        case 'a': {
                            string3 = "native";
                            n = 127;
                            break;
                        }
                        case 'e': {
                            char c = string2.charAt(0);
                            if (c == 'd') {
                                string3 = "delete";
                                n = 31;
                                break;
                            }
                            if (c != 'r') break;
                            string3 = "return";
                            n = 5;
                            break;
                        }
                        case 'h': {
                            string3 = "throws";
                            n = 127;
                            break;
                        }
                        case 'm': {
                            string3 = "import";
                            n = 112;
                            break;
                        }
                        case 'o': {
                            string3 = "double";
                            n = 127;
                            break;
                        }
                        case 't': {
                            string3 = "static";
                            n = 127;
                            break;
                        }
                        case 'u': {
                            string3 = "public";
                            n = 127;
                            break;
                        }
                        case 'w': {
                            string3 = "switch";
                            n = 115;
                            break;
                        }
                        case 'x': {
                            string3 = "export";
                            n = 111;
                            break;
                        }
                        case 'y': {
                            string3 = "typeof";
                            n = 8297;
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    switch (string2.charAt(1)) {
                        case 'a': {
                            string3 = "package";
                            n = 127;
                            break block0;
                        }
                        case 'e': {
                            string3 = "default";
                            n = 117;
                            break block0;
                        }
                        case 'i': {
                            string3 = "finally";
                            n = 126;
                            break block0;
                        }
                        case 'o': {
                            string3 = "boolean";
                            n = 127;
                            break block0;
                        }
                        case 'r': {
                            string3 = "private";
                            n = 127;
                            break block0;
                        }
                        case 'x': {
                            string3 = "extends";
                            n = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (string2.charAt(0)) {
                        case 'a': {
                            string3 = "abstract";
                            n = 127;
                            break block0;
                        }
                        case 'c': {
                            string3 = "continue";
                            n = 122;
                            break block0;
                        }
                        case 'd': {
                            string3 = "debugger";
                            n = 127;
                            break block0;
                        }
                        case 'f': {
                            string3 = "function";
                            n = 110;
                            break block0;
                        }
                        case 'v': {
                            string3 = "volatile";
                            n = 127;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    char c = string2.charAt(0);
                    if (c == 'i') {
                        string3 = "interface";
                        n = 127;
                        break;
                    }
                    if (c == 'p') {
                        string3 = "protected";
                        n = 127;
                        break;
                    }
                    if (c != 't') break;
                    string3 = "transient";
                    n = 127;
                    break;
                }
                case 10: {
                    char c = string2.charAt(1);
                    if (c == 'm') {
                        string3 = "implements";
                        n = 127;
                        break;
                    }
                    if (c != 'n') break;
                    string3 = "instanceof";
                    n = 16487;
                    break;
                }
                case 12: {
                    string3 = "synchronized";
                    n = 127;
                }
            }
            if (string3 != null && string3 != string2 && !string3.equals(string2)) {
                return 0;
            }
        }
        if (n == 0) {
            return 0;
        }
        this.eof = n >> 8;
        return n & 0xFF;
    }

    public TokenStream(Reader reader, Scriptable scriptable, String string, int n) {
        this.OEAB = new LineBuffer(reader, n);
        this.charAt = scriptable;
        this.constructError = 0;
        this.arraycopy = string;
        this.flags = 0;
    }

    public Scriptable getScope() {
        return this.charAt;
    }

    public boolean matchToken(int n) throws IOException {
        int n2 = this.getToken();
        if (n2 == n) {
            return true;
        }
        --this.doubleValue;
        this.constructError = n2;
        return false;
    }

    public void clearPushback() {
        this.constructError = 0;
    }

    public void ungetToken(int n) {
        if (this.constructError != 0 && n != -1) {
            String string = Context.getMessage2("msg.token.replaces.pushback", this.tokenToString(n), this.tokenToString(this.constructError));
            throw new RuntimeException(string);
        }
        this.constructError = n;
        --this.doubleValue;
    }

    public int peekToken() throws IOException {
        int n;
        this.constructError = n = this.getToken();
        --this.doubleValue;
        return n;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 1;
        int n = this.peekToken();
        this.flags &= 0xFFFFFFFE;
        if (this.constructError == 1) {
            this.constructError = 0;
        }
        return n;
    }

    protected static boolean isJSIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isJavaIdentifierPart(c) && c == '\\' && n2 + 5 >= n && string.charAt(n2 + 1) == 'u' && 0 <= TokenStream.xDigitToInt(string.charAt(n2 + 2)) && 0 <= TokenStream.xDigitToInt(string.charAt(n2 + 3)) && 0 <= TokenStream.xDigitToInt(string.charAt(n2 + 4)) && 0 <= TokenStream.xDigitToInt(string.charAt(n2 + 5))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean arraycopy(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    static boolean isDigit(int n) {
        return n >= 48 && n <= 57;
    }

    static int xDigitToInt(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 87;
        }
        if (65 <= n && n <= 70) {
            return n - 55;
        }
        return -1;
    }

    public static boolean isJSSpace(int n) {
        return n == 32 || n == 9 || n == 12 || n == 11 || n == 160 || Character.getType((char)n) == 12;
    }

    public static boolean isJSLineTerminator(int n) {
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    private void charAt() throws IOException {
        int n;
        while ((n = this.OEAB.read()) != -1 && n != 10) {
        }
        this.OEAB.unread();
    }

    /*
     * Unable to fully structure code
     */
    public int getToken() throws IOException {
        block124: {
            block125: {
                ++this.doubleValue;
                if (this.constructError != 0) {
                    var2_1 = this.constructError;
                    this.constructError = 0;
                    return var2_1;
                }
                do {
                    if ((var1_3 = this.OEAB.read()) != 10) continue;
                    this.flags &= -33;
                    if ((this.flags & 1) != 0) break;
                } while (TokenStream.isJSSpace(var1_3) || var1_3 == 10);
                if (var1_3 == -1) {
                    return 0;
                }
                if (var1_3 != 45 && var1_3 != 10) {
                    this.flags |= 32;
                }
                var3_4 = false;
                if (var1_3 == 92) {
                    var1_3 = this.OEAB.read();
                    if (var1_3 == 117) {
                        var2_2 = true;
                        var3_4 = true;
                        this.getLineno = 0;
                    } else {
                        var2_2 = false;
                        var1_3 = 92;
                        this.OEAB.unread();
                    }
                } else {
                    var2_2 = Character.isJavaIdentifierStart((char)var1_3);
                    if (var2_2) {
                        this.getLineno = 0;
                        this.doubleValue(var1_3);
                    }
                }
                if (var2_2) {
                    var4_5 = var3_4;
                    while (true) {
                        if (var3_4) {
                            var5_9 = 0;
                            var6_14 = 0;
                            while (var6_14 != 4) {
                                var1_3 = this.OEAB.read();
                                if ((var5_9 = var5_9 << 4 | TokenStream.xDigitToInt(var1_3)) < 0) break;
                                ++var6_14;
                            }
                            if (var5_9 < 0) {
                                this.reportSyntaxError("msg.invalid.escape", null);
                                return -1;
                            }
                            this.doubleValue(var5_9);
                            var3_4 = false;
                            continue;
                        }
                        var1_3 = this.OEAB.read();
                        if (var1_3 == 92) {
                            var1_3 = this.OEAB.read();
                            if (var1_3 == 117) {
                                var3_4 = true;
                                var4_5 = true;
                                continue;
                            }
                            this.reportSyntaxError("msg.illegal.character", null);
                            return -1;
                        }
                        if (!Character.isJavaIdentifierPart((char)var1_3)) break;
                        this.doubleValue(var1_3);
                    }
                    this.OEAB.unread();
                    var5_10 = this.constructError();
                    if (!var4_5 && (var6_14 = this.OEAB(var5_10)) != 0) {
                        if (var6_14 != 127) {
                            return var6_14;
                        }
                        if (!Context.getContext().hasFeature(3)) {
                            return var6_14;
                        }
                        var7_17 = new Object[]{var5_10};
                        this.eof("msg.reserved.keyword", var7_17);
                    }
                    this.equals = var5_10;
                    return 44;
                }
                if (!TokenStream.isDigit(var1_3) && (var1_3 != 46 || !TokenStream.isDigit(this.OEAB.peek()))) break block124;
                this.getLineno = 0;
                var4_6 = 10;
                if (var1_3 == 48) {
                    var1_3 = this.OEAB.read();
                    if (var1_3 == 120 || var1_3 == 88) {
                        var4_6 = 16;
                        var1_3 = this.OEAB.read();
                    } else if (TokenStream.isDigit(var1_3)) {
                        var4_6 = 8;
                    } else {
                        this.doubleValue(48);
                    }
                }
                if (var4_6 != 16) ** GOTO lbl96
                while (0 <= TokenStream.xDigitToInt(var1_3)) {
                    this.doubleValue(var1_3);
                    var1_3 = this.OEAB.read();
                }
                break block125;
lbl-1000:
                // 1 sources

                {
                    if (var4_6 == 8 && var1_3 >= 56) {
                        var5_11 = new Object[]{var1_3 == 56 ? "8" : "9"};
                        this.eof("msg.bad.octal.literal", var5_11);
                        var4_6 = 10;
                    }
                    this.doubleValue(var1_3);
                    var1_3 = this.OEAB.read();
lbl96:
                    // 2 sources

                    ** while (48 <= var1_3 && var1_3 <= 57)
                }
            }
            var5_12 = true;
            if (var4_6 == 10 && (var1_3 == 46 || var1_3 == 101 || var1_3 == 69)) {
                var5_12 = false;
                if (var1_3 == 46) {
                    do {
                        this.doubleValue(var1_3);
                    } while (TokenStream.isDigit(var1_3 = this.OEAB.read()));
                }
                if (var1_3 == 101 || var1_3 == 69) {
                    this.doubleValue(var1_3);
                    var1_3 = this.OEAB.read();
                    if (var1_3 == 43 || var1_3 == 45) {
                        this.doubleValue(var1_3);
                        var1_3 = this.OEAB.read();
                    }
                    if (!TokenStream.isDigit(var1_3)) {
                        this.reportSyntaxError("msg.missing.exponent", null);
                        return -1;
                    }
                    do {
                        this.doubleValue(var1_3);
                    } while (TokenStream.isDigit(var1_3 = this.OEAB.read()));
                }
            }
            this.OEAB.unread();
            var6_15 = this.constructError();
            if (var4_6 == 10 && !var5_12) {
                try {
                    var7_18 = Double.valueOf(var6_15);
                }
                catch (NumberFormatException var9_20) {
                    var10_21 = new Object[]{var9_20.getMessage()};
                    this.reportSyntaxError("msg.caught.nfe", var10_21);
                    return -1;
                }
            } else {
                var7_18 = ScriptRuntime.stringToNumber(var6_15, 0, var4_6);
            }
            this.getContext = var7_18;
            return 45;
        }
        if (var1_3 == 34 || var1_3 == 39) {
            var4_7 = var1_3;
            var5_13 = 0;
            this.getLineno = 0;
            var1_3 = this.OEAB.read();
            block46: while (var1_3 != var4_7) {
                if (var1_3 == 10 || var1_3 == -1) {
                    this.OEAB.unread();
                    this.reportSyntaxError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (var1_3 == 92) {
                    var1_3 = this.OEAB.read();
                    switch (var1_3) {
                        case 98: {
                            var1_3 = 8;
                            break;
                        }
                        case 102: {
                            var1_3 = 12;
                            break;
                        }
                        case 110: {
                            var1_3 = 10;
                            break;
                        }
                        case 114: {
                            var1_3 = 13;
                            break;
                        }
                        case 116: {
                            var1_3 = 9;
                            break;
                        }
                        case 118: {
                            var1_3 = 11;
                            break;
                        }
                        case 117: {
                            var6_16 = this.getLineno;
                            this.doubleValue(117);
                            var7_19 = 0;
                            var8_22 = 0;
                            while (var8_22 != 4) {
                                var1_3 = this.OEAB.read();
                                if ((var7_19 = var7_19 << 4 | TokenStream.xDigitToInt(var1_3)) < 0) continue block46;
                                this.doubleValue(var1_3);
                                ++var8_22;
                            }
                            this.getLineno = var6_16;
                            var1_3 = var7_19;
                            break;
                        }
                        case 120: {
                            var1_3 = this.OEAB.read();
                            var6_16 = TokenStream.xDigitToInt(var1_3);
                            if (var6_16 < 0) {
                                this.doubleValue(120);
                                continue block46;
                            }
                            var7_19 = var1_3;
                            var1_3 = this.OEAB.read();
                            if ((var6_16 = var6_16 << 4 | TokenStream.xDigitToInt(var1_3)) < 0) {
                                this.doubleValue(120);
                                this.doubleValue(var7_19);
                                continue block46;
                            }
                            var1_3 = var6_16;
                            break;
                        }
                        default: {
                            if (48 > var1_3 || var1_3 >= 56) break;
                            var5_13 = var1_3 - 48;
                            var1_3 = this.OEAB.read();
                            if (48 <= var1_3 && var1_3 < 56) {
                                var5_13 = 8 * var5_13 + var1_3 - 48;
                                var1_3 = this.OEAB.read();
                                if (48 <= var1_3 && var1_3 < 56 && var5_13 <= 31) {
                                    var5_13 = 8 * var5_13 + var1_3 - 48;
                                    var1_3 = this.OEAB.read();
                                }
                            }
                            this.OEAB.unread();
                            var1_3 = var5_13;
                        }
                    }
                }
                this.doubleValue(var1_3);
                var1_3 = this.OEAB.read();
            }
            this.equals = this.constructError();
            return 46;
        }
        switch (var1_3) {
            case 10: {
                return 1;
            }
            case 59: {
                return 89;
            }
            case 91: {
                return 90;
            }
            case 93: {
                return 91;
            }
            case 123: {
                return 92;
            }
            case 125: {
                return 93;
            }
            case 40: {
                return 94;
            }
            case 41: {
                return 95;
            }
            case 44: {
                return 96;
            }
            case 63: {
                return 98;
            }
            case 58: {
                return 99;
            }
            case 46: {
                return 108;
            }
            case 124: {
                if (this.OEAB.match(124)) {
                    return 100;
                }
                if (this.OEAB.match(61)) {
                    this.eof = 11;
                    return 97;
                }
                return 11;
            }
            case 94: {
                if (this.OEAB.match(61)) {
                    this.eof = 12;
                    return 97;
                }
                return 12;
            }
            case 38: {
                if (this.OEAB.match(38)) {
                    return 101;
                }
                if (this.OEAB.match(61)) {
                    this.eof = 13;
                    return 97;
                }
                return 13;
            }
            case 61: {
                if (this.OEAB.match(61)) {
                    this.eof = this.OEAB.match(61) != false ? 53 : 14;
                    return 102;
                }
                this.eof = 128;
                return 97;
            }
            case 33: {
                if (this.OEAB.match(61)) {
                    this.eof = this.OEAB.match(61) != false ? 54 : 15;
                    return 102;
                }
                this.eof = 129;
                return 105;
            }
            case 60: {
                if (this.OEAB.match(33)) {
                    if (this.OEAB.match(45)) {
                        if (this.OEAB.match(45)) {
                            this.charAt();
                            return this.getToken();
                        }
                        this.OEAB.unread();
                    }
                    this.OEAB.unread();
                }
                if (this.OEAB.match(60)) {
                    if (this.OEAB.match(61)) {
                        this.eof = 20;
                        return 97;
                    }
                    this.eof = 20;
                    return 104;
                }
                if (this.OEAB.match(61)) {
                    this.eof = 17;
                    return 103;
                }
                this.eof = 16;
                return 103;
            }
            case 62: {
                if (this.OEAB.match(62)) {
                    if (this.OEAB.match(62)) {
                        if (this.OEAB.match(61)) {
                            this.eof = 22;
                            return 97;
                        }
                        this.eof = 22;
                        return 104;
                    }
                    if (this.OEAB.match(61)) {
                        this.eof = 21;
                        return 97;
                    }
                    this.eof = 21;
                    return 104;
                }
                if (this.OEAB.match(61)) {
                    this.eof = 19;
                    return 103;
                }
                this.eof = 18;
                return 103;
            }
            case 42: {
                if (this.OEAB.match(61)) {
                    this.eof = 25;
                    return 97;
                }
                return 25;
            }
            case 47: {
                if (this.OEAB.match(47)) {
                    this.charAt();
                    return this.getToken();
                }
                if (this.OEAB.match(42)) {
                    while (!((var1_3 = this.OEAB.read()) == -1 || var1_3 == 42 && this.OEAB.match(47))) {
                    }
                    if (var1_3 == -1) {
                        this.reportSyntaxError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return this.getToken();
                }
                if ((this.flags & 16) != 0) {
                    this.getLineno = 0;
                    while ((var1_3 = this.OEAB.read()) != 47) {
                        if (var1_3 == 10 || var1_3 == -1) {
                            this.OEAB.unread();
                            this.reportSyntaxError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (var1_3 == 92) {
                            this.doubleValue(var1_3);
                            var1_3 = this.OEAB.read();
                        }
                        this.doubleValue(var1_3);
                    }
                    var4_8 = this.getLineno;
                    while (true) {
                        if (this.OEAB.match(103)) {
                            this.doubleValue(103);
                            continue;
                        }
                        if (this.OEAB.match(105)) {
                            this.doubleValue(105);
                            continue;
                        }
                        if (!this.OEAB.match(109)) break;
                        this.doubleValue(109);
                    }
                    if (TokenStream.arraycopy(this.OEAB.peek())) {
                        this.reportSyntaxError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.equals = new String(this.getLine, 0, var4_8);
                    this.regExpFlags = new String(this.getLine, var4_8, this.getLineno - var4_8);
                    return 56;
                }
                if (this.OEAB.match(61)) {
                    this.eof = 26;
                    return 97;
                }
                return 26;
            }
            case 37: {
                this.eof = 27;
                if (this.OEAB.match(61)) {
                    return 97;
                }
                return 27;
            }
            case 126: {
                this.eof = 28;
                return 105;
            }
            case 43: {
                if (this.OEAB.match(61)) {
                    this.eof = 23;
                    return 97;
                }
                if (this.OEAB.match(43)) {
                    return 106;
                }
                return 23;
            }
            case 45: {
                if (this.OEAB.match(61)) {
                    this.eof = 24;
                    var1_3 = 97;
                } else if (this.OEAB.match(45)) {
                    if (0 == (this.flags & 32) && this.OEAB.match(62)) {
                        this.charAt();
                        return this.getToken();
                    }
                    var1_3 = 107;
                } else {
                    var1_3 = 24;
                }
                this.flags |= 32;
                return var1_3;
            }
        }
        this.reportSyntaxError("msg.illegal.character", null);
        return -1;
    }

    private String constructError() {
        return new String(this.getLine, 0, this.getLineno);
    }

    private void doubleValue(int n) {
        if (this.getLineno == this.getLine.length) {
            char[] cArray = new char[this.getLine.length * 2];
            System.arraycopy(this.getLine, 0, cArray, 0, this.getLineno);
            this.getLine = cArray;
        }
        this.getLine[this.getLineno++] = (char)n;
    }

    public void reportSyntaxError(String string, Object[] objectArray) {
        String string2 = Context.getMessage(string, objectArray);
        if (this.charAt != null) {
            throw NativeGlobal.constructError(Context.getContext(), "SyntaxError", string2, this.charAt, this.getSourceName(), this.getLineno(), this.getOffset(), this.getLine());
        }
        Context.reportError(string2, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    private void eof(String string, Object[] objectArray) {
        String string2 = Context.getMessage(string, objectArray);
        Context.reportWarning(string2, this.getSourceName(), this.getLineno(), this.getLine(), this.getOffset());
    }

    public String getSourceName() {
        return this.arraycopy;
    }

    public int getLineno() {
        return this.OEAB.getLineno();
    }

    public int getOp() {
        return this.eof;
    }

    public String getString() {
        return this.equals;
    }

    public double getNumber() {
        return this.getContext;
    }

    public String getLine() {
        return this.OEAB.getLine();
    }

    public int getOffset() {
        return this.OEAB.getOffset();
    }

    public int getTokenno() {
        return this.doubleValue;
    }

    public boolean eof() {
        return this.OEAB.eof();
    }
}

