/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.BinaryDigitReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdEnumeration;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class ScriptRuntime {
    public static final Class UndefinedClass = class$org$mozilla$javascript$Undefined == null ? (class$org$mozilla$javascript$Undefined = ScriptRuntime.class$("org.mozilla.javascript.Undefined")) : class$org$mozilla$javascript$Undefined;
    public static final Class ScriptableClass = class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = ScriptRuntime.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable;
    public static final Class StringClass = class$java$lang$String == null ? (class$java$lang$String = ScriptRuntime.class$("java.lang.String")) : class$java$lang$String;
    public static final Class NumberClass = class$java$lang$Number == null ? (class$java$lang$Number = ScriptRuntime.class$("java.lang.Number")) : class$java$lang$Number;
    public static final Class BooleanClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScriptRuntime.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    public static final Class ByteClass = class$java$lang$Byte == null ? (class$java$lang$Byte = ScriptRuntime.class$("java.lang.Byte")) : class$java$lang$Byte;
    public static final Class ShortClass = class$java$lang$Short == null ? (class$java$lang$Short = ScriptRuntime.class$("java.lang.Short")) : class$java$lang$Short;
    public static final Class IntegerClass = class$java$lang$Integer == null ? (class$java$lang$Integer = ScriptRuntime.class$("java.lang.Integer")) : class$java$lang$Integer;
    public static final Class LongClass = class$java$lang$Long == null ? (class$java$lang$Long = ScriptRuntime.class$("java.lang.Long")) : class$java$lang$Long;
    public static final Class FloatClass = class$java$lang$Float == null ? (class$java$lang$Float = ScriptRuntime.class$("java.lang.Float")) : class$java$lang$Float;
    public static final Class DoubleClass = class$java$lang$Double == null ? (class$java$lang$Double = ScriptRuntime.class$("java.lang.Double")) : class$java$lang$Double;
    public static final Class CharacterClass = class$java$lang$Character == null ? (class$java$lang$Character = ScriptRuntime.class$("java.lang.Character")) : class$java$lang$Character;
    public static final Class ObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = ScriptRuntime.class$("java.lang.Object")) : class$java$lang$Object;
    public static final Class FunctionClass = class$org$mozilla$javascript$Function == null ? (class$org$mozilla$javascript$Function = ScriptRuntime.class$("org.mozilla.javascript.Function")) : class$org$mozilla$javascript$Function;
    public static final Class ClassClass = class$java$lang$Class == null ? (class$java$lang$Class = ScriptRuntime.class$("java.lang.Class")) : class$java$lang$Class;
    public static final Class SerializableClass = class$java$io$Serializable == null ? (class$java$io$Serializable = ScriptRuntime.class$("java.io.Serializable")) : class$java$io$Serializable;
    public static final Class ComparableClass = ScriptRuntime.ComparableClass("java.lang.Comparable");
    public static double NaN = Double.NaN;
    public static Double NaNobj = new Double(Double.NaN);
    public static double negativeZero = -0.0;
    public static final Object[] emptyArgs = new Object[0];
    static Class class$org$mozilla$javascript$Undefined;
    static Class class$org$mozilla$javascript$Scriptable;
    static Class class$java$lang$String;
    static Class class$java$lang$Number;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$Float;
    static Class class$java$lang$Double;
    static Class class$java$lang$Character;
    static Class class$java$lang$Object;
    static Class class$org$mozilla$javascript$Function;
    static Class class$java$lang$Class;
    static Class class$java$io$Serializable;
    static Class class$org$mozilla$javascript$NativeGlobal;
    static Class class$org$mozilla$javascript$NativeWith;
    static Class class$org$mozilla$javascript$NativeScript;
    static Class class$org$mozilla$javascript$Context;

    protected ScriptRuntime() {
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Scriptable) {
            if (Context.getContext().isVersionECMA1()) {
                return object != Undefined.instance;
            }
            if ((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.DoubleClass("msg.primitive.expected", object);
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        throw ScriptRuntime.DoubleClass("msg.invalid.type", object);
    }

    public static boolean toBoolean(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toBoolean(objectArray[n]) : false;
    }

    public static double toNumber(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Scriptable) {
            if ((object = ((Scriptable)object).getDefaultValue(NumberClass)) != null && object instanceof Scriptable) {
                throw ScriptRuntime.DoubleClass("msg.primitive.expected", object);
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.DoubleClass("msg.invalid.type", object);
    }

    public static double toNumber(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : NaN;
    }

    static double stringToNumber(String string, int n, int n2) {
        int n3;
        char c = '9';
        char c2 = 'a';
        char c3 = 'A';
        int n4 = string.length();
        if (n2 < 10) {
            c = (char)(48 + n2 - 1);
        }
        if (n2 > 10) {
            c2 = (char)(97 + n2 - 10);
            c3 = (char)(65 + n2 - 10);
        }
        double d = 0.0;
        int n5 = n;
        while (n5 < n4) {
            char c4 = string.charAt(n5);
            if ('0' <= c4 && c4 <= c) {
                n3 = c4 - 48;
            } else if ('a' <= c4 && c4 < c2) {
                n3 = c4 - 97 + 10;
            } else {
                if ('A' > c4 || c4 >= c3) break;
                n3 = c4 - 65 + 10;
            }
            d = d * (double)n2 + (double)n3;
            ++n5;
        }
        if (n == n5) {
            return NaN;
        }
        if (d >= 9.007199254740992E15) {
            if (n2 == 10) {
                try {
                    return Double.valueOf(string.substring(n, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16 || n2 == 32) {
                BinaryDigitReader binaryDigitReader = new BinaryDigitReader(n2, string, n, n5);
                d = 0.0;
                while ((n3 = binaryDigitReader.getNextBinaryDigit()) == 0) {
                }
                if (n3 == 1) {
                    d = 1.0;
                    int n6 = 52;
                    while (n6 != 0) {
                        n3 = binaryDigitReader.getNextBinaryDigit();
                        if (n3 < 0) {
                            return d;
                        }
                        d = d * 2.0 + (double)n3;
                        --n6;
                    }
                    int n7 = binaryDigitReader.getNextBinaryDigit();
                    if (n7 >= 0) {
                        int n8;
                        double d2 = 2.0;
                        int n9 = 0;
                        while ((n8 = binaryDigitReader.getNextBinaryDigit()) >= 0) {
                            n9 |= n8;
                            d2 *= 2.0;
                        }
                        d += (double)(n7 & (n3 | n9));
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static double toNumber(String string) {
        char c;
        char c2;
        int n = string.length();
        int n2 = 0;
        while (true) {
            if (n2 == n) {
                return 0.0;
            }
            c2 = string.charAt(n2);
            if (!Character.isWhitespace(c2)) break;
            ++n2;
        }
        if (c2 == '0' && n2 + 2 < n && Character.toLowerCase(string.charAt(n2 + 1)) == 'x') {
            return ScriptRuntime.stringToNumber(string, n2 + 2, 16);
        }
        if ((c2 == '+' || c2 == '-') && n2 + 3 < n && string.charAt(n2 + 1) == '0' && Character.toLowerCase(string.charAt(n2 + 2)) == 'x') {
            double d = ScriptRuntime.stringToNumber(string, n2 + 3, 16);
            return c2 == '-' ? -d : d;
        }
        int n3 = n - 1;
        while (Character.isWhitespace(c = string.charAt(n3))) {
            --n3;
        }
        if (c == 'y') {
            if (c2 == '+' || c2 == '-') {
                ++n2;
            }
            if (n2 + 7 == n3 && string.regionMatches(n2, "Infinity", 0, 8)) {
                return c2 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String string2 = string.substring(n2, n3 + 1);
        int n4 = string2.length() - 1;
        while (n4 >= 0) {
            char c3 = string2.charAt(n4);
            if (('0' > c3 || c3 > '9') && c3 != '.' && c3 != 'e' && c3 != 'E' && c3 != '+' && c3 != '-') {
                return NaN;
            }
            --n4;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return NaN;
        }
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray2[n2] = objectArray[n2];
            ++n2;
        }
        while (n2 < n) {
            objectArray2[n2] = Undefined.instance;
            ++n2;
        }
        return objectArray2;
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = null;
        int n = 0;
        int n2 = string.length();
        while (n != n2) {
            char c = string.charAt(n);
            if (' ' <= c && c <= '~' && c != '\"' && c != '\\') {
                if (stringBuffer != null) {
                    stringBuffer.append(c);
                }
            } else {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n2 + 3);
                    stringBuffer.append(string);
                    stringBuffer.setLength(n);
                }
                int n3 = -1;
                switch (c) {
                    case '\b': {
                        n3 = 98;
                        break;
                    }
                    case '\f': {
                        n3 = 102;
                        break;
                    }
                    case '\n': {
                        n3 = 110;
                        break;
                    }
                    case '\r': {
                        n3 = 114;
                        break;
                    }
                    case '\t': {
                        n3 = 116;
                        break;
                    }
                    case '\u000b': {
                        n3 = 118;
                        break;
                    }
                    case '\"': {
                        n3 = 34;
                        break;
                    }
                    case ' ': {
                        n3 = 32;
                        break;
                    }
                    case '\\': {
                        n3 = 92;
                    }
                }
                if (n3 >= 0) {
                    stringBuffer.append('\\');
                    stringBuffer.append((char)n3);
                } else {
                    int n4;
                    if (c < '\u0100') {
                        stringBuffer.append("\\x");
                        n4 = 2;
                    } else {
                        stringBuffer.append("\\u");
                        n4 = 4;
                    }
                    int n5 = (n4 - 1) * 4;
                    while (n5 >= 0) {
                        int n6 = 0xF & c >> n5;
                        int n7 = n6 < 10 ? 48 + n6 : 87 + n6;
                        stringBuffer.append((char)n7);
                        n5 -= 4;
                    }
                }
            }
            ++n;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String toString(Object object) {
        block3: {
            do {
                if (object == null) {
                    return "null";
                }
                if (!(object instanceof Scriptable)) break block3;
            } while ((object = ((Scriptable)object).getDefaultValue(StringClass)) == Undefined.instance || !(object instanceof Scriptable));
            throw ScriptRuntime.DoubleClass("msg.primitive.expected", object);
        }
        if (object instanceof Number) {
            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
        }
        return object.toString();
    }

    public static String toString(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toString(objectArray[n]) : "undefined";
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String numberToString(double d, int n) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, 0, 0, d);
        return stringBuffer.toString();
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object, null);
    }

    public static Scriptable toObject(Scriptable scriptable, Object object, Class clazz) {
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object, clazz);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object) {
        return ScriptRuntime.toObject(context, scriptable, object, null);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object, Class clazz) {
        String string;
        if (object == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        if (object instanceof Scriptable) {
            if (object == Undefined.instance) {
                throw NativeGlobal.typeError0("msg.undef.to.object", scriptable);
            }
            return (Scriptable)object;
        }
        String string2 = object instanceof String ? "String" : (object instanceof Number ? "Number" : (string = object instanceof Boolean ? "Boolean" : null));
        if (string == null) {
            Object object2 = context.getWrapFactory().wrap(context, scriptable, object, clazz);
            if (object2 instanceof Scriptable) {
                return (Scriptable)object2;
            }
            throw ScriptRuntime.DoubleClass("msg.invalid.type", object);
        }
        Object[] objectArray = new Object[]{object};
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable2 = ScriptRuntime.newObject(context, scriptable, string, objectArray);
        return scriptable2;
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, string);
        try {
            if (objectArray == null) {
                objectArray = emptyArgs;
            }
            return function.construct(context, scriptable, objectArray);
        }
        catch (JavaScriptException javaScriptException) {
            throw Context.reportRuntimeError(javaScriptException.getMessage());
        }
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
    }

    public static int toInt32(Object object) {
        if (object instanceof Byte) {
            return ((Number)object).intValue();
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(object));
    }

    public static int toInt32(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
    }

    public static int toInt32(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        d = Math.IEEEremainder(d, d2);
        long l = (long)d;
        return (int)l;
    }

    public static long toUint32(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return l & 0xFFFFFFFFL;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        l = (long)Math.IEEEremainder(d, d2);
        return l & 0xFFFFFFFFL;
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static char toUint16(Object object) {
        double d = ScriptRuntime.toNumber(object);
        int n = (int)d;
        if ((double)n == d) {
            return (char)n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        int n2 = 65536;
        n = (int)Math.IEEEremainder(d, n2);
        return (char)n;
    }

    public static Object unwrapJavaScriptException(JavaScriptException javaScriptException) {
        return javaScriptException.value;
    }

    public static Object unwrapWrappedException(WrappedException wrappedException) {
        Throwable throwable = wrappedException.getWrappedException();
        if (throwable instanceof JavaScriptException) {
            return ((JavaScriptException)throwable).value;
        }
        throw wrappedException;
    }

    public static Object getProp(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null || scriptable2 == Undefined.instance) {
            String string2 = scriptable2 == null ? "msg.null.to.object" : "msg.undefined";
            throw NativeGlobal.constructError(Context.getContext(), "ConversionError", ScriptRuntime.getMessage0(string2), scriptable);
        }
        Object object2 = ScriptableObject.getProperty(scriptable2, string);
        if (object2 != Scriptable.NOT_FOUND) {
            return object2;
        }
        return Undefined.instance;
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptableObject.getProperty(scriptable, string);
    }

    static Function getExistingCtor(Context context, Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object instanceof Function) {
            return (Function)object;
        }
        if (object == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", string);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", string);
    }

    public static Scriptable getProto(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        return scriptable2.getPrototype();
    }

    public static Scriptable getParent(Object object) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (scriptable == null) {
            return null;
        }
        return ScriptRuntime.getThis(scriptable.getParentScope());
    }

    public static Scriptable getParent(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        return scriptable2.getParentScope();
    }

    public static Object setProto(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        try {
            scriptable3 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable3 = ScriptRuntime.toObject(scriptable, object);
        }
        Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2);
        while (scriptable4 != null) {
            if (scriptable4 == scriptable3) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__proto__");
            }
            scriptable4 = scriptable4.getPrototype();
        }
        if (scriptable3 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        scriptable3.setPrototype(scriptable2);
        return scriptable2;
    }

    public static Object setParent(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        try {
            scriptable3 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable3 = ScriptRuntime.toObject(scriptable, object);
        }
        Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2);
        while (scriptable4 != null) {
            if (scriptable4 == scriptable3) {
                throw Context.reportRuntimeError1("msg.cyclic.value", "__parent__");
            }
            scriptable4 = scriptable4.getParentScope();
        }
        if (scriptable3 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        scriptable3.setParentScope(scriptable2);
        return scriptable2;
    }

    public static Object setProp(Object object, String string, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        ScriptableObject.putProperty(scriptable2, string, object2);
        return object2;
    }

    private static long BooleanClass(String string) {
        int n = 10;
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = 0;
            boolean bl = false;
            int n4 = string.charAt(0);
            if (n4 == 45 && n2 > 1) {
                n4 = string.charAt(1);
                n3 = 1;
                bl = true;
            }
            if (0 <= (n4 -= 48) && n4 <= 9 && n2 <= (bl ? 11 : 10)) {
                int n5 = -n4;
                int n6 = 0;
                ++n3;
                if (n5 != 0) {
                    while (n3 != n2 && 0 <= (n4 = string.charAt(n3) - 48) && n4 <= 9) {
                        n6 = n5;
                        n5 = 10 * n5 - n4;
                        ++n3;
                    }
                }
                if (n3 == n2 && (n6 > -214748364 || n6 == -214748364 && n4 <= (bl ? 8 : 7))) {
                    return 0xFFFFFFFFL & (bl ? (long)n5 : (long)(-n5));
                }
            }
        }
        return -1L;
    }

    static String getStringId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.BooleanClass(string);
        if (l >= 0L) {
            return null;
        }
        return string;
    }

    static int getIntId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return n;
            }
            return 0;
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.BooleanClass(string);
        if (l >= 0L) {
            return (int)l;
        }
        return 0;
    }

    public static Object getElem(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        String string;
        int n;
        if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            n = (int)d;
            string = (double)n == d ? null : ScriptRuntime.toString(object2);
        } else {
            string = object2 instanceof String ? (String)object2 : ScriptRuntime.toString(object2);
            long l = ScriptRuntime.BooleanClass(string);
            if (l >= 0L) {
                n = (int)l;
                string = null;
            } else {
                n = 0;
            }
        }
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (string != null) {
            return ScriptRuntime.getStrIdElem(scriptable2, string);
        }
        return ScriptRuntime.getElem(scriptable2, n);
    }

    public static Object getElem(Scriptable scriptable, int n) {
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        return Undefined.instance;
    }

    static Object getStrIdElem(Scriptable scriptable, String string) {
        Object object;
        int n = string.length();
        if (n == 9) {
            if (string.equals("__proto__")) {
                return scriptable.getPrototype();
            }
        } else if (n == 10 && string.equals("__parent__")) {
            return scriptable.getParentScope();
        }
        if ((object = ScriptableObject.getProperty(scriptable, string)) != Scriptable.NOT_FOUND) {
            return object;
        }
        return Undefined.instance;
    }

    public static Object setElem(Object object, Object object2, Object object3, Scriptable scriptable) {
        Scriptable scriptable2;
        String string;
        int n;
        if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            n = (int)d;
            string = (double)n == d ? null : ScriptRuntime.toString(object2);
        } else {
            string = object2 instanceof String ? (String)object2 : ScriptRuntime.toString(object2);
            long l = ScriptRuntime.BooleanClass(string);
            if (l >= 0L) {
                n = (int)l;
                string = null;
            } else {
                n = 0;
            }
        }
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (string != null) {
            return ScriptRuntime.setStrIdElem(scriptable2, string, object3, scriptable);
        }
        return ScriptRuntime.setElem(scriptable2, n, object3);
    }

    public static Object setElem(Scriptable scriptable, int n, Object object) {
        ScriptableObject.putProperty(scriptable, n, object);
        return object;
    }

    static Object setStrIdElem(Scriptable scriptable, String string, Object object, Scriptable scriptable2) {
        int n = string.length();
        if (n == 9) {
            if (string.equals("__proto__")) {
                return ScriptRuntime.setProto(scriptable, object, scriptable2);
            }
        } else if (n == 10 && string.equals("__parent__")) {
            return ScriptRuntime.setParent(scriptable, object, scriptable2);
        }
        ScriptableObject.putProperty(scriptable, string, object);
        return object;
    }

    public static Object delete(Object object, Object object2) {
        String string = ScriptRuntime.getStringId(object2);
        boolean bl = string != null ? ScriptableObject.deleteProperty((Scriptable)object, string) : ScriptableObject.deleteProperty((Scriptable)object, ScriptRuntime.getIntId(object2));
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object name(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Object object = ScriptableObject.getProperty(scriptable2, string);
            if (object != Scriptable.NOT_FOUND) {
                return object;
            }
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string.toString()), scriptable);
    }

    public static Scriptable bind(Scriptable scriptable, String string) {
        while (!ScriptableObject.hasProperty(scriptable, string)) {
            if ((scriptable = scriptable.getParentScope()) == null) break;
        }
        return scriptable;
    }

    public static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 != null) {
            return scriptable2;
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static Scriptable getThis(Scriptable scriptable) {
        while (scriptable instanceof NativeWith) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        return scriptable;
    }

    public static Object setName(Scriptable scriptable, Object object, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            ScriptableObject.putProperty(scriptable, string, object);
        } else {
            scriptable = ScriptableObject.getTopLevelScope(scriptable2);
            scriptable.put(string, scriptable, object);
        }
        return object;
    }

    public static Object initEnum(Object object, Scriptable scriptable) {
        if (object == null || object == Undefined.instance) {
            return new IdEnumeration(null);
        }
        Scriptable scriptable2 = ScriptRuntime.toObject(scriptable, object);
        return new IdEnumeration(scriptable2);
    }

    public static Object nextEnum(Object object) {
        IdEnumeration idEnumeration = (IdEnumeration)object;
        return idEnumeration.nextId();
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable = null;
        if (object instanceof Scriptable) {
            scriptable = ((Scriptable)object).getParentScope();
        }
        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        Function function;
        try {
            function = (Function)object;
        }
        catch (ClassCastException classCastException) {
            throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object), scriptable);
        }
        Scriptable scriptable2 = object2 instanceof Scriptable || object2 == null ? (Scriptable)object2 : ScriptRuntime.toObject(context, scriptable, object2);
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    private static Object ByteClass(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray, boolean bl, String string, int n) throws JavaScriptException {
        if (object instanceof IdFunction) {
            IdFunction idFunction = (IdFunction)object;
            String string2 = idFunction.getFunctionName();
            if (string2.length() == 4) {
                if (string2.equals("eval")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeGlobal == null ? (class$org$mozilla$javascript$NativeGlobal = ScriptRuntime.class$("org.mozilla.javascript.NativeGlobal")) : class$org$mozilla$javascript$NativeGlobal)) {
                        return NativeGlobal.evalSpecial(context, scriptable, object3, objectArray, string, n);
                    }
                } else if (string2.equals("With")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeWith == null ? (class$org$mozilla$javascript$NativeWith = ScriptRuntime.class$("org.mozilla.javascript.NativeWith")) : class$org$mozilla$javascript$NativeWith)) {
                        return NativeWith.newWithSpecial(context, objectArray, idFunction, !bl);
                    }
                } else if (string2.equals("exec")) {
                    if (idFunction.master.getClass() == (class$org$mozilla$javascript$NativeScript == null ? (class$org$mozilla$javascript$NativeScript = ScriptRuntime.class$("org.mozilla.javascript.NativeScript")) : class$org$mozilla$javascript$NativeScript)) {
                        return ((NativeScript)object2).exec(context, ScriptableObject.getTopLevelScope(scriptable));
                    }
                    RegExpProxy regExpProxy = context.getRegExpProxy();
                    if (regExpProxy != null && regExpProxy.isRegExp(object2)) {
                        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
                    }
                }
            }
        } else if (object instanceof NativeJavaMethod) {
            return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
        }
        if (bl) {
            return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
        }
        return ScriptRuntime.newObject(context, object, objectArray, scriptable);
    }

    public static Object callSpecial(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, String string, int n) throws JavaScriptException {
        return ScriptRuntime.ByteClass(context, scriptable2, object, object2, scriptable, objectArray, true, string, n);
    }

    public static Scriptable newObject(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        try {
            Function function = (Function)object;
            if (function != null) {
                return function.construct(context, scriptable, objectArray);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(object), scriptable);
    }

    public static Scriptable newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        return (Scriptable)ScriptRuntime.ByteClass(context, scriptable, object, null, null, objectArray, false, null, -1);
    }

    public static String typeof(Object object) {
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object == null) {
            return "object";
        }
        if (object instanceof Scriptable) {
            return object instanceof Function ? "function" : "object";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.DoubleClass("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(scriptable2, string, scriptable));
    }

    public static Object add(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof String) && !(object2 instanceof String)) {
            if (object instanceof Number && object2 instanceof Number) {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(object) + ScriptRuntime.toNumber(object2));
        }
        return ScriptRuntime.toString(object) + ScriptRuntime.toString(object2);
    }

    public static Object postIncrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(object) + 1.0);
        return object;
    }

    public static Object postIncrement(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                Object object;
                if ((object = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object2 = object;
                if (object2 instanceof Number) {
                    object2 = new Double(((Number)object2).doubleValue() + 1.0);
                    scriptable3.put(string, scriptable2, object2);
                    return object;
                }
                object2 = new Double(ScriptRuntime.toNumber(object2) + 1.0);
                scriptable3.put(string, scriptable2, object2);
                return new Double(ScriptRuntime.toNumber(object));
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static Object postIncrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() + 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) + 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d + 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Object postDecrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d - 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Object postDecrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(object) - 1.0);
        return object;
    }

    public static Object postDecrement(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        while (scriptable2 != null) {
            Scriptable scriptable3 = scriptable2;
            do {
                Object object;
                if ((object = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object2 = object;
                if (object2 instanceof Number) {
                    object2 = new Double(((Number)object2).doubleValue() - 1.0);
                    scriptable3.put(string, scriptable2, object2);
                    return object;
                }
                object2 = new Double(ScriptRuntime.toNumber(object2) - 1.0);
                scriptable3.put(string, scriptable2, object2);
                return new Double(ScriptRuntime.toNumber(object));
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2 = scriptable2.getParentScope();
        }
        throw NativeGlobal.constructError(Context.getContext(), "ReferenceError", ScriptRuntime.getMessage1("msg.is.not.defined", string), scriptable);
    }

    public static Object postDecrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        try {
            scriptable2 = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            scriptable2 = ScriptRuntime.toObject(scriptable, object);
        }
        if (scriptable2 == null) {
            throw NativeGlobal.typeError0("msg.null.to.object", scriptable);
        }
        Scriptable scriptable3 = scriptable2;
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() - 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) - 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object toPrimitive(Object object) {
        if (object == null || !(object instanceof Scriptable)) {
            return object;
        }
        Object object2 = ((Scriptable)object).getDefaultValue(null);
        if (object2 != null && object2 instanceof Scriptable) {
            throw NativeGlobal.typeError0("msg.bad.default.value", object);
        }
        return object2;
    }

    private static Class CharacterClass(Object object) {
        if (object == null) {
            return ScriptableClass;
        }
        if (object == Undefined.instance) {
            return UndefinedClass;
        }
        if (object instanceof Number) {
            return NumberClass;
        }
        if (object instanceof Scriptable) {
            return ScriptableClass;
        }
        return object.getClass();
    }

    public static boolean eq(Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        while (true) {
            Class clazz;
            Class clazz2;
            if ((clazz2 = ScriptRuntime.CharacterClass(object)) == (clazz = ScriptRuntime.CharacterClass(object2))) {
                if (clazz2 == UndefinedClass) {
                    return true;
                }
                if (clazz2 == NumberClass) {
                    return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
                }
                if (clazz2 == StringClass || clazz2 == BooleanClass) {
                    return object3.equals(object4);
                }
                if (clazz2 == ScriptableClass) {
                    if (object == object2) {
                        return true;
                    }
                    if (object instanceof Wrapper && object2 instanceof Wrapper) {
                        return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (object == null && object2 == Undefined.instance) {
                return true;
            }
            if (object == Undefined.instance && object2 == null) {
                return true;
            }
            if (clazz2 == NumberClass && clazz == StringClass) {
                return ((Number)object).doubleValue() == ScriptRuntime.toNumber(object2);
            }
            if (clazz2 == StringClass && clazz == NumberClass) {
                return ScriptRuntime.toNumber(object) == ((Number)object2).doubleValue();
            }
            if (clazz2 == BooleanClass) {
                object3 = object = new Double(ScriptRuntime.toNumber(object));
                continue;
            }
            if (clazz == BooleanClass) {
                object4 = object2 = new Double(ScriptRuntime.toNumber(object2));
                continue;
            }
            if ((clazz2 == StringClass || clazz2 == NumberClass) && clazz == ScriptableClass && object2 != null) {
                object4 = object2 = ScriptRuntime.toPrimitive(object2);
                continue;
            }
            if (clazz2 != ScriptableClass || object == null || clazz != StringClass && clazz != NumberClass) break;
            object3 = object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    public static Boolean eqB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean neB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean shallowEq(Object object, Object object2) {
        Class clazz = ScriptRuntime.CharacterClass(object);
        if (clazz != ScriptRuntime.CharacterClass(object2)) {
            return false;
        }
        if (clazz == StringClass || clazz == BooleanClass) {
            return object.equals(object2);
        }
        if (clazz == NumberClass) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (clazz == ScriptableClass) {
            if (object == object2) {
                return true;
            }
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
            return false;
        }
        return clazz == UndefinedClass;
    }

    public static Boolean seqB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean sneB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean instanceOf(Scriptable scriptable, Object object, Object object2) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scriptable);
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    protected static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        Scriptable scriptable3 = scriptable.getPrototype();
        while (scriptable3 != null) {
            if (scriptable3.equals(scriptable2)) {
                return true;
            }
            scriptable3 = scriptable3.getPrototype();
        }
        return false;
    }

    public static boolean in(Object object, Object object2, Scriptable scriptable) {
        if (!(object2 instanceof Scriptable)) {
            throw NativeGlobal.typeError0("msg.instanceof.not.object", scriptable);
        }
        String string = ScriptRuntime.getStringId(object);
        return string != null ? ScriptableObject.hasProperty((Scriptable)object2, string) : ScriptableObject.hasProperty((Scriptable)object2, ScriptRuntime.getIntId(object));
    }

    public static Boolean cmp_LTB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LT(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            double d = ((Number)object).doubleValue();
            double d2 = ((Number)object2).doubleValue();
            if (d != d) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d < d2 ? 1 : 0;
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d < d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LE(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            double d = ((Number)object).doubleValue();
            double d2 = ((Number)object2).doubleValue();
            if (d != d) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d <= d2 ? 1 : 0;
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d <= d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) <= 0 ? 1 : 0;
    }

    private static ScriptableObject ClassClass(Context context) {
        try {
            Class<?> clazz = Class.forName("org.mozilla.javascript.tools.shell.Global");
            Class[] classArray = new Class[]{class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = ScriptRuntime.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{context};
            return (ScriptableObject)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return new ImporterTopLevel(context);
    }

    public static void main(Class clazz, String[] stringArray) throws JavaScriptException {
        Context context = Context.enter();
        try {
            Script script = null;
            try {
                script = (Script)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (script == null) {
                throw new RuntimeException("Error creating script object");
            }
            ScriptableObject scriptableObject = ScriptRuntime.ClassClass(context);
            Scriptable scriptable = context.newArray((Scriptable)scriptableObject, stringArray);
            scriptableObject.defineProperty("arguments", scriptable, 2);
            script.exec(context, scriptableObject);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public static Scriptable initScript(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, boolean bl) {
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            Scriptable scriptable3 = scriptable;
            if (bl) {
                scriptable3 = scriptable;
                while (scriptable3 instanceof NativeWith) {
                    scriptable3 = scriptable3.getParentScope();
                }
            }
            int n = stringArray.length;
            while (n-- != 0) {
                String string = stringArray[n];
                if (ScriptRuntime.hasProp(scriptable, string)) continue;
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string, Undefined.instance, 4);
                    continue;
                }
                scriptable3.put(string, scriptable3, (Object)Undefined.instance);
            }
        }
        return scriptable;
    }

    public static Scriptable runScript(Script script) {
        Context context = Context.enter();
        ScriptableObject scriptableObject = ScriptRuntime.ClassClass(context);
        try {
            try {
                script.exec(context, scriptableObject);
            }
            catch (JavaScriptException javaScriptException) {
                throw new Error(javaScriptException.toString());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return scriptableObject;
    }

    public static Scriptable initVarObj(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        return new NativeCall(context, scriptable, nativeFunction, scriptable2, objectArray);
    }

    public static void popActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        if (nativeCall != null) {
            context.currentActivation = nativeCall.caller;
            nativeCall.caller = null;
        }
    }

    public static Scriptable newScope() {
        return new NativeObject();
    }

    public static Scriptable enterWith(Object object, Scriptable scriptable) {
        return new NativeWith(scriptable, ScriptRuntime.toObject(scriptable, object));
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        return scriptable.getParentScope();
    }

    public static void setFunctionProtoAndParent(Scriptable scriptable, Function function) {
        function.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        function.setParentScope(scriptable);
    }

    public static void initFunction(Context context, Scriptable scriptable, NativeFunction nativeFunction, int n, boolean bl) {
        String string;
        ScriptRuntime.setFunctionProtoAndParent(scriptable, nativeFunction);
        if (n == 1) {
            String string2 = nativeFunction.functionName;
            if (string2 != null && string2.length() != 0) {
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string2, nativeFunction, 4);
                } else {
                    scriptable.put(string2, scriptable, (Object)nativeFunction);
                }
            }
        } else if (n == 3 && (string = nativeFunction.functionName) != null && string.length() != 0) {
            while (scriptable instanceof NativeWith) {
                scriptable = scriptable.getParentScope();
            }
            scriptable.put(string, scriptable, (Object)nativeFunction);
        }
    }

    static void checkDeprecated(Context context, String string) {
        int n = context.getLanguageVersion();
        if (n >= 140 || n == 0) {
            String string2 = ScriptRuntime.getMessage1("msg.deprec.ctor", string);
            if (n == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    public static String getMessage0(String string) {
        return Context.getMessage0(string);
    }

    public static String getMessage1(String string, Object object) {
        return Context.getMessage1(string, object);
    }

    public static String getMessage2(String string, Object object, Object object2) {
        return Context.getMessage2(string, object, object2);
    }

    public static String getMessage(String string, Object[] objectArray) {
        return Context.getMessage(string, objectArray);
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    public static NativeCall getCurrentActivation(Context context) {
        return context.currentActivation;
    }

    public static void setCurrentActivation(Context context, NativeCall nativeCall) {
        context.currentActivation = nativeCall;
    }

    private static Class ComparableClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    static boolean hasProp(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(string, scriptable)) continue;
            return true;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return false;
    }

    static String makeUrlForGeneratedScript(boolean bl, String string, int n) {
        if (bl) {
            return string + '#' + n + "(eval)";
        }
        return string + '#' + n + "(Function)";
    }

    static boolean isGeneratedScript(String string) {
        return string.indexOf("(eval)") >= 0 || string.indexOf("(Function)") >= 0;
    }

    private static RuntimeException DoubleClass(String string, Object object) {
        return Context.reportRuntimeError1(string, object.getClass().getName());
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

