/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQExpression;
import net.sf.saxon.javax.xml.xquery.XQMetaData;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQStaticContext;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDataSource;
import net.sf.saxon.xqj.SaxonXQExpression;
import net.sf.saxon.xqj.SaxonXQMetaData;
import net.sf.saxon.xqj.SaxonXQPreparedExpression;
import net.sf.saxon.xqj.SaxonXQStaticContext;

public class SaxonXQConnection
extends SaxonXQDataFactory
implements XQConnection {
    private Configuration config;
    private SaxonXQStaticContext staticContext;
    private boolean closed;

    SaxonXQConnection(SaxonXQDataSource dataSource) {
        this.config = dataSource.getConfiguration();
        this.staticContext = new SaxonXQStaticContext(this.config);
        this.init();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void close() {
        this.closed = true;
    }

    public void commit() throws XQException {
        this.checkNotClosed();
    }

    public XQExpression createExpression() throws XQException {
        this.checkNotClosed();
        return new SaxonXQExpression(this);
    }

    public XQExpression createExpression(XQStaticContext properties) throws XQException {
        return new SaxonXQExpression(this, (SaxonXQStaticContext)properties);
    }

    public boolean getAutoCommit() throws XQException {
        return false;
    }

    public XQMetaData getMetaData() throws XQException {
        this.checkNotClosed();
        return new SaxonXQMetaData(this.config);
    }

    public XQStaticContext getStaticContext() throws XQException {
        return new SaxonXQStaticContext(this.config);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public XQPreparedExpression prepareExpression(InputStream xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(InputStream xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext sqc = ((SaxonXQStaticContext)properties).getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery, null);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw this.newXQException(e);
        }
    }

    public XQPreparedExpression prepareExpression(Reader xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(Reader xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext sqc = ((SaxonXQStaticContext)properties).getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw this.newXQException(e);
        }
    }

    public XQPreparedExpression prepareExpression(String xquery) throws XQException {
        return this.prepareExpression(xquery, (XQStaticContext)this.staticContext);
    }

    public XQPreparedExpression prepareExpression(String xquery, XQStaticContext properties) throws XQException {
        this.checkNotClosed();
        try {
            StaticQueryContext sqc = ((SaxonXQStaticContext)properties).getSaxonStaticQueryContext();
            XQueryExpression exp = sqc.compileQuery(xquery);
            DynamicQueryContext dqc = new DynamicQueryContext(this.config);
            return new SaxonXQPreparedExpression(this, exp, dqc);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    public void rollback() throws XQException {
        this.checkNotClosed();
    }

    public void setAutoCommit(boolean autoCommit) throws XQException {
        this.checkNotClosed();
    }

    public void setStaticContext(XQStaticContext properties) throws XQException {
        this.staticContext = (SaxonXQStaticContext)properties;
    }

    private void checkNotClosed() throws XQException {
        if (this.closed) {
            throw new XQException("Connection has been closed");
        }
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

