/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ConstrainableRegistration;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.ServiceLease;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

class Registration
implements ServiceRegistration,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Registrar server;
    final ServiceLease lease;

    static Registration getInstance(Registrar registrar, ServiceLease serviceLease) {
        return registrar instanceof RemoteMethodControl ? new ConstrainableRegistration(registrar, serviceLease, null) : new Registration(registrar, serviceLease);
    }

    Registration(Registrar registrar, ServiceLease serviceLease) {
        this.server = registrar;
        this.lease = serviceLease;
    }

    public ServiceID getServiceID() {
        return this.lease.getServiceID();
    }

    public Lease getLease() {
        return this.lease;
    }

    public void addAttributes(Entry[] entryArray) throws UnknownLeaseException, RemoteException {
        this.server.addAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(entryArray, true));
    }

    public void modifyAttributes(Entry[] entryArray, Entry[] entryArray2) throws UnknownLeaseException, RemoteException {
        this.server.modifyAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(entryArray, false), EntryRep.toEntryRep(entryArray2, false));
    }

    public void setAttributes(Entry[] entryArray) throws UnknownLeaseException, RemoteException {
        this.server.setAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(entryArray, true));
    }

    public Uuid getReferentUuid() {
        return this.lease.getReferentUuid();
    }

    public int hashCode() {
        return this.lease.getReferentUuid().hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("null server");
        }
        if (this.lease == null) {
            throw new InvalidObjectException("null lease");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

