/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.FiddlerAdminProxy;
import com.sun.jini.fiddler.FiddlerLease;
import com.sun.jini.fiddler.FiddlerProxy;
import com.sun.jini.fiddler.FiddlerRegistration;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl innerProxy;
    private final Uuid proxyID;

    ProxyVerifier(Fiddler fiddler, Uuid uuid) {
        if (!(fiddler instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("cannot construct verifier - canonical inner proxy is not an instance of RemoteMethodControl");
        }
        if (!(fiddler instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("cannot construct verifier - canonical inner proxy is not an instance of TrustEquivalence");
        }
        this.innerProxy = (RemoteMethodControl)fiddler;
        this.proxyID = uuid;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        FiddlerRegistration fiddlerRegistration;
        Uuid uuid;
        RemoteMethodControl remoteMethodControl;
        if (object == null || context == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (object instanceof FiddlerProxy.ConstrainableFiddlerProxy) {
            remoteMethodControl = (RemoteMethodControl)((FiddlerProxy)object).server;
            uuid = ((ReferentUuid)object).getReferentUuid();
        } else if (object instanceof FiddlerRegistration.ConstrainableFiddlerRegistration) {
            fiddlerRegistration = (FiddlerRegistration)object;
            if (!this.isTrustedObject(fiddlerRegistration.eventReg.getSource(), context)) {
                return false;
            }
            if (!this.isTrustedObject(fiddlerRegistration.eventReg.getLease(), context)) {
                return false;
            }
            remoteMethodControl = (RemoteMethodControl)fiddlerRegistration.server;
            uuid = this.proxyID;
        } else if (object instanceof FiddlerLease.ConstrainableFiddlerLease) {
            remoteMethodControl = (RemoteMethodControl)((FiddlerLease)object).server;
            uuid = ((FiddlerLease)object).getServerID();
        } else if (object instanceof FiddlerAdminProxy.ConstrainableFiddlerAdminProxy) {
            remoteMethodControl = (RemoteMethodControl)((FiddlerAdminProxy)object).server;
            uuid = ((ReferentUuid)object).getReferentUuid();
        } else if (object instanceof RemoteMethodControl) {
            remoteMethodControl = (RemoteMethodControl)object;
            uuid = this.proxyID;
        } else {
            return false;
        }
        fiddlerRegistration = remoteMethodControl.getConstraints();
        TrustEquivalence trustEquivalence = (TrustEquivalence)this.innerProxy.setConstraints((MethodConstraints)fiddlerRegistration);
        return trustEquivalence.checkTrustEquivalence((Object)remoteMethodControl) && this.proxyID.equals((Object)uuid);
    }
}

