/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class ConnectedInputStream
extends InputStream {
    private byte[] buffer;
    private boolean closed = false;
    private boolean receiverClosed = false;
    private int write = 0;
    private int read = 0;
    private int available = 0;
    private final boolean senderFlushBlock;

    public ConnectedInputStream(int size, boolean senderFlushBlock) {
        this.buffer = new byte[size];
        this.senderFlushBlock = senderFlushBlock;
    }

    public synchronized int read() throws IOException {
        while (this.available == 0) {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.receiverClosed) {
                return -1;
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        int r = this.buffer[this.read++] & 0xFF;
        if (this.read >= this.buffer.length) {
            this.read = 0;
        }
        --this.available;
        this.notifyAll();
        return r;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            if (this.closed && this.available == 0) {
                throw new IOException("Stream closed");
            }
            return 0;
        }
        int c = this.read();
        if (c < 0) {
            return -1;
        }
        b[off] = (byte)(c & 0xFF);
        int rlen = 1;
        while (this.available > 0 && --len > 0) {
            b[off + rlen] = this.buffer[this.read++];
            ++rlen;
            if (this.read >= this.buffer.length) {
                this.read = 0;
            }
            --this.available;
            this.notifyAll();
        }
        return rlen;
    }

    public synchronized int available() throws IOException {
        return this.available;
    }

    void receiveFlush() throws IOException {
        if (this.senderFlushBlock) {
            this.receiveFlushBlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFlushBlock() throws IOException {
        while (this.available != 0) {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.receiverClosed) {
                throw new IOException("Connection closed");
            }
            ConnectedInputStream connectedInputStream = this;
            synchronized (connectedInputStream) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    synchronized void receive(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        if (this.available == this.buffer.length) {
            this.waitFreeBuffer();
        }
        this.buffer[this.write++] = (byte)(b & 0xFF);
        if (this.write >= this.buffer.length) {
            this.write = 0;
        }
        ++this.available;
        this.notifyAll();
    }

    public synchronized void receive(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (this.closed) {
                throw new IOException("Connection closed");
            }
            if (this.available == this.buffer.length) {
                this.waitFreeBuffer();
            }
            this.buffer[this.write++] = b[off + i];
            if (this.write >= this.buffer.length) {
                this.write = 0;
            }
            ++this.available;
        }
        this.notifyAll();
    }

    private void waitFreeBuffer() throws IOException {
        while (this.available == this.buffer.length) {
            if (this.receiverClosed || this.closed) {
                throw new IOException("Receiver closed");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    synchronized void receiverClose() throws IOException {
        this.receiverClosed = true;
        this.notifyAll();
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }
}

