/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanelSupport;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.jxbrowser.BrowserTypeConfig;
import com.mathworks.html.jxbrowser.SelectionListener;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class JxBrowserSelectionListener
implements RequestHandler,
NavigationListener,
SelectionListener {
    private static final String URL_PREFIX = "textselection:";
    private final List<HtmlDataListener<String>> fListeners = new LinkedList<HtmlDataListener<String>>();
    private HtmlPanelSupport fPanel;
    private String fSelectionScript;
    private String fCurrentSelection;

    public JxBrowserSelectionListener(HtmlPanelSupport htmlPanelSupport, BrowserTypeConfig browserTypeConfig) {
        this.fPanel = htmlPanelSupport;
        this.fSelectionScript = JxBrowserSelectionListener.createSelectionScript(browserTypeConfig);
    }

    private static String createSelectionScript(BrowserTypeConfig browserTypeConfig) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("function() {\n");
        stringBuilder.append("    var selection = ").append(browserTypeConfig.getTextSelectionScript()).append(";\n");
        stringBuilder.append("    document.location = '").append(URL_PREFIX).append("' + encodeURIComponent(selection);\n");
        stringBuilder.append("}");
        return browserTypeConfig.createAddEventFunction("document.body", "mouseup", stringBuilder.toString());
    }

    @Override
    public boolean handleRequest(BrowserRequest browserRequest) {
        String string = browserRequest.getUrl();
        if (string.startsWith(URL_PREFIX)) {
            String string2 = string.substring(URL_PREFIX.length());
            if (EncodingUtils.needsDecoding(string2)) {
                string2 = EncodingUtils.decodeUrl(string2);
            }
            this.setCurrentSelection(string2);
            return true;
        }
        return false;
    }

    public void navigationStarted(NavigationEvent navigationEvent) {
    }

    public void navigationFinished(NavigationFinishedEvent navigationFinishedEvent) {
        this.fPanel.executeScript(this.fSelectionScript, null);
    }

    private synchronized void setCurrentSelection(final String string) {
        boolean bl = this.fCurrentSelection == null ? string != null : !this.fCurrentSelection.equals(string);
        this.fCurrentSelection = string;
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JxBrowserSelectionListener.this.notifyListeners(string);
                }
            });
        }
    }

    @Override
    public synchronized String getCurrentSelection() {
        return this.fCurrentSelection;
    }

    @Override
    public void addSelectionListener(HtmlDataListener<String> htmlDataListener) {
        this.fListeners.add(htmlDataListener);
    }

    @Override
    public void removeSelectionListener(HtmlDataListener<String> htmlDataListener) {
        this.fListeners.remove(htmlDataListener);
    }

    private void notifyListeners(String string) {
        for (HtmlDataListener<String> htmlDataListener : this.fListeners) {
            htmlDataListener.dataRetrieved(string);
        }
    }
}

