/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.teamdev.jxbrowser.BrowserType;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class JxBrowserMouseAdapter
extends MouseAdapter
implements HtmlDataListener<Boolean> {
    private final JxBrowserSwingComponent fBrowserComponent;
    private boolean fMousePressedSinceFocusGained = false;

    private JxBrowserMouseAdapter(JxBrowserSwingComponent jxBrowserSwingComponent) {
        this.fBrowserComponent = jxBrowserSwingComponent;
    }

    static void install(JxBrowserSwingComponent jxBrowserSwingComponent) {
        JxBrowserMouseAdapter jxBrowserMouseAdapter = new JxBrowserMouseAdapter(jxBrowserSwingComponent);
        jxBrowserSwingComponent.getFocusManager().addFocusChangeListener(jxBrowserMouseAdapter);
        jxBrowserSwingComponent.getBrowser().getComponent().addMouseListener(jxBrowserMouseAdapter);
        if (jxBrowserSwingComponent.getBrowser().getType() == BrowserType.Safari) {
            Container container = (Container)jxBrowserSwingComponent.getBrowser().getComponent();
            for (Component component : container.getComponents()) {
                component.addMouseListener(jxBrowserMouseAdapter);
            }
        }
    }

    @Override
    public void dataRetrieved(Boolean bl) {
        this.fMousePressedSinceFocusGained = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.fBrowserComponent.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.fMousePressedSinceFocusGained) {
            MouseEvent mouseEvent2 = JxBrowserMouseAdapter.cloneAndChangeType(mouseEvent, 501);
            this.mousePressed(mouseEvent2);
            this.fBrowserComponent.dispatchEvent(mouseEvent);
            MouseEvent mouseEvent3 = JxBrowserMouseAdapter.cloneAndChangeType(mouseEvent, 500);
            this.mouseClicked(mouseEvent3);
        } else {
            this.fBrowserComponent.dispatchEvent(mouseEvent);
        }
    }

    private static MouseEvent cloneAndChangeType(MouseEvent mouseEvent, int n) {
        return new MouseEvent((Component)mouseEvent.getSource(), n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fMousePressedSinceFocusGained = true;
        if (mouseEvent.getButton() == 1) {
            this.fBrowserComponent.dispatchEvent(mouseEvent);
        }
    }
}

