/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlPanel;
import com.mathworks.html.jxbrowser.SystemUtils;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFactory;
import com.teamdev.jxbrowser.BrowserType;
import java.io.File;
import java.io.IOException;

class BrowserBuilder {
    private static final BrowserType BROWSER_TYPE = BrowserBuilder.determineBrowserType();
    private static final String JXBROWSER_DIR_NAME = ".JxBrowser";
    private static final String MOZILLA_EXTRACT_PROPERTY = "jxbrowser.xulrunner.dir";

    BrowserBuilder() {
    }

    private static BrowserType determineBrowserType() {
        boolean bl = SystemUtils.is64Bit();
        return bl ? BrowserType.getPlatformSpecificBrowser() : BrowserType.Mozilla;
    }

    static Browser createBrowser() {
        for (int i = 4; i >= 0; --i) {
            Browser browser = BrowserBuilder.createBrowser(false);
            if (browser != null) {
                return browser;
            }
            if (i <= 0) continue;
            BrowserBuilder.pause(200L);
        }
        return null;
    }

    private static Browser createBrowser(boolean bl) {
        try {
            BrowserBuilder.prepareBrowserFactory();
            return BrowserFactory.createBrowser((BrowserType)BROWSER_TYPE);
        }
        catch (Exception exception) {
            if (bl) assert (false) : BrowserBuilder.displayFailure(exception);
            return null;
        }
    }

    private static void prepareBrowserFactory() {
        if (BROWSER_TYPE == BrowserType.Mozilla) {
            BrowserBuilder.prepareMozilla();
        }
    }

    private static void prepareMozilla() {
        File file = BrowserBuilder.getMozillaDirectory();
        if (file != null) {
            try {
                String string = file.getCanonicalPath();
                System.setProperty(MOZILLA_EXTRACT_PROPERTY, string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File getMozillaDirectory() {
        File file;
        File file2 = HtmlPanel.getResourceDirectory();
        if (file2 != null && ((file = new File(file2, JXBROWSER_DIR_NAME)).exists() || file.mkdirs()) && file.canWrite()) {
            return file;
        }
        return null;
    }

    private static String displayFailure(Exception exception) {
        exception.printStackTrace();
        return "Failed to create JxBrowser instance.";
    }

    private static void pause(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

