/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.StartLine;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

class MessageReader {
    private static final int START = 0;
    private static final int HEADER = 1;
    private static final int CONTENT = 2;
    private static final int DONE = 3;
    private static final byte[] sink = new byte[256];
    private final InputStream in;
    private final boolean noContent;
    private int state = 0;
    private StartLine sline;
    private InputStream cin;

    MessageReader(InputStream inputStream, boolean bl) {
        this.in = inputStream;
        this.noContent = bl;
    }

    StartLine readStartLine() throws IOException {
        this.updateState(0, 1);
        this.sline = new StartLine(this.in);
        return this.sline;
    }

    Header readHeader() throws IOException {
        this.updateState(1, 2);
        Header header = new Header(this.in);
        if (!this.noContent && MessageReader.contentIndicated(this.sline, header)) {
            if (header.containsValue("Transfer-Encoding", "chunked", true)) {
                this.cin = new ChunkedInputStream();
            } else {
                String string = header.getField("Content-Length");
                if (string != null) {
                    int n;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        throw new HttpParseException("invalid content length");
                    }
                    if (n < 0) {
                        throw new HttpParseException("invalid content length");
                    }
                    this.cin = new BoundedInputStream(n);
                } else {
                    if (this.sline.isRequest) {
                        throw new HttpParseException("request length undeclared");
                    }
                    this.cin = this.in;
                }
            }
        } else {
            this.cin = new BoundedInputStream(0);
        }
        return header;
    }

    int readContent(byte[] byArray, int n, int n2) throws IOException {
        this.updateState(2, 2);
        return this.cin.read(byArray, n, n2);
    }

    int availableContent() throws IOException {
        this.updateState(2, 2);
        return this.cin.available();
    }

    Header readTrailer() throws IOException {
        this.updateState(2, 2);
        while (this.cin.read(sink) != -1) {
        }
        this.updateState(2, 3);
        if (this.cin instanceof ChunkedInputStream) {
            Header header = new Header(this.in);
            return header.size() > 0 ? header : null;
        }
        return null;
    }

    static String readLine(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (n == 13) {
                n = inputStream.read();
                if (n == 10) break;
                stringBuffer.append('\r');
                continue;
            }
            stringBuffer.append((char)n);
            n = inputStream.read();
        } while (n != -1);
        return stringBuffer.toString();
    }

    private void updateState(int n, int n2) {
        if (this.state != n) {
            throw new IllegalStateException();
        }
        this.state = n2;
    }

    private static boolean contentIndicated(StartLine startLine, Header header) {
        if (!(startLine.isRequest || startLine.status / 100 != 1 && startLine.status != 204 && startLine.status != 304)) {
            return false;
        }
        if (header.getField("Transfer-Encoding") != null || header.getField("Content-Length") != null) {
            return true;
        }
        return !startLine.isRequest;
    }

    private class ChunkedInputStream
    extends InputStream {
        private byte[] buf;
        private int pos = 0;
        private int lim = 0;

        ChunkedInputStream() {
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, 1) != -1 ? byArray[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            while (this.pos >= this.lim) {
                this.refill();
            }
            if (this.pos < 0) {
                return -1;
            }
            int n3 = Math.min(this.lim - this.pos, n2);
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos += n3;
            return n3;
        }

        public int available() throws IOException {
            while (this.pos >= this.lim) {
                this.refill();
            }
            return this.pos >= 0 ? this.lim - this.pos : 0;
        }

        private void refill() throws IOException {
            int n = 0;
            try {
                String string = MessageReader.readLine(MessageReader.this.in);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ;\t");
                n = Integer.parseInt(stringTokenizer.nextToken(), 16);
            }
            catch (Exception exception) {
                throw new HttpParseException("error parsing chunk length");
            }
            if (n < 0) {
                throw new HttpParseException("illegal chunk length");
            }
            if (n == 0) {
                this.pos = -1;
            } else {
                int n2;
                if (this.buf == null || n > this.buf.length) {
                    this.buf = new byte[n];
                }
                for (int i = 0; i < n; i += n2) {
                    n2 = MessageReader.this.in.read(this.buf, i, n - i);
                    if (n2 >= 0) continue;
                    throw new EOFException("incomplete chunk");
                }
                String string = MessageReader.readLine(MessageReader.this.in);
                if (string == null || string.length() > 0) {
                    throw new HttpParseException("illegal chunk tail");
                }
                this.pos = 0;
                this.lim = n;
            }
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private int bound;

        BoundedInputStream(int n) {
            this.bound = n;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, 1) != -1 ? byArray[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bound == 0) {
                return -1;
            }
            int n3 = MessageReader.this.in.read(byArray, n, Math.min(this.bound, n2));
            if (n3 != -1) {
                this.bound -= n3;
            }
            return n3;
        }

        public int available() throws IOException {
            return Math.min(this.bound, MessageReader.this.in.available());
        }
    }
}

