/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.util;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.util.DebugUtils;
import com.mathworks.util.Result;
import com.mathworks.util.TimeInterval;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public final class MLCommands {
    public static Result<String> which(final String string, TimeInterval timeInterval) {
        Result result;
        block10: {
            result = new Result();
            if (!Matlab.isMatlabAvailable()) {
                assert (DebugUtils.warning((String)"MATLAB is not running"));
                return result;
            }
            if (StringUtils.isBlank((String)string)) {
                result.set((Object)"");
                return result;
            }
            if (timeInterval == null) {
                timeInterval = TimeInterval.ZERO_SEC;
            }
            Future<String> future = MatlabEventQueue.invoke(new MatlabCallable<String>(){

                @Override
                public void callOnEdt(String string2, boolean bl) {
                }

                @Override
                public String call() throws Exception {
                    try {
                        Object object = MatlabMCR.mtFeval("which", new Object[]{string}, 1);
                        if (object != null) {
                            assert (object instanceof String) : object.getClass().getName();
                            result.set((Object)((String)object));
                        }
                    }
                    catch (Exception exception) {
                        assert (DebugUtils.outputException((Throwable)exception));
                        result.setErrorMessage(exception.getMessage());
                        return null;
                    }
                    return (String)result.get();
                }
            });
            try {
                future.get(timeInterval.getInterval(), timeInterval.getTimeUnit());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException executionException) {
                result.setErrorMessage(executionException.getMessage());
                assert (DebugUtils.outputException((Throwable)new ExecutionException(executionException)));
            }
            catch (TimeoutException timeoutException) {
                String string2 = "Timeout calling which: " + timeInterval;
                result.setErrorMessage(string2);
                if ($assertionsDisabled || DebugUtils.warning((String)string2)) break block10;
                throw new AssertionError();
            }
        }
        return result;
    }

    public static Result<Boolean> isa(final Object object, final String string) {
        final Result result = new Result();
        if (!Matlab.isMatlabAvailable()) {
            assert (DebugUtils.warning((String)"MATLAB is not running"));
            return result;
        }
        if (StringUtils.isBlank((String)string)) {
            result.set((Object)Boolean.FALSE);
            return result;
        }
        Future<Boolean> future = MatlabEventQueue.invoke(new MatlabCallable<Boolean>(){

            @Override
            public void callOnEdt(Boolean bl, boolean bl2) {
            }

            @Override
            public Boolean call() throws Exception {
                try {
                    Object object2 = MatlabMCR.mtFeval("isa", new Object[]{object, string}, 1);
                    if (object2 != null) {
                        assert (object2 instanceof boolean[]);
                        boolean[] blArray = (boolean[])object2;
                        assert (blArray.length > 0);
                        result.set((Object)blArray[0]);
                    }
                }
                catch (Exception exception) {
                    assert (DebugUtils.outputException((Throwable)exception));
                    result.setErrorMessage(exception.getMessage());
                }
                return (Boolean)result.get();
            }
        });
        TimeInterval timeInterval = TimeInterval.THREE_SEC;
        try {
            future.get(timeInterval.getInterval(), timeInterval.getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
            assert (DebugUtils.outputException((Throwable)new ExecutionException(executionException)));
            result.setErrorMessage(executionException.getMessage());
        }
        catch (TimeoutException timeoutException) {
            String string2 = "Timeout calling isa: " + timeInterval;
            result.setErrorMessage(string2);
        }
        return result;
    }

    private MLCommands() {
    }
}

