/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.types;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.jmi.types.MLArrayRefEditorLooper;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;

class MLArrayRefEditorPanel
extends MWPanel {
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.jmi.types.resources.RES_Types");
    private static final int STATUS_OK = 1;
    private static final int STATUS_TOO_LARGE = 4;
    private static final int STATUS_EMPTY = 7;
    private static final String ARRAYVIEW = "com.mathworks.ide.arrayeditor.ArrayView";
    private static final String SETREF = "setVariableRef";
    private static final String GETREF = "getVariableRef";
    private static final String SETWIDTH = "setVarWidth";
    private static final String GETWIDTH = "getVarWidth";
    private static final String SETHEIGHT = "setVarHeight";
    private static final String GETHEIGHT = "getVarHeight";
    private static final String ADDLISTENER = "addArrayViewListener";
    private static final String SETTABLESIZE = "setPreferredTableSize";
    private static final String GETSTATUS = "getStatus";
    private static final Class[] LISTENARG = new Class[]{ActionListener.class};
    private static final Class[] NOARGS = new Class[0];
    private static final Class[] REFARG = new Class[]{MLArrayRef.class};
    private static final Class[] INT1ARG = new Class[]{Integer.TYPE};
    private static final Class[] INT2ARGS = new Class[]{Integer.TYPE, Integer.TYPE};
    private Component fArrayView;
    private Class fArrayViewClass;
    private MWTextField fHeightField;
    private MWTextField fWidthField;
    private MWTextField fExpressionField;

    MLArrayRefEditorPanel(MLArrayRef mLArrayRef) {
        this.setLayout(new BorderLayout());
        this.fArrayView = this.newArrayView(mLArrayRef);
        MWToolbar mWToolbar = new MWToolbar();
        ExpressionHandler expressionHandler = new ExpressionHandler();
        MWPanel mWPanel = new MWPanel((LayoutManager)new FlowLayout());
        this.fExpressionField = new MWTextField(12);
        this.fExpressionField.addActionListener((ActionListener)expressionHandler);
        this.fExpressionField.addFocusListener((FocusListener)expressionHandler);
        mWPanel.add((Component)new MWLabel(fRes.getString("label.enter_expression")));
        mWPanel.add((Component)this.fExpressionField);
        MWPanel mWPanel2 = new MWPanel((LayoutManager)new FlowLayout());
        mWPanel2.add((Component)new MWLabel(fRes.getString("label.size")));
        this.fHeightField = new MWTextField(6);
        EventHandler eventHandler = new EventHandler();
        this.fHeightField.addActionListener((ActionListener)eventHandler);
        this.fHeightField.addFocusListener((FocusListener)eventHandler);
        mWPanel2.add((Component)this.fHeightField);
        mWPanel2.add((Component)new MWLabel(fRes.getString("label.by")));
        this.fWidthField = new MWTextField(6);
        eventHandler = new EventHandler();
        this.fWidthField.addActionListener((ActionListener)eventHandler);
        this.fWidthField.addFocusListener((FocusListener)eventHandler);
        mWPanel2.add((Component)this.fWidthField);
        mWToolbar.addComponent((Component)mWPanel);
        mWToolbar.addSpacer();
        mWToolbar.addComponent((Component)mWPanel2);
        this.add(this.fArrayView, "Center");
        this.add((Component)mWToolbar, "North");
    }

    MLArrayRef getRef() {
        MLArrayRef mLArrayRef = null;
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{};
                mLArrayRef = (MLArrayRef)this.fArrayViewClass.getMethod(GETREF, NOARGS).invoke((Object)this.fArrayView, objectArray);
            }
            catch (Exception exception) {
                mLArrayRef = null;
            }
        }
        return mLArrayRef;
    }

    void setRef(MLArrayRef mLArrayRef) {
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{mLArrayRef};
                this.fArrayViewClass.getMethod(SETREF, REFARG).invoke((Object)this.fArrayView, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void expressionEvaluated(MLArrayRef mLArrayRef) {
        if (mLArrayRef != null) {
            this.fExpressionField.setText("");
            this.setRef(mLArrayRef);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private int getStatus() {
        int n = 0;
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{};
                Integer n2 = (Integer)this.fArrayViewClass.getMethod(GETSTATUS, NOARGS).invoke((Object)this.fArrayView, objectArray);
                n = n2;
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private int getVarWidth() {
        int n = 0;
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{};
                Integer n2 = (Integer)this.fArrayViewClass.getMethod(GETWIDTH, NOARGS).invoke((Object)this.fArrayView, objectArray);
                n = n2;
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private void setVarWidth(int n) {
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{new Integer(n)};
                this.fArrayViewClass.getMethod(SETWIDTH, INT1ARG).invoke((Object)this.fArrayView, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int getVarHeight() {
        int n = 0;
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{};
                Integer n2 = (Integer)this.fArrayViewClass.getMethod(GETHEIGHT, NOARGS).invoke((Object)this.fArrayView, objectArray);
                n = n2;
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private void setVarHeight(int n) {
        if (this.fArrayViewClass != null) {
            try {
                Object[] objectArray = new Object[]{new Integer(n)};
                this.fArrayViewClass.getMethod(SETHEIGHT, INT1ARG).invoke((Object)this.fArrayView, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Component newArrayView(MLArrayRef mLArrayRef) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = null;
        try {
            this.fArrayViewClass = Class.forName(ARRAYVIEW);
            objectArray2 = new Object[]{mLArrayRef};
            objectArray3 = (Object[])this.fArrayViewClass.getConstructor(REFARG).newInstance(objectArray2);
            objectArray = new Object[]{new Integer(10), new Integer(6)};
            this.fArrayViewClass.getMethod(SETTABLESIZE, INT2ARGS).invoke((Object)objectArray3, objectArray);
            Object[] objectArray4 = new Object[]{new EventHandler()};
            this.fArrayViewClass.getMethod(ADDLISTENER, LISTENARG).invoke((Object)objectArray3, objectArray4);
        }
        catch (Exception exception) {
            objectArray3 = null;
        }
        if (objectArray3 == null) {
            objectArray2 = new MWPanel();
            objectArray = new MWLabel(fRes.getString("label.array_view_not_available"));
            objectArray2.add((Component)objectArray);
            this.fArrayViewClass = null;
            objectArray3 = objectArray2;
        }
        return objectArray3;
    }

    private class EventHandler
    extends FocusAdapter
    implements ActionListener {
        private boolean fDealingWithIt = false;

        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof MWTextField) {
                this.updateViaTextField((MWTextField)actionEvent.getSource());
            } else {
                MLArrayRefEditorPanel.this.fHeightField.setText(Integer.toString(MLArrayRefEditorPanel.this.getVarHeight()));
                MLArrayRefEditorPanel.this.fWidthField.setText(Integer.toString(MLArrayRefEditorPanel.this.getVarWidth()));
                int n = MLArrayRefEditorPanel.this.getStatus();
                if (n == 1 || n == 4 || n == 7) {
                    MLArrayRefEditorPanel.this.fHeightField.setEnabled(true);
                    MLArrayRefEditorPanel.this.fWidthField.setEnabled(true);
                } else {
                    MLArrayRefEditorPanel.this.fHeightField.setEnabled(false);
                    MLArrayRefEditorPanel.this.fWidthField.setEnabled(false);
                }
                MLArrayRefEditorPanel.this.fArrayView.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.updateViaTextField((MWTextField)focusEvent.getSource());
        }

        private void updateViaTextField(MWTextField mWTextField) {
            if (!this.fDealingWithIt) {
                this.fDealingWithIt = true;
                String string = mWTextField.getText();
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n2 = mWTextField == MLArrayRefEditorPanel.this.fWidthField ? MLArrayRefEditorPanel.this.getVarWidth() : MLArrayRefEditorPanel.this.getVarHeight();
                if (n >= 0) {
                    if (n != n2) {
                        if (mWTextField == MLArrayRefEditorPanel.this.fWidthField) {
                            MLArrayRefEditorPanel.this.setVarWidth(n);
                        } else {
                            MLArrayRefEditorPanel.this.setVarHeight(n);
                        }
                    }
                } else {
                    mWTextField.setText(Integer.toString(n2));
                }
                this.fDealingWithIt = false;
            }
        }
    }

    private class ExpressionHandler
    extends FocusAdapter
    implements ActionListener {
        private boolean fDealingWithIt = false;

        private ExpressionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.evaluate(MLArrayRefEditorPanel.this.fExpressionField.getText());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.evaluate(MLArrayRefEditorPanel.this.fExpressionField.getText());
        }

        private void evaluate(String string) {
            if (!this.fDealingWithIt) {
                this.fDealingWithIt = true;
                if (string != null && string.length() > 0) {
                    MLArrayRefEditorLooper.evaluateExpression(string, MLArrayRefEditorPanel.this);
                }
                this.fDealingWithIt = false;
            }
        }
    }
}

